package com.bcxin.ars.rest.mobile;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.HistorySearchDto;
import com.bcxin.ars.model.SearchHistory;
import com.bcxin.ars.service.SearchHistoryService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @author linqinglin
 * @date 2020/02/17 0017 11:35
 */
@RequestMapping("mobile/searchHistory")
@Controller
public class MobileSearchHistoryController {

    @Autowired
    private SearchHistoryService searchHistoryService;

    @RequestMapping("searchForPage")
    @ResponseBody
    public AjaxResult searchForPage(HistorySearchDto searchDto,AjaxPageResponse<SearchHistory> page){
        searchHistoryService.searchForPage(searchDto,page);
        AjaxResult result = new AjaxResult();
        result.setData(page.getData());
        result.setSuccessful(true);
        return result;
    }
}
