package com.bcxin.ars.rest.mobile;

import com.bcxin.ars.dto.SecurityPersonDTO;
import com.bcxin.ars.dto.page.PersonPageSearchDto;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.rest.util.NativeUtil;
import com.bcxin.ars.service.SecurityCompanyPersonService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.supervision.PersonAwardService;
import com.bcxin.ars.service.supervision.PersonPunishService;
import com.bcxin.ars.service.util.ConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;

/**
 * @author linqinglin
 * @date 2020/02/18 0018 13:07
 */
@RequestMapping("mobile/person")
@Controller
public class MobilePersonController {

    private Logger logger = LoggerFactory.getLogger(MobilePersonController.class);

    @Autowired
    private SecurityPersonService securityPersonService;
    @Autowired
    private SecurityCompanyPersonService securityCompanyPersonService;

    @Autowired
    private PersonAwardService personAwardService;

    @Autowired
    private PersonPunishService personPunishService;

    @Autowired
    private ConfigUtils configUtils;

    @RequestMapping("/list")
    public ModelAndView detail(PersonPageSearchDto searchDto) {
        ModelAndView view = new ModelAndView("mobile/person/list");
        view.addObject("searchDto",searchDto);
        return view;
    }

    /**
     * 企业概述
     * @param id
     * @return
     */
    @RequestMapping("/detail")
    public ModelAndView detail(Long id,Long relationId) {
        ModelAndView view = new ModelAndView("mobile/person/detail");
        SecurityPerson person =securityPersonService.findById(id);
        //获取
        if(relationId!=null){
            person.setRelation(securityCompanyPersonService.findById(relationId));
        }
        view.addObject("record",person);
        return view;
    }


    /**
     * 基础信息
     * @param id
     * @return
     */
    @RequestMapping("/baseInfo")
    public ModelAndView baseInfo(Long id, HttpServletRequest request) {
        ModelAndView view = new ModelAndView("mobile/person/baseInfo");
        SecurityPerson person = securityPersonService.findById(id);
        person.setNativePlace(NativeUtil.getNativeByIdNum(person.getIdNumber(),request));
        view.addObject("record",person);
        return view;
    }


    /**
     * 证书信息
     * @param id
     * @return
     */
    @RequestMapping("/certificateInfo")
    public ModelAndView certificateInfo(Long id) {
        ModelAndView view = new ModelAndView("mobile/person/certificateInfo");
        view.addObject("record",securityPersonService.findById(id));
        return view;
    }

    /**
     * 检查记录
     * @return
     */
    @RequestMapping("/checkLog")
    public ModelAndView checkLog(Long personId) {
        ModelAndView view = new ModelAndView("mobile/person/checkLog");
        view.addObject("personId",personId);
        return view;
    }

    /**
     * 新增表彰奖励
     * @param person
     * @return
     */
    @RequestMapping("/award")
    public ModelAndView award(SecurityPersonDTO person) {
        ModelAndView view = new ModelAndView("mobile/person/award");
        view.addObject("record",person);
        view.addObject("token", configUtils.getToken());
        return view;
    }

    /**
     * 表彰奖励详情
     * @param id
     * @return
     */
    @RequestMapping("/award/detail")
    public ModelAndView awardDetail(Long id,String routeType) {
        ModelAndView view = new ModelAndView("mobile/person/awardDetail");
        view.addObject("record",personAwardService.findById(id));
        view.addObject("routeType",routeType);
        return view;
    }

    /**
     * 新增违法违规处罚
     * @param person
     * @return
     */
    @RequestMapping("/punish")
    public ModelAndView punish(SecurityPersonDTO person) {
        ModelAndView view = new ModelAndView("mobile/person/punish");
        view.addObject("record",person);
        view.addObject("token", configUtils.getToken());
        return view;
    }

    /**
     * 违法违规处罚详情
     * @param id
     * @return
     */
    @RequestMapping("/punish/detail")
    public ModelAndView punishDetail(Long id,String routeType)  {
        ModelAndView view = new ModelAndView("mobile/person/punishDetail");
        view.addObject("record",personPunishService.findById(id));
        view.addObject("routeType",routeType);
        return view;
    }

}
