package com.bcxin.ars.rest.interceptor;

import com.abcxin.smart.validator.annotation.CheckFormToken;
import com.abcxin.smart.validator.annotation.FormToken;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.service.util.ConfigUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import java.lang.reflect.Method;

/**
 * 表单重复提交 返回值统一处理加上token
 * @author linqinglin
 * @date 2019/09/02 0002 11:15
 */
@ControllerAdvice
public class FormResponseAdvice implements ResponseBodyAdvice<Object> {

    @Autowired
    ConfigUtils configUtils;

    @Override
    public boolean supports(MethodParameter methodParameter, Class<? extends HttpMessageConverter<?>> aClass) {
        return true;
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter methodParameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> aClass, ServerHttpRequest serverHttpRequest, ServerHttpResponse serverHttpResponse) {
        Method method = methodParameter.getMethod();
        //FormToken
        if (method.isAnnotationPresent(FormToken.class)) {
            FormToken formToken = method.getAnnotation(FormToken.class);
            if (formToken.required()) {
                if(body instanceof AjaxResult){
                    AjaxResult result = ((AjaxResult) body);
                    result.setToken(configUtils.getToken());
                }
            }
        }else if (method.isAnnotationPresent(CheckFormToken.class)) {
            CheckFormToken formToken = method.getAnnotation(CheckFormToken.class);
            if (formToken.required()) {
                if(body instanceof AjaxResult){
                    AjaxResult result = ((AjaxResult) body);
                    result.setToken(configUtils.getToken());
                }
            }
        }

        return body;
    }
}
