package com.bcxin.ars.rest.interceptor;

import com.abcxin.smart.validator.annotation.CheckFormToken;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.service.util.ConfigUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;

/**
 * 表单重复提交拦截器
 *
 */
public class FormInterceptor implements HandlerInterceptor  {

	@Autowired
	ConfigUtils configUtils;

	@Override
	public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o) throws Exception {
		//防表单重复提交
		// 如果不是映射到方法直接通过
		if (!(o instanceof HandlerMethod)) {
			return true;
		}

		HandlerMethod handlerMethod = (HandlerMethod) o;
		Method method = handlerMethod.getMethod();
		//CheckFormToken，有则跳过认证
		if (method.isAnnotationPresent(CheckFormToken.class)) {
			CheckFormToken checkFormToken = method.getAnnotation(CheckFormToken.class);
			if (checkFormToken.required()) {
				boolean isRepeat = isRepeatSubmit(httpServletRequest);//判断用户是否是重复提交
				if(isRepeat==true){
					AjaxResult result = new AjaxResult(false,"请不要重复提交。");
					result.setToken(configUtils.getToken());
					httpServletResponse.getWriter().write(JSONObject.toJSONString(result));
					httpServletResponse.getWriter().flush();
					return false;
				}

				return true;
			}
		}

		return true;
	}

	@Override
	public void postHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, ModelAndView modelAndView) throws Exception {
	}

	@Override
	public void afterCompletion(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object o, Exception e) throws Exception {
	}


	/**
	 * 判断客户端提交上来的令牌和服务器端生成的令牌是否一致
	 * @param request
	 * @return
	 * true 用户重复提交了表单
	 * false 用户没有重复提交表单
	 */
	private boolean isRepeatSubmit(HttpServletRequest request) {
		String client_token = request.getParameter("token");
		//1、如果用户提交的表单数据中没有token，则用户是重复提交了表单
		return !configUtils.isExistToken(client_token);
	}
}
