package com.bcxin.ars.rest.exam;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

import javax.servlet.http.HttpServletResponse;

import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.exam.TrainExamPersonSearchDto;
import com.bcxin.ars.dto.sb.ExamSearchDto;
import com.bcxin.ars.model.PageResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.exam.TrainExamPerson;
import com.bcxin.ars.service.exam.TrainExamPersonService;
import com.bcxin.ars.service.sb.PersoncertificateService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.excel.ExcelEnum;
import com.bcxin.ars.util.StringUtil;

import net.sf.json.JSONObject;

/**
 * 考试人员信息管理
 *
 * @author wangjianchi
 */
@Controller
@RequestMapping("examPerson")
public class TrainExamPersonWebController {

    private static final Logger logger = LoggerFactory.getLogger(TrainExamPersonWebController.class);
    @Autowired
    private TrainExamPersonService trainExamPersonService;
    @Autowired
    private PersoncertificateService personcertificateService;
    @Autowired
    private ArsUtil arsUtil;

    /**
     * 分页搜索查询
     *
     * @return
     */
    @RequestMapping(value = "/page")
    @ResponseBody
    public PageResult page(TrainExamPersonSearchDto dto) {
        User user = arsUtil.getCurrentUser();
        if (user != null) {
            return trainExamPersonService.query(dto);
        } else {
            return null;
        }
    }

    /**
     * 根据保安员证人员ID查看人员所有考试信息
     *
     * @return
     */
    @RequestMapping(value = "/history")
    @ResponseBody
    public PageResult history(TrainExamPersonSearchDto dto) {
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                return trainExamPersonService.queryHistory(dto);
            } else {
                return null;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * 获取需要新增的考试人员名单分页功能 <b>Function </b>（百课堂）
     *
     * @param searchDto
     * @return
     * @author wangjianchi
     * @date 2018年8月10日 下午5:00:07
     * @注意事项 </b> <b>
     */
    @RequestMapping("findUnScheduledPersonList")
    public @ResponseBody
    PageResult findUnScheduledPersonList(ExamSearchDto searchDto) {
        try {

            User user = arsUtil.getCurrentUser();
            if (user != null) {

                String areaCode = user.getCityAreaCode();
                if (searchDto.getAreaCode() != null) {
                    areaCode = searchDto.getAreaCode();
                }
                // 省级
                if (areaCode.endsWith("0000")) {
                    searchDto.setAreaCode(areaCode.substring(0, 2) + "____");
                    // 市级
                } else if (areaCode.endsWith("00")) {
                    searchDto.setAreaCode(areaCode.substring(0, 4) + "__");
                } else {
                    searchDto.setAreaCode(areaCode);
                }
                return personcertificateService.query(searchDto);
            } else {
                return null;
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }

    /**
     * 批量新增考试学员到指定考场功能 <b>Function </b>
     *
     * @param dataJSON
     * @return
     * @author wangjianchi
     * @date 2018年8月13日 下午5:00:07
     * @注意事项 </b> <b>
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(String dataJSON) {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                if (StringUtil.isNotEmpty(dataJSON)) {
                    List<TrainExamPerson> trainExamPeoples = JSON.parseArray(dataJSON, TrainExamPerson.class);
                    String resultMsg = trainExamPersonService.batchSave(trainExamPeoples);
                    if (StringUtils.isEmpty(resultMsg)) {
                        result.setMsg("操作成功！");
                    } else {
                        result.setMsg(resultMsg);
                    }
                    result.setSuccessful(true);
                }
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 更新考试人员成绩信息
     *
     * @param trainExamPerson
     * @return
     * @throws Exception
     */
    @RequestMapping("updateScore")
    public @ResponseBody
    AjaxResult updateScore(TrainExamPerson trainExamPerson) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                result.setSuccessful(true);
                TrainExamPerson dbTrainExamPerson =trainExamPersonService.updateScore(trainExamPerson);
                result.setData(dbTrainExamPerson);
                result.setMsg("操作成功!");
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据ID获取人员信息
     *
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping("findById/{id}")
    public @ResponseBody
    AjaxResult findById(@PathVariable("id") Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            TrainExamPerson trainExamPerson = trainExamPersonService.findById(id);
            result.setSuccessful(true);
            result.setData(trainExamPerson);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据ID删除人员信息
     *
     * @param id
     * @return
     * @throws Exception
     */
    @RequestMapping("delById/{id}")
    public @ResponseBody
    AjaxResult delById(@PathVariable("id") Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            trainExamPersonService.deleteById(id);
            result.setSuccessful(true);
            result.setMsg("删除成功！");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 批量导出学员成绩数据
     *
     * @param examID
     * @return
     */
    @RequestMapping(value = "/exportData")
    @ResponseBody
    public AjaxResult exportData(@RequestParam Long examID) {
        AjaxResult result = new AjaxResult();
        if (examID == null) {
            result.setSuccessful(false);
            result.setMsg("考场ID不能为空！");
            return result;
        }
        result = trainExamPersonService.exportData(examID);
        result.setSuccessful(true);
        return result;
    }

    /**
     * 下载学员成绩Excel
     *
     * @param examPersonJSON
     * @param response
     * @return
     */
    @RequestMapping(value = "/download")
    @ResponseBody
    public AjaxResult download(@RequestParam String examPersonJSON, HttpServletResponse response) {
        AjaxResult result = new AjaxResult();
        OutputStream os = null;
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition",
                    "attachment;fileName=" + new String("学员成绩信息汇总表.xls".getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            trainExamPersonService.downLoad(examPersonJSON, os);
            result.setSuccessful(true);
        } catch (Exception e) {
            result.setSuccessful(false);
        } finally {
            try {
                if (os != null) {
                    os.flush();
                    os.close();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /**
     * 下载录入学员名单Excel模板
     *
     * @param examID
     * @param response
     * @return
     */
    @RequestMapping(value = "/template")
    @ResponseBody
    public AjaxResult template(@RequestParam Long examID, HttpServletResponse response) {
        AjaxResult result = new AjaxResult();
        OutputStream os = null;
        try {
            response.setContentType("application/vnd.ms-excel");
            response.setHeader("Content-Disposition",
                    "attachment;fileName=" + new String("学员成绩名单表.xls".getBytes("gb2312"), "ISO8859-1"));
            os = response.getOutputStream();
            result = trainExamPersonService.template(examID, os);
        } catch (Exception e) {
            result.setSuccessful(false);
        } finally {
            try {
                if (os != null) {
                    os.flush();
                    os.close();
                }
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    /**
     * 批量导入学员成绩Excel
     *
     * @param file
     * @return
     */
    @RequestMapping(value = "/importResult")
    public void importResult(MultipartFile file, @RequestParam Long examID, HttpServletResponse response) {
        InputStream inputStream = null;
        AjaxResult result = new AjaxResult();
        try {
            response.addHeader("Content-Type", "text/html");
            String resultMsg = "";
            if (file != null && file.getSize() > 0) {
                String fileType = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1)
                        .toLowerCase();// 文件类型
                if (!fileType.equals(ExcelEnum.EXCEL_TYPE_XLS.getValue())
                        && !fileType.equals(ExcelEnum.EXCEL_TYPE_XLSX.getValue())) {
                    result.setSuccessful(false);
                    resultMsg = "上传文件不是Excel文件！";
                    result.setMsg(resultMsg);
                } else {
                    inputStream = file.getInputStream();
                    result = trainExamPersonService.importResult(examID, inputStream, fileType);
                }
            } else {
                result.setSuccessful(false);
                resultMsg = "上传文件不能为空！";
                result.setMsg(resultMsg);
            }

        } catch (Exception e) {
            if (inputStream != null) {
                try {
                    inputStream.close();
                } catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            result.setSuccessful(false);
        }
        try {
            JSONObject responseJSONObject = JSONObject.fromObject(result);
            response.getWriter().append(responseJSONObject.toString());
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    /**
     * 发送考试通知
     *
     * @param trainExamPerson
     * @return
     * @throws Exception
     */
    @RequestMapping("sendExamNotice")
    public @ResponseBody
    AjaxResult sendExamNotice(TrainExamPersonSearchDto trainExamPersonSearchDto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                result.setSuccessful(true);
                String msg = trainExamPersonService.sendExamNotice(trainExamPersonSearchDto);
                result.setMsg(msg);
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 发送成绩通知
     *
     * @param trainExamPersonSearchDto
     * @return
     * @throws Exception
     */
    @RequestMapping("sendScoreNotice")
    public @ResponseBody
    AjaxResult sendScoreNotice(TrainExamPersonSearchDto trainExamPersonSearchDto)
            throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                result.setSuccessful(true);
                String msg = trainExamPersonService.sendScoreNotice(trainExamPersonSearchDto);
                result.setMsg(msg);
            } else {
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
