package com.bcxin.ars.rest.exam;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.exam.TrainExamConfig;
import com.bcxin.ars.service.exam.TrainExamConfigService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * 考试权限配置管理
 *
 * @author wangjianchi
 * @version 1.0
 */
@Controller
@RequestMapping("exam/config")
public class TrainExamConfigController {

    private static final Logger logger = LoggerFactory.getLogger(TrainExamConfigController.class);

    @Autowired
    private TrainExamConfigService trainExamConfigService;
    @Autowired
    private ArsUtil arsUtil;

    /**
     * 分页查询
     *
     * @param trainExamConfig
     * @return
     */
    @RequestMapping(value = "/list")
    @ResponseBody
    public AjaxResult list(TrainExamConfig trainExamConfig) {
        AjaxResult result = new AjaxResult();
        User user = arsUtil.getCurrentUser();
        if (user != null) {
            String areaCode = user.getCityAreaCode();
            if (StringUtil.isNotEmpty(areaCode)) {
                trainExamConfig.setAreaCode(areaCode);
                List<TrainExamConfig> list = trainExamConfigService.list(trainExamConfig);
                result.setData(list);
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
            }
            return result;
        } else {
            return null;
        }
    }
}
