package com.bcxin.ars.rest.epidemic;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.epidemic.RiskAreaDto;
import com.bcxin.ars.model.epidemic.RiskArea;
import com.bcxin.ars.service.epidemic.RiskAreaService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping("riskArea")
public class RiskAreaController {

    /***
     * 日志
     */
    private static  final Logger logger = LoggerFactory.getLogger(RiskAreaController.class);
    @Autowired
    private RiskAreaService riskAreaService;
    /**
     *
     * @return
     */
    @RequestMapping("list")
    public ModelAndView list() {
        ModelAndView view = new ModelAndView("riskArea/list");
        return view;
    }
    /**
     * 查询全部
     * @return
     */
    @RequestMapping("search")
    @ResponseBody
    public AjaxPageResponse search(RiskAreaDto riskAreaDto, AjaxPageResponse<RiskArea> page) throws Exception {
        riskAreaService.search(riskAreaDto,page);
        return page;
    }
    /**
     * 新增编辑页面
     * @param riskArea
     * @return
     */
    @RequestMapping("edit")
    public ModelAndView editIndex(RiskArea riskArea){
        ModelAndView view = new ModelAndView("riskArea/edit");
        view.addObject("record",riskArea);
        return view;
    }
    /**
     * 进入修改页面
     * @return
     */
    @RequestMapping("enterEditPage")
    public ModelAndView enterEditPage(Long id) {
        ModelAndView view = new ModelAndView("riskArea/edit");
        view.addObject("record",riskAreaService.findById(id));
        return view;
    }
    /**
     * 保存
     * @param riskArea
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(RiskArea riskArea){
        AjaxResult result = new AjaxResult();
        try {
            riskAreaService.save(riskArea);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }


}
