package com.bcxin.ars.rest.epidemic;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.appeal.AppealSearchDto;
import com.bcxin.ars.dto.epidemic.EpidemicSearchDto;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.epidemic.Epidemic;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.epidemic.EpidemicService;
import com.bcxin.ars.service.epidemic.RiskAreaService;
import com.bcxin.ars.service.task.ComTaskService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import java.util.List;

@RequestMapping("epidemic")
@Controller
public class EpidemicController {



    private static final Logger logger = LoggerFactory.getLogger(EpidemicController.class);


    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private EpidemicService epidemicService;

    @Autowired
    private ComTaskService comTaskService;

    @Autowired
    private SecurityCompanyService securityCompanyService;

    @Autowired
    private RiskAreaService riskAreaService;
    /***
     * 进入查询页面
     * @return 页面路径
     */
    @RequestMapping("query")
    public ModelAndView listPage(AppealSearchDto searchDto) {
        ModelAndView view = new ModelAndView("epidemic/list");
        Epidemic record = new Epidemic();
        User currentUser = arsUtil.getCurrentUser();
        record.setUserId(currentUser.getId());
        view.addObject("record",record);
        return view;
    }

    /***
     * 进入查询页面（公安）
     * @return 页面路径
     */
    @RequestMapping("queryPolice")
    public ModelAndView listPolicePage(AppealSearchDto searchDto) {
        ModelAndView view = new ModelAndView("epidemic/listPolice");
        view.addObject("record",searchDto);
        return view;
    }
    /***
     * 分页查询
     * @param searchDto 查询参数
     * @param page 返回查询列表
     * @throws Exception 异常
     */
    @RequestMapping("searchForPage")
    public @ResponseBody
    AjaxPageResponse searchForPage(EpidemicSearchDto searchDto, AjaxPageResponse<Epidemic> page)  throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            epidemicService.searchForPage(searchDto,page);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return page;
    }

    /***
     * 进入查询页面
     * @return 页面路径
     */
    @RequestMapping("add")
    public ModelAndView addPage() {
        ModelAndView view = new ModelAndView("epidemic/edit");
        //当前用户
        User currentUser = arsUtil.getCurrentUser();
        SecurityCompany company = securityCompanyService.findByUserid(currentUser.getId());
//        SecurityCompany company = securityCompanyService.findByUserid(670597175091501L);

        if(company!=null) {
            List taskList = comTaskService.findByComId(company.getComId());
            view.addObject("taskList",taskList);
        }
        Epidemic record = new Epidemic();
        //Epidemic newRecord = epidemicService.findNew(currentUser.getId());
        record.setFilledType("1");
        Epidemic newRecord = epidemicService.findNew(currentUser.getId());
        //填报时间和填报人
        if(newRecord!=null){
            record.setFilledBy(newRecord.getFilledBy());
            record.setFilledByPhone(newRecord.getFilledByPhone());
        }
        view.addObject("record",record);


        view.addObject("streetList",riskAreaService.findAll());

        return view;
    }

    /***
     * 进入查询页面
     * @return 页面路径
     */
    @RequestMapping("edit")
    public ModelAndView editPage(Long id) {
        ModelAndView view = new ModelAndView("epidemic/edit");
        //当前用户
        User currentUser = arsUtil.getCurrentUser();
         SecurityCompany company = securityCompanyService.findByUserid(currentUser.getId());
//        SecurityCompany company = securityCompanyService.findByUserid(670597175091501L);
        if(company!=null) {
            List taskList = comTaskService.findByComId(company.getComId());
            view.addObject("taskList",taskList);
        }
        view.addObject("streetList",riskAreaService.findAll());

        
        view.addObject("record",epidemicService.findById(id));
        return view;
    }
    /***
     * 进入查询页面
     * @return 页面路径
     */
    @RequestMapping("view")
    public ModelAndView viewPage(Long id) {
        ModelAndView view = new ModelAndView("epidemic/view");
        view.addObject("record",epidemicService.findById(id));
        return view;
    }

    /***
     * 查询未补充街道个数
     * @desc add subh
     */
    @RequestMapping("findByStreetCount")
    public @ResponseBody AjaxResult findByStreetCount(Epidemic epidemic){
        AjaxResult result = new AjaxResult();
        try {
            User currentUser = arsUtil.getCurrentUser();
            epidemic.setUserId(currentUser.getId());
            result.setData(epidemicService.findByStreetCount(epidemic));
            result.setSuccessful(true);
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /***
     * 保存或更新
     * @desc add subh
     */
    @RequestMapping("del")
    public @ResponseBody AjaxResult del(Epidemic epidemic){
        AjaxResult result = new AjaxResult();
        try {
            epidemicService.del(epidemic);
            result.setSuccessful(true);
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }



    /***
     * 复制前一天的数据
     * @desc add subh
     */
    @RequestMapping("copyYesterdayData")
    public @ResponseBody AjaxResult copyYesterdayData(){
        AjaxResult result = new AjaxResult();
        try {
            epidemicService.saveCopyYesterdayData();
            result.setSuccessful(true);
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /***
     * 保存或更新
     * @desc add subh
     */
    @RequestMapping("saveOrUpdate")
    public @ResponseBody AjaxResult saveOrUpdate(Epidemic epidemic) throws  Exception{
        AjaxResult result = new AjaxResult();
        try {
            if(epidemic.getId()==null) {
                epidemicService.insert(epidemic);
            }else{
                epidemicService.update(epidemic);
            }
            result.setSuccessful(true);
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
