package com.bcxin.ars.rest.conference;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.UserDto;
import com.bcxin.ars.dto.UserSearchDto;
import com.bcxin.ars.dto.conference.CloudConferenceRoomSearchDto;
import com.bcxin.ars.service.conference.CloudConferenceRoomService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;

/**
 * 云会议室相关
 * @author zhangyutong
 */
@Controller
@RequestMapping("conference")
public class CloudConferenceRoomController {

    @Resource
    private CloudConferenceRoomService cloudConferenceRoomService;

    @RequestMapping("room/list")
    public ModelAndView cloudListView(ModelAndView modelAndView) {
        modelAndView.setViewName("conference/room/list");
        return modelAndView;
    }

    @RequestMapping("room/searchForPage")
    @ResponseBody
    public AjaxPageResponse<CloudConferenceRoomSearchDto> cloudList(CloudConferenceRoomSearchDto cloudConferenceRoomSearchDto) {
        return cloudConferenceRoomService.listCloudConferenceRoom(cloudConferenceRoomSearchDto);
    }

    @RequestMapping("room/recycleVmr")
    @ResponseBody
    public AjaxResult recycleVmr(String[] ids,
                                 String memberId) {
        return cloudConferenceRoomService.recycleVmr(ids,memberId);
    }


    @RequestMapping("room/assignVmr")
    @ResponseBody
    public AjaxResult assignVmr(String[] ids,
                                String memberId) {
        return cloudConferenceRoomService.assignVmr(ids,memberId);
    }


    @RequestMapping("room/assignListView")
    public ModelAndView assignListView(ModelAndView modelAndView) {
        modelAndView.setViewName("conference/room/assignList");
        return modelAndView;
    }

    @RequestMapping("room/getAssignList")
    @ResponseBody
    public AjaxPageResponse<UserDto> getAssignList(UserSearchDto userSearchDto,
                                                   AjaxPageResponse<UserDto> userDtoAjaxPageResponse) {
        return cloudConferenceRoomService.getAssignList(userSearchDto,userDtoAjaxPageResponse);
    }
}
