package com.bcxin.ars.rest.certificate;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.certificate.TrainCertificateSearchDto;
import com.bcxin.ars.model.Police;
import com.bcxin.ars.model.ProjectChange;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.TrainCertificate;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.ProjectChangeService;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.certificate.TrainCertificateService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.approval.BusinessType;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.List;


/**
 * 保安员处罚
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年8月2日 上午9:59:41
 * @注意事项 </b>
 * <b>
 */

@Controller
@RequestMapping("trainCertificate")
public class TrainCertificateController {
	
	private static final Logger logger = LoggerFactory.getLogger(TrainCertificateController.class);
	
	@Autowired
	private TrainCertificateService trainCertificateService;

	@Autowired
	private SecurityPersonService securityPersonService;

	@Autowired
	private ProjectChangeService projectChangeService;

	@Autowired
	private ArsRestUtil arsUtil;
	@Autowired
	private SecurityCompanyService securityCompanyService;

	@Autowired
	private ConfigUtils configUtils;

	@RequestMapping("list/index")
	public ModelAndView listPage(TrainCertificateSearchDto searchDto){
		ModelAndView view = new ModelAndView("certificate/train/list"+configUtils.getCurrentNative());
		view.addObject("record",searchDto);
		return view;
	}

	/**
	 * 保安培训机构许可证打印列表页面
	 * @return
	 */
	@RequestMapping("toQueryPage")
	@RequiresPermissions("traincompanyapplyPrint:query")
	public ModelAndView listIndex(TrainCertificateSearchDto searchDto){
		ModelAndView view = new ModelAndView("certificate/train/list");
		view.addObject("record",searchDto);
		return view;
	}
	/**
	 * 分页查询
	 * @return
	 */
	@RequestMapping("searchForPage")
    @RequiresPermissions("traincompanyapplyPrint:query")
	@ResponseBody
	public AjaxPageResponse searchForPage(TrainCertificateSearchDto trainCertificateSearchDto,AjaxPageResponse<TrainCertificate> page) throws Exception {
		trainCertificateService.searchForPage(trainCertificateSearchDto,page);
		return page;
	}
	/**
	 * 查询全部
	 * @return
	 */
	@RequestMapping("search")
    @RequiresPermissions("traincompanyapplyPrint:query")
	@ResponseBody
	public AjaxPageResponse search(TrainCertificateSearchDto trainCertificateSearchDto,AjaxPageResponse<TrainCertificate> page) throws Exception {
		User currentUser = arsUtil.getCurrentUser();
//		//机构信息
//		Police police = currentUser.getPolice();
//		if(police != null) {
//			String areacode = police.getAreacode();
//			if (areacode.endsWith("0000")) {//省
//				trainCertificateSearchDto.setDistrict(areacode.substring(0, 2) + "____");
//			} else if (areacode.endsWith("00")) {//市
//				trainCertificateSearchDto.setDistrict(areacode.substring(0, 4) + "__");
//			} else {//区
//				trainCertificateSearchDto.setDistrict(areacode);
//			}
//		}
		trainCertificateService.search(trainCertificateSearchDto,page);
		return page;
	}
	/**
	 * 查询全部
	 * @return
	 */
	@RequestMapping("v1/search")
	@RequiresPermissions("traincompanyapplyPrint:query")
	public @ResponseBody AjaxResult search(TrainCertificateSearchDto trainCertificateSearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User currentUser = arsUtil.getCurrentUser();
			//机构信息
			Police police = currentUser.getPolice();
			if(police != null) {
				String areacode = police.getAreacode();
				if (areacode.endsWith("0000")) {//省
					trainCertificateSearchDto.setDistrict(areacode.substring(0, 2) + "____");
				} else if (areacode.endsWith("00")) {//市
					trainCertificateSearchDto.setDistrict(areacode.substring(0, 4) + "__");
				} else {//区
					trainCertificateSearchDto.setDistrict(areacode);
				}
			}
			TrainCertificateSearchDto data = trainCertificateService.search(trainCertificateSearchDto);
			result.setSuccessful(true);
			result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 新增编辑页面
	 * @param trainCertificate
	 * @return
	 */
	@RequestMapping("edit/index")
	@RequiresPermissions("traincompanyapplyPrint:add")
	public ModelAndView editIndex(TrainCertificate trainCertificate){
		/*//公司名称可选，去掉已经存在的公司名称
		List<String > list = securityCompanyService.selectCompanyName("0103");
		List<String> tranList = trainCertificateService.selectCompanyName();
		list.removeAll(tranList);*/
		ModelAndView view = new ModelAndView("certificate/train/edit");
		if(trainCertificate.getId() != null){
			TrainCertificate trainCertificate1 = trainCertificateService.findById(trainCertificate.getId());
			//显示未驻入系统的公司名称
			String isInSystem = trainCertificate1.getIsInSystem();
			if(!StringUtils.isEmpty(isInSystem) && isInSystem.equals(Constants.NOT_IN_SYS)){
				String gsmc = trainCertificate1.getGsmc();
				trainCertificate1.setGsmcDefine(gsmc);
			}
			view.addObject("record",trainCertificate1);
			//修改的时候需要带入公司名称
			/*list.add(trainCertificate1.getGsmc());*/
		}else {
			//默认新增是已驻入系统的公司名
			trainCertificate.setIsInSystem(Constants.IS_IN_SYS);
			view.addObject("record", trainCertificate);
		}
		view.addObject("companyList", securityCompanyService.findByAll("0103"));
		return view;
	}

	/**
	 * 保存
	 * @param trainCertificate
	 * @return
	 */
	@RequestMapping("save")
	@ResponseBody
	public AjaxResult save(TrainCertificate trainCertificate){
		AjaxResult result = new AjaxResult();
		try {
			trainCertificateService.save(trainCertificate);
			result.setSuccessful(true);
			result.setMsg("操作成功");
		}catch (Exception e){
			logger.error(e.getMessage(), e);
			result.setSuccessful(false);
			throw e;
		}
		return result;
	}

	/**
	 * 创建或更新保安培训公司证书信息
	 * @param trainCertificate 保安培训公司证书信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	@RequiresPermissions("traincompanyapply:certificate")
	public @ResponseBody AjaxResult update(TrainCertificate trainCertificate, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			trainCertificateService.saveOrUpdate(trainCertificate);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}

	/**
	 * 创建或更新保安培训公司项目变更证书信息
	 * @param trainCertificate 保安培训公司证书信息
	 * @return
	 */
	@RequestMapping("updateForLegalchange")
    @RequiresPermissions("legalchange:certificate")
	public @ResponseBody AjaxResult updateForLegalchange(TrainCertificate trainCertificate ) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			trainCertificateService.saveOrUpdateForLegalchange(trainCertificate);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}

	@RequestMapping("updateAndCreatePDF")
	public @ResponseBody AjaxResult updateAndCreatePDF(TrainCertificate trainCertificate) {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				trainCertificateService.updateAndCreatePDF(trainCertificate);
				result.setSuccessful(true);
				result.setData(trainCertificate);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 批量生成pdf文件
	 */
	@RequestMapping("createPdfBatch")
	public @ResponseBody AjaxResult createPdfBatch() throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				trainCertificateService.createPdfBatch();
				result.setSuccessful(true);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 删除保安培训公司证书信息
	 * @return
	 */
	@RequestMapping("delete/{id}")
	public @ResponseBody AjaxResult delete(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			TrainCertificate trainCertificate = trainCertificateService.findById(id);

			if(trainCertificate != null) {
				trainCertificateService.delete(trainCertificate);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
					result.setMsg("删除信息失败，ID:" + id);
				}

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据ID获取保安培训公司证书信息
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id,String type) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			/***
			 * 根据id获取证书信息，并且根据打印类型（正副本）生成二维码
			 */
			TrainCertificate trainCertificate = trainCertificateService.findById(id,type);
			//获取项目变更记录信息
			List<ProjectChange> projectChangeList = projectChangeService.findByCertificateIdAndType(trainCertificate.getId().toString(), BusinessType.PXDW);
			if(null!=trainCertificate){
				trainCertificate.setProjectChangeList(projectChangeList);
			}
			result.setSuccessful(true);
			result.setData(trainCertificate);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据ID获取保安培训公司证书信息
	 * @return
	 */
	@RequestMapping("findByIdV2/{id}")
	public @ResponseBody AjaxResult findByIdV2(@PathVariable("id")Long id,String type) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			/***
			 * 根据id获取证书信息，并且根据打印类型（正副本）生成二维码
			 */
			TrainCertificate trainCertificate = trainCertificateService.findByIdV2(id,type);
			//获取项目变更记录信息
			List<ProjectChange> projectChangeList = projectChangeService.findByCertificateIdAndType(trainCertificate.getId().toString(), BusinessType.PXDW);
			if(null!=trainCertificate){
				trainCertificate.setProjectChangeList(projectChangeList);
			}
			result.setSuccessful(true);
			result.setData(trainCertificate);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据companyId获取保安培训公司证书信息
	 * @return
	 */
	@RequestMapping("findByCompanyId/{companyId}")
	public @ResponseBody AjaxResult findByCompanyId(@PathVariable("companyId")Long companyId) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			TrainCertificate trainCertificate = trainCertificateService.findByCompanyId(companyId);
			result.setSuccessful(true);
			result.setData(trainCertificate);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据申请ID更新打印状态
	 * @return
	 */
	@RequestMapping("updatePrintedByid/{id}")
	public @ResponseBody AjaxResult updatePrintedByidArr(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();

		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				trainCertificateService.updatePrintedByid(id);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
