package com.bcxin.ars.rest.certificate;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSycDto;
import com.bcxin.ars.dto.certificate.DSSecurityCertificateDto;
import com.bcxin.ars.dto.certificate.SecurityCertificateSearchDto;
import com.bcxin.ars.dto.page.SecurityCertificateDto;
import com.bcxin.ars.dto.page.SecurityCertificatePageSearchDto;
import com.bcxin.ars.dto.sb.PersoncertificateSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.PersonBaseInfo;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.PerCerSnapshot;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sb.PrintDesign;
import com.bcxin.ars.service.PersonBaseInfoService;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.certificate.PerCerSnapshotService;
import com.bcxin.ars.service.certificate.SecurityCertificateService;
import com.bcxin.ars.service.sb.PersoncertificateService;
import com.bcxin.ars.service.sb.PrintDesignService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.*;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.*;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

/****
 * 保安员
 */
@Controller
@RequestMapping("securityCertificate")
public class SecurityCertificateController {

	Logger logger = LoggerFactory.getLogger(SecurityCertificateController.class);
	
	@Autowired
	private SecurityCertificateService securityCertificateService;

	@Autowired
	private PerCerSnapshotService perCerSnapshotService;

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ConfigUtils configUtils;

	/***
	 * 公司服务层
	 */
	@Autowired
	private SecurityCompanyService securityCompanyService;

    /**
     * 资格证服务层
     */
	@Autowired
    private PersoncertificateService personcertificateService;

	@Value("${temp-folder}")
	private String tempfolder;


	@Autowired
	private GetPersonImgUtil getPersonImgUtil;

	@Autowired
	private PrintDesignService printDesignService;

	@Autowired
	private  PersonBaseInfoService personBaseInfoService;
	@RequestMapping("search")
	public @ResponseBody AjaxResult search(SecurityCertificateSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				SecurityCertificateSearchDto list = securityCertificateService.search(dto);
				result.setSuccessful(true);
				result.setData(list);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("publicSearch")
	public @ResponseBody AjaxResult publicSearch(SecurityCertificateSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			if(StringUtil.isEmpty(dto.getKeyword())){
				throw new ArsException("请输入要查询的内容！");
			}
			SecurityCertificateSearchDto list = securityCertificateService.search(dto);
			//循环获取保安员证图片 add subh 2018-05-19 start
			//临时数组变量
			List<SecurityCertificate> resultlist = new ArrayList<SecurityCertificate>();
			//循环设置图片的值
			for (SecurityCertificate securi:
				 list.getData()) {
				securi.setPhoto(getPersonImgUtil.getPersonImg(securi.getIdnum()));
				resultlist.add(securi);
			}
			list.setData(resultlist);
			//循环获取保安员证图片 add subh 2018-05-19 start
			result.setSuccessful(true);
			result.setData(list);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("update")
	public @ResponseBody AjaxResult update(SecurityCertificate securityCertificate) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				securityCertificateService.saveOrUpdate(securityCertificate);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findDetail")
	public @ResponseBody AjaxResult findDetail(SecurityCertificateSearchDto dto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<SecurityCertificate> securityCertificateList = securityCertificateService.findDetail(dto);
			result.setSuccessful(true);
			result.setData(securityCertificateList);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(SecurityCertificate securityCertificate) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				securityCertificateService.delete(securityCertificate);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SecurityCertificate securityCertificate = securityCertificateService.findById(id);
			result.setSuccessful(true);
			result.setData(securityCertificate);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据申请ID获取明细
	 * @return
	 */
	@RequestMapping("findBySecuritypersonid/{securitypersonid}")
	public @ResponseBody AjaxResult findBySecuritypersonid(@PathVariable("securitypersonid")Long securitypersonid,String type) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SecurityCertificate securityCertificate = securityCertificateService.findBySecuritypersonid(securitypersonid,type);
			if(securityCertificate!=null) {
				result.setSuccessful(true);
				result.setData(securityCertificate);
			}else{
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
    /**
     * 根据申请ID获取明细
     * @return
     */
    @RequestMapping("findBySecuritypersonIdForSingle/{securitypersonid}")
    public @ResponseBody AjaxResult findBySecuritypersonIdForSingle(@PathVariable("securitypersonid")Long securitypersonid) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            SecurityCertificate securityCertificate = securityCertificateService.findBySecuritypersonid(securitypersonid);
            if(securityCertificate!=null) {
                result.setSuccessful(true);
                result.setData(securityCertificate);
            }else{
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
	/**
	 * 根据申请ID获取明细
	 * @return
	 */
	@RequestMapping("findBySecuritypersonidArr")
	public @ResponseBody AjaxResult findBySecuritypersonid(String[] idArrays,String[] personids,String printsort,
	String printorder) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			//证书表的securitypersonId转换为Long
			Long[] idArray = new Long[idArrays.length];
			for (int i = 0; i < idArrays.length; i++) {
				idArray[i] = Long.valueOf(idArrays[i]);
			}
			SecurityCertificateSearchDto dto  = new SecurityCertificateSearchDto();
			dto.setIdArray(idArray);
			dto.setPrintsort(printsort);
			dto.setPrintorder(printorder);
			dto.setPersonIds(personids);
			//批量查询报名地址
			List<SecurityCertificate> securityCertificatelist = securityCertificateService.findBySecuritypersonidArr(dto);
			//批量查询人口地址
			if(securityCertificatelist!=null) {
				result.setSuccessful(true);
				result.setData(securityCertificatelist);
				result.setData("");
			}else{
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


	/**
	 * 根据申请ID获取明细
	 * @return
	 */
	@RequestMapping("batchFindBySecuritypersonid")
	public @ResponseBody AjaxResult batchFindBySecuritypersonid(String[] idArrays,String[] personids,String printsort,
														   String printorder,String types[]) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			//证书表的securitypersonId转换为Long
			Long[] idArray = new Long[idArrays.length];
			for (int i = 0; i < idArrays.length; i++) {
				idArray[i] = Long.valueOf(idArrays[i]);
			}
			//设置查询证书表参数
			SecurityCertificateSearchDto dto  = new SecurityCertificateSearchDto();
			dto.setIdArray(idArray);
			dto.setPrintsort(printsort);
			dto.setPrintorder(printorder);
			//设置查询报名表参数
			PersoncertificateSearchDto personcertificateSearchDto = new PersoncertificateSearchDto();
			personcertificateSearchDto.setIdArrs(idArray);
			//批量查询人口地址
			List<SecurityCertificate> securityCertificatelist = securityCertificateService.findBySecuritypersonidArr(dto);
			//批量查询报名地址
			List<Personcertificate> personcertificateList = personcertificateService.findAddressByIdArr(idArray);
			//把查询出来的id和报名地址放在同一个键值对
			Map<Long,String> map = new HashMap<>();
			for (Personcertificate personcertificate : personcertificateList) {
				map.put(personcertificate.getId(),personcertificate.getAddress());
			}
			//根据前端选择的地址返回前端页面
			for (SecurityCertificate securityCertificate : securityCertificatelist) {
				for(int i=0;i<idArray.length;i++){
					if(securityCertificate.getSecuritypersonid().equals(idArray[i])){
						String address = (types[i].equals("2"))?map.get(securityCertificate.getSecuritypersonid()):securityCertificate.getAddress();
						securityCertificate.setAddress(address);
						break;
					}
				}
			}
			if(securityCertificatelist!=null) {
				result.setSuccessful(true);
				result.setData(securityCertificatelist);
			}else{
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

    /***
     * 更新打印状态并记录日志
     * @param securitypersonid  主键
     * @param printType 打印类型
     * @return
     */
    @RequestMapping("updatePrintedByLog/{securitypersonid}")
    public @ResponseBody AjaxResult updatePrintedByLog(@PathVariable("securitypersonid")Long securitypersonid,String printType) {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                securityCertificateService.updatePrintedByLog(securitypersonid,printType);
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

	/**
	 * 根据申请ID更新打印状态
	 * @return
	 */
	@RequestMapping("updatePrintedByidArr/{idArray}")
	public @ResponseBody AjaxResult updatePrintedByidArr(@PathVariable("idArray")Long[] idArray) throws Exception {
		AjaxResult result = new AjaxResult();

		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				securityCertificateService.updatePrintedByidArr(idArray);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


	@RequestMapping("publicQueryInit")
	public ModelAndView publicQueryInit(String keyword){
		ModelAndView view = new ModelAndView();
		view.setViewName("securityCertificate/informationQuery");
		view.addObject("keyword",keyword);
		return view;
	}


	/**
	 * 批量导出保安员证书列表（内网导出）
	 */
	@RequestMapping("certExport")
	public @ResponseBody AjaxResult certExport(HttpServletRequest request) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				DataSycDto dataSycDto = new DataSycDto();
				DSSecurityCertificateDto cerDto = new DSSecurityCertificateDto();
				dataSycDto.setDataType(Constants.DATASYC_SECURITY_CERT_LIST);
				List<String> filePaths = new ArrayList<String>();
				List<SecurityCertificate> cerList = securityCertificateService.searchUpdateflagForExport();
				cerDto.setCerList(cerList);

				dataSycDto.setData(JSONObject.toJSONString(cerDto));
				Date now = new Date();
				String dirDate = DateUtil.systemDate.format(now);
				File dir = new File(tempfolder + dirDate);
				if (!dir.exists()) {
					dir.mkdirs();
				}
				String listStr = JSONObject.toJSONString(dataSycDto);
				String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(listStr.getBytes(), Constants.SECURITY_CER_KEY));

				String filepath = FileUtil.writeTxtFile(content, "securityCer", tempfolder);

				if (StringUtil.isNotEmpty(filepath)) {
					filePaths.add(filepath);
					result.setData(FileUtil.zipFiles(filePaths, tempfolder + FileUtil.generatingFileNameByDate("securityCer") + ".zip"));
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
				}
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


	/**
	 * 下载证书
	 * @param response
	 * @throws Exception
	 */
	@RequestMapping("downloadCert")
	public void exportApprovals(String templateName, HttpServletResponse response) throws Exception {
		User user = arsUtil.getCurrentUser();
		if (user != null) {
			File file = new File(templateName);
			if (file != null) {
				ServletOutputStream out = response.getOutputStream();
				response.addHeader("Content-Disposition", "attachment;filename=" + file.getName());
				InputStream is = new FileInputStream(file);
				int read = 0;
				byte[] buffer = new byte[8192];
				while ((read = is.read(buffer)) != -1) {
					out.write(buffer, 0, read);
				}
				is.close();
				out.flush();
				out.close();
				file.delete();
			}
		}
	}

	/**
	 * 批量导入保安资格证书列表（仅适用与内网数据导入到外网）
	 */
	@RequestMapping("certImport")
	public @ResponseBody
	AjaxResult importData(MultipartFile file, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			if (!file.getOriginalFilename().startsWith("securityCer")) {
				throw new ArsException("导入失败，非保安员资格证书的数据！");
			}

			Map<String, String> pathMap = new HashMap<>();
			List<String> filePaths = new ArrayList<String>();
			Date now = new Date();
			String fileName = now.getTime() + "_" + file.getOriginalFilename();
			String dirDate = DateUtil.systemDate.format(now);
			File dir = new File(tempfolder + dirDate);
			if (!dir.exists()) {
				dir.mkdirs();
			}
			String targetPath = tempfolder + dirDate + "/" + fileName;
			File targetFile = new File(targetPath);
			logger.info("执行文件上传..." + targetFile);
			file.transferTo(targetFile);
			File dataFile = null;
			long startTime = System.currentTimeMillis();
			try {
				ZipInputStream Zin = new ZipInputStream(new FileInputStream(targetFile));//输入源zip路径
				BufferedInputStream Bin = new BufferedInputStream(Zin);
				String Parent = tempfolder; //输出路径（文件夹目录）
				File Fout = null;
				ZipEntry entry;
				try {
					while ((entry = Zin.getNextEntry()) != null && !entry.isDirectory()) {
						Fout = new File(Parent, entry.getName());
						if (!Fout.exists()) {
							(new File(Fout.getParent())).mkdirs();
						}
						FileOutputStream out = new FileOutputStream(Fout);
						BufferedOutputStream Bout = new BufferedOutputStream(out);
						int b;
						while ((b = Bin.read()) != -1) {
							Bout.write(b);
						}
						Bout.close();
						out.close();
						if (Fout.getName().endsWith(".data")) {
							dataFile = Fout;
						} else {
							pathMap.put(Fout.getName(), Fout.getPath());
						}
						filePaths.add(Fout.getPath());
						logger.info(Fout + "解压成功");
					}
					Bin.close();
					Zin.close();
				} catch (IOException e) {
					logger.info(e.getMessage());
				}
			} catch (FileNotFoundException e) {
				logger.info(e.getMessage());
			}
			long endTime = System.currentTimeMillis();
			targetFile.delete();
			logger.info("耗费时间： " + (endTime - startTime) + " ms");
			if (dataFile != null) {
				BufferedReader br = new BufferedReader(new FileReader(dataFile));
				StringBuffer content = new StringBuffer();
				// 获取文件内容
				String lineTxt = null;
				while ((lineTxt = br.readLine()) != null) {// 使用readLine方法，一次读一行
					content.append(lineTxt);
				}
				br.close();

				String jsonStr = new String(CipherDESUtil.decrypt(Encodes.decodeHex(content.toString()), Constants.SECURITY_CER_KEY));

				DataSycDto dataSycDto = JSONObject.parseObject(jsonStr, DataSycDto.class);

				if (dataSycDto != null) {
					if (dataSycDto.getDataType().equals(Constants.DATASYC_SECURITY_CERT_LIST)) {
						DSSecurityCertificateDto certDto = JSONObject.parseObject(dataSycDto.getData(), DSSecurityCertificateDto.class);

						List<SecurityCertificate> certList = certDto.getCerList();



						result.setMsg("导入成功");
						result.setSuccessful(true);
					} else {
						result.setMsg("导入失败，非保安员证书的数据！");
						result.setSuccessful(false);
					}
				} else {
					result.setMsg("导入失败，非保安员证书的数据！");
					result.setSuccessful(false);
				}
			} else {
				result.setMsg("导入失败，非保安员证书的数据！");
				result.setSuccessful(false);
			}
			for (String filePath : filePaths) {
				FileUtil.deleteFolder(filePath);
			}

			Map<String, Object> resultMap = new HashMap<String, Object>();
			resultMap.put("faildFilePath", "");
			result.setData(resultMap);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

    /**
     * 手动获取人口库头像
     * @param idArrays
     * @return
     * @throws Exception
     */
	@RequestMapping("getPersonImg")
	public @ResponseBody AjaxResult getPersonImg(Long[] idArrays) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
                securityCertificateService.getPersonImg(idArrays);
                result.setSuccessful(true);
                result.setMsg("操作成功！");
			} else {
				result.setSuccessful(false);
				result.setMsg("请登录后面再试！");
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 *  批量证书领取状态
	 * @param
	 * @return 执行结果
	 */
	@RequestMapping("updateReceiveState")
	//shiro权限注解
	@RequiresPermissions("personcertificatePrint:receive")
	public @ResponseBody AjaxResult updateReceiveState(Long[] idArr){
		AjaxResult result = new AjaxResult();
		try {
			//获取当前用户信息
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				//更新领取状态
			 	securityCertificateService.updateReceiveState(idArr);
			 	//成功之返回给前端
				result.setSuccessful(true);
				result.setMsg("领取成功！");
			} else {
				//用户不存在则提示错误信息
				result.setMsg("用户未登陆，请重新登陆！");
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

    /***
     * 培训机构进入保安员资格证证书查询页面
     * @desc add subh 2019-03-22 14:39
     */
    @RequestMapping("choseAddress")
    public ModelAndView choseAddress(Long securitypersonid,Long id,String printType){
        ModelAndView view = new ModelAndView();
        Personcertificate personcertificate = personcertificateService.findById(securitypersonid);
        SecurityCertificate securityCertificate = securityCertificateService.findById(id);
        //证书信息
        view.addObject("securityCertificate",securityCertificate);
        //打印类型
        view.addObject("printType",printType);
        //报名信息
        view.addObject("personcertificate",personcertificate);
        view.setViewName("certificate/security/choseAddress");
        return view;
    }


    /**
	 * 公安进入保安员资格证证书批量查询地址页面
	 * @desc add yyx 2020-01-19
	 * @param idArrays
	 * @param personids
	 * @param printsort
	 * @param printorder
	 */
	@RequestMapping("choseAddressSecurityBatch")
	public ModelAndView choseAddressSecurityBatch(String[] idArrays,String[] personids,String printsort,
												  String printorder)throws Exception{
		ModelAndView view = new ModelAndView();
		try {
			//证书表的securitypersonId转换为Long
			Long[] idArray = new Long[idArrays.length];
			for (int i = 0; i < idArrays.length; i++) {
				idArray[i] = Long.valueOf(idArrays[i]);
			}
			//设置查询证书表参数
			SecurityCertificateSearchDto dto  = new SecurityCertificateSearchDto();
			dto.setIdArray(idArray);
			dto.setPrintsort(printsort);
			dto.setPrintorder(printorder);
			dto.setPersonIds(personids);
			//设置查询报名表参数
			PersoncertificateSearchDto personcertificateSearchDto = new PersoncertificateSearchDto();
			personcertificateSearchDto.setIdArrs(idArray);
			//批量查询人口地址
			List<SecurityCertificate> securityCertificatelist = securityCertificateService.findBySecuritypersonidArrBatch(dto);
			//批量查询报名地址
			List<Personcertificate> personcertificateList = personcertificateService.findByDtoIdArr(personcertificateSearchDto);
			//保证传给前端数据的id是一样的
			for (Personcertificate personcertificate : personcertificateList) {
				for (SecurityCertificate securityCertificate : securityCertificatelist) {
					if (personcertificate.getId().equals(securityCertificate.getSecuritypersonid())){
						personcertificate.setPopulationAddress(securityCertificate.getAddress());
						break;
					}
				}
			}
			view.addObject("personcertificateList",personcertificateList);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		view.setViewName("certificate/security/choseAddressSecurityBatch");
		return view;
	}
    /***
     * 公安进入保安员资格证证书查询页面
     * @desc add yyx 2020-01-17
     */
    @RequestMapping("choseAddressSecurity")
    public ModelAndView choseAddressSecurity(Long securitypersonid){
        ModelAndView view = new ModelAndView();
        //通过personId查询保安员证报名考试信息
        Personcertificate personcertificate = personcertificateService.findById(securitypersonid);
        //查询保安员证信息
        SecurityCertificate securityCertificate = securityCertificateService.findBySecuritypersonid(personcertificate.getId());
        //证书信息
        view.addObject("securityCertificate",securityCertificate);
        //报名信息
        view.addObject("personcertificate",personcertificate);
        view.setViewName("certificate/security/choseAddressSecurity");
        return view;
    }
    /***
     * 补证管理
     */
    @RequestMapping("trainOrg/queryRepair")
    public ModelAndView toQueryForRepair(){
        ModelAndView view = new ModelAndView();
        view.setViewName("certificate/security/queryRepair");
		List<PrintDesign> printDesigns = printDesignService.findByAreacode(configUtils.getCurrentProvince(), Constants.BAYZGZ);

		String printDesign = null;
		if(printDesigns.size() > 0){
			printDesign = printDesigns.get(0).getContent();
		}
		view.addObject("printDesign",printDesign);
        return view;
    }
	/***
	 * 培训机构进入保安员资格证证书查询页面
	 * @desc add subh 2019-03-22 14:39
	 */
	@RequestMapping("trainOrg/query")
	public ModelAndView toQueryForTrainOrg(){
		ModelAndView view = new ModelAndView();
		view.setViewName("certificate/security/query");

		List<PrintDesign> printDesigns = printDesignService.findByAreacode(configUtils.getCurrentProvince(), Constants.BAYZGZ);

		String printDesign = null;
		if(printDesigns.size() > 0){
			printDesign = printDesigns.get(0).getContent();
		}
		view.addObject("printDesign",printDesign);

		//获取当前用户
		User user = arsUtil.getCurrentUser();
		if(user!=null){
			//培训机构
			if(user.getPlatform() ==  Constants.PLATFORM_COMPANY) {
				//根据用户ID获取公司信息
				SecurityCompany company = securityCompanyService.findByUserid(user.getId());
				view.addObject("trainId",company.getComId());
			}
		}
		return view;
	}
	/***
	 * 培训机构查询保安员资格证方法
	 * @param dto 培训机构保安员证查询参数
	 * @return 保安员证列表
	 * @throws Exception
	 */
	@RequestMapping("searchForTrain")
	public @ResponseBody AjaxPageResponse searchForTrain(SecurityCertificateSearchDto dto,AjaxPageResponse page){
		try {
			//获取当前用户
			User user = arsUtil.getCurrentUser();
			if(user!=null&&StringUtil.isNotEmpty(dto.getTrainOrgID())){
				//培训机构
				if(user.getPlatform() ==  Constants.PLATFORM_COMPANY) {
					//根据用户ID获取公司信息
					SecurityCompany company = securityCompanyService.findByUserid(user.getId());
					//设置培训机构ID，查询
					dto.setTrainOrgID(company.getComId());
					//设置培训机构姓名，查询
					//dto.setTrainOrgName(company.getName());
				}
			}
			//查询保安员证信息
			securityCertificateService.searchForTrain(dto, page);
			return page;
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
	}

	/**
	 * 修改页面进入
	 * @param id
	 * @return
	 */
	@RequestMapping("edit/index")
	public ModelAndView editIndex(String id){
		ModelAndView view = new ModelAndView("certificate/security/edit"+configUtils.getCurrentNative());
		Long aLong = Long.valueOf(id);
		view.addObject("record",securityCertificateService.getDetail(aLong));
		return view;
	}
	/**
	 * 修改
	 * @param securityCertificate
	 * @return
	 */
	@RequestMapping("edit")
	@ResponseBody
	public AjaxResult edit(SecurityCertificate securityCertificate){
		AjaxResult result = new AjaxResult();
		try {
			securityCertificateService.edit(securityCertificate);
			result.setSuccessful(true);
			result.setMsg("修改成功！");
		}catch (Exception e){
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


	/***
	 * 根据不同的省市进入保安员资格证考试报名页面
	 * @return 页面路径
	 * @deprecated  add 2019-04-04
	 */
	@RequestMapping("/toListPage")
	@Deprecated
	public ModelAndView toListPage(SecurityCertificatePageSearchDto searchDto) {
		//默认返回路径地址，如有配置省份，地址加上省份编码，如北京splist11
		ModelAndView view = new ModelAndView("certificate/security/list"+configUtils.getCurrentNative());
		List<PrintDesign> printDesigns = printDesignService.findByAreacode(configUtils.getCurrentProvince(), Constants.BAYZGZ);

		String printDesign = null;
		if(printDesigns.size() > 0){
			printDesign = printDesigns.get(0).getContent();
		}
		view.addObject("printDesign",printDesign);
		view.addObject("record",searchDto);
		return view;
	}

	/**
	 * 保安员证书分页查询
	 * @param dto
	 * @param page
	 * @return
	 */
	@RequestMapping("searchForPage")
	@ResponseBody
	@Deprecated
	public AjaxPageResponse searchForPage(SecurityCertificatePageSearchDto dto, AjaxPageResponse<SecurityCertificateDto> page){
		securityCertificateService.searchForPage(dto,page);
		return page;
	}

	/**
	 * 电子证书（快照）
	 * @param snapshotId
	 * @return
	 */
	@RequestMapping("viewCer")
	public ModelAndView viewCer(String snapshotId){
		ModelAndView view = new ModelAndView("certificate/security/cerDetail");
		try {
			String qrcode = securityCertificateService.getQRCode(snapshotId);
			snapshotId = DES3.decode(snapshotId);
			PerCerSnapshot perCerSnapshot = perCerSnapshotService.findById(Long.parseLong(snapshotId));
			if(null!=perCerSnapshot&&StringUtil.isEmpty( perCerSnapshot.getPhoto())){
				//查询
				PersonBaseInfo baseInfo = personBaseInfoService.findByIdNum(perCerSnapshot.getIdNum());
				if(null!=baseInfo){
					perCerSnapshot.setPhoto(baseInfo.getImgPath());
				}
			}
			//perCerSnapshot.setQrcode(qrcode);
			if(perCerSnapshot == null){
				view.addObject("msg","暂无该打印信息，待数据同步到外网");
			}
			view.addObject("record",perCerSnapshot);
		}catch (Exception e){
			e.printStackTrace();
		}
		return view;
	}

	/**
	 * 打印预览根据证书ID获取明细
	 * @return
	 */
	@RequestMapping("previewById/{id}")
	public @ResponseBody AjaxResult previewById(@PathVariable("id")Long id,String type) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SecurityCertificate securityCertificate = securityCertificateService.previewById(id,type);
			if(securityCertificate!=null) {
				result.setSuccessful(true);
				result.setData(securityCertificate);
			}else{
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据申请ID获取明细
	 * @return
	 */
	@RequestMapping("previewByIdArr")
	public @ResponseBody AjaxResult previewByIdArr(SecurityCertificateSearchDto dto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			//批量查询人口地址
			List<SecurityCertificate> securityCertificatelist = securityCertificateService.previewByIdArr(dto);
			if(securityCertificatelist!=null) {
				result.setSuccessful(true);
				result.setData(securityCertificatelist);
			}else{
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

    /***
     * 公安进入保安员资格证证书查询页面
     * @desc add yyx 2020-01-17
     */
    @RequestMapping("choisePersonAddress")
    public ModelAndView choisePersonAddress(Long id,String printType){
        ModelAndView view = new ModelAndView("certificate/security/choisePersonAddress");
		//打印类型
		view.addObject("printType",printType);
        view.addObject("record",securityCertificateService.findById(id));
        return view;
    }

	/**
	 * 公安进入保安员资格证证书批量查询地址页面
	 * @desc add 070 2020-04-24
	 * @param idArr
	 */
	@RequestMapping("choisePersonAddressBatch")
	public ModelAndView choisePersonAddressBatch(Long[] idArr)throws Exception{
		ModelAndView view = new ModelAndView("certificate/security/choisePersonAddressBatch");
		try {
			//批量查询报名地址
			view.addObject("record",securityCertificateService.findAddressByIdArr(idArr));
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return view;
	}


    /**
     * 根据申请ID更新打印状态
     * @return
     */
    @RequestMapping("updatePrinted")
    public @ResponseBody AjaxResult updatePrinted(Long[] idArr,Long[] snapshotIdArr,String printType) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                securityCertificateService.updatePrinted(idArr,snapshotIdArr,printType);
            } else {
                result.setSuccessful(false);
            }
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("reCer")
    public @ResponseBody AjaxResult reCer(Long cerId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if(user != null) {
                result.setSuccessful(true);
                securityCertificateService.reCer(cerId);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("public/query/index")
	public ModelAndView queryIndex() {
		return new ModelAndView("public/personCertificate");
	}

	@RequestMapping(value = "public/search", method = RequestMethod.POST)
	@ResponseBody
	public AjaxResult publicSearch(String idnum) {
		return securityCertificateService.searchForPublicQuery(idnum);
	}
}

