package com.bcxin.ars.rest.certificate;

import com.bcxin.ars.dao.sys.FileTempDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.certificate.GradeCertificateSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.certificate.GradeCertificate;
import com.bcxin.ars.model.sys.FileTemp;
import com.bcxin.ars.rest.BaseController;
import com.bcxin.ars.service.certificate.GradeCertificateService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.IdcardValidator;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.poi.ExcelUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.util.*;

/****
 * 等级证信息
 * @author  subh
 */
@Controller
@RequestMapping("grade")
public class GradeCertificateController extends BaseController {
    /***
     * 日志
     */
    public static Logger logger = LoggerFactory.getLogger(GradeCertificateController.class);
    @Autowired
    private GradeCertificateService gradeCertificateService;
    @Value("${temp-folder}")
    private String tempfolder;
    @Autowired
    private ArsUtil arsUtil;
    @Autowired
    private FileTempDao fileTempDao;
    /***
     * 进入 等级证查询页面
     * @desc add subh 2019-03-22 14:39
     */
    @RequestMapping("toQueryPage")
    @RequiresPermissions("gradeManager:toQueryPage")
    public ModelAndView toQueryForTrainOrg(GradeCertificateSearchDto searchDto){
        ModelAndView view = new ModelAndView("certificate/grade/query");
        view.addObject("record",searchDto);
        return view;
    }

    /***
     * 进入 等级证修改页面
     * @param  id  主键
     */
    @RequestMapping("toEditPage/{id}")
    @RequiresPermissions("gradeManager:edit")
    public ModelAndView toEditPage(@PathVariable Long id){
        ModelAndView view = new ModelAndView();
        view.addObject("record",gradeCertificateService.findById(id));
        view.setViewName("certificate/grade/edit");
        return view;
    }
    /**
     * 修改
     * @param gradeCertificate 比对人员信息
     */
    @RequestMapping("edit")
    @RequiresPermissions("gradeManager:edit")
    @ResponseBody
    public AjaxResult edit(GradeCertificate gradeCertificate){
        AjaxResult result = new AjaxResult();
        try {
            gradeCertificateService.update(gradeCertificate);
            result.setSuccessful(true);
            result.setMsg("修改成功！");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /***
     * 等级证查询
     * @param dto 等级证查询参数
     * @return 等级证列表
     * @throws Exception
     */
    @RequestMapping("query")
    @RequiresPermissions("gradeManager:query")
    public @ResponseBody   AjaxPageResponse searchForTrain(GradeCertificateSearchDto dto, AjaxPageResponse page){
        try {
            //获取当前用户
            User user = arsUtil.getCurrentUser();
            if(user!=null){
                //公安设置为空
                if(user.getPlatform() ==  Constants.PLATFORM_POLICE) {
                    //公安设置为空
                    dto.setUserId(null);
                }
            }
            //查询等级证信息
            gradeCertificateService.query(dto, page);
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }


    /**
     * 批量导入等级证书信息
     */
    @RequestMapping("importGradeData")
    @RequiresPermissions("gradeManager:import")
    public @ResponseBody
    AjaxResult importSecurityGuardData(MultipartFile file, HttpServletRequest request)
            throws Exception {
        AjaxResult result = new AjaxResult();
        String fileType = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".") + 1);
        if (!fileType.toUpperCase().equalsIgnoreCase("XLS") && !fileType.toUpperCase().equalsIgnoreCase("XLSX")) {
            result.setMsg("导入的模板文件有误");
            result.setSuccessful(false);
            return result;
        }
        long startTime = System.currentTimeMillis();
        try {
            Date now = new Date();
            String fileName = now.getTime() + "." + fileType;
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(tempfolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String targetPath = tempfolder + dirDate + "/" + fileName;
            File targetFile = new File(targetPath);
            file.transferTo(targetFile);
            Map<String, Object> resultMap = new HashMap<String, Object>();
            User loginUser = arsUtil.getCurrentUser();
            List<Map<String, String>> list = new ArrayList<Map<String, String>>(); // 数据库校验的list
            List<Map<String, String>> faildList = new ArrayList<Map<String, String>>(); // 定义失败的list
            if (loginUser != null) {

                FileInputStream inStream = new FileInputStream(targetFile);
                Workbook workBook = WorkbookFactory.create(inStream);
                Sheet sheet = workBook.getSheetAt(0); // 读取第一个sheet
                boolean flag = true;
                int i = 5; // 设置初始行为第6行
                while (flag) {
                    Row row = sheet.getRow(i);
                    if (row != null) {
                        Map<String, String> data = new HashMap<String, String>();
                        try {
                            /*** 客户的数据格式及其复杂
                             *
                             * 1.英文的空格  2.中文的空格  3.非美式英文的半角空格  4.一个tab键  5 .2个tab键
                             * 不过tab键在java可以按英文空格处理，如果在数据库判断长度就非常长了
                             * 现有校验按 1-2-3
                             */
                            String errorMsg = ""; // 校验错误信息
                            /**** 身份证 ****/
                            String idnum = ExcelUtil.getCellValue(row.getCell(0));
                            idnum = idnum.trim().toUpperCase().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "");
                            data.put("idnum", idnum);

                            /**** 姓名 ****/
                            String name = ExcelUtil.getCellValue(row.getCell(1));
                            name = name.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "").replaceAll("	", "");
                            data.put("name", name);


                            /**** 等级证编号 ****/
                            String certificateNo = ExcelUtil.getCellValue(row.getCell(2));
                            certificateNo = certificateNo.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "").replaceAll("	", "");
                            data.put("certificateNo", certificateNo);


                            /**** 培训时间 ****/
                            String trainTime = ExcelUtil.getCellValue(row.getCell(3));
                            trainTime = trainTime.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "").replaceAll("	", "");
                            data.put("trainTime", trainTime);

                            /**** 鉴定时间 ****/
                            String appraisalTime = ExcelUtil.getCellValue(row.getCell(4));
                            appraisalTime = appraisalTime.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "").replaceAll("	", "");
                            data.put("appraisalTime", appraisalTime);

                            /**** 鉴定等级 ****/
                            String appraisalGrade = ExcelUtil.getCellValue(row.getCell(5));
                            appraisalGrade = appraisalGrade.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "").replaceAll("	", "");
                            data.put("appraisalGrade", appraisalGrade);

                            /**** 所在企业名称 ****/
                            String companyName = ExcelUtil.getCellValue(row.getCell(6));
                            companyName = companyName.trim().replaceAll(" ", "").replaceAll(" ", "").replaceAll(" ", "").replaceAll("	", "");
                            data.put("companyName", companyName);
                            /***** 校验excel字段 ****/

                            data.put("trainOrgName", loginUser.getRealname());
                            data.put("userId", loginUser.getId().toString());
                            data.put("updateBy", loginUser.getUsername());

                            /*** 身份证号码 ****/
                            if (StringUtil.isEmpty(idnum)) {
                                errorMsg = errorMsg + "身份证号码不能为空";
                            } else {
                                IdcardValidator idcardValidator = new IdcardValidator();
                                if (!idcardValidator.isValidatedAllIdcard(idnum)) {
                                    errorMsg = errorMsg
                                            + (StringUtil.isEmpty(errorMsg) ? "身份证号码格式错误" : " || " + "身份证号码格式错误");
                                }
                            }
                            /*** 姓名 ****/
                            if (StringUtil.isEmpty(name)) {
                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "姓名不能为空" : " || " + "姓名不能为空");
                            }
                            /*** 等级证书编号 ****/
                            if (StringUtil.isEmpty(certificateNo)) {
                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "等级证书编号不能为空" : " || " + "等级证书编号不能为空");
                            }

                            /*** 培训时间 ****/
                            if (StringUtil.isEmpty(trainTime)) {
                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "培训时间不能为空" : " || " + "培训时间不能为空");
                            }else{
                               if(!DateUtil.checkDate(trainTime)){
                                   errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "培训时间格式错误" : " || " + "培训时间格式错误");
                               }
                            }
                            /*** 鉴定时间 ****/
                            if (StringUtil.isEmpty(appraisalTime)) {
                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "鉴定时间不能为空" : " || " + "鉴定时间不能为空");
                            }else{
                                if(!DateUtil.checkDate(trainTime)){
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "鉴定时间格式错误" : " || " + "鉴定时间格式错误");
                                }
                            }
                            /*** 鉴定等级 ****/
                            if (StringUtil.isEmpty(appraisalGrade)) {
                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "鉴定等级不能为空" : " || " + "鉴定等级不能为空");
                            }else{
                                appraisalGrade = appraisalGrade.substring(0, 1);
                                if (!appraisalGrade.equalsIgnoreCase(Constants.APPRAISALGRADE_1)
                                        && !appraisalGrade.equalsIgnoreCase(Constants.APPRAISALGRADE_2) && !appraisalGrade.equalsIgnoreCase(Constants.APPRAISALGRADE_3)) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "鉴定等级无效" : " || " + "鉴定等级性别无效");
                                }
                                data.put("appraisalGrade", appraisalGrade);
                            }
                            /*** 所在单位名称  ****/
                            if (StringUtil.isEmpty(companyName)) {
                                errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg) ? "所在单位名称不能为空" : " || " + "所在单位名称不能为空");
                            }

                            // 生成错误的list
                            if (StringUtil.isNotEmpty(errorMsg)) {
                                data.put("errorMsg", errorMsg);
                                faildList.add(data);
                            } else {
                                list.add(data);
                            }

                        } catch (Exception e) {
                            if (e instanceof ArsException) {
                                data.put("errorMsg", e.getMessage());
                            } else {
                                data.put("errorMsg", "格式有错");
                            }
                            faildList.add(data);
                        }
                    } else {
                        flag = false;
                    }
                    i++;
                }

                /** 如果客户没上传内容 **/
                if (list.size() == 0 && faildList.size() == 0) {
                    result.setMsg("导入模板没有等级证信息，请录入");
                    result.setSuccessful(false);
                    return result;
                }

                /**** 处理保安师业务逻辑 ***/
                List<Map<String, String>> checkFaildList = new ArrayList<>();
                if (list != null && list.size() > 0) {
                    //处理业务逻辑
                      checkFaildList = gradeCertificateService.insertBatchForImport(list);
                }
                long endTime = System.currentTimeMillis();
                logger.info("耗费时间： " + (endTime - startTime) + " ms");

                /**** 如果校验的等级证息有误 ****/
                if (checkFaildList != null && checkFaildList.size() > 0) {
                    faildList.addAll(checkFaildList);
                }

                /**** 如果存在校验错误信息，导出excel表格 ****/
                if (faildList.size() > 0) {
                    String excelTmepName = "gradeFailTemp.xls"; // excel模板
                    FileTemp fileTemp = fileTempDao.getFileTempByName(excelTmepName); // 查询文件模板信息
                    resultMap.put("faildFilePath",
                            buildFaildList(Constants.FILETEMPPATH + fileTemp.getFileTempName(), faildList, request)); // 生成导入错误的文件
                }
            } else {
                throw new RuntimeException("当前登录信息错误, user:" + loginUser);
            }
            result.setData(resultMap);
            if (faildList.size() == 0) {
                result.setMsg("批量导入成功");
            } else {
                result.setMsg(faildList.size() + "条导入失败，请下载导入失败的等级证信息");
            }
            targetFile.delete(); // 导入成功完删除文件
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /***
     * 生成导入错误信息文件
     *
     * @param excelTempPath
     * @param data
     * @return downloadFilePath by llc 2018-08-09
     * @throws Exception
     */
    private String buildFaildList(String excelTempPath, List<Map<String, String>> data, HttpServletRequest request)
            throws Exception {

        Date now = new Date();
        String dirDate = DateUtil.systemDate.format(now);
        File dir = new File(tempfolder + dirDate);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String fileName = now.getTime() + "_importFailList.xls";
        String filePath = tempfolder + dirDate + "/" + fileName;
        String fileKey = "temp/" + dirDate + "/" + fileName;
        logger.info("路径： " + filePath);
        /**** 生成file ****/
        // FileUtil.reNameFile(excelTempPath,filePath); // 绝对路径文件实现
        reNameFile(excelTempPath, filePath, request);
        File file = new File(filePath);

        if (file != null) {
            HSSFWorkbook workbook = new HSSFWorkbook(new FileInputStream(file));
            HSSFSheet sheet = workbook.getSheetAt(0);
            int index = 5;
            for (Map<String, String> map : data) {
                Row row = sheet.createRow(index);
                row.createCell(0).setCellValue(map.get("idnum")); // 身份证
                row.createCell(1).setCellValue(map.get("name")); // 姓名
                row.createCell(2).setCellValue(map.get("certificateNo")); // 编号
                row.createCell(3).setCellValue(map.get("trainTime")); // 培训时间
                row.createCell(4).setCellValue(map.get("appraisalTime")); // 鉴定时间
                row.createCell(5).setCellValue(map.get("appraisalGrade")); // 等级
                row.createCell(6).setCellValue(map.get("companyName")); // 公司名称
                row.createCell(7).setCellValue(map.get("errorMsg")); // 错误信息
                index++;
            }
            FileOutputStream fileOut = new FileOutputStream(file);
            workbook.write(fileOut);
            fileOut.close();
            workbook.close();
            return "/getResource.do?path=" + fileKey;
        }
        return null;
    }

    /**
     * 重命名文件
     *
     * @param oldPath String 原文件路径 如：原文件路径
     *                如：c:/data/ars/temp/securityCertificateTemp.xls
     * @param newPath String 复制后路径 如：复制后路径 如：c:/data/ars/temp/2018-08-09/保安员导入失败.xls
     * @return boolean by llc 2018-08-09
     **/
    private static void reNameFile(String oldPath, String newPath, HttpServletRequest request) throws IOException {
        InputStream is = null;
        OutputStream out = null;
        try {
            is = request.getServletContext().getResourceAsStream(oldPath);
            int bytesum = 0;
            int byteread = 0;
            if (is != null) { // 文件存在时
                out = new FileOutputStream(newPath);
                byte[] buffer = new byte[1444];
                int length;
                while ((byteread = is.read(buffer)) != -1) {
                    bytesum += byteread; // 字节数 文件大小
                    out.write(buffer, 0, byteread);
                }
                is.close(); // 输入流关闭
                out.flush(); // 刷新输出流
                out.close(); // 输出流关闭
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw e;
        } finally { // 无论程序怎么运行，最后都要关闭流；
            if (is != null || out != null) {
                try {
                    is.close();// 输入流关闭
                    out.close(); // 输出流关闭
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
