package com.bcxin.ars.rest.certificate;


import com.bcxin.ars.dto.page.CertificatePrintLogSearchDto;
import com.bcxin.ars.service.certificate.CertificatePrintLogService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/****
 * 资格证打印信息
 * @author  subh
 */
@Controller
@RequestMapping("certificatePrintLog")
public class CertificatePrintLogController {
    /***
     * 日志
     */
    public static Logger logger = LoggerFactory.getLogger(CertificatePrintLogController.class);
    @Autowired
    private CertificatePrintLogService certificatePrintLogService;
    /***
     * 进入资格证打印信息查询页面
     * @desc add subh 2019-03-22 14:39
     */
    @RequestMapping("toQueryPage")
    @RequiresPermissions("certificatePrintLogManager:query")
    public ModelAndView toQueryForTrainOrg(CertificatePrintLogSearchDto searchDto){
        ModelAndView view = new ModelAndView();
        view.setViewName("certificate/certificatePrintLog/query");
        view.addObject("record",searchDto);
        return view;
    }
    /***
     * 资格证打印信息查询
     * @param searchDto 资格证打印信息查询参数
     * @return 资格证打印信息列表
     * @throws Exception
     */
    @RequestMapping("query")
    @RequiresPermissions("certificatePrintLogManager:query")
    public @ResponseBody  AjaxPageResponse query(CertificatePrintLogSearchDto searchDto, AjaxPageResponse page){
        try {
            //资格证打印信息查询
            certificatePrintLogService.query(searchDto, page);
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }
}

