package com.bcxin.ars.rest.approve;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.approve.ApproveTempDto;
import com.bcxin.ars.model.approve.ApproveGroup;
import com.bcxin.ars.service.approve.ApproveGroupService;
import com.bcxin.ars.service.approve.ApproveTempService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.List;

/**
 * @author：wangcy
 * @date：2018/01/16 0016 19:41
 * @description：审批模板controller
 */
@Controller
@RequestMapping("approveGroup")
public class ApproveGroupController {

   @Autowired
   private ApproveGroupService approveGroupService;

    @RequestMapping(value = "findAll", method = RequestMethod.GET)
    public @ResponseBody
    AjaxResult findAll() throws Exception {
        AjaxResult result = new AjaxResult();
        //获取模板数据
        List<ApproveGroup> approveGroupList = approveGroupService.findAll();
        result.setSuccessful(true);
        result.setData(approveGroupList);
        return result;
    }
}
