package com.bcxin.ars.rest.approve;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.approve.ApproveTempDao;
import com.bcxin.ars.dao.approve.ApproveTempLinkRelaDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSycDto;
import com.bcxin.ars.dto.approve.ApproveAreaProcessDataDto;
import com.bcxin.ars.dto.approve.ApproveAreaProcessDto;
import com.bcxin.ars.dto.approve.ApproveOrgDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.approve.ApproveAreaProcess;
import com.bcxin.ars.model.approve.ApproveLinkLevel;
import com.bcxin.ars.model.approve.ApproveTemp;
import com.bcxin.ars.model.approve.ApproveTempLinkRela;
import com.bcxin.ars.service.approve.ApproveAreaProcessService;
import com.bcxin.ars.service.approve.ApproveLinkLevelService;
import com.bcxin.ars.service.approve.ApproveTempLinkService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.*;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author：wangcy @date：2018/01/22 0022 13:29
 * @description：区域审批流程controller
 */
@Controller
@RequestMapping("approveAreaProcess")
public class ApproveAreaProcessController {
	Logger logger = LoggerFactory.getLogger(ApproveLinkLevelController.class);

	@Autowired
	private ArsUtil arsUtil;

	@Autowired
	private ApproveAreaProcessService approveAreaProcessService;

	@Autowired
	private ApproveLinkLevelService approveLinkLevelService;

	@Autowired
	private ConfigDao configDao;
	@Autowired
	private ApproveTempLinkService approveTempLinkService;

	@Value("${temp-folder}")
	private String tempfolder;
	@Autowired
	private ApproveTempLinkRelaDao approveTempLinkRelaDao;

	@Autowired
	private ApproveTempDao approveTempDao;
	/**
	 * @Author: wangcy
	 * @Description:查询环节
	 * @Date: 2018/01/19 0019 10:51
	 */
	@RequestMapping(value = "search", method = RequestMethod.POST)
	public @ResponseBody AjaxResult search(ApproveAreaProcessDto approveAreaProcess) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			// 区域级别不为空
			if (user != null && approveAreaProcess.getTempLinkRelaId() != null) {
				if (StringUtil.isEmpty(approveAreaProcess.getPoliceId())) {
					approveAreaProcess.setPoliceId(user.getPolice().getId().toString());
				}
				// 审批环节层级必须存在不能是删除过的
				List<ApproveLinkLevel> approveLinkLevelList = approveLinkLevelService
						.findListTureByApproveLinkIdAndLevel(approveAreaProcess.getTempLinkRelaId(),
								approveAreaProcess.getApproveLevel());
				if (approveLinkLevelList.size() > 0) {
					List<ApproveAreaProcessDto> list = approveAreaProcessService.search(approveAreaProcess);
					result.setSuccessful(true);
					result.setData(list);
				} else {
					result.setSuccessful(false);
				}
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * @Author: wangcy
	 * @Description:修改或者添加审批环节层级
	 * @Date: 2018/01/19 0019 10:51
	 */
	@RequestMapping(value = "update", method = RequestMethod.POST)
	public @ResponseBody AjaxResult update(ApproveAreaProcessDto approveAreaProcessDto) throws Exception {
		AjaxResult result = new AjaxResult();
		User user = this.arsUtil.getCurrentUser();

		//业务模版的
		String tempCode = "";
		try {
			/**
			 *1.根据审批模板环节关联ID获取到对应的模版
			 */
			Long tempLinkRelaId = approveAreaProcessDto.getTempLinkRelaId();
			ApproveTempLinkRela curApproveTempLinkRela = this.approveTempLinkRelaDao.findById(tempLinkRelaId);
			Long tempId = curApproveTempLinkRela.getApproveTempId();
			ApproveTemp curApproveTemp = approveTempDao.findById(tempId);
			tempCode = curApproveTemp.getTempCode();
			/**
			 *2.获取模板的配置，检查该模版是否被启用，同一个市不能存在有二个用户以上同样启用流程
			 */
			Config config = configDao.findByKey(tempCode);
			ApproveLinkLevel approveLinkLevel = this.approveLinkLevelService
					.findById(approveAreaProcessDto
							.getApproveLinkLevelId());
			if ((approveLinkLevel != null) && (user != null)) {
				String failMsg = "";
				/**
				 * 3.模板的配置表值为0的话，证明有二个用户同时启动，提示其它人正在启动该流程
				 */
				if ( config != null && "0".equals(config.getValue())) {
					/***
					 * 4.启动流程时先把流程锁定，不允许其它人启动流程
					 */
					config.setValue("1");
					configDao.update(config);
					failMsg = this.approveAreaProcessService.saveOrUpdate(approveAreaProcessDto);
					/***
					 * 5.启动成功之后解锁流程
					 */
					config.setValue("0");
					configDao.update(config);
					if (StringUtils.isNotEmpty(failMsg)) {
						result.setSuccessful(false);
						result.setMsg(failMsg);
					} else {
						result.setSuccessful(true);
					}
				} else {
					result.setSuccessful(false);
					result.setMsg("当前有其它人正在启动该流程，请稍后再试");
				}
			} else {
				result.setSuccessful(true);
			}
		} catch (Exception e) {
			/***
			 * 6.出现异常的时候解锁流程配置
			 */
			Config config = configDao.findByKey(tempCode);
			logger.error(e.getMessage(), e);
			config.setValue("0");
			configDao.update(config);
			throw e;
		}

		/*try {	new Thread(()->{
			List<ApproveAreaProcessDto> listpro = approveAreaProcessService.searchProcess();
			ApproveAreaProcessDto approveAreaProcess = new ApproveAreaProcessDto();
			for (ApproveAreaProcessDto approveAreaProcessDto:
					listpro) {

				ApproveLinkLevel approveLinkLevel = approveLinkLevelService
						.findById(approveAreaProcessDto.getApproveLinkLevelId());


				approveAreaProcess.setPoliceId(approveAreaProcessDto.getOrgId().toString());
				approveAreaProcess.setTempLinkRelaId(approveAreaProcessDto.getTempLinkRelaId());
				approveAreaProcess.setApproveLevel(approveAreaProcessDto.getApproveLevel());
				List<ApproveAreaProcessDto> list = approveAreaProcessService.search(approveAreaProcess);


				List<ApproveAreaProcessDto> resultlist = new ArrayList<ApproveAreaProcessDto>();

				for (ApproveAreaProcessDto  temp :
						list) {
					temp.setPerIds(temp.getPositionIds());
					temp.setPositionName(temp.getPositionNames());
					temp.setPositionIds(null);
					temp.setPositionNames(null);
					resultlist.add(temp);
				}
				approveAreaProcessDto.setApproveAreaProDetailDtoList(JSON.toJSONString(resultlist));
				try {
					if (approveLinkLevel != null) {
						approveAreaProcessService.saveOrUpdate(approveAreaProcessDto);
					}
					Thread.sleep(3000);
				} catch (Exception e) {
					logger.error(e.getMessage(), e);
				}
				//approveAreaProcessService.saveOrUpdate(approveAreaProcessDto);

				*//**//*
			}
		}).start();
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}*/
		return result;
	}

	@RequestMapping(value = "findApproveOrgList", method = RequestMethod.POST)
	public @ResponseBody AjaxResult findApproveOrgList(ApproveAreaProcessDto approveAreaProcess) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			// 区域级别不为空
			if (user != null && approveAreaProcess.getTempLinkRelaId() != null) {
				// 审批环节层级必须存在不能是删除过的
				List<ApproveOrgDto> list;
				if (StringUtil.isEmpty(approveAreaProcess.getPoliceId())) {
					approveAreaProcess.setPoliceId(user.getPolice().getId().toString());
					list = approveAreaProcessService.findApproveOrgList(approveAreaProcess);
				} else {
					list = approveAreaProcessService.findApproveOrgListBypoliceId(approveAreaProcess);
				}
				for (ApproveOrgDto approveOrgDto : list) {

					// 已配置
					if (approveOrgDto.isConfig()) {
						// 未配置
					} else {
						approveOrgDto.setApproveSetStatus("0");
					}
				}
				result.setSuccessful(true);
				result.setData(list);
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 批量导出审批流程设置配置-生成data(数据库数据导出）
	 *
	 * @param request
	 */
	@RequestMapping("createData")
	public @ResponseBody AjaxResult createData(HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				// 数据dto
				ApproveAreaProcessDataDto approveAreaProcessDataDto = approveAreaProcessService.findDataDtoForDS();

				List<ApproveAreaProcess> approveAreaProcessList = approveAreaProcessDataDto.getApproveAreaProcessList();
				List<ApproveLinkLevel> approveLinkLevelList = approveAreaProcessDataDto.getApproveLinkLevelList();
				List<ApproveTempLinkRela> approveTempLinkRelaList = approveAreaProcessDataDto.getApproveTempLinkRelaList();
				// 验证数据是否存在
				if ((approveAreaProcessList != null && approveAreaProcessList.size() > 0)
						|| (approveLinkLevelList != null && approveLinkLevelList.size() > 0)
						|| (approveTempLinkRelaList != null && approveTempLinkRelaList.size() > 0)) {
					Date now = new Date();
					// 文件名
					String dirDate = DateUtil.systemDate.format(now);
					File dir = new File(tempfolder + dirDate);
					if (!dir.exists()) {
						dir.mkdirs();
					}
					// 文件转换
					DataSycDto dataSycDto = new DataSycDto();
					dataSycDto.setDataType(Constants.DATASYC_APPROVEAREAPROCESS_LIST);
					dataSycDto.setData(JSONObject.toJSONString(approveAreaProcessDataDto));

					String listStr = JSONObject.toJSONString(dataSycDto);
					String content = CipherDESUtil
							.parseByte2HexStr(CipherDESUtil.encrypt(listStr.getBytes(), Constants.APPROVAL_KEY));

					String filepath = FileUtil.writeTxtFile(content, "approveAreaProcess", tempfolder);
					if (StringUtil.isNotEmpty(filepath)) {
						result.setData(filepath);
						result.setSuccessful(true);
					} else {
						result.setSuccessful(false);
						result.setMsg("导出失败，请联系系统管理员确认！");
					}
				} else {
					result.setSuccessful(false);
				}
			}
		} catch (Exception e) {
			throw e;
		}
		return result;
	}

	/**
	 * 批量导出审批流程设置数据
	 * 
	 * @param response
	 * @param response
	 * @throws Exception
	 */
	@RequestMapping("exportData")
	public void exportData(String templateName, HttpServletResponse response) throws Exception {
		User user = arsUtil.getCurrentUser();
		if (user != null) {
			File file = new File(templateName);
			if (file != null) {
				ServletOutputStream out = response.getOutputStream();
				String fileName = new String(
						file.getName().substring(file.getName().indexOf("_") + 1).getBytes("UTF-8"), "iso-8859-1");
				response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
				InputStream is = new FileInputStream(file);
				int read = 0;
				byte[] buffer = new byte[8192];
				while ((read = is.read(buffer)) != -1) {
					out.write(buffer, 0, read);
				}
				is.close();
				out.flush();
				out.close();
			}
		}
	}

	@RequestMapping("importData/init")
	public ModelAndView importDataInit() {
		ModelAndView result = new ModelAndView();
		result.setViewName("/approveTemp/importData");
		return result;
	}

	/**
	 * 批量导入审批流程设置数据(数据库导入）
	 */
	@RequestMapping("importData")
	public @ResponseBody AjaxResult importData(MultipartFile file, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Date now = new Date();
			String fileName = now.getTime() + "_" + file.getOriginalFilename();
			String dirDate = DateUtil.systemDate.format(now);
			File dir = new File(tempfolder + dirDate);
			if (!dir.exists()) {
				dir.mkdirs();
			}
			String targetPath = tempfolder + dirDate + "/" + fileName;
			File targetFile = new File(targetPath);
			logger.info("执行文件上传..." + targetFile);
			file.transferTo(targetFile);

			BufferedReader br = new BufferedReader(new FileReader(targetFile));
			StringBuffer content = new StringBuffer();
			// 获取文件内容
			String lineTxt = null;
			while ((lineTxt = br.readLine()) != null) {// 使用readLine方法，一次读一行
				content.append(lineTxt);
			}
			br.close();

			// TODO
			String jsonStr = new String(
					CipherDESUtil.decrypt(Encodes.decodeHex(content.toString()), Constants.APPROVAL_KEY));
			DataSycDto dataSycDto = JSONObject.parseObject(jsonStr, DataSycDto.class);
			if (dataSycDto != null) {
				if (dataSycDto.getDataType().equals(Constants.DATASYC_APPROVEAREAPROCESS_LIST)) {

					try {
						ApproveAreaProcessDataDto approveDto = JSONObject.parseObject(dataSycDto.getData(),
								ApproveAreaProcessDataDto.class);

						if (approveDto != null) {
							List<ApproveAreaProcess> approveAreaProcessList = approveDto.getApproveAreaProcessList();
							List<ApproveTempLinkRela> approveTempLinkRelaList = approveDto.getApproveTempLinkRelaList();
							List<ApproveLinkLevel> approveLinkLevelList = approveDto.getApproveLinkLevelList();
							if(null!=approveAreaProcessList && approveAreaProcessList.size()>0){
								approveAreaProcessService.insertBatchTemp(approveAreaProcessList);
							}
							if(null!=approveTempLinkRelaList && approveTempLinkRelaList.size()>0){
								approveTempLinkService.insertBatchTemp(approveTempLinkRelaList);
							}
							if(null!=approveLinkLevelList && approveLinkLevelList.size()>0){
								approveLinkLevelService.insertBatchTemp(approveLinkLevelList);
							}
						}

						result.setMsg("数据导入成功！");
						result.setSuccessful(true);
					} catch (Exception e) {
						logger.error(e.getMessage(),e);
						result.setMsg("导入失败，请稍后重试！");
						result.setSuccessful(false);
					}

				} else {
					result.setMsg("导入失败，非审批流程设置的数据！");
					result.setSuccessful(false);
				}
			} else {
				result.setMsg("导入失败，非审批流程设置的数据！");
				result.setSuccessful(false);
			}

			Map<String, Object> resultMap = new HashMap<String, Object>();
			resultMap.put("faildFilePath", "");
			result.setData(resultMap);
			result.setSuccessful(true);
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("startAllProcess")
	public @ResponseBody AjaxResult startAllProcess(){
		AjaxResult result = new AjaxResult();
		result.setSuccessful(true);
		result.setMsg("启动中，需要比较久的时间，请稍候再查看！");
		new Thread(()->{
			try {
				approveAreaProcessService.startAllProcess();
			}catch (Exception e){
				logger.error(e.getMessage());
			}
		}).start();
		return result;
	}
}
