package com.bcxin.ars.rest.appeal;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.appeal.AppealSearchDto;
import com.bcxin.ars.model.appeal.Appeal;
import com.bcxin.ars.service.PoliceService;
import com.bcxin.ars.service.appeal.AppealService;
import com.bcxin.ars.service.sb.PersonAdaptService;
import com.bcxin.ars.service.sb.PersonGradeService;
import com.bcxin.ars.service.sb.PersoncertificateService;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 申诉信息 控制层
 * @author linqinglin
 * @date 2019/12/05 0005 16:04
 */
@RequestMapping("appeal")
@Controller
public class AppealController {

    private static final Logger logger = LoggerFactory.getLogger(AppealController.class);

    @Autowired
    private AppealService appealService;

    @Autowired
    private PersonGradeService PersonGradeService;

    @Autowired
    private PersonAdaptService personAdaptService;

    @Autowired
    private PersoncertificateService personcertificateService;

    @Autowired
    private PoliceService policeService;

    /***
     * 进入查询页面
     * @return 页面路径
     */
    @RequestMapping("/list/page")
    @RequiresPermissions("appealManager:query")
    public ModelAndView listPage(AppealSearchDto searchDto) {
        ModelAndView view = new ModelAndView("appeal/list");
        view.addObject("record",searchDto);
        return view;
    }
    /***
     * 分页查询
     * @param searchDto 查询参数
     * @param page 返回查询列表
     * @throws Exception 异常
     */
    @RequestMapping("searchForPage")
    @RequiresPermissions("appealManager:query")
    public @ResponseBody
    AjaxPageResponse searchForPage(AppealSearchDto searchDto, AjaxPageResponse page) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            appealService.searchForPage(searchDto,page);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return page;
    }


    /***
     * 进入认证查看页面
     * @desc subh
     */
    @RequestMapping("toAppealViewPage/{id}")
    @RequiresPermissions("appealManager:query")
    public ModelAndView toAppealViewPage(@PathVariable Long id){
        ModelAndView view = new ModelAndView();
        Appeal record  =  appealService.findById(id);
        view.addObject("record",record);
        view.setViewName("appeal/authView"+record.getBusinesstype());
        if(Constants.APPEALTYPE_PERSONCERTIFICATE.equals(record.getBusinesstype())){
            view.addObject("personcertificate",personcertificateService.findById(record.getBusinessid()));
        }else if(Constants.APPEALTYPE_PERSONGRADE.equals(record.getBusinesstype())){
            view.addObject("personGrade",PersonGradeService.findById(record.getBusinessid()));
        }else if(Constants.APPEALTYPE_PERSONADAPT.equals(record.getBusinesstype())){
            view.addObject("personAdapt", personAdaptService.findById(record.getBusinessid()));
        }
        return view;
    }

    /***
     * 进入认证审批页面
     * @desc subh
     */
    @RequestMapping("toAppealApprovalPage/{id}")
    @RequiresPermissions("appealManager:saveAppealApproval")
    public ModelAndView toAppealApprovalPage(@PathVariable Long id){
        ModelAndView view = new ModelAndView();
        Appeal record  =  appealService.findById(id);
        view.addObject("record",record);
        if(Constants.APPROVALSTATE_DSP.equals(record.getAppealState())) {
            view.setViewName("appeal/auth"+record.getBusinesstype());
        }else{
            view.setViewName("appeal/authView"+record.getBusinesstype());
        }

        if(Constants.APPEALTYPE_PERSONCERTIFICATE.equals(record.getBusinesstype())){
            view.addObject("personcertificate",personcertificateService.findById(record.getBusinessid()));
        }else if(Constants.APPEALTYPE_PERSONGRADE.equals(record.getBusinesstype())){
            view.addObject("personGrade",PersonGradeService.findById(record.getBusinessid()));
        }else if(Constants.APPEALTYPE_PERSONADAPT.equals(record.getBusinesstype())){
            view.addObject("personAdapt", personAdaptService.findById(record.getBusinessid()));
        }
        return view;
    }


    /***
     * 进入等级证班级信息查询页面
     * @desc add subh 2019-03-22 14:39
     */
    @RequestMapping("saveAppealApproval")
    @RequiresPermissions("appealManager:saveAppealApproval")
    public @ResponseBody AjaxResult saveAppealApproval(Appeal appeal){
        AjaxResult result = new AjaxResult();
        try {
            appealService.saveAppealApproval(appeal);
            result.setSuccessful(true);
            result.setMsg("审批成功！");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping({"findAppealById"})
    @ResponseBody
    public AjaxResult findAppealById(Long id) {
        AjaxResult result = new AjaxResult();
        Appeal appeal = appealService.findById(id);

        try {
            result.setSuccessful(true);
            result.setMsg("请求成功！");
            result.setData(appeal);
            return result;
        } catch (Exception var5) {
            logger.error(var5.getMessage(), var5);
            throw var5;
        }
    }

    @RequestMapping({"findAppealByBusinessId"})
    @ResponseBody
    public AjaxResult findAppealByBusinessId(String businessid, String businesstype) {
        AjaxResult result = new AjaxResult();
        Appeal appeal = appealService.findOneByBusinessIdAndType(businessid, businesstype);

        try {
            result.setSuccessful(true);
            result.setMsg("请求成功！");
            result.setData(appeal);
            return result;
        } catch (Exception var6) {
            logger.error(var6.getMessage(), var6);
            throw var6;
        }
    }

    @RequestMapping({"applyAppeal"})
    @ResponseBody
    public AjaxResult applyAppeal(Appeal appeal) {
        AjaxResult result= appealService.applyAppeal(appeal);
        return result;
    }
}
