package com.bcxin.ars.rest.act;

import com.bcxin.ars.dto.AjaxResult;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;

@Controller
@RequestMapping("activiti/subsidiary")
public class SubsidiaryActivitiController {

    private Logger logger = LoggerFactory.getLogger(SubsidiaryActivitiController.class);
    
	@Resource
	private RuntimeService runtimeService;
	
	@Resource
	private TaskService taskService;
	/**
	 * 提交請假流程申請
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("/startApply")
	public @ResponseBody
    AjaxResult startApply(String applyId) throws Exception{
		AjaxResult result = new AjaxResult();
        try {
        	
        	Map<String,Object> variables=new HashMap<String,Object>();
    		variables.put("applyId", applyId);
    		// 启动流程
    		ProcessInstance pi= runtimeService.startProcessInstanceByKey("activitisubsidiaryapprovalProcess",variables);
    		// 根据流程实例Id查询任务
    		Task task=taskService.createTaskQuery().processInstanceId(pi.getProcessInstanceId()).singleResult();
    		// 完成 填写分公司申请任务
    		taskService.complete(task.getId());
        	
            result.setSuccessful(true);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
	}
}
