package com.bcxin.ars.rest.act;

import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.repository.ProcessDefinition;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

/**
 * Created by lenovo on 2017/10/20.
 */
@Controller
public class ProcessController {

    // 引入activiti自带的Service接口
    @Resource
    private TaskService taskService;
    @Resource
    private RepositoryService repositoryService;
    @Resource
    private RuntimeService runtimeService;

    /**
     * 查询当前流程图
     * @return
     */
    @RequestMapping("/showCurrentView")
    public ModelAndView showCurrentView(HttpServletResponse response, String processInstanceId){
        //视图
        ModelAndView mav=new ModelAndView();

        // 根据流程实例Id查询任务
        Task task=taskService.createTaskQuery().processInstanceId(processInstanceId).singleResult();

       /* Task task=taskService.createTaskQuery() // 创建任务查询
                .taskId(taskId) // 根据任务id查询
                .singleResult();*/
        // 获取流程定义id
        String processDefinitionId=task.getProcessDefinitionId();
        ProcessDefinition processDefinition=repositoryService.createProcessDefinitionQuery() // 创建流程定义查询
                // 根据流程定义id查询
                .processDefinitionId(processDefinitionId)
                .singleResult();
        // 部署id
        mav.addObject("deploymentId",processDefinition.getDeploymentId());
        mav.addObject("diagramResourceName", processDefinition.getDiagramResourceName()); // 图片资源文件名称

        ProcessDefinitionEntity processDefinitionEntity=(ProcessDefinitionEntity)
                repositoryService.getProcessDefinition(processDefinitionId);
        // 获取流程实例id
        //String processInstanceId=task.getProcessInstanceId();
        // 根据流程实例id获取流程实例
        ProcessInstance pi=runtimeService.createProcessInstanceQuery()
                .processInstanceId(processInstanceId)
                .singleResult();

        // 根据活动id获取活动实例
        ActivityImpl activityImpl=processDefinitionEntity.findActivity(pi.getActivityId());
        //整理好View视图返回到显示页面
        mav.addObject("x", activityImpl.getX()); // x坐标
        mav.addObject("y", activityImpl.getY()); // y坐标
        mav.addObject("width", activityImpl.getWidth()); // 宽度
        mav.addObject("height", activityImpl.getHeight()); // 高度
        mav.setViewName("act/currentView");
        return mav;
    }

}
