package com.bcxin.ars.rest;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.page.PoliceUserDto;
import com.bcxin.ars.dto.page.UserPageSearchDto;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.dto.singleLogin.SingleUserDTO;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.sb.PrintDesign;
import com.bcxin.ars.model.sys.Sysarea;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.*;
import com.bcxin.ars.service.bean.factory.SingleLoginBeanFactory;
import com.bcxin.ars.service.gx.GXSSOService;
import com.bcxin.ars.service.sb.PrintDesignService;
import com.bcxin.ars.service.singleLogin.SingleLoginService;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.sys.RegisterpersonService;
import com.bcxin.ars.service.sys.SysareaService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.GXSSOUtil;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.gx.encry.SSOAES;
import com.bcxin.ars.util.redis.RedisUtil;
import com.bcxin.ars.web.util.WebStartup;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.*;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.validation.Valid;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.util.*;

@Controller
@RequestMapping("user")
public class UserController {
    /***
     * 日志
     */
    private final static Logger logger = LoggerFactory.getLogger(UserController.class);

    @Autowired
    private UserService userService;

    @Autowired
    private SearchHistoryService searchHistoryService;
    @Autowired
    private MessageLogDao messageLogDao;
    @Autowired
    private ArsRestUtil arsUtil;

    @Autowired
    private RedisUtil redisUtil;

    @Autowired
    private PermissionService permissionService;

    @Autowired
    private PoliceService policeService;

    @Autowired
    private GXSSOService gxssoService;
    @Autowired
    private ConfigService configService;
    @Autowired
    private SecurityPersonService securityPersonService;

    @Autowired
    private SecurityCompanyService securityCompanyService;

    @Autowired
    private LoginLogService loginLogService;


    @Autowired
    private PoliceRoleService policeRoleService;

    @Autowired
    private ApprovalService approvalService;

    @Autowired
    private UserRoleService userRoleService;
    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private GXSSOUtil gxssoUtil;

    @Autowired
    private SysareaService sysareaService;

    @Value("${message-code-timeout}")
    private int messageCodeTimeout = 2;

    @Value("${login-timeout}")
    private int loginTimeout = 10;

    @Value("${JWT_SECRET}")
    public String JWT_SECRET = ""; //私钥

    @Value("${BLB_PARTY}")
    public String BLB_PARTY = "ARS-NC";
    @Autowired
    private RegisterpersonService registerpersonService;
    @Value("${singleLoginServiceName}")
    private String singleLoginServiceName;


    private SingleLoginService singleLoginService;

    @Autowired
    private PrintDesignService printDesignService;

    /***
     * 先获取背景筛查实现类对
     */
    private void getSingleLoginService(){
        if(singleLoginService == null){
            singleLoginService = SingleLoginBeanFactory.getSingleLoginHandleBean(singleLoginServiceName);
        }
    }
    /**
     * 北京自然人单点登录
     * @param code 用户信息
     * @return
     */
    @RequestMapping(value = "singleLoginBJ")
    public String singleLoginBJ(@RequestParam(value = "code", required = true) String code,HttpServletRequest request, HttpServletResponse response) throws Exception {
        String referer = request.getHeader("Referer");
        logger.error("=========> 北京自然人单点登录singleLoginBJ.Referer:"+referer);
        System.out.println("=========> 北京自然人单点登录singleLoginBJ.Referer:"+referer);
        String initiatorChain = request.getHeader("Origin");
        logger.error("=========> 北京自然人单点登录singleLoginBJ.Request initiator chain: " + initiatorChain);
        System.out.println("=========> 北京自然人单点登录singleLoginBJ.Request initiator chain: " + initiatorChain);
        //先获取单点处理类
        getSingleLoginService();
        //获取上下文
        ServletContext servletContext = request.getServletContext();
        //上下文路径
        String rootPath = servletContext.getContextPath();
        //根据code从网上公安局接口获取用户信息，用户手机号码如果不存在保安系统，则自动注册
        /**
         * 参数
         */
        SingleUserDTO dto  = new SingleUserDTO();
        dto.setCode(code);
        AjaxResult ajaxResult = singleLoginService.handle(dto,request);
        //登陆成功跳转到主页
        if (ajaxResult.isSuccessful()) {
            return "redirect:/index.do";
        }else{
            //登陆失败则到登陆页面
            response.sendRedirect(rootPath+"/login.jsp");
        }
        return "error";
    }

    /**
     * 南宁单点登录
     * @param userInfo 用户信息
     * @return
     */
    @RequestMapping(value = "singleLoginNN")
    public String singleLoginNN(SingleUserDTO userInfo,HttpServletRequest request, HttpServletResponse response) throws Exception {
        //先获取单点处理类
        getSingleLoginService();
        //获取上下文
        ServletContext servletContext = request.getServletContext();
        //上下文路径
        String rootPath = servletContext.getContextPath();
        AjaxResult ajaxResult = singleLoginService.handle(userInfo,request);
        //登陆成功跳转到主页
        if (ajaxResult.isSuccessful()) {
            return "redirect:/index.do";
        }else{
            //登陆失败则到登陆页面
            response.sendRedirect(rootPath+"/login.jsp");
        }
        return "error";
    }
    /**
     * 单点登陆通过警号进行对接
     * @param userid 用户信息userService
     * @return
     */
    @RequestMapping(value = "singleLoginIPolice")
    public @ResponseBody
    AjaxResult singleLoginIPolice(@RequestParam(value = "userid", required = true) String userid,HttpServletRequest request, HttpServletResponse response) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            //登陆信息
            UsernamePasswordToken token = new UsernamePasswordToken(userid, "");
            Subject currentUser = SecurityUtils.getSubject();
            token.setRememberMe(false);
            //广西内网单点登陆标记
            token.setHost(Constants.GX_NW_Code);
            try {
                currentUser.login(token);
            } catch (AuthenticationException e) {
                logger.error(e.getMessage(), e);
                result.setSuccessful(false);
                result.setMsg(Constants.PASSWORDERROR_MESSAGE);
                return result;
            }
            //判断是否登录成功！
            if (currentUser.isAuthenticated()) {
                Session session = currentUser.getSession();
                User user = null;
                //edit subh 2019-03-09  7:43根据用户类型和用户查询用户
                user = userService.findByUsername(userid,Constants.PLATFORM_POLICE+"");
                //内网不允许保安公司登陆 add subh 2018-06-10 end
                //logger.info("当前登录用户是："+user.getUsername());
                //功能权限
                if(user.getPlatform() == Constants.PLATFORM_POLICE  ) {
                    //机构信息
                    Police police = policeService.findById(user.getOrgid());
                    if(police!=null){
                        user.setPolice(police);
                    }
                    /***
                     * 城市区域
                     */
                    String cityAreaCode =police.getAreacode().substring(0,4)+"00";
                    user.setCityAreaCode(cityAreaCode);
                    //获取用户的数据权限机构编码列表 add subh 2019-04-05 10:25
                    user.setAreasList(policeService.findDataPoliceForUserID(user.getId()));
                    //获取城市信息
                    //只要广西
                    if(Constants.GUANGXI.equals(configUtils.getCurrentNative()) && user.getPolice() !=null && !Constants.ORGTYPE_PROVINCE.equals(user.getPolice().getOrgtype())) {
                        Sysarea sysarea = sysareaService.findByCode(cityAreaCode);
                        if(sysarea!=null){
                            //城市名称
                            user.setCityName(sysarea.getName());
                            //城市标识
                            user.setCity(cityAreaCode);
                        }
                    }

                }
                //登录次数+1
                if( null!= user.getLoginNum() ) {
                    user.setLoginNum(user.getLoginNum()+1);
                }else{
                    user.setLoginNum(1);
                }
                //登录时间为当前时间
                user.setLoginDate(new Date());
                userService.updateLoginState(user);
                user.setSessionId(session.getId().toString());
                arsUtil.setCurrentUser(user,1000*120*loginTimeout);
                result.setData(user);
                result.setSuccessful(true);
                loginLogService.logIn(request);
                //获取上下文
                ServletContext servletContext = request.getServletContext();
                String rootPath = servletContext.getContextPath();
                response.sendRedirect(rootPath+"/index.do");
            }else{
                result.setSuccessful(false);
                result.setMsg(Constants.PASSWORDERROR_MESSAGE);
            }
        } catch (UnknownAccountException e) {
            logger.info(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (IncorrectCredentialsException e) {
            logger.info(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (ExcessiveAttemptsException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (AuthenticationException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        }catch (ArsException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    /**
     * 北京ca认证登录
     */
    @RequestMapping("/ca/login")
    public ModelAndView testCaLogin(HttpServletRequest request){
        ModelAndView result = new ModelAndView("caLogin");
        if(!Constants.YES.equals(configUtils.getValueByKey(Constants.CA_SWITCH))){
            result.addObject("msg","登录失败：未授权环境");
        }else{
            try {
                String dnname = request.getHeader("dnname");
                //String dnname = request.getParameter("dnname");
                //dnname = "CN=å®\u0089å\u0085¨ä¿\u009Då¯\u0086ç®¡ç\u0090\u0086å\u0091\u0098 220122198001010093, O=JIT, C=CN";
                dnname = URLEncoder.encode(DES3.encode(dnname),"UTF-8");
                result.addObject("dnname",dnname);
            }catch (Exception e){
                result.addObject("msg","登录失败：证书主题解析错误");
            }
        }

        return result;
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String DN = new String("CN=ç\u008E\u008Bå\u0085\u0089æ\u0099\u0096 220122198001010093, OU=00, OU=32, O=22, L=00, L=00, ST=11, C=CN".getBytes("ISO8859-1"),"UTF-8");

        String idnum = null;
        for (String data : DN.split(",")) {
            String[]datas = data.split("=");
            System.out.println(datas[0].trim());
            System.out.println(datas[1].trim());
            if("CN".equals(datas[0].trim())){
                String userInfo = datas[1].trim();
                idnum = userInfo.split(" ")[1];
            }
        }
        System.out.println(DN);
        System.out.println(idnum);
    }

    private Map<String, String> getHeadersInfo(HttpServletRequest request) {
        Map<String, String> map = new HashMap<String, String>();
        Enumeration headerNames = request.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String key = (String) headerNames.nextElement();
            String value = request.getHeader(key);
            logger.error("北京ca认证登录header信息,key:{},value:{}",key,value);
            map.put(key, value);
        }
        return map;
    }

/*
    @RequestMapping("/ca/login")
    @ResponseBody
    public AjaxResult caLogin(HttpServletRequest request,HttpServletResponse response){
        AjaxResult result = new AjaxResult();
        try {

            //getHeadersInfo(request);
            String idnum = request.getParameter("dnname");
            *//*String DN = request.getHeader("dnname");
            logger.error("北京ca认证登录:{}",DN);
            if(StrUtil.isEmpty(DN)){
                return AjaxResult.error("登录失败：无法获取到证书主题");
            }

            DN = new String(DN.getBytes("ISO8859-1"),"UTF-8");

            String idnum = null;
            for (String data : DN.split(",")) {
                String[]datas = data.split("=");
                System.out.println(datas[0].trim());
                System.out.println(datas[1].trim());
                if("CN".equals(datas[0].trim())){
                    String userInfo = datas[1].trim();
                    idnum = userInfo.split(" ")[1];
                }
            }*//*
            if(StrUtil.isEmpty(idnum)){
                return AjaxResult.error("登录失败：无法从证书主题中获取到身份证号");
            }

            //登陆信息
            UsernamePasswordToken token = new UsernamePasswordToken(idnum, "");
            Subject currentUser = SecurityUtils.getSubject();
            token.setRememberMe(false);
            //北京ca认证登录标记
            token.setHost(Constants.BJ_CA_SSO);
            try {
                currentUser.login(token);
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                result.setSuccessful(false);
                result.setMsg(Constants.CA_PASSWORDERROR_MESSAGE);
                return result;
            }
            //判断是否登录成功！
            if (currentUser.isAuthenticated()) {
                Session session = currentUser.getSession();
                User user = userService.findByIdNum(idnum,Constants.PLATFORM_POLICE+"");
                //功能权限
                //机构信息
                Police police = policeService.findById(user.getOrgid());
                if(police!=null){
                    user.setPolice(police);
                }
                //设置数据大屏链接
                userService.setDateView(user);
                *//***
                 * 城市区域
                 *//*
                String cityAreaCode =police.getAreacode().substring(0,4)+"00";
                user.setCityAreaCode(cityAreaCode);
                //获取用户的数据权限机构编码列表 add subh 2019-04-05 10:25
                user.setAreasList(policeService.findDataPoliceForUserID(user.getId()));
                //登录次数+1
                if( null!= user.getLoginNum() ) {
                    user.setLoginNum(user.getLoginNum()+1);
                }else{
                    user.setLoginNum(1);
                }
                //登录时间为当前时间
                user.setLoginDate(new Date());
                userService.updateLoginState(user);
                user.setSessionId(session.getId().toString());
                arsUtil.setCurrentUser(user,1000*120*loginTimeout);
                result.setData(user);
                result.setSuccessful(true);
                loginLogService.logIn(request);
                //获取上下文
                ServletContext servletContext = request.getServletContext();
                String rootPath = servletContext.getContextPath();
                //RequestDispatcher dispatcher=request.getRequestDispatcher("http://192.168.30.182:8089/ars-web/index.do");
                //dispatcher.forward(request,   response);

                redisUtil.set(user.getSessionId(), currentUser.getSession().getId().toString());
                redisUtil.set(user.getSessionId()+"_USERINFO", JSONObject.toJSONString(result.getData()));
                //response.sendRedirect("http://14.62.1.152/index.do?sid="+session.getId());

                Cookie cookie = new Cookie("sid", user.getSessionId());
                cookie.setMaxAge(0);
                cookie.setDomain("justme070.xicp.net");
                cookie.setPath("/");
                response.addCookie(cookie);

                response.sendRedirect("http://justme070.xicp.net/ars-web/index.do?sessionID="+session.getId());


                //response.getWriter().write("认证登录成功！3秒钟跳到主页");
                ////设置3秒钟跳转
                //response.setHeader("refresh", "3;url=http://justme070.xicp.net/ars-web/index.do?sessionID="+session.getId());
            }else{
                result.setSuccessful(false);
                result.setMsg(Constants.CA_PASSWORDERROR_MESSAGE);
            }
        }catch (Exception e){
            e.printStackTrace();
        }

        return AjaxResult.error(Constants.CA_PASSWORDERROR_MESSAGE);
    }*/

    /**
     * 广西单点登录
     * @param userinfo 加密串
     * @param city 城市
     * @return
     */
    @RequestMapping(value = "singleLogin")
    public @ResponseBody
    AjaxResult singleLogin(@RequestParam(value = "userinfo", required = true) String userinfo,
                        @RequestParam(value = "city", required = true) String city ,HttpServletRequest request, HttpServletResponse response) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            String des3 = userinfo;
            //用户名
            String username = "";
            //对userinfo进行解密 ，解析后规则：警号+，+身份证+，+当前日期YYYYMMDDHHmmss+，+岗位id
            userinfo =DES3.des3DecodeCBC(userinfo);
            if(StringUtil.isNotEmpty(userinfo)) {
                //加密后
                String[] userArray = userinfo.split(",");
                //获取用户名
                username = userArray[0];
            }
            //登陆信息
            UsernamePasswordToken token = new UsernamePasswordToken(username, "");
            Subject currentUser = SecurityUtils.getSubject();
            token.setRememberMe(false);
            //广西内网单点登陆标记
            token.setHost(Constants.GX_NW_Code);
            try {
                currentUser.login(token);
            } catch (AuthenticationException e) {
                logger.error(e.getMessage(), e);
                result.setSuccessful(false);
                result.setMsg(Constants.PASSWORDERROR_MESSAGE);
                return result;
            }
            //判断是否登录成功！
            if (currentUser.isAuthenticated()) {
                Session session = currentUser.getSession();
                User user = null;
                //edit subh 2019-03-09  7:43根据用户类型和用户查询用户
                user = userService.findByUsername(username,Constants.PLATFORM_POLICE+"");
                //内网不允许保安公司登陆 add subh 2018-06-10 start
                Config config = configService.findByKey(Constants.POLICE);
                if (Constants.PLATFORM_POLICE != user.getPlatform() && Constants.ISPOLICE_YES.equals(config.getValue())) {
                    result.setSuccessful(false);
                    result.setMsg("保安公司或保安人员不支持内网登陆！");
                    return result;
                }

                //内网不允许保安公司登陆 add subh 2018-06-10 end
                //logger.info("当前登录用户是："+user.getUsername());
                //功能权限
                if(user.getPlatform() == Constants.PLATFORM_POLICE  ) {
                    //机构信息
                    Police police = policeService.findById(user.getOrgid());
                    if(police!=null){
                        user.setPolice(police);
                    }
                    //设置数据大屏链接
                    userService.setDateView(user);
                    /***
                     * 城市区域
                     */
                    String cityAreaCode =police.getAreacode().substring(0,4)+"00";
                    user.setCityAreaCode(cityAreaCode);
                    //对userinfo进行解密 ，解析后规则：警号+，+身份证+，+当前日期YYYYMMDDHHmmss
                    user.setUserinfo(URLEncoder.encode(des3,"UTF-8"));
                    //获取用户的数据权限机构编码列表 add subh 2019-04-05 10:25
                    user.setAreasList(policeService.findDataPoliceForUserID(user.getId()));
                    //获取城市信息
                    //只要广西
                    if(Constants.YES.equals(configUtils.getValueByKey(Constants.GX_NEW_AUTH))) {
                        PrincipalCollection principal = currentUser.getPrincipals();
                        User loginUser = (User) principal.getPrimaryPrincipal();
                        user.setPermissionList(loginUser.getPermissionList());
                    }
                    if(Constants.GUANGXI.equals(configUtils.getCurrentNative()) && user.getPolice() !=null && !Constants.ORGTYPE_PROVINCE.equals(user.getPolice().getOrgtype())) {

                        Sysarea sysarea = null ;
                        if(StringUtil.isEmpty(city)) {
                            sysarea = sysareaService.findByCode(cityAreaCode);
                        }else{
                            sysarea = sysareaService.findByCode(city);
                        }
                        if(sysarea!=null){
                            //城市名称
                            user.setCityName(sysarea.getName());
                            if(StringUtil.isEmpty(city)) {
                                //城市标识
                                user.setCity(cityAreaCode);
                            }else{
                                //城市标识
                                user.setCity(city);
                            }
                        }
                    }

                }
                //登录次数+1
                if( null!= user.getLoginNum() ) {
                    user.setLoginNum(user.getLoginNum()+1);
                }else{
                    user.setLoginNum(1);
                }
                //登录时间为当前时间
                user.setLoginDate(new Date());
                userService.updateLoginState(user);
                user.setSessionId(session.getId().toString());
                arsUtil.setCurrentUser(user,1000*120*loginTimeout);
                result.setData(user);
                result.setSuccessful(true);
                loginLogService.logIn(request);
                //获取上下文
                ServletContext servletContext = request.getServletContext();
                String rootPath = servletContext.getContextPath();
                response.sendRedirect(rootPath+"/index.do");


            }else{
                result.setSuccessful(false);
                result.setMsg(Constants.PASSWORDERROR_MESSAGE);
            }
        } catch (UnknownAccountException e) {
            //logger.info(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (IncorrectCredentialsException e) {
            //logger.info(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (ExcessiveAttemptsException e) {
            //logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (AuthenticationException e) {
            //logger.error(e.getMessage(), e);
            //throw e;
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        }catch (ArsException e) {
            //logger.error(e.getMessage(), e);
            //throw e;
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    /**
     * 广西单点登录
     * @param token 令牌
     * @param projectNo 办件流水号
     * @param taskCode 事项编码
     * @return
     */
    @RequestMapping(value = "autoLogin")
    public @ResponseBody
    AjaxResult gxsingleLogin(@RequestParam(value = "token", required = true) String token,
                             @RequestParam(value = "projectNo", required = true) String projectNo,
                             @RequestParam(value = "taskCode", required = true) String taskCode ,
                             HttpServletRequest request, HttpServletResponse response, HttpSession httpSession) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            //用户名
            String username="";
            //token = AES.decrypt(token,Constants.GX_APP_KEY);
            String userinfo = gxssoUtil.getUserObj(token);
            if(StringUtil.isNotEmpty(userinfo)) {
               JSONObject js=JSONObject.parseObject(userinfo);
                //获取用户名
               username = SSOAES.decrypt(js.getString("mobile"),Constants.GX_APP_KEY);
            }
            //登陆信息
            UsernamePasswordToken usernamePasswordToken = new UsernamePasswordToken(username, "");
            Subject currentUser = SecurityUtils.getSubject();
            usernamePasswordToken.setRememberMe(false);
            //广西单点登陆标记
            usernamePasswordToken.setHost(Constants.GX_WW_Code);
            User user=arsUtil.getCurrentUser();
            if (user!=null&&username.equals(user.getUsername())){
                result.setData(user);
                result.setSuccessful(true);
                request.getSession().setAttribute(Constants.LOGIN_USER, user);
                request.getSession().setAttribute(Constants.SESSION_ID, user.getSessionId());

                //获取上下文
                ServletContext servletContext = request.getServletContext();
                String rootPath = servletContext.getContextPath();
                String path="";
                if (user.getPlatform().equals(4)){
                    path=gxssoUtil.getPathFour(taskCode);
                }
                if (user.getPlatform().equals(2)){
                    path=gxssoUtil.getPathTwo(taskCode,user.getSessionId());
                }
                response.sendRedirect(rootPath+path);
            }else {
                try {
                    currentUser.login(usernamePasswordToken);
                } catch (AuthenticationException e) {
                    logger.error(e.getMessage(), e);
                    result.setSuccessful(false);
                    result.setMsg(Constants.PASSWORDERROR_MESSAGE);
                    return result;
                }
                //判断是否登录成功！
                if (currentUser.isAuthenticated()) {
                    httpSession.setAttribute("projectNo",projectNo);
                    httpSession.setAttribute("gxssotoken",token);
                    Session session = currentUser.getSession();
                    //edit subh 2019-03-09  7:43根据用户类型和用户查询用户
                    user = userService.findGSAndZRRByUsername(username);
                    //登录次数+1
                    if( null!= user.getLoginNum() ) {
                        user.setLoginNum(user.getLoginNum()+1);
                    }else{
                        user.setLoginNum(1);
                    }

                    //登录时间为当前时间
                    user.setLoginDate(new Date());
                    userService.updateLoginState(user);
                    user.setSessionId(session.getId().toString());
                    arsUtil.setCurrentUser(user,1000*120*loginTimeout);
                    result.setData(user);
                    result.setSuccessful(true);
                    request.getSession().setAttribute(Constants.LOGIN_USER, user);
                    request.getSession().setAttribute(Constants.SESSION_ID, user.getSessionId());
                    loginLogService.logIn(request);
                    GXSSO gxsso=new GXSSO();
                    gxsso.setProjectNo(projectNo);
                    gxsso.setToken(token);
                    gxsso.setStartTime(new Date());
                    gxsso.setTaskCode(taskCode);
                    gxsso.setUid(user.getId());
                    gxsso.setUname(user.getUsername());
                    gxsso.setComplete(false);
                    gxssoService.save(gxsso);
                    //获取上下文
                    ServletContext servletContext = request.getServletContext();
                    String rootPath = servletContext.getContextPath();
                    String path="";
                    if (user.getPlatform().equals(4)){
                        path=gxssoUtil.getPathFour(taskCode);
                    }
                    if (user.getPlatform().equals(2)){
                        path=gxssoUtil.getPathTwo(taskCode,user.getSessionId());
                    }
                    response.sendRedirect(rootPath+path);
                }else{
                    result.setSuccessful(false);
                    result.setMsg(Constants.PASSWORDERROR_MESSAGE);
                }
            }

        } catch (UnknownAccountException e) {
            //logger.info(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (IncorrectCredentialsException e) {
            //logger.info(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (ExcessiveAttemptsException e) {
            //logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (AuthenticationException e) {
            //logger.error(e.getMessage(), e);
            //throw e;
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        }catch (ArsException e) {
            //logger.error(e.getMessage(), e);
            //throw e;
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }

        return result;
    }

    /**
     * 广西南宁新单点登录
     * @param userinfo 加密串
     * @return
     */
    @RequestMapping(value = "singleLoginForNN")
    public @ResponseBody
    AjaxResult singleLoginForNN(@RequestParam(value = "userinfo", required = true) String userinfo,String city ,
                        HttpServletRequest request, HttpServletResponse response) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            String des3 = userinfo;
            //用户名
            String username = "";
            //对userinfo进行解密 ，解析后规则：警号+，+身份证+，+当前日期YYYYMMDDHHmmss+，+岗位id
            userinfo =DES3.des3DecodeCBC(userinfo);
            if(StringUtil.isNotEmpty(userinfo)) {
                //加密后
                String[] userArray = userinfo.split(",");
                //获取用户名
                username = userArray[0];
            }
            //登陆信息
            UsernamePasswordToken token = new UsernamePasswordToken(username, "");
            Subject currentUser = SecurityUtils.getSubject();
            token.setRememberMe(false);
            //广西南宁内网单点登陆标记
            token.setHost(Constants.GX_NN_NW_Code);
            try {
                currentUser.login(token);
            } catch (AuthenticationException e) {
                logger.error(e.getMessage(), e);
                result.setSuccessful(false);
                result.setMsg(Constants.PASSWORDERROR_MESSAGE);
                return result;
            }
            //判断是否登录成功！
            if (currentUser.isAuthenticated()) {
                Session session = currentUser.getSession();
                User user = null;
                //edit subh 2019-03-09  7:43根据用户类型和用户查询用户
                user = userService.findByUsername(username,Constants.PLATFORM_POLICE+"");
                //内网不允许保安公司登陆 add subh 2018-06-10 start
                Config config = configService.findByKey(Constants.POLICE);
                if (Constants.PLATFORM_POLICE != user.getPlatform() && Constants.ISPOLICE_YES.equals(config.getValue())) {
                    result.setSuccessful(false);
                    result.setMsg("保安公司或保安人员不支持内网登陆！");
                    return result;
                }

                //内网不允许保安公司登陆 add subh 2018-06-10 end
                //logger.info("当前登录用户是："+user.getUsername());
                //功能权限
                if(user.getPlatform() == Constants.PLATFORM_POLICE  ) {
                    //机构信息
                    Police police = policeService.findById(user.getOrgid());
                    if(police!=null){
                        user.setPolice(police);
                    }
                    //设置数据大屏链接
                    userService.setDateView(user);
                    /***
                     * 城市区域
                     */
                    String cityAreaCode =police.getAreacode().substring(0,4)+"00";
                    user.setCityAreaCode(cityAreaCode);
                    //对userinfo进行解密 ，解析后规则：警号+，+身份证+，+当前日期YYYYMMDDHHmmss
                    user.setUserinfo(URLEncoder.encode(des3,"UTF-8"));
                    //获取用户的数据权限机构编码列表 add subh 2019-04-05 10:25
                    user.setAreasList(policeService.findDataPoliceForUserID(user.getId()));
                    //获取城市信息
                    //只要广西
                    if(Constants.GUANGXI.equals(configUtils.getCurrentNative()) && user.getPolice() !=null && !Constants.ORGTYPE_PROVINCE.equals(user.getPolice().getOrgtype())) {

                        Sysarea sysarea = null ;
                        if(StringUtil.isEmpty(city)) {
                            sysarea = sysareaService.findByCode(cityAreaCode);
                        }else{
                            sysarea = sysareaService.findByCode(city);
                        }
                        if(sysarea!=null){
                            //城市名称
                            user.setCityName(sysarea.getName());
                            if(StringUtil.isEmpty(city)) {
                                //城市标识
                                user.setCity(cityAreaCode);
                            }else{
                                //城市标识
                                user.setCity(city);
                            }
                        }
                    }

                }
                //登录次数+1
                if( null!= user.getLoginNum() ) {
                    user.setLoginNum(user.getLoginNum()+1);
                }else{
                    user.setLoginNum(1);
                }
                //登录时间为当前时间
                user.setLoginDate(new Date());
                userService.updateLoginState(user);
                user.setSessionId(session.getId().toString());
                arsUtil.setCurrentUser(user,1000*120*loginTimeout);
                result.setData(user);
                result.setSuccessful(true);
                loginLogService.logIn(request);
                //获取上下文
                ServletContext servletContext = request.getServletContext();
                String rootPath = servletContext.getContextPath();
                response.sendRedirect(rootPath+"/index.do");


            }else{
                result.setSuccessful(false);
                result.setMsg(Constants.PASSWORDERROR_MESSAGE);
            }
        } catch (UnknownAccountException e) {
            //logger.info(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (IncorrectCredentialsException e) {
            //logger.info(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (ExcessiveAttemptsException e) {
            //logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (AuthenticationException e) {
            //logger.error(e.getMessage(), e);
            //throw e;
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        }catch (ArsException e) {
            //logger.error(e.getMessage(), e);
            //throw e;
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    /**
     * 登录
     *
     * @param username
     * @param password
     * @return
     */
    @RequestMapping(value = "web/login", method = RequestMethod.POST)
    public @ResponseBody
    AjaxResult webLogin(@RequestParam(value = "username", required = true) String username,
                        @RequestParam(value = "password", required = true) String password,
                        @RequestParam(value = "platform", required = false) String platform,
                        HttpServletRequest request, HttpServletResponse response) throws Exception {

        AjaxResult result = new AjaxResult();
        try {
            String decryptPassword=RSAUtil.decryptBase64(password);
            UsernamePasswordToken token = new UsernamePasswordToken(username,decryptPassword);
            Subject currentUser = SecurityUtils.getSubject();
            token.setRememberMe(false);
            //平台角色
            token.setHost(platform);
            try {
                currentUser.login(token);
            } catch (AuthenticationException e) {
                logger.error(e.getMessage(), e);
                result.setSuccessful(false);
                result.setMsg(Constants.PASSWORDERROR_MESSAGE);
                return result;
            }
            //判断是否登录成功！
            if (currentUser.isAuthenticated()) {
                Session session = currentUser.getSession();
                User user = null;
                //edit subh 2019-03-09  7:43根据用户类型和用户查询用户
                user = userService.findByUsername(username,platform);
                //内网不允许保安公司登陆 add subh 2018-06-10 start
                Config config = configService.findByKey(Constants.POLICE);
                if (Constants.PLATFORM_POLICE != user.getPlatform() && Constants.ISPOLICE_YES.equals(config.getValue())) {
                    result.setSuccessful(false);
                    result.setMsg("保安公司或保安人员不支持内网登陆！");
                    return result;
                }
                //内网不允许保安公司登陆 add subh 2018-06-10 end
                //logger.info("当前登录用户是："+user.getUsername());
				//功能权限
				if(user.getPlatform() == Constants.PLATFORM_POLICE  ) {
					 //机构信息
					Police police = policeService.findById(user.getOrgid());
					if(police!=null){
						user.setPolice(police);
					}
					//设置数据大屏链接
                    userService.setDateView(user);
                    /***
                     * 城市区域
                     */
					String cityAreaCode =police.getAreacode().substring(0,4)+"00";
					user.setCityAreaCode(cityAreaCode);
                    //获取用户的数据权限机构编码列表 add subh 2019-04-05 10:25
                    user.setAreasList(policeService.findDataPoliceForUserID(user.getId()));
                    //获取城市信息
                    //只要广西
                    if(Constants.GUANGXI.equals(configUtils.getCurrentNative()) && user.getPolice() !=null && !Constants.ORGTYPE_PROVINCE.equals(user.getPolice().getOrgtype())) {
                        Sysarea sysarea = sysareaService.findByCode(cityAreaCode);
                        if(sysarea!=null){
                            //城市名称
                            user.setCityName(sysarea.getName());
                            //城市标识
                            user.setCity(cityAreaCode);

                        }
                    }
				}
				//登录次数+1
                if( null!= user.getLoginNum() ) {
					user.setLoginNum(user.getLoginNum()+1);
				}else{
					user.setLoginNum(1);
				}
                //如果有会议帐号的话，则登陆华为云会议 TODO
                //user.setConferenceAccessToken(arsUtil.getHuaweiMeetAccessToken("13328701375su","gmhc3R6X",user.getId()));
                //arsUtil.getHuaweiMeetAccessToken("bj_super","bcxin123456",user.getId());


	            //登录时间为当前时间
	            user.setLoginDate(new Date());
				userService.updateLoginState(user);
				user.setSessionId(session.getId().toString());
				arsUtil.setCurrentUser(user,1000*120*loginTimeout);
				result.setData(user);
				result.setSuccessful(true);
				loginLogService.logIn(request);



	        }else{
	        	result.setSuccessful(false);
                result.setMsg(Constants.PASSWORDERROR_MESSAGE);
	        }
		} catch (UnknownAccountException e) {
			//logger.info(e.getMessage(), e);
			result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
		} catch (IncorrectCredentialsException e) {
			//logger.info(e.getMessage(), e);
			result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
		} catch (ExcessiveAttemptsException e) {
			//logger.error(e.getMessage(), e);
			result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
		} catch (AuthenticationException e) {
			//logger.error(e.getMessage(), e);
			//throw e;
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
		}catch (ArsException e) {
            //logger.error(e.getMessage(), e);
            //throw e;
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
		return result;
	}
    /**
     * 单点登录
     * @param request 请求域
     * @param response 响应域
     * @return
     */
    @RequestMapping(value = "cas/login")
    public @ResponseBody
    AjaxResult casLogin(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Subject currentUser = SecurityUtils.getSubject();

            //判断是否登录成功！
            if (currentUser.isAuthenticated()) {
                //当前session
                Session session = currentUser.getSession();
                //用户
                User user =  (User)currentUser.getPrincipal();
                //机构信息
                Police police = policeService.findById(user.getOrgid());
                if(police!=null){
                    user.setPolice(police);
                }
                /***
                 * 城市区域
                 */
                String cityAreaCode =police.getAreacode().substring(0,4)+"00";
                user.setCityAreaCode(cityAreaCode);
                //获取用户的数据权限机构编码列表 add subh 2019-04-05 10:25
                user.setAreasList(policeService.findDataPoliceForUserID(user.getId()));
                //登录次数+1
                if( null!= user.getLoginNum() ) {
                    user.setLoginNum(user.getLoginNum()+1);
                }else{
                    user.setLoginNum(1);
                }
                //登录时间为当前时间
                user.setLoginDate(new Date());
                userService.updateLoginState(user);
                user.setSessionId(session.getId().toString());
                arsUtil.setCurrentUser(user,1000*120*loginTimeout);
                result.setData(user);
                result.setSuccessful(true);
                loginLogService.logIn(request);
                //获取上下文
                ServletContext servletContext = request.getServletContext();
                String rootPath = servletContext.getContextPath();
                response.sendRedirect(rootPath+"/index.do");
            }else{
                result.setSuccessful(false);
                result.setMsg(Constants.PASSWORDERROR_MESSAGE);
            }
        } catch (UnknownAccountException e) {
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (IncorrectCredentialsException e) {
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (ExcessiveAttemptsException e) {
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        } catch (AuthenticationException e) {
            result.setSuccessful(false);
            result.setMsg(Constants.PASSWORDERROR_MESSAGE);
        }catch (ArsException e) {
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }

    /**
	 * 通过sid验证对应登录信息是否有效
	 * @param sid
	 * @return
	 */
	@RequestMapping(value="validateLogin", method=RequestMethod.POST)
	public @ResponseBody AjaxResult validateLogin(@RequestParam(value="sid", required=true)String sid) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				result.setData(user);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping(value="getCurrentUser", method=RequestMethod.POST)
	public @ResponseBody AjaxResult getCurrentUser() throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User currentUser = arsUtil.getCurrentUser();
			if(currentUser != null) {
				result.setSuccessful(true);
				User user = userService.findById(currentUser.getId());
				result.setData(user);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


    /**
     * <b>Function </b>登出
     *
     * @param sid
     * @return
     * @author LinQingLin
     * @date 2017年2月6日 下午5:11:33
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping(value = "logout", method = RequestMethod.POST)
    public @ResponseBody
    AjaxResult logOut(String sid, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            //更新一下下线状态
            User user = arsUtil.getCurrentUser();
            if (null!= user ) {
                loginLogService.logOut(request);
                user.setLoginstate(0);
                user.setRegistrationID("");
                userService.updateLoginState(user);
            }

            Subject currentUser = SecurityUtils.getSubject();
            currentUser.logout();
            arsUtil.removeCurrentUser(request);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 忘记密码
     *
     * @param username
     * @param realname
     * @param phone
     * @param request
     * @return
     */
    @RequestMapping("forgetPwd")
    public @ResponseBody
    AjaxResult forgetPwd(@RequestParam(value = "username", required = true) String username,
                         @RequestParam(value = "realname", required = true) String realname,
                         @RequestParam(value = "phone", required = true) String phone, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = userService.findByUsername(username,null);
            if (user != null) {
                //查询经办人号码
                SecurityCompany securityCompany = securityCompanyService.findByUserid(user.getId());

                if (user.getRealname().equals(realname.trim()) && (user.getPhone().equals(phone.trim()) || (securityCompany.getOperatorphone() != null && securityCompany.getOperatorphone().equals(phone.trim())))) {
                    int code = MessageUtil.sendMessageCode(phone, messageLogDao);
                    //判断是向法人还是经办人发送验证码，保证法人经办人都能收到一致的验证码
                    if (user.getPhone().equals(phone)) {
                        //法人跟经办人不同才再发，如果法人手机号跟经办人同一手机号，则会报一分钟内重复发送的错误
                        if(!user.getPhone().equals(securityCompany.getOperatorphone())) {
                            MessageUtil.sendMessageHaveCode(securityCompany.getOperatorphone(), messageLogDao, code);
                        }
                    } else if (securityCompany.getOperatorphone().equals(phone)) {
                        MessageUtil.sendMessageHaveCode(user.getPhone(), messageLogDao, code);
                    }
                    redisUtil.set(code + "", username, (messageCodeTimeout * 60));
                    result.setSuccessful(true);
                    result.setMsg("验证码已发送。");
                    logger.debug(code + "");
                } else {
                    result.setSuccessful(false);
                    result.setMsg("信息不正确，请重新输入！");
                }
            } else {
                result.setSuccessful(false);
                result.setMsg("信息不正确，请重新输入！");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 忘记密码
     *
     * @param username
     * @param realname
     * @param phone
     * @param request
     * @return
     */
    @RequestMapping("zrrgsforgetPwd")
    public @ResponseBody
    AjaxResult zrrgsforgetPwd(@RequestParam(value = "username", required = true) String username,
                              @RequestParam(value = "realname", required = true) String realname,
                              @RequestParam(value = "phone", required = true) String phone, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = userService.findByUsernameAndPlatform(username);
            if (user != null) {
                //查询经办人号码
                SecurityCompany securityCompany = securityCompanyService.findByUserid(user.getId());
                if (securityCompany != null) {
                    if (user.getRealname() != null && user.getRealname().equals(realname.trim()) && (user.getPhone() != null && user.getPhone().equals(phone.replace(",", " ").trim()) || (securityCompany.getOperatorphone() != null && securityCompany.getOperatorphone().equals(phone.replace(",", " ").trim())))) {
                        int code = MessageUtil.sendMessageCode(phone, messageLogDao);
                        //判断是向法人还是经办人发送验证码，保证法人经办人都能收到一致的验证码
                        if (user.getPhone().equals(phone.replace(",", " "))) {
                            //法人跟经办人不同才再发，如果法人手机号跟经办人同一手机号，则会报一分钟内重复发送的错误
                            if(!user.getPhone().equals(securityCompany.getOperatorphone())) {
                                MessageUtil.sendMessageHaveCode(securityCompany.getOperatorphone(), messageLogDao, code);
                            }
                        } else if (securityCompany.getOperatorphone() != null && securityCompany.getOperatorphone().equals(phone.replace(",", " "))) {
                            MessageUtil.sendMessageHaveCode(user.getPhone(), messageLogDao, code);
                        }
                        redisUtil.set(code + "", username, (messageCodeTimeout * 60));
                        result.setSuccessful(true);
                        result.setMsg("验证码已发送。");
                        logger.debug(code + "");
                    } else {
                        result.setSuccessful(false);
                        result.setMsg("信息不正确，请重新输入！");
                    }
                } else {
                    if (user.getRealname() != null && user.getRealname().equals(realname.trim()) && (user.getPhone() != null && user.getPhone().equals(phone.replace(",", " ").trim()))) {
                        int code = MessageUtil.sendMessageCode(phone.replace(",", " "), messageLogDao);
                        redisUtil.set(code + "", username, (messageCodeTimeout * 60));
                        result.setSuccessful(true);
                        result.setMsg("验证码已发送。");
                        logger.debug(code + "");
                    } else {
                        result.setSuccessful(false);
                        result.setMsg("信息不正确，请重新输入！");
                    }
                }

            } else {
                result.setSuccessful(false);
                result.setMsg("信息不正确，请重新输入！");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 忘记密码
     *
     * @param phone
     * @param request
     * @return
     */
    @RequestMapping("zrrforgetPwd")
    public @ResponseBody
    AjaxResult zrrforgetPwd(@RequestParam(value = "phone", required = true) String phone, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = userService.findByPhone(phone.replace(",", ""));
            if (user != null) {
                int code = MessageUtil.sendMessageCode(phone.replace(",", ""), messageLogDao);
                redisUtil.set(code + "", user.getPhone(), (messageCodeTimeout * 60));
                result.setSuccessful(true);
                result.setMsg("验证码已发送。");
                logger.debug(code + "");
            } else {
                result.setSuccessful(false);
                result.setMsg("信息不正确，请重新输入！");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 获取短信验证码
     *
     * @param request
     */
    @RequestMapping("getop")
    public @ResponseBody
    AjaxResult getop(HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                //查询经办人号码
                SecurityCompany securityCompany = securityCompanyService.findByUserid(user.getId());
                result.setData(securityCompany);
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
                result.setMsg("该用户不存在。");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 获取短信验证码
     *
     * @param request
     */
    @RequestMapping("getMessageCode")
    public @ResponseBody
    AjaxResult getMessageCode(String phone, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                if (phone == null) {
                    int code = MessageUtil.sendMessageCode(user.getPhone(), messageLogDao);
                    redisUtil.set(code + "", user.getUsername(), (messageCodeTimeout * 60));
                } else {
                    //查询经办人号码
                    String[] phoneArr = phone.split("/");
                    int code = MessageUtil.sendMessageCode(phoneArr[0], messageLogDao);
                    redisUtil.set(code + "", user.getUsername(), (messageCodeTimeout * 60));
                    if (phone.split("/").length > 1 && phoneArr[1] != null && !phoneArr[1].equals("") && !phoneArr[1].equals(phoneArr[0])) {
                        MessageUtil.sendMessageHaveCode(phoneArr[1], messageLogDao, code);
                    }

                }

                result.setSuccessful(true);
                result.setMsg("验证码已发送。");
            } else {
                result.setSuccessful(false);
                result.setMsg("该用户不存在。");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping(value = "verifyMessageCode", method = RequestMethod.POST)
    public @ResponseBody
    AjaxResult verifyMessageCode(@RequestParam(value = "username", required = true) String username,
                                 @RequestParam(value = "messageCode", required = true) String messageCode, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            String un = redisUtil.get(messageCode);
            if (un != null && un.equals(username)) {
                result.setSuccessful(true);
                result.setMsg("短信验证码正确.");
            } else {
                result.setSuccessful(false);
                result.setMsg("短信验证码错误.");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping(value = "zzrverifyMessageCode", method = RequestMethod.POST)
    public @ResponseBody
    AjaxResult zzrverifyMessageCode(@RequestParam(value = "phone", required = true) String phone,
                                    @RequestParam(value = "messageCode", required = true) String messageCode, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            String un = redisUtil.get(messageCode);
            if (un != null && un.equals(phone.replace(",", ""))) {
                result.setSuccessful(true);
                result.setMsg("短信验证码正确.");
            } else {
                result.setSuccessful(false);
                result.setMsg("短信验证码错误.");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


	/**
	 * 完成初始化
	 * @param request
	 * @return
	 */
	@RequestMapping(value="finishInit", method=RequestMethod.POST)
	public @ResponseBody AjaxResult finishInit(HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null){
				User dbUser = userService.findByUsername(user.getUsername(),user.getPlatform()==null?null:user.getPlatform().toString());
				dbUser.setInit(true);
				dbUser.setInitstep(Constants.INTISTEP_ROL);
				userService.updateInitstep(dbUser);
				result.setSuccessful(true);
				dbUser.setSessionId(user.getSessionId());
				Subject currentUser = SecurityUtils.getSubject();
	        	Session session=currentUser.getSession();
				arsUtil.setCurrentUser(dbUser,(int)session.getTimeout());
				result.setData(dbUser);
			} else {
				result.setSuccessful(false);
				result.setMsg("当前用户信息错误");
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 查询搜索历史
	 * <b>Function </b> 
	 * 
	 * @param dto
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月1日 下午1:48:28
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping(value="searchHistory")
	public @ResponseBody AjaxResult searchHistory(HistorySearchDto dto) throws Exception{
		try {
			return searchHistoryService.searchHistory(dto);
		} catch (Exception e) {
			throw e;
		}
	}
	
	/**
	 * 删除指定搜索历史
	 * <b>Function </b> 
	 * 
	 * @param id
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月1日 下午1:48:49
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping(value="deleteHistory")
	public @ResponseBody AjaxResult deleteHistory(long id) throws Exception{
		try {
			return searchHistoryService.deleteHistory(id);
		} catch (Exception e) {
			throw e;
		}
	}
	
	/**
	 * 删除当前登录账号下的全部搜索历史
	 * <b>Function </b> 
	 * 
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月1日 下午1:48:54
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping(value="deleteAllHistory")
	public @ResponseBody AjaxResult deleteAllHistory() throws Exception{
		try {
			return searchHistoryService.deleteAllHistory();
		} catch (Exception e) {
			throw e;
		}
	}
	
	/**
	 * 根据手机号获取验证码
	 * <b>Function </b> 
	 * 
	 * @param phone
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月1日 下午1:54:25
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("getCodeByPhone")
	public @ResponseBody AjaxResult getCodeByPhone(String phone) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			String[] phoneArr = phone.split("/");
			int code = MessageUtil.sendMessageCode(phoneArr[0],messageLogDao);
			if(phone.split("/").length>1&&phoneArr[1]!=null&& !phoneArr[1].equals("") && !phoneArr[1].equals(phoneArr[0])){
				MessageUtil.sendMessageHaveCode(phoneArr[1],messageLogDao,code);
				redisUtil.set(code+"", phoneArr[1], (messageCodeTimeout*60));
			}
			redisUtil.set(code+"", phoneArr[0], (messageCodeTimeout*60));
			result.setSuccessful(true);
			result.setMsg("验证码已发送。");
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	

    /**
     * 修改密码
     *
     * @param password
     * @param messageCode
     * @param request
     * @return
     */
    @RequestMapping(value = "zrrgsupdatePwd", method = RequestMethod.POST)
    public @ResponseBody
    AjaxResult zrrgsupdatePwd(@RequestParam(value = "username", required = true) String username,
                              @RequestParam(value = "password", required = true) String password,
                              @RequestParam(value = "messageCode", required = true) String messageCode,
                              @RequestParam(value = "operatorphone", required = false) String operatorphone,
                              @RequestParam(value = "operatorname", required = false) String operatorname, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            logger.info(messageCode + "," + username);
            String un = redisUtil.get(messageCode);
            if (un != null && un.equals(username)) {
                User user = userService.findByUsernameAndPlatform(username);
                if (user != null) {
                    //法人填写经办人手机号码
                    SecurityCompany securityCompany = securityCompanyService.findByUserid(user.getId());
                    if (securityCompany != null) {
                        if (operatorphone != null && !operatorphone.equals("")) {
                            securityCompany.setOperatorphone(operatorphone);
                        }
                        if (operatorname != null && !operatorname.equals("")) {
                            securityCompany.setOperatorname(operatorname);
                        }
                        securityCompanyService.updateOperatorphone(securityCompany);
                    }
                    user.setPassword(Sha1Util.entryptPassword(password));
                    user.setUpdateTime(new Date());
                    user.setUpdateBy(user.getUsername());
                    userService.updatePassword(user);
                    result.setSuccessful(true);
                } else {
                    result.setSuccessful(false);
                    result.setMsg("用户信息错误.");
                }
            } else {
                result.setSuccessful(false);
                result.setMsg("短信验证码错误.");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 修改密码
     *
     * @param password
     * @param messageCode
     * @param request
     * @return
     */
    @RequestMapping(value = "updatePwd", method = RequestMethod.POST)
    public @ResponseBody
    AjaxResult updatePwd(@RequestParam(value = "username", required = true) String username,
                         @RequestParam(value = "password", required = true) String password,
                         @RequestParam(value = "messageCode", required = true) String messageCode,
                         @RequestParam(value = "operatorphone", required = false) String operatorphone,
                         @RequestParam(value = "operatorname", required = false) String operatorname, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            logger.info(messageCode + "," + username);
            String un = redisUtil.get(messageCode);
            if (un != null && un.equals(username)) {
                User user = userService.findByUsername(username,null);
                if (user != null) {
                    //法人填写经办人手机号码
                    SecurityCompany securityCompany = securityCompanyService.findByUserid(user.getId());
                    if (securityCompany != null) {
                        if (operatorphone != null && !operatorphone.equals("")) {
                            securityCompany.setOperatorphone(operatorphone);
                        }
                        if (operatorname != null && !operatorname.equals("")) {
                            securityCompany.setOperatorname(operatorname);
                        }
                        securityCompanyService.updateOperatorphone(securityCompany);
                    }
                    user.setPassword(Sha1Util.entryptPassword(password));
                    user.setUpdateTime(new Date());
                    user.setUpdateBy(user.getUsername());
                    userService.updatePassword(user);
                    result.setSuccessful(true);
                } else {
                    result.setSuccessful(false);
                    result.setMsg("用户信息错误.");
                }
            } else {
                result.setSuccessful(false);
                result.setMsg("短信验证码错误.");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 修改密码
     *
     * @param password
     * @param messageCode
     * @param request
     * @return
     */
    @RequestMapping(value = "zrrupdatePwd", method = RequestMethod.POST)
    public @ResponseBody
    AjaxResult zrrupdatePwd(@RequestParam(value = "phone", required = true) String phone,
                            @RequestParam(value = "password", required = true) String password,
                            @RequestParam(value = "messageCode", required = true) String messageCode, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            logger.info(messageCode + "," + phone.replace(",", ""));
            String un = redisUtil.get(messageCode);
            if (un != null && un.equals(phone.replace(",", ""))) {
                User user = userService.findByPhone(phone.replace(",", ""));
                if (user != null) {
                    user.setPassword(Sha1Util.entryptPassword(password));
                    user.setUpdateTime(new Date());
                    user.setUpdateBy(user.getUsername());
                    userService.updatePassword(user);
                    result.setSuccessful(true);
                } else {
                    result.setSuccessful(false);
                    result.setMsg("用户信息错误.");
                }
            } else {
                result.setSuccessful(false);
                result.setMsg("短信验证码错误.");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 修改密码（公安内网专用）
     *
     * @param password
     * @param username
     * @param request
     * @return
     */
    @RequestMapping(value = "editPwd", method = RequestMethod.POST)
    public @ResponseBody
    AjaxResult editPwd(@RequestParam(value = "username", required = true) String username,
                       @RequestParam(value = "password", required = true) String password, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Config config = configService.findByKey("police");
            if (config.getValue().equals("1")) {//公安内网
                logger.info(username);
                User user = userService.findByUsername(username,null);
                if (user != null) {
                    user.setPassword(Sha1Util.entryptPassword(password));
                    user.setUpdateTime(new Date());
                    user.setUpdateBy(user.getUsername());
                    userService.updatePassword(user);
                    result.setSuccessful(true);
                } else {
                    result.setSuccessful(false);
                    result.setMsg("用户信息错误.");
                }
            } else {
                throw new ArsException("非公安内网，无法使用此功能！");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    @RequestMapping(value = "verifyCode", method = RequestMethod.POST)
    public @ResponseBody
    AjaxResult verifyCode(@RequestParam(value = "messageCode", required = true) String messageCode, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            String un = redisUtil.get(messageCode);
//            if (user != null) {
//                //查询经办人号码
//                SecurityCompany securityCompany = securityCompanyService.getCurrentUserCompany();
//				if(un != null &&(un.equals(user.getPhone())|| (StringUtil.isNotEmpty(securityCompany.getOperatorphone()) && un.equals(securityCompany.getOperatorphone())))) {
//					result.setSuccessful(true);
//					result.setMsg("短信验证码正确.");
//				} else {
//					result.setSuccessful(false);
//					result.setMsg("短信验证码错误.");
//				}
//			}
            result.setSuccessful(true);
            result.setMsg("短信验证码正确.");
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

    /**
     * 公安用户管理列表页
     *
     * @return
     */
    @RequestMapping("manage/index")
    @RequiresPermissions("userManager:query")
    public String manageIndex() {
        return "sys/user/list";
    }
    /**
     * 公安用户管理列表页(会议)
     *
     * @return
     */
    @RequestMapping("manage/indexConference")
    @RequiresPermissions("userManager:query")
    public ModelAndView manageConference(UserPageSearchDto dto) {
        ModelAndView view=new ModelAndView();
        view.addObject("searchDto",dto);
        view.setViewName("sys/user/listConference");
        return view;
    }

    /**
     * 公安用户管理新增修改页面
     *
     * @return
     */
    @RequestMapping("edit/index")
    @RequiresPermissions(logical = Logical.OR,value ={"userManager:edit","userManager:add"})
    public String editIndex() {
        return "sys/user/edit";
    }

    /***
     * 公安用户管理查询
     * @param dto 查询条件参数
     * @param page 返回数据对象
     * @return 查询列表
     */
    @RequestMapping("searchForPage")
    @RequiresPermissions("userManager:query")
    public @ResponseBody
    AjaxPageResponse searchForPage(UserPageSearchDto dto, AjaxPageResponse<PoliceUserDto> page){
        try {
            User currentUser = arsUtil.getCurrentUser();
            dto.setPath(currentUser.getPolice().getPath());
            userService.searchForPage(dto, page);
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }

	/**
	 * 搜索用户列表
	 * <b>Function </b> 
	 * 
	 * @param dto
	 * @param request
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月1日 下午1:54:39
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("search")
	public @ResponseBody AjaxResult search(UserSearchDto dto, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			UserSearchDto data = userService.search(dto);
			result.setSuccessful(true);
			result.setData(data);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}

    /**
     * 账号管理
     * @param dto
     * @param request
     * @return
     * @throws Exception
     */
    @RequestMapping("searchAccount")
    public @ResponseBody AjaxResult searchCount(UserSearchDto dto, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            UserSearchDto data = userService.searchAccount(dto);
            result.setSuccessful(true);
            result.setData(data);
        } catch(Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 修改用户信息
     * <b>Function </b>
     *
     * @param user
     * @param roleIds
     * @param request
     * @return
     * @throws Exception
     * @author LinQingLin
     * @date 2017年8月1日 下午1:54:54
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("update")
    public @ResponseBody
    AjaxResult update(User user, Long[] roleIds, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User currentUser = arsUtil.getCurrentUser();
            if (currentUser != null) {
                user.setUsername(user.getIdNumber());
                List<PoliceRole> roleList = new ArrayList<PoliceRole>();
                if (roleIds != null && roleIds.length > 0) {

                    PoliceRole role = null;
                    for (Long roleId : roleIds) {
                        role = new PoliceRole();
                        role.setId(roleId);
                        roleList.add(role);
                    }
                }

                if (currentUser.getPlatform().intValue() == 1) {
                    //公安以警号为登陆名
                    user.setUsername(user.getCodeNo());

                    if(user.getReplyRole() != null && user.getReplyRole()){

                        //处长角色
                        Config czConfig =configUtils.getConfigByKey(Constants.CZJSID);
                        if (czConfig != null) {
                            String czjsid = "";
                            if (czConfig != null && czConfig.getValue() != null) {
                                czjsid = czConfig.getValue();
                                PoliceRole role = new PoliceRole();
                                role.setId(Long.parseLong(czjsid));
                                roleList.add(role);
                            }
                        }

                    }
                }

                //角色
                user.setRoles(roleList);
                userService.saveOrUpdate(user,String.valueOf(Constants.PLATFORM_POLICE));
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
                result.setMsg("当前用户信息错误");
            }
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 重置密码
     * <b>Function </b>
     *
     * @param user
     * @param request
     * @return
     * @throws Exception
     * @author LinQingLin
     * @date 2017年8月1日 下午1:52:27
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("resetPassword")
    public @ResponseBody
    AjaxResult resetPassword(User user, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            if(StringUtil.isEmpty(user.getPassword())){
                user.setPassword(Constants.DEFAULT_PASSWORD);
            }
            user.setPassword(Sha1Util.entryptPassword(user.getPassword()));
            userService.updatePasswordBypolice(user);
            result.setSuccessful(true);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }




    /**
     * 更新云会议状态
     * <b>Function </b>
     *
     * @param user
     * @throws Exception
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("updateConferenceState")
    public @ResponseBody
    AjaxResult updateConferenceState(User user) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            userService.updateConferenceState(user);
            result.setSuccessful(true);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }


    /**
     * 根据id获取用户信息
     * <b>Function </b>
     *
     * @param id
     * @param request
     * @return
     * @throws Exception
     * @author LinQingLin
     * @date 2017年8月1日 下午1:55:10
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("findById/{id}")
    public @ResponseBody
    AjaxResult findById(@PathVariable("id") Long id, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User currentUser = arsUtil.getCurrentUser();
            if (currentUser != null) {
                User user = userService.findById(id);
                if (user != null) {
                    user.getRoles();
                    result.setSuccessful(true);
                    result.setData(user);
                } else {
                    result.setSuccessful(false);
                    result.setMsg("未找到指定用户信息。");
                }
            } else {
                result.setSuccessful(false);
                result.setMsg("当前用户信息错误");
            }
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 根据id获取用户信息(用户管理专用)
     * <b>Function </b>
     *
     * @param id
     * @param request
     * @return
     * @throws Exception
     * @author LinQingLin
     * @date 2017年8月1日 下午1:55:33
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("findByIdForManager/{id}")
    public @ResponseBody
    AjaxResult findByIdForManager(@PathVariable("id") Long id, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User currentUser = arsUtil.getCurrentUser();
            if (currentUser != null) {
                User user = userService.findByIdForManager(id);
                if (user != null) {
                    user.getRoles();
                    boolean replyRole = false;
                    //处长角色
                    Config czConfig =configUtils.getConfigByKey(Constants.CZJSID);
                    if (czConfig != null) {
                        String czjsid = "";
                        if (czConfig != null && czConfig.getValue() != null) {
                            czjsid = czConfig.getValue();
                            UserRole userRole = userRoleService.findByUserIdAndRoleId(user.getId(),Long.parseLong(czjsid));
                            if(userRole != null){
                                replyRole = true;
                            }
                        }
                    }
                    user.setReplyRole(replyRole);

                    result.setSuccessful(true);
                    result.setData(user);
                } else {
                    result.setSuccessful(false);
                    result.setMsg("未找到指定用户信息。");
                }
            } else {
                result.setSuccessful(false);
                result.setMsg("当前用户信息错误");
            }
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 删除用户
     * <b>Function </b>
     *
     * @param userid
     * @param request
     * @return
     * @throws Exception
     * @author LinQingLin
     * @date 2017年8月1日 下午1:55:53
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("delete/{userid}")
    public @ResponseBody
    AjaxResult delete(@PathVariable Long userid, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User currentUser = arsUtil.getCurrentUser();
            if (currentUser != null) {
                if (currentUser.getId().equals(userid)) {
                    result.setSuccessful(false);
                    result.setMsg("无法删除自己的账号！");
                } else {
                    User user = userService.findById(userid);
                    user.getRoles();
                    userService.delete(user);
                    result.setSuccessful(true);
                }
            } else {
                result.setSuccessful(false);
                result.setMsg("当前用户信息错误");
            }
        } catch (Exception e) {
            throw e;
        }
        return result;
    }


    @RequestMapping("findByAreaReport")
    public @ResponseBody
    AjaxResult findByAreaReport(ReportDataSearchDto searchDto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            JSONObject resultObj = new JSONObject();
            DecimalFormat df = new DecimalFormat("#.0");
            List<ReportData> data = userService.findByAreaReport(searchDto);
            List<String> nameList = new ArrayList<String>();
            Long total = 0l;
            for (ReportData reportData : data) {
                total = total + reportData.getValue();
            }
            for (ReportData reportData : data) {
                System.out.println(reportData.getName() + "  " + reportData.getValue() + "人  " + df.format(reportData.getValue() * 100.0 / total) + "%");
//				nameList.add(reportData.getName());
                nameList.add(reportData.getName() + "  " + reportData.getValue() + "人  " + df.format(reportData.getValue() * 100.0 / total) + "%");
                reportData.setName(reportData.getName() + "  " + reportData.getValue() + "人  " + df.format(reportData.getValue() * 100.0 / total) + "%");
            }
            resultObj.put("names", nameList);
            resultObj.put("values", data);
            resultObj.put("total", total);
            result.setSuccessful(true);
            result.setData(resultObj);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 新审批模板：选择人员
     * @param dto
     * @param request
     * @return
     * @throws Exception
     */
	@RequestMapping("searchApproveUser")
	public @ResponseBody AjaxResult searchApproveuser(UserSearchDto dto, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			UserSearchDto data = userService.searchApproveUser(dto);
			result.setSuccessful(true);
			result.setData(data);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}



    /*********************************与SaaS对接start*******************************************/
    /**
     * 修改密码（用于与SaaS对接）
     * @param userDto 用户信息
     * @return 是否执行成这功
     */
    @RequestMapping(value="modify-pwd", method=RequestMethod.POST)
    public @ResponseBody AjaxResult modifyPwd(@Valid UserDto userDto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            logger.info(userDto.getUsername());
            User user = userService.findByUsername(userDto.getUsername(),null);
            if(user != null) {
                user.setPassword(Sha1Util.entryptPassword(userDto.getPassword()));
                user.setUpdateTime(new Date());
                user.setUpdateBy(user.getUsername());
                userService.updatePassword(user);
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
                result.setMsg("用户信息错误.");
            }
        } catch(Exception e) {
            logger.error(e.getMessage(),e);
            result.setSuccessful(false);
            result.setMsg(e.getMessage());
        }
        return result;
    }
    /**
     * SaaS登录之后回调百保盾
     * @param userDto 用户信息
     * @return
     */
    @RequestMapping(value="saas/login",method=RequestMethod.POST)
    public @ResponseBody AjaxResult saasLogin(@Valid UserDto userDto,HttpServletRequest request,HttpServletResponse response) {
        AjaxResult result = new AjaxResult();
        try {
            if(StringUtil.isEmpty(userDto.getSessionId())){
                throw new ArsException("登录信息错误！");
            }
            /*sessonID加密规则：
            公司ID+用户名+密码+机构类别+失效日期
            comId+username+password+orgType+expiresDate  (|分割,DES3对称加密)
            */
            String sessionID = AESUtil.decode(userDto.getSessionId());
            String[] userInfos = sessionID.split("\\|");
            String comId = userInfos[0];
            String password = userInfos[2];
            result = webSaaSLogin(comId,password,request,response);
            if(result.isSuccessful()) {
                //登录成功保存session到缓存
                Subject currentUser = SecurityUtils.getSubject();
                redisUtil.set(userDto.getSessionId(), currentUser.getSession().getId().toString());
                redisUtil.set(userDto.getSessionId()+"_USERINFO", JSONObject.toJSONString(result.getData()));
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            result.setMsg("用户名/密码错误");
        }
        return result;
    }
    /**
     * SaaS登录之后回调百保盾
     * @param userDto 用户信息
     * @return
     */
    @RequestMapping(value="saas/toPage")
    public @ResponseBody AjaxResult toPage(@Valid UserDto userDto,HttpServletRequest request,HttpServletResponse response) {
        AjaxResult result = new AjaxResult();
        try {
            if(StringUtil.isEmpty(userDto.getSessionId())){
                throw new ArsException("登录信息错误！");
            }
            if(StringUtil.isEmpty(userDto.getPageType())){
                throw new ArsException("参数信息错误！");
            }
            /*sessonID加密规则：
            公司ID+用户名+密码+机构类别+失效日期
            comId+username+password+orgType+expiresDate  (|分割,DES3对称加密)
            */
            String sessionID = AESUtil.decode(userDto.getSessionId());
            String[] userInfos = sessionID.split("\\|");
            String comId = userInfos[0];
            String password = userInfos[2];
            // 验证失效日期
            result = webSaaSLogin(comId,password,request,response);
            if(result.isSuccessful()) {
                //登录成功保存session到缓存
                User currentUser = arsUtil.getCurrentUser();
                //陕西
                if (currentUser.getPlatform() != 1 && currentUser.getPlatform() != 4) {
                    SecurityCompany company = securityCompanyService.findByUserid(currentUser.getId());
                    if (company.getAreaCode() != null) {
                        String cityAreaCode = company.getAreaCode().substring(0, 4) + "00";
                        currentUser.setCityAreaCode(cityAreaCode);
                    }
                }
                //用户信息和sessionID
                request.getSession().setAttribute(Constants.LOGIN_USER, currentUser);

                request.getSession().setAttribute(Constants.SESSION_ID, currentUser.getSessionId());
                //获取上下文
                ServletContext servletContext = request.getServletContext();
                String rootPath = servletContext.getContextPath();
                //根据不同的页面类型，跳转到不同的页面
                String perId = request.getParameter("perId");

                switch (userDto.getPageType()) {
                    case "001"://地图
                        response.sendRedirect(rootPath + "/saas/map/index.do?sid=" + currentUser.getSessionId());
                        break;
                    case "002"://申报
                        response.sendRedirect(rootPath + "/approval/approveMenu.do?sid=" + currentUser.getSessionId());
                        break;
                    case "003"://枪支
                    response.sendRedirect(rootPath + "/firearms/list/index.do?sid=" + currentUser.getSessionId());
                        break;
                    case "004"://车辆
                    response.sendRedirect(rootPath + "/vehicle/list/index.do?sid=" + currentUser.getSessionId());
                        break;
                    case "005"://问题人员
                    response.sendRedirect(rootPath + "/problemperson/toCompanyListPage.do?sid=" + currentUser.getSessionId());
                        break;
                    case "006"://比对人员
                    response.sendRedirect(rootPath + "/gradePerson/toQueryPage.do?sid=" + currentUser.getSessionId());
                        break;
                    case "007"://等级证管理
                    response.sendRedirect(rootPath + "/grade/toQueryPage.do?sid=" + currentUser.getSessionId());
                        break;
                    case "008"://消息回复
                    response.sendRedirect(rootPath + "/newsnoticecompany/index/list.do?sid=" + currentUser.getSessionId());
                        break;
                    case "009"://补证管理
                    response.sendRedirect(rootPath + "/securityCertificate/trainOrg/queryRepair.do?sid=" + currentUser.getSessionId());
                        break;
                    case "010"://打印记录
                    response.sendRedirect(rootPath + "/certificatePrintLog/toQueryPage.do?sid=" + currentUser.getSessionId());
                        break;
                    case "011"://等级证补贴批次管理
                    response.sendRedirect(rootPath + "/gradeSubsidyBatch/trainList/index.do?subsidyCerType=01&sid=" + currentUser.getSessionId());
                        break;
                    case "012"://等级证比对人员名单
                    response.sendRedirect(rootPath + "/gradeSubsidyRoster/trainList/index.do?subsidyCerType=01&sid=" + currentUser.getSessionId());
                        break;
                    case "013"://资格证补贴批次管理
                    response.sendRedirect(rootPath + "/gradeSubsidyBatch/trainList/index.do?subsidyCerType=02&sid=" + currentUser.getSessionId());
                        break;
                    case "014"://资格证比对人员名单
                    response.sendRedirect(rootPath + "/gradeSubsidyRoster/trainList/index.do?subsidyCerType=02&sid=" + currentUser.getSessionId());
                        break;
                    case "015"://疫情防控
                    response.sendRedirect(rootPath + "/epidemic/query.do?sid=" + currentUser.getSessionId());
                        break;
                    case "016"://等级证补贴可申请人员名单
                    response.sendRedirect(rootPath + "/gradeSubsidyRoster/applyList/index.do?subsidyCerType=01&sid=" + currentUser.getSessionId());
                        break;
                    case "017"://资格证课程学习记录查询页面
                    response.sendRedirect(rootPath + "/cerLearnRecord/list/index.do?recordType=01&sid=" + currentUser.getSessionId());
                        break;
                    case "018"://等级证课程学习记录查询页面
                    response.sendRedirect(rootPath + "/cerLearnRecord/list/index.do?recordType=03&sid=" + currentUser.getSessionId());
                        break;
                    case "019"://等级证课程学习记录查询页面
                    response.sendRedirect(rootPath + "/annualSurveyReport/edit/index.do?sid=" + currentUser.getSessionId() + "&perId=" + perId);
                        break;
                    case "020"://保安员离京登记
                        response.sendRedirect(rootPath+"/enrolmentLeaveBeijing/list/index.do?sid="+ currentUser.getSessionId());
                        break;
                    case "021"://临保任务
                        response.sendRedirect(rootPath+"/tempTask/list/index.do?sid="+ currentUser.getSessionId());
                        break;
                    case "022"://保安协会等级评定
                        response.sendRedirect(rootPath + "/rating/list/index.do?sid=" + currentUser.getSessionId() + "&perId=" + perId);
                    default:
                        break;
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            result.setMsg("用户名/密码错误");
        }
        return result;
    }



    /**
     * SaaS 培训机构登陆跳转到保安员证书页面
     * @param userDto 用户信息
     * @return 用户密码错误跳转到失败页面，正确跳转到保安员证查询页面
     */
    @RequestMapping(value="saas/toPageForTrain")
    public @ResponseBody
    ModelAndView toPageForTrain(@Valid UserDto userDto, HttpServletRequest request, HttpServletResponse response) {
        ModelAndView view = new ModelAndView();
        AjaxResult result = new AjaxResult();
        try {
            if(StringUtil.isEmpty(userDto.getSessionId())){
                throw new ArsException("登录信息错误！");
            }
            /*sessonID加密规则：
            公司ID+用户名+密码+机构类别+失效日期
            comId+username+password+orgType+expiresDate  (|分割,DES3对称加密)
            */
            String sessionID = AESUtil.decode(userDto.getSessionId());
            String[] userInfos = sessionID.split("\\|");
            String comId = userInfos[0];
            String password = userInfos[2];
            String expiresDate =  userInfos[4];
            // 验证失效日期
            result = webSaaSLogin(comId,password,request,response);

            //获取当前用户
            User user = (User)result.getData();
            if(result.isSuccessful()) {
                //登录成功保存session到缓存
                Subject currentUser = SecurityUtils.getSubject();
                //用户信息和sessionID
                request.getSession().setAttribute(Constants.LOGIN_USER, user);
                request.getSession().setAttribute(Constants.SESSION_ID, currentUser.getSession().getId());

                List<PrintDesign> printDesigns = printDesignService.findByAreacode(configUtils.getCurrentProvince(), Constants.BAYZGZ);

                String printDesign = null;
                if(printDesigns.size() > 0){
                    printDesign = printDesigns.get(0).getContent();
                }
                view.addObject("printDesign",printDesign);
                view.setViewName("certificate/security/query");

                //培训机构
                if(user.getPlatform() ==  Constants.PLATFORM_COMPANY) {
                    //根据用户ID获取公司信息
                    SecurityCompany company = securityCompanyService.findByUserid(user.getId());
                    view.addObject("trainId",company.getComId());
                }

            }else{
                view.setViewName("loginFail");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            view.setViewName("loginFail");
        }
        return view;
    }


    /****
     * 与公共安全服务平台登陆
     * @param comId 公司ID
     * @param password 密码
     * @param request
     * @param response
     * @return
     * @throws Exception
     */
    @RequestMapping(value = "saas/web/login", method = RequestMethod.POST)
    public @ResponseBody
    AjaxResult webSaaSLogin(@RequestParam(value = "comId", required = true) String comId,
                            @RequestParam(value = "password", required = true) String password, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            UsernamePasswordToken token = new UsernamePasswordToken(comId, password);
            Subject currentUser = SecurityUtils.getSubject();
            token.setRememberMe(false);
            token.setHost(Constants.SaaSCode);
            try {
                currentUser.login(token);
            } catch (AuthenticationException e) {
                logger.error(e.getMessage(), e);
                result.setSuccessful(false);
                result.setMsg("用户名/密码错误");
                return result;
            }
            //判断是否登录成功！
            if (currentUser.isAuthenticated()) {
                Session session = currentUser.getSession();
                SecurityCompany securityCompany = securityCompanyService.findByComId(Long.parseLong(comId));
                if(securityCompany == null){
                    logger.error("公共安全服务平台公司id("+comId+")不存在");
                }
                User user = securityCompany.getUser();
                //内网不允许保安公司登陆 add subh 2018-06-10 start
                Config config = configService.findByKey(Constants.POLICE);
                if (user.getPlatform() != Constants.PLATFORM_POLICE && Constants.ISPOLICE_YES.equals(config.getValue())) {
                    result.setSuccessful(false);
                    result.setMsg("保安公司或保安人员不支持内网登陆！");
                    return result;
                }
                //功能权限
                if(user.getPlatform() == 1  ) {
                    List list = permissionService.findByGAUserId(user.getId());
                    //用户与类型权限关系
                    List userbusinesslist  =  approvalService.findAllUserBusinessType(user.getId());
                    user.setUserBusinessTypeList(userbusinesslist);
                    user.setPermissionList(list);
                    Police police = policeService.findById(user.getOrgid());
                    if(police!=null){
                        user.setPolice(police);
                    }
                    //旧审批
                    //获取审批角色
                    List<PoliceRole> rolelist =  policeRoleService.findByUserId(user.getId());
                    user.setRoles(rolelist);

                    /***
                     * 城市区域
                     */
                    String cityAreaCode =police.getAreacode().substring(0,4)+"00";
                    user.setCityAreaCode(cityAreaCode);

                    //是否需要报名确认环节
                    String activiti_link_signup = (String) WebStartup.context.getAttribute(Constants.ACTIVITI_LINK+cityAreaCode+Constants.ACTIVITI_SIGNUP);
                    if(StringUtil.isNotEmpty(activiti_link_signup) && Constants.CONFIG_USABLE.equals(activiti_link_signup)){
                        request.getSession().setAttribute(Constants.ACTIVITI_SIGNUP, true);
                    }else{
                        request.getSession().setAttribute(Constants.ACTIVITI_SIGNUP, false);
                    }

                    //是否需要 缴费确认 环节
                    Config c = configUtils.getConfigByKey(Constants.CONFIGFEE+user.getCityAreaCode());
                    //是否需要 缴费确认 环节
                    if(null!=c && Constants.CONFIGFEE_YES.equals(c.getValue())){
                        request.getSession().setAttribute(Constants.CONFIGFEE_YES_SIGNUP, true);
                    }else{
                        request.getSession().setAttribute(Constants.CONFIGFEE_YES_SIGNUP, false);
                    }

                }else{
                    List list = permissionService.findByUserId(user.getId());
                    user.setPermissionList(list);
                }
                //更新一下登陆状态
                user.setLoginstate(1);
                //登录次数+1
                if( user.getLoginNum()!=null) {
                    user.setLoginNum(user.getLoginNum()+1);
                }else{
                    user.setLoginNum(1);
                }
                //登录时间为当前时间
                user.setLoginDate(new Date());

                //如果没有上传registrationID，就存USERID
                if( StringUtil.isEmpty(user.getRegistrationID())) {
                    user.setRegistrationID(user.getId().toString());
                }
                userService.updateLoginState(user);

                Map<String, String> p = new HashMap<String, String>();
                //百课堂加密  公司ID+用户名+密码+机构类别+失效日期
                //userId+username+password+orgType+expiresDate  (|分割,DES3对称加密)
                //保安公司
                String orgType= Constants.BKT_ORGTYPE_GS;
                if (user.getPlatform() == 5){
                    //机构
                    orgType=Constants.BKT_ORGTYPE_JG;
                }
                String bktTokenStr = user.getId() + "|" + user.getUsername() + "|" + user.getPhone() + "|" + orgType + "|" + DateUtil.convertDateToString(new Date(), DateUtil.FORMAT2);
                String bktToken = DES3.encode(bktTokenStr);
                user.setBktToken(bktToken);
                //百保联加密
                p.put("userid", user.getId().toString());//用户iD
                String usertoken = JwtUtil.createJWT(p);//加密生成token
                user.setToken(usertoken+"&party="+BLB_PARTY);
                if(user.getPlatform() == 2){
                    user.setCompanyUserId(user.getId());
                    user.setCompanyUsername(user.getUsername());
                }
                user.setSessionId(session.getId().toString());
                arsUtil.setCurrentUser(user,1000*120*loginTimeout);
                result.setData(user);
                result.setSuccessful(true);
                loginLogService.logIn(request);
            }else{
                result.setSuccessful(false);
                result.setMsg("用户名/密码错误");
            }
        } catch (UnknownAccountException e) {
            //logger.info(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("用户名/密码错误");
        } catch (IncorrectCredentialsException e) {
            //logger.info(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("用户名/密码错误");
        } catch (ExcessiveAttemptsException e) {
            //logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("登录失败多次，账户锁定10分钟");
        } catch (AuthenticationException e) {
            //logger.error(e.getMessage(), e);
            //throw e;
            result.setSuccessful(false);
            result.setMsg("用户名/密码错误");
        }
        return result;
    }

    /*********************************与SaaS对接end*******************************************/
}
