package com.bcxin.ars.rest;

import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.StarLevel;
import com.bcxin.ars.util.Constants;

@Controller
@RequestMapping("starlvl")
public class StarLevelController {
	
	/**
	 * 获取星级列表
	 * @param request
	 * @return
	 */
	@RequestMapping("findAll")
	public @ResponseBody AjaxResult findAll(HttpServletRequest request) {
		AjaxResult result = new AjaxResult();
		Object data = request.getServletContext().getAttribute(Constants.STAR_LEVEL_LIST);
		if(data != null) {
			result.setSuccessful(true);
			result.setData(data);
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
	/**
	 * 根据ID获取星级
	 * @param request
	 * @return
	 */
	@SuppressWarnings("unchecked")
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id, HttpServletRequest request) {
		AjaxResult result = new AjaxResult();
		Object data = request.getServletContext().getAttribute(Constants.STAR_LEVEL_MAP);
		if(data != null) {
			Map<Long, StarLevel> lvlMap = (Map<Long, StarLevel>)data;
			StarLevel lvl = lvlMap.get(id);
			if(lvl != null) {
				result.setSuccessful(true);
				result.setData(lvl);
			} else {
				result.setSuccessful(false);
				result.setMsg("未找到常量数据。ID:" + id);
			}
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
}
