package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.SecurityCompanyInsuranceSearchDto;
import com.bcxin.ars.model.SecurityCompanyInsurance;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.SecurityCompanyInsuranceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;


@Controller
@RequestMapping("securityCompanyInsurance")
public class SecurityCompanyInsuranceController {
	
	private static final Logger logger = LoggerFactory.getLogger(SecurityCompanyInsuranceController.class);
	
	@Autowired
	private SecurityCompanyInsuranceService securityCompanyInsuranceService;

	@Autowired
	private ArsRestUtil arsUtil;

	/**
	 * 查询全部
	 * @return
	 */
	@RequestMapping("getSecurityCompanyInsuranceList")
	public @ResponseBody
    AjaxResult search(SecurityCompanyInsuranceSearchDto securityCompanyInsuranceSearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			securityCompanyInsuranceSearchDto.setCompany_id(user.getId());
			SecurityCompanyInsuranceSearchDto data = securityCompanyInsuranceService.search(securityCompanyInsuranceSearchDto);
				result.setSuccessful(true);
				result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 创建或更新保安公司保险信息信息
	 * @param securityCompanyInsurance 保安公司保险信息信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody
    AjaxResult update(SecurityCompanyInsurance securityCompanyInsurance, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			securityCompanyInsuranceService.saveOrUpdate(securityCompanyInsurance);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}
	/**
	 * 删除保安公司保险信息信息
	 * @return
	 */
	@RequestMapping("delete/{id}")
	public @ResponseBody
    AjaxResult delete(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SecurityCompanyInsurance securityCompanyInsurance = securityCompanyInsuranceService.findById(id);

			if(securityCompanyInsurance != null) {
				securityCompanyInsuranceService.delete(securityCompanyInsurance);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
					result.setMsg("删除信息失败，ID:" + id);
				}

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据ID获取保安公司保险信息信息
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody
    AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SecurityCompanyInsurance securityCompanyInsurance = securityCompanyInsuranceService.findById(id);
			result.setSuccessful(true);
			result.setData(securityCompanyInsurance);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据USERID获取明细
	 * @return
	 */
	@RequestMapping("findByUserId/{userId}")
	public @ResponseBody AjaxResult findByUserId(@PathVariable("userId")Long userId) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<SecurityCompanyInsurance> securityCompanyInsurances = securityCompanyInsuranceService.findByUserId(userId);
			result.setSuccessful(true);
			result.setData(securityCompanyInsurances);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
