package com.bcxin.ars.rest;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.SecurityCompanyDao;
import com.bcxin.ars.dao.sb.PersoncertificateDao;
import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.page.CompanyDto;
import com.bcxin.ars.dto.page.CompanyPageSearchDto;
import com.bcxin.ars.dto.report.CompanyReportData;
import com.bcxin.ars.dto.report.ReportDataSearchDto;
import com.bcxin.ars.dto.report.SupervisionSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.sys.Sysdict;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.*;
import com.bcxin.ars.service.util.SysDictUtils;
import com.bcxin.ars.util.*;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.message.messageUtils;
import com.bcxin.ars.util.poi.ExcelUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.*;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import javax.crypto.BadPaddingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.net.URLEncoder;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.*;

@Controller
@RequestMapping("company")
public class SecurityCompanyController {

    private Logger logger = LoggerFactory.getLogger(SecurityCompanyController.class);

    @Autowired
    private SecurityCompanyService companyService;
    @Autowired
    private SecurityCompanyPersonService securityCompanyPersonService;

    @Autowired
    private SecurityPersonService personService;
    
    @Autowired
    private OrganizationService orgService;
    
    @Autowired
    private RoleService roleService;

    @Autowired
    private SecurityCompanyScheduleService scheduleService;

    @Autowired
    private ArsRestUtil arsUtil;

    @Autowired
    private SysDictUtils sysDictUtils;

    @Autowired
    private UserService userService;
    
    @Autowired
    private UserRoleService userRoleService;

    @Autowired
    private SecurityCompanyDao securityCompanyDao;

    @Autowired
    private PersoncertificateDao personcertificateDao;


    @Autowired
    private ConfigDao configDao;


    @Value("${upload-folder}")
    private String uploadFolder;

    @Value("${temp-folder}")
    private String tempFolder;

    @Autowired
    private OrderService orderService;

    @Value("${company-download-folder}")
    private String downloadFolder;

    @Value("${base-folder}")
    private String baseFolder;

    /**
     * 安保公司一键搜功能
     *
     * @param dto
     * @param request
     * @return
     */
    @RequestMapping("search")
//	@RequiresPermissions("search:read")
    public @ResponseBody
    AjaxResult search(CompanySearchDto dto, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            CompanySearchDto data = companyService.search(dto);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 安保公司管理 列表
     *
     * @param dto
     * @param request
     * @return
     */
    @RequestMapping("searchForManager")
//	@RequiresPermissions("search:read")
    public @ResponseBody
    AjaxResult searchForManager(CompanySearchDto dto, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            CompanySearchDto data = companyService.searchForManager(dto);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }
    @RequestMapping("/searchForManagerList_table")
    @ResponseBody
    public Object searchTraincompanyapplyList_table(@RequestParam Map<Object, Object> params, ModelMap model,
                                                    HttpServletRequest req, HttpServletResponse resp) {
        Map<Object, Object> p = CTLUtil.init(req, params);//查询初始化
        return companyService.searchForManagerList_table(p);
    }
    /***
     * 保存单位与订单号的信息
     * @param user_id 单位ID
     * @param orderNo 订单号
     * @return
     */
    @RequestMapping("cancelOrderInfo")
    public @ResponseBody
    AjaxResult cancelOrderInfo(Long user_id, String orderNo) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            //获取单位信息
            SecurityCompany company = companyService.findByUserid(user_id);
            company.setOrderNo("");
            companyService.saveOrUpdateForFX(company);
            List<SecurityPerson> list = personService.findByCompanyId(company.getId());
            int i = 0;
            if (list != null && list.size() > 0) {
                for (SecurityPerson person :
                        list) {
                    if (person.getInsured() != null && person.getInsured().equals("0")) {
                        person.setInsured(Constants.INSURED_NO);
                        personService.updateBX(person);
                        break;
                    }
                }
            }
        } catch (Exception e) {
            throw e;
        }
        return result;
    }


    /***
     * 保存单位与订单号的信息
     * @param user_id 单位ID
     * @param orderNo 订单号
     * @return
     */
    @RequestMapping("saveOrderInfo")
    public @ResponseBody
    AjaxResult saveOrderInfo(Long user_id, String orderNo, String cardList, String insuranceamount, String insuranceEscortAmount) throws Exception {
        //获取单位信息
        AjaxResult result = new AjaxResult();
        try {
            SecurityCompany company = companyService.findByUserid(user_id);
            JSONObject jsonObject = JSONObject.parseObject(cardList);
            List<String> ordercards = new ArrayList<String>();
            for (int i = 0; i < Integer.parseInt(jsonObject.getString("count")); i++) {
                String cardNo = jsonObject.getString(i + "");
                ordercards.add(cardNo);
            }
            if (company != null) {
//				String orderNotemp =  company .getOrderNo();
//				orderNotemp = orderNo;
                company.setOrderNo(orderNo);
                company.setInsuranceAmount(insuranceamount);
                company.setInsuranceEscortAmount(insuranceEscortAmount);
                companyService.saveOrUpdateForFX(company);

                Map<String, Object> map = new HashMap<String, Object>();
                map.put("order_id", orderNo);
                //获得保险信息
                String url = ThirdPartyURL.BAILIANBAO + "/api/order/policyDal";
                String resultStr = messageUtils.doPost2(url, messageUtils.packageMap(map, "ARS"));
                String product_name = messageUtils.getStringValueByKey(resultStr, "product_name");//产品名称
                String insurance_ame = messageUtils.getStringValueByKey(resultStr, "insurance_ame");//保险公司名称
                String inception_date = messageUtils.getStringValueByKey(resultStr, "inception_date");//生效日期
                String planned_end_date = messageUtils.getStringValueByKey(resultStr, "planned_end_date");//失效日期
                String gross_premium = messageUtils.getStringValueByKey(resultStr, "gross_premium");//保费
                String applicant_name = messageUtils.getStringValueByKey(resultStr, "applicant_name");//投保人名称
                String ins_count = messageUtils.getStringValueByKey(resultStr, "ins_count");//被保险人数量

                List<Long> personIdlists = new ArrayList<Long>();


                List<SecurityPerson> list = personService.findByCompanyId(company.getId());
                int i = 0;
                if (list != null && list.size() > 0) {
                    for (SecurityPerson person : list) {
                        /*Map<String, Object> map = new HashMap<String, Object>();
                        map.put("oid", orderNo);
						map.put("webType", Constants.POLICY_WEBTYPE);
						map.put("idCard", person.getIdNumber());
						map.put("token", Sha1Util.entryptPassword(Constants.POLICY_WEBTYPE + company.getUser().getId()));//生成密钥 当密钥相同的时候才进行插入数据
						//保存分销商
						String url = ThirdPartyURL.FENXIAO + ThirdPartyURL.CHECK_USER_POLICY;
						String resultStr = messageUtils.doPost2(url, messageUtils.packageMap(map, "ARS"));
						String status = messageUtils.getStringValueByKey(resultStr, "status");
						String flag = messageUtils.getStringValueByKey(resultStr, "flag");*/
                        for (String cardno : ordercards) {
                            if (person.getIdNumber() != null && person.getIdNumber().equals(cardno)) {
                                if (StringUtil.isNotEmpty(person.getPersonType()) && person.getPersonType().equals("3")) {
                                    //押运人员
                                    person.setInsuranceAmount(insuranceEscortAmount);
                                } else {
                                    person.setInsuranceAmount(insuranceamount);
                                }
                                person.setInsured(Constants.INSURED_YES);
                                person.setBxOrderno(orderNo);

                                person.setProduct_name(product_name);
                                person.setInsurance_ame(insurance_ame);
                                person.setInception_date(inception_date);
                                person.setPlanned_end_date(planned_end_date);
                                person.setGross_premium(gross_premium);
                                person.setApplicant_name(applicant_name);
                                person.setIns_count(ins_count);

                                personService.updateBX(person);
                                personIdlists.add(person.getId());
                                break;

                            }
                        }
                    }
                }
                //TODO
                Order order = new Order();
                //金额
                order.setAmount("0");
                //付款状态
                order.setPaystate("2");

                //订单类型
                order.setOrdertype("2");
                //订单号
                order.setOrdernumber(orderNo);
                //商品
                order.setGoodsname("任务管理+继续再教育课程");
                order.setUnitprice("120");
//				Map<String, Object> map = new HashMap<String, Object>();
//				map.put("order_id", orderNo);
//				//保存保险信息
//				String url = ThirdPartyURL.BAILIANBAO + "/api/order/policyDal";
//				String resultStr = messageUtils.doPost2(url, messageUtils.packageMap(map, "ARS"));
//				String inception_date = messageUtils.getStringValueByKey(resultStr, "inception_date");//生效日期
//				String planned_end_date = messageUtils.getStringValueByKey(resultStr, "planned_end_date");//失效日期
                if (planned_end_date != null && inception_date != null && !"".equals(inception_date) && !"".equals(planned_end_date)) {
                    //生效日期
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    Date date = sdf.parse(planned_end_date);
                    order.setEffectiveendtime(date);
                    //失效日期
                    sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    date = sdf.parse(inception_date);
                    order.setEffectivestarttime(date);
                }
                //订单状态
                order.setOrderstate("4");
                //订单类型
                order.setTraintype("2");
                //订单名称
                order.setCompanyname(company.getName());
                //订单培训机构
                order.setTrainorgid(100l);
                //人数
                order.setCountnumber(i);
                Long[] personIds = new Long[personIdlists.size()];
                for (int j = 0; j < personIdlists.size(); j++) {
                    personIds[j] = personIdlists.get(j);
                }
                //TODO 调用培训平台人员与视频关系
                orderService.createOrderForBxMF(order, personIds, company.getUser());


                //MessageUtil.sendMessage("13515961024","百联保订单号："+orderNo+"已生效请及时配置培训平台权限！");
                //MessageUtil.sendMessage("18259460057","百联保订单号："+orderNo+"已生效请及时配置培训平台权限！");
            }
            result.setSuccessful(true);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }


    /***
     * 保险保全
     * @param user_id 单位ID
     * @param orderNo 订单号
     * @param cardList 身份证信息
     * @return
     */
    @RequestMapping("insurancePreservation")
    public @ResponseBody
    AjaxResult insurancePreservation(Long user_id, String orderNo, String cardList) throws Exception {
        //获取单位信息
        AjaxResult result = new AjaxResult();
        try {
            SecurityCompany company = companyService.findByUserid(user_id);

            if (company != null) {
//				String orderNotemp =  company.getOrderNo();
//				orderNotemp = orderNo;
                company.setOrderNo(orderNo);
                companyService.saveOrUpdateForFX(company);
                List<Long> personIdlists = new ArrayList<Long>();
                List<SecurityPerson> list = personService.findByCompanyId(company.getId());

                JSONObject jsonObject = JSONObject.parseObject(cardList);
                List<String> ordercards = new ArrayList<String>();
                for (int i = 0; i < Integer.parseInt(jsonObject.getString("count")); i++) {
                    String cardNo = jsonObject.getString(i + "");
                    ordercards.add(cardNo);
                }

                Map<String, Object> map = new HashMap<String, Object>();
                map.put("order_id", orderNo);
                //获得保险信息
                String url = ThirdPartyURL.BAILIANBAO + "/api/order/policyDal";
                String resultStr = messageUtils.doPost2(url, messageUtils.packageMap(map, "ARS"));
                String product_name = messageUtils.getStringValueByKey(resultStr, "product_name");//产品名称
                String insurance_ame = messageUtils.getStringValueByKey(resultStr, "insurance_ame");//保险公司名称
                String inception_date = messageUtils.getStringValueByKey(resultStr, "inception_date");//生效日期
                String planned_end_date = messageUtils.getStringValueByKey(resultStr, "planned_end_date");//失效日期
                String gross_premium = messageUtils.getStringValueByKey(resultStr, "gross_premium");//保费
                String applicant_name = messageUtils.getStringValueByKey(resultStr, "applicant_name");//投保人名称
                String ins_count = messageUtils.getStringValueByKey(resultStr, "ins_count");//被保险人数量

                if (list != null && list.size() > 0) {
                    for (SecurityPerson person : list) {
                        for (String cardno : ordercards) {
                            String recordType = cardno.split("#")[1];//1增 2减
                            cardno = cardno.split("#")[0];
                            if (person.getIdNumber() != null && person.getIdNumber().equals(cardno)) {
                                if (recordType.equals("1")) {
                                    person.setInsured(Constants.INSURED_YES);

                                    person.setProduct_name(product_name);
                                    person.setInsurance_ame(insurance_ame);
                                    person.setInception_date(inception_date);
                                    person.setPlanned_end_date(planned_end_date);
                                    person.setGross_premium(gross_premium);
                                    person.setApplicant_name(applicant_name);
                                    person.setIns_count(ins_count);

                                    person.setBxOrderno(orderNo);
                                    personIdlists.add(person.getId());
                                } else {
                                    person.setBxOrderno("");
                                    person.setInsured(Constants.INSURED_NO);
                                }
                                personService.updateBX(person);
                                break;
                            }
                        }
                    }
                }
                //TODO
                Order order = new Order();
                //金额
                order.setAmount("0");
                //付款状态
                order.setPaystate("2");

                //订单类型
                order.setOrdertype("2");
                //订单号
                order.setOrdernumber(orderNo);
                //商品
                order.setGoodsname("任务管理+继续再教育课程");
                order.setUnitprice("120");
                if (planned_end_date != null && inception_date != null && !"".equals(inception_date) && !"".equals(planned_end_date)) {
                    //生效日期
                    DateUtil.convertStringToDate(planned_end_date);

                    order.setEffectiveendtime(DateUtil.convertStringToDate(planned_end_date));
                    //失效日期
                    order.setEffectivestarttime(DateUtil.convertStringToDate(inception_date));
                }
                //订单状态
                order.setOrderstate("4");
                //订单类型
                order.setTraintype("2");
                //订单名称
                order.setCompanyname(company.getName());
                //订单培训机构
                order.setTrainorgid(100l);
                //人数
                order.setCountnumber(personIdlists.size());
                Long[] personIds = new Long[personIdlists.size()];
                for (int j = 0; j < personIdlists.size(); j++) {
                    personIds[j] = personIdlists.get(j);
                }
                //TODO 调用培训平台人员与视频关系
                orderService.createOrderForBxMF(order, personIds, company.getUser());
            }
            result.setSuccessful(true);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }


    /***
     * 根据公司的ID获取公司信息和人员信息
     * @param user_id
     * @return
     */
    @RequestMapping("findCompnayAndPersonByUserid")
    public @ResponseBody
    AjaxResult findCompnayAndPersonByUserid(Long user_id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            List list = new ArrayList();
            result.setSuccessful(true);
            result.setData(list);
            //获取单位信息
            SecurityCompany company = companyService.findByUserid(user_id);
            if (company != null) {
                //单位信息
                RoleSubjectVo vo = new RoleSubjectVo();
                vo.setKind("1");
                vo.setName_cn(company.getName());//单位名称
                vo.setId_type("2");
                vo.setPhone(company.getTel());
//				vo.setRegProvince(company.getProvince());//省
//				vo.setRegCity(company.getCity());//市
//				vo.setRegDistrict(company.getArea());//区
                vo.setReg_address(company.getLocation());
                vo.setDo_business_address(company.getLocation());
                vo.setTotal_emp(company.getSecurityAmount() + "");
                vo.setOrganization_code(company.getSocialCode());

                list.add(vo);
                //获取人员信息
                List<SecurityPerson> listperson = personService.findByCompanyId(company.getId());
                Map<String, Object> data = new HashMap<String, Object>();
                for (SecurityPerson person : listperson) {
                    RoleSubjectVo temp = new RoleSubjectVo();
                    if (person.getRelation().getActive()) {
                        temp.setKind("2");
                        temp.setName_cn(person.getRealName());//单位名称
                        temp.setId_type("0");
                        temp.setMobile(person.getPhone());
                        temp.setSex(person.getGender().equals("男") ? "1" : "2");
                        temp.setOrganization_code(person.getIdNumber().trim().replaceAll(" ", "").toUpperCase());
                        temp.setBirth_date(IdNumUtil.getBirthdayByIdCard(person.getIdNumber()));
                        temp.setMajor_group("保安人员");
                        list.add(temp);
                    }
                }
                result.setSuccessful(true);
                result.setData(list);
            } else {
                result.setSuccessful(false);
                result.setMsg("未找到指定公司信息。");
            }
        } catch (Exception e) {
            throw e;
        }
        return result;
    }


    /***
     * 根据公司的ID以及在职状态获取人员信息
     * @param user_id
     * @return
     */
    @RequestMapping("findPersonByUseridAndStatus")
    public @ResponseBody
    AjaxResult findPersonByUseridAndStatus(Long user_id, String work_status) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            List<RoleSubjectVo> list = new ArrayList<RoleSubjectVo>();
            //获取单位信息
            SecurityCompany company = companyService.findByUserid(user_id);
            if (company != null) {
                //获取人员信息
                List<SecurityPerson> listperson = personService.findPersonByCompanyIdAndStatus(company.getId(), work_status);
                if (listperson != null && listperson.size() > 0) {
                    for (SecurityPerson person : listperson) {
                        RoleSubjectVo temp = new RoleSubjectVo();
                        temp.setKind("2");
                        temp.setName_cn(person.getRealName());//单位名称
                        temp.setId_type("0");
                        temp.setMobile(person.getPhone());
                        temp.setSex(person.getGender().equals("男") ? "1" : "2");
                        temp.setOrganization_code(person.getIdNumber().trim().replaceAll(" ", "").toUpperCase());
                        temp.setBirth_date(IdNumUtil.getBirthdayByIdCard(person.getIdNumber()));
                        temp.setMajor_group("保安人员");
                        list.add(temp);
                    }
                }
                result.setSuccessful(true);
                result.setData(list);
            } else {
                result.setSuccessful(false);
                result.setMsg("未找到指定公司信息。");
            }
        } catch (Exception e) {
            throw e;
        }
        return result;
    }


    /**
     * 获取指定安保公司明细
     *
     * @param request
     * @return
     */
    @RequestMapping("findById/{id}")
    public @ResponseBody
    AjaxResult findById(@PathVariable("id") Long id, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            SecurityCompany company = companyService.findById(id);
            if (company != null) {


                if (company.getOrderNo() != null && !company.getOrderNo().equals("")) {
                    String[] ordernos = company.getOrderNo().split(",");
                    for (int i = 0; i < ordernos.length; i++) {
                        //TODO
                        Map<String, Object> map = new HashMap<String, Object>();
                        map.put("order_id", ordernos[0]);
                        //获得保险信息
                        String url = ThirdPartyURL.BAILIANBAO + "/api/order/policyDal";
                        String resultStr = messageUtils.doPost2(url, messageUtils.packageMap(map, "ARS"));
                        String product_name = messageUtils.getStringValueByKey(resultStr, "product_name");//产品名称
                        String insurance_ame = messageUtils.getStringValueByKey(resultStr, "insurance_ame");//保险公司名称
                        String inception_date = messageUtils.getStringValueByKey(resultStr, "inception_date");//生效日期
                        String planned_end_date = messageUtils.getStringValueByKey(resultStr, "planned_end_date");//失效日期
                        String gross_premium = messageUtils.getStringValueByKey(resultStr, "gross_premium");//保费
                        String applicant_name = messageUtils.getStringValueByKey(resultStr, "applicant_name");//投保人名称
                        String ins_count = messageUtils.getStringValueByKey(resultStr, "ins_count");//被保险人数量

                        company.setProduct_name(product_name);
                        company.setInsurance_ame(insurance_ame);
                        company.setInception_date(inception_date);
                        company.setPlanned_end_date(planned_end_date);
                        company.setGross_premium(gross_premium);
                        company.setApplicant_name(applicant_name);
                        company.setIns_count(ins_count);
                    }

                }
                result.setSuccessful(true);
                result.setData(company);
            } else {
                result.setSuccessful(false);
                result.setMsg("未找到指定公司信息。");
            }
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 获取档期登录的安保公司明细
     *
     * @param request
     * @return
     */
    @RequestMapping("detail")
    public @ResponseBody
    AjaxResult detail(HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                SecurityCompany company = null;

                if (user.getPlatform() == 2) {
                    company = companyService.findByUserid(user.getId());
                }

                if (company != null) {
                    result.setSuccessful(true);
                    result.setData(company);
                } else {
                    result.setSuccessful(false);
                    result.setMsg("安保公司信息错误。");
                }
            } else {
                result.setSuccessful(false);
                result.setMsg("该用户不存在。");
            }
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 保安公司角色 创建或更新安保公司信息
     *
     * @param company        基本信息
     * @param securityScopes 安保范围
     * @return
     * @throws Exception
     */
    @RequestMapping("update")
    public @ResponseBody
    AjaxResult update(SecurityCompany company, Long[] securityScopes, HttpServletRequest request, OrderUnderVo order) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            if (securityScopes != null) {
                boolean flag = false;
                for (Long ssi : securityScopes) {
                    SecurityScope ss = new SecurityScope();
                    ss.setId(ssi);
                    company.getSecurityScope().add(ss);

                    //判断是否有 其他 选项 2018年8月23日15:26:04 wjb
                    if(ssi == 20){
                         flag = true;
                    }
                }
                //没有其他，则其他的名称清空
                if(!flag){
                    company.setOtherSecScopeType(null);
                }

            }


            User currentUser = arsUtil.getCurrentUser();

            SecurityCompany dbcompany = null;

            if (currentUser.getPlatform() == 2) {
                dbcompany = companyService.findByUserid(currentUser.getId());
            }

            if (dbcompany == null) {
                throw new ArsException("安保公司信息错误。");
            }

            User user = dbcompany.getUser();
            if (user != null) {
                if (company != null) {
                    user.setRealname(company.getName());
                    if (company.getUser() != null) {
                        user.setPhone(company.getUser().getPhone());
                        user.setPhoto(company.getUser().getPhoto());
                    }
                }
            }
            userService.saveOrUpdateCompanyUser(user,String.valueOf(Constants.PLATFORM_COMPANY));
            company.setUser(user);
            companyService.saveOrUpdate(company);
            result.setSuccessful(true);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }


    /**
     * 公安角色 创建或更新安保公司信息
     *
     * @param company        基本信息
     * @return
     * @throws Exception
     */
    @RequestMapping("updateCompany")
    public @ResponseBody
    AjaxResult updateCompany(SecurityCompany company) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            company.setUpdateflag(true);

            companyService.updateCompany(company);
            result.setSuccessful(true);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 获取安保范围
     *
     * @return
     */
    @SuppressWarnings("unchecked")
    @RequestMapping("getSecurityScope")
    @Deprecated
    public @ResponseBody
    AjaxResult getSecurityScope(HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            List<SecurityScope> scopeList = (List<SecurityScope>) request.getSession().getServletContext().getAttribute(Constants.SCOPE_LIST);
            result.setSuccessful(true);
            result.setData(scopeList);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }


    /**
     * @author wjb
     * @date 2018年8月17日09:20:52
     * @param type 编码类型
     * @return result
     * @desc 查询单位类型信息
     */
    @RequestMapping("getSecurityScope/{type}")
    public @ResponseBody
    AjaxResult getSecurityScope(@PathVariable(value ="type") String type) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            List<Sysdict> sysdictList = sysDictUtils.getDictType(type);
            if(null!=sysdictList){
                result.setSuccessful(true);
                result.setData(sysdictList);
            }else{
                result.setSuccessful(false);
            }

        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 导出人员录入模板
     *
     * @param request
     * @param response
     * @throws Exception
     */
    @RequestMapping("exportPersonTemplate")
    public void exportPersonTemplate(HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = arsUtil.getCurrentUser();
        if (user != null) {

            SecurityCompany company = null;
            if (user.getPlatform() == 2) {
                company = companyService.findByUserid(user.getId());
            }

            if (company != null) {
                Date now = new Date();
                String dirDate = DateUtil.systemDate.format(now);
                File dir = new File(tempFolder + dirDate);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                String templateName = tempFolder + dirDate + (now.getTime() + "personlist_import_template.xls");
                File file = new File(templateName);
                companyService.buildTemplate(company, file);
                if (file != null) {
                    ServletOutputStream out = response.getOutputStream();
                    String fileName = new String(file.getName().substring(file.getName().indexOf("_") + 1).getBytes("UTF-8"), "iso-8859-1");
                    response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                    InputStream is = new FileInputStream(file);
                    int read = 0;
                    byte[] buffer = new byte[8192];
                    while ((read = is.read(buffer)) != -1) {
                        out.write(buffer, 0, read);
                    }
                    is.close();
                    out.flush();
                    out.close();
                }
            }
        }
    }
    /**
     * 批量导入保安员
     */
    @RequestMapping("importPersonDataOld")
    public @ResponseBody
    AjaxResult importPersonDataOld(MultipartFile file) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Date now = new Date();
            String fileName = now.getTime() + "_" + file.getOriginalFilename();
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(uploadFolder + dirDate);
            if(!dir.exists()) {
                dir.mkdirs();
            }
            String targetPath = uploadFolder + dirDate + "/" + fileName;
            File targetFile = new File(targetPath);
            logger.info("执行人员文件上传..." + targetFile);
            file.transferTo(targetFile);
            Map<String, Object> resultMap = new HashMap<String, Object>();
            User loginUser = arsUtil.getCurrentUser();
            if (loginUser != null) {
                SecurityCompany company = null;
                if (loginUser.getPlatform() == 2) {
                    company = companyService.findByUserid(loginUser.getId());
                }

                if (company != null) {
                    List<Long> saveList = new ArrayList<Long>();
                    List<Map<String, String>> faildList = new ArrayList<Map<String, String>>();
                    FileInputStream inStream = new FileInputStream(targetFile);
                    Workbook workBook = WorkbookFactory.create(inStream);
                    Sheet sheet = workBook.getSheetAt(1);
                    boolean flag = true;
                    int i = 1;
                    while (flag) {
                        Row row = sheet.getRow(i);
                        if (row != null) {
                            Map<String, String> data = new HashMap<String, String>();
                            try {
                                String org = ExcelUtil.getCellValue(row.getCell(0));
                                data.put("org", org);
                                org = org.substring(org.lastIndexOf("-") + 1);
                                Organization orgObj = new Organization();
                                orgObj.setId(Long.valueOf(org));

                                String name = ExcelUtil.getCellValue(row.getCell(1));
                                name = name.trim().replaceAll(" ", "");
                                data.put("name", name);

                                Cell cellPhone = row.getCell(2);
                                cellPhone.setCellType(HSSFCell.CELL_TYPE_STRING);
                                String phone = ExcelUtil.getCellValue(cellPhone);
                                phone = phone.trim().replaceAll(" ", "");
                                data.put("phone", phone);

                                Cell cellIdNum = row.getCell(3);
                                cellIdNum.setCellType(HSSFCell.CELL_TYPE_STRING);
                                String idNum = ExcelUtil.getCellValue(cellIdNum);
                                idNum = idNum.trim().toUpperCase().replaceAll(" ", "");
                                data.put("idNum", idNum);

                                String role = ExcelUtil.getCellValue(row.getCell(4));
                                data.put("role", role);
                                role = role.substring(role.lastIndexOf("-") + 1);
                                Role roleObj = new Role();
                                roleObj.setId(Long.valueOf(role));

                                String personType = ExcelUtil.getCellValue(row.getCell(5));
                                data.put("personType", personType);
                                personType = personType.substring(personType.lastIndexOf("-") + 1);

                                String edu = ExcelUtil.getCellValue(row.getCell(6));
                                data.put("edu", edu);
                                edu = edu.substring(edu.lastIndexOf("-") + 1);

                                String nationality = ExcelUtil.getCellValue(row.getCell(7));
                                data.put("nationality", nationality);
                                nationality = nationality.substring(nationality.lastIndexOf("-") + 1);

                                String stature = ExcelUtil.getCellValue(row.getCell(8));
                                data.put("stature", stature);

                                String age = ExcelUtil.getCellValue(row.getCell(9));
                                data.put("age", age);

                                String profession_level = ExcelUtil.getCellValue(row.getCell(10));
                                data.put("profession_level", profession_level);
                                profession_level = profession_level.substring(profession_level.lastIndexOf("-") + 1);

                                String credential = ExcelUtil.getCellValue(row.getCell(11));
                                data.put("credential", credential);

                                String politics = ExcelUtil.getCellValue(row.getCell(12));
                                data.put("politics", politics);
                                politics = politics.substring(politics.lastIndexOf("-") + 1);

                                String marriage = ExcelUtil.getCellValue(row.getCell(13));
                                data.put("marriage", marriage);
                                marriage = marriage.substring(marriage.lastIndexOf("-") + 1);

                                String blood = ExcelUtil.getCellValue(row.getCell(14));
                                data.put("blood", blood);
                                blood = blood.substring(blood.lastIndexOf("-") + 1);

                                String gender = ExcelUtil.getCellValue(row.getCell(15));
                                data.put("gender", gender);

                                String idCardAddress = ExcelUtil.getCellValue(row.getCell(16));
                                data.put("idCardAddress", idCardAddress);

                                String currentAddress = ExcelUtil.getCellValue(row.getCell(17));
                                data.put("currentAddress", currentAddress);


                                if (StringUtil.isEmpty(org)) {
                                    throw new ArsException("部门不能为空！");
                                }else {
                                	//TODO
                                	Organization dbOrg = orgService.findById(orgObj.getId());
                                	if(dbOrg == null || dbOrg.getCompany().getId().longValue() != company.getId().longValue()) {
                                		throw new ArsException("部门错误！");
                                	}
                                }

                                if (StringUtil.isEmpty(name)) {
                                    throw new ArsException("姓名不能为空！");
                                }

                                if (StringUtil.isEmpty(phone)) {
                                    throw new ArsException("手机号不能为空！");
                                }

                                if (StringUtil.isEmpty(idNum)) {
                                    throw new ArsException("身份证号码不能为空！");
                                }else {
                                	IdcardValidator idcardValidator = new IdcardValidator();
                                	if(!idcardValidator.isValidatedAllIdcard(idNum)) {
                                		throw new ArsException("身份证号码格式错误！");
                                	}
                                }

                                if (StringUtil.isEmpty(role)) {
                                    throw new ArsException("角色不能为空！");
                                }else {
                                	//TODO
                                	Role dbRole = roleService.findById(roleObj.getId());
                                	if(dbRole == null || dbRole.getCompany().getId().longValue() != company.getId().longValue()) {
                                		throw new ArsException("角色错误！");
                                	}
                                }
                                if (StringUtil.isEmpty(personType)) {
                                    throw new ArsException("人员类别不能为空！");
                                }else if(!personType.equals("1") && !personType.equals("2") && !personType.equals("3")) {
                                    throw new ArsException("人员类别错误！");
                                }

                                if(StringUtil.isEmpty(edu)){
                                    throw new ArsException("学历不能为空！");
                                }
                                if(StringUtil.isEmpty(nationality)){
                                    throw new ArsException("国籍不能为空！");
                                }

                                SecurityPerson dbPerson = personService.findActiveByIdCard(idNum);
                                if (dbPerson == null) {
                                    dbPerson = personService.findActiveByPhone(phone);
                                }
                                if (dbPerson != null) {
                                    if (dbPerson.getRelation() != null && dbPerson.getIncumbencyStatus().equals(Constants.INCUMBENCYSTATUS_Y)) {
                                        if (dbPerson.getRelation().getCompany().getId().longValue() == company.getId().longValue()) {
                                            throw new ArsException("该人员已存在人员档案，请匆重复导入！");
                                        } else {
                                            throw new ArsException("当前人员目前在职，不允许添加！请联系该人员退出在职公司之后再添加！");
                                        }
                                    } else {
                                        SecurityCompanyPerson securityCompanyPerson = securityCompanyPersonService.findByPersonAndCompany(dbPerson.getId(), company.getId());
                                        if (securityCompanyPerson != null) {
                                            throw new ArsException("该人员已存在人员档案，请匆重复导入！");
                                        }
                                    }
                                }

                                SecurityPerson person = new SecurityPerson();

                                if (!StringUtil.isEmpty(age)) {
                                    person.setAge(Integer.valueOf(age));
                                } else {
                                    person.setAge(IdNumUtil.getAgeByIdCard(idNum));
                                }

                                if (!StringUtil.isEmpty(gender)) {
                                    person.setGender(gender);
                                } else {
                                    person.setGender(IdNumUtil.getGenderByIdCard(idNum));
                                }

                                if (!StringUtil.isEmpty(stature)) {
                                    person.setStature(Integer.valueOf(stature));
                                }
                                if (StringUtil.isNotEmpty(profession_level)) {
                                    if(!profession_level.equals("6")){
                                        person.setProfessionLevel(profession_level);
                                    }
                                }
                                if (StringUtil.isNotEmpty(credential)) {
                                    if(StringUtil.isNotEmpty(profession_level)&& !profession_level.equals("6")){
                                        person.setCredential(credential);
                                    }else{
                                        person.setZgcredential(credential);
                                    }
                                }
                                person.setPolitics(politics);
                                person.setMarriage(marriage);

                                person.setBlood(blood);
                                person.setNationality(nationality);
                                person.setCurrentAddress(currentAddress);
                                person.setIdCardAddress(idCardAddress);
                                person.setPersonType(personType);
                                if (StringUtil.isNotEmpty(edu)) {
                                    person.setEdu(Integer.parseInt(edu));
                                }
                                person.setNatives(Integer.parseInt(IdNumUtil.getNativeCodeByIdNum(idNum, 6)));
                                person.setIdNumber(idNum);
                                SecurityCompanyPerson relation = new SecurityCompanyPerson();
                                relation.setCompany(company);
                                relation.setPerson(person);
                                relation.setOrg(orgObj);
                                //	relation.setRole(roleObj);
                                relation.setActive(true);
                                person.setRelation(relation);
                                
                                logger.info("update... " + person);
                                personService.saveOrUpdate(person);
                                saveList.add(person.getId());
                            } catch (Exception e) {
                                if (e instanceof ArsException) {
                                    data.put("failMsg", e.getMessage());
                                } else {
                                    data.put("failMsg", "格式有错");
                                }
                                faildList.add(data);
                                logger.error("批量录入错误：" + data.get("idNum"), e);
                            }
                        } else {
                            flag = false;
                        }
                        i++;
                    }
                    if (faildList.size() > 0) {
                        resultMap.put("faildFilePath", buildFaildList(company, faildList));
                    }
                    // if (StringUtil.isNotEmpty(company.getOrderNo())) {
                    resultMap.put("successIds", saveList);
                    //}
                } else {
                    throw new RuntimeException("当前登录信息错误, company:" + company);
                }
            } else {
                throw new RuntimeException("当前登录信息错误, user:" + loginUser);
            }
            result.setData(resultMap);
            if(resultMap.get("faildFilePath") == null || StringUtil.isEmpty(resultMap.get("faildFilePath").toString())) {
                result.setMsg("批量导入成功");
            } else {
                result.setMsg("导入失败，请下载失败列表，修改后再上传.");//#1013
            }
            //保存成功之后发送记录
            if(resultMap.get("saveSuccessPhoneList")!=null) {
                List<String> phonsList = (ArrayList)resultMap.get("saveSuccessPhoneList");
                companyService.batchSendMessage(phonsList);
            }

            result.setSuccessful(true);
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 批量导入保安员（重写）
     * by llc 2018-08-19
     */
    @RequestMapping("importPersonData")
    public @ResponseBody
    AjaxResult importPersonData(MultipartFile file) throws Exception {
        AjaxResult result = new AjaxResult();
        String fileType = file.getOriginalFilename().substring(file.getOriginalFilename().lastIndexOf(".")+1);
        if(!fileType.toUpperCase().equalsIgnoreCase("XLS") && !fileType.toUpperCase().equalsIgnoreCase("XLSX")){
            result.setMsg("导入的模板文件有误");
            result.setSuccessful(false);
            return result;
        }
        try {
            Date now = new Date();
            String fileName = now.getTime() + "_" + file.getOriginalFilename();
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(uploadFolder + dirDate);
            long startTime = System.currentTimeMillis();
            if(!dir.exists()) {
                dir.mkdirs();
            }
            String targetPath = uploadFolder + dirDate + "/" + fileName;
            File targetFile = new File(targetPath);
            logger.info("执行人员文件上传..." + targetFile);
            file.transferTo(targetFile);
            Map<String, Object> resultMap = new HashMap<String, Object>();
            User loginUser = arsUtil.getCurrentUser();
            if (loginUser != null) {
                SecurityCompany company = null;
                if (loginUser.getPlatform() == 2) {
                    company = companyService.findByUserid(loginUser.getId());
                }

                if (company != null) {
                    List<Long> saveList = new ArrayList<Long>();
                    IdcardValidator idcardValidator = new IdcardValidator();

                    List<Map<String, String>> list = new ArrayList<Map<String, String>>();  // 数据库校验的list
                    List<Map<String, String>> faildList = new ArrayList<Map<String, String>>();  // 定义失败的list

                    FileInputStream inStream = new FileInputStream(targetFile);
                    Workbook workBook = WorkbookFactory.create(inStream);
                    Sheet sheet = workBook.getSheetAt(1);
                    boolean flag = true;
                    int i = 1;
                    while (flag) {
                        Row row = sheet.getRow(i);
                        if (row != null) {
                            Map<String, String> data = new HashMap<String, String>();
                            /*** 客户的数据格式及其复杂
                             *
                             * 1.英文的空格  2.中文的空格  3.非美式英文的半角空格  4.一个tab键  5 .2个tab键
                             * 不过tab键在java可以按英文空格处理，如果在数据库判断长度就非常长了
                             * 现有校验按 1-2-3
                             */
                            String errorMsg = "" ;  // 校验错误信息
                            try {
                                /*** 部门名称 ***/
                                String orgInfo = ExcelUtil.getCellValue(row.getCell(0));
                                orgInfo = orgInfo.trim().replaceAll(" ", "").replaceAll(" ","").replaceAll(" ","");
                                data.put("orgInfo", orgInfo);

                                /*** 姓名 ***/
                                String name = ExcelUtil.getCellValue(row.getCell(1));
                                name = name.trim().replaceAll(" ", "").replaceAll(" ","").replaceAll(" ","");
                                data.put("name", name);

                                /*** 手机号码 ***/
                                Cell cellPhone = row.getCell(2);
                                cellPhone.setCellType(HSSFCell.CELL_TYPE_STRING);
                                String phone = ExcelUtil.getCellValue(cellPhone);
                                phone = phone.trim().replaceAll(" ", "").replaceAll(" ","").replaceAll(" ","");
                                data.put("phone", phone);

                                /*** 身份证 ***/
                                Cell cellIdNum = row.getCell(3);
                                cellIdNum.setCellType(HSSFCell.CELL_TYPE_STRING);
                                String idNum = ExcelUtil.getCellValue(cellIdNum);
                                idNum = idNum.trim().toUpperCase().replaceAll(" ", "").replaceAll(" ","").replaceAll(" ","");
                                data.put("idNum", idNum);

                                /*** 角色名称 ***/
                                String roleInfo = ExcelUtil.getCellValue(row.getCell(4));
                                roleInfo = roleInfo.trim().replaceAll(" ", "").replaceAll(" ","").replaceAll(" ","");
                                data.put("roleInfo", roleInfo);

                                /*** 人员类别 ***/
                                String personTypeInfo = ExcelUtil.getCellValue(row.getCell(5));
                                personTypeInfo = personTypeInfo.trim().replaceAll(" ", "").replaceAll(" ","").replaceAll(" ","");
                                data.put("personTypeInfo", personTypeInfo);

                                /*** 学历 ***/
                                String eduInfo = ExcelUtil.getCellValue(row.getCell(6));
                                eduInfo = eduInfo.trim().replaceAll(" ", "").replaceAll(" ","").replaceAll(" ","");
                                data.put("eduInfo", eduInfo);


                                /*** 国籍 ***/
                                String nationalityInfo = ExcelUtil.getCellValue(row.getCell(7));
                                nationalityInfo = nationalityInfo.trim().replaceAll(" ", "").replaceAll(" ","").replaceAll(" ","");
                                data.put("nationalityInfo", nationalityInfo);

                                /*** 身高 ***/
                                String stature = ExcelUtil.getCellValue(row.getCell(8));
                                stature = stature.trim().replaceAll(" ", "").replaceAll(" ","").replaceAll(" ","");
                                data.put("stature", stature);

//                                /*** 年龄 ***/
//                                String age = ExcelUtil.getCellValue(row.getCell(9));
//                                age = age.trim().replaceAll(" ", "");
//                                data.put("age", age);

                                /*** 职业证书 ***/
                                String professionLevelInfo = ExcelUtil.getCellValue(row.getCell(9));
                                professionLevelInfo = professionLevelInfo.trim().replaceAll(" ", "").replaceAll(" ","").replaceAll(" ","");
                                data.put("professionLevelInfo", professionLevelInfo);


                                /*** 证书号 ***/
                                String credential = ExcelUtil.getCellValue(row.getCell(10));
                                credential = credential.trim().replaceAll(" ", "").replaceAll(" ","").replaceAll(" ","");
                                data.put("credential", credential);

                                /*** 政治面貌 ***/
                                String politicsInfo = ExcelUtil.getCellValue(row.getCell(11));
                                politicsInfo = politicsInfo.trim().replaceAll(" ", "").replaceAll(" ","").replaceAll(" ","");
                                data.put("politicsInfo", politicsInfo);

                                /*** 婚姻状态 ***/
                                String marriageInfo = ExcelUtil.getCellValue(row.getCell(12));
                                marriageInfo = marriageInfo.trim().replaceAll(" ", "").replaceAll(" ","").replaceAll(" ","");
                                data.put("marriageInfo", marriageInfo);

                                /*** 血型 ***/
                                String bloodInfo = ExcelUtil.getCellValue(row.getCell(13));
                                bloodInfo = bloodInfo.trim().replaceAll(" ", "").replaceAll(" ","").replaceAll(" ","");
                                data.put("bloodInfo", bloodInfo);

                                /*** 保安员资格证号 ***/
                                String bayCredential = ExcelUtil.getCellValue(row.getCell(14));
                                bayCredential = bayCredential.trim().replaceAll(" ", "").replaceAll(" ","").replaceAll(" ","");
                                data.put("bayCredential", bayCredential);

                                /*** 性别 ***/
//                                String sexInfo = ExcelUtil.getCellValue(row.getCell(16));
//                                sexInfo = sexInfo.trim().replaceAll(" ", "");
//                                data.put("sexInfo", sexInfo);

                                /*** 家庭住址 ***/
                                String idCardAddress = ExcelUtil.getCellValue(row.getCell(15));
                                idCardAddress = idCardAddress.trim().replaceAll(" ", "").replaceAll(" ","").replaceAll(" ","");
                                data.put("idCardAddress", idCardAddress);

                                /*** 现住地址 ***/
                                String currentAddress = ExcelUtil.getCellValue(row.getCell(16));
                                currentAddress = currentAddress.trim().replaceAll(" ", "").replaceAll(" ","").replaceAll(" ","");
                                data.put("currentAddress", currentAddress);


                                /*************  校验excel表格字段 ***************/


                                /*** 部门名称 ***/
                                if (StringUtil.isEmpty(orgInfo)) {
                                    errorMsg = errorMsg + "部门不能为空";
                                }
                                /*** 姓名 ***/
                                if (StringUtil.isEmpty(name)) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "姓名不能为空" :" || " + "姓名不能为空");
                                }else{
                                    if(name.length() > 20 ){
                                        errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "姓名长度不能超过20位" :" || " + "姓名长度不能超过20位");
                                    }
                                }
                                /*** 手机号码 ***/
                                if (StringUtil.isEmpty(phone)) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "手机号不能为空" :" || " + "手机号不能为空");
                                }else{
                                   /*** 校验手机号有效性 ***/
                                   if(!StringUtil.isMobileNO(phone)){
                                       errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "手机号无效" :" || " + "手机号无效");
                                   }
                                }

                                /*** 身份证 ***/
                                if (StringUtil.isEmpty(idNum)) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "身份证号码不能为空" :" || " + "身份证号码不能为空");
                                }else {
                                    if(!idcardValidator.isValidatedAllIdcard(idNum)) {
                                        errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "身份证号码无效" :" || " + "身份证号码无效");
                                    }
                                }

                                /*** 角色 ***/
                                if (StringUtil.isEmpty(roleInfo)) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "角色不能为空" :" || " + "角色不能为空");
                                }

                                /*** 人员类别 ***/
                                personTypeInfo = personTypeInfo.substring(personTypeInfo.lastIndexOf("-") + 1);
                                if (StringUtil.isEmpty(personTypeInfo)) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "人员类别不能为空" :" || " + "人员类别不能为空");
                                }else if(!personTypeInfo.equals("1") && !personTypeInfo.equals("2") && !personTypeInfo.equals("3")) {
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "人员类别错误" :" || " + "人员类别错误");
                                }

                                /*** 学历 ***/
                                if(StringUtil.isEmpty(eduInfo)){
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "学历不能为空" :" || " + "学历不能为空");
                                }else{
                                    eduInfo = eduInfo.substring(eduInfo.lastIndexOf("-") + 1);
                                      if(!eduInfo.equals(Constants.EDU_CZ) && !eduInfo.equals(Constants.EDU_ZZ) && !eduInfo.equals(Constants.EDU_JX) && !eduInfo.equals(Constants.EDU_GZ)
                                          && !eduInfo.equals(Constants.EDU_ZK) && !eduInfo.equals(Constants.EDU_BK) && !eduInfo.equals(Constants.EDU_SS) && !eduInfo.equals(Constants.EDU_BS)){
                                          errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "学历无效" :" || " + "学历无效");
                                      }
                                }

                                /*** 国籍 ***/
                                if(StringUtil.isEmpty(nationalityInfo)){
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "国籍不能为空" :" || " + "国籍不能为空");
                                }else{
                                    if(nationalityInfo.indexOf("-") == -1){
                                        errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "国籍无效" :" || " + "国籍无效");
                                    }
                                }

                                /*** 身高 ***/
                                if(StringUtil.isNotEmpty(stature)){
                                  if(!StringUtil.isFloat(stature)){
                                      errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "身高无效" :" || " + "身高无效");
                                  }else{
                                      Float statureFloat = new Float(stature);
                                      if(statureFloat <= 100F || statureFloat >= 220F){
                                      errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "身高无效" :" || " + "身高无效");
                                      }
                                  }
                                }

                                /*** 年龄  ***/
//                                if(StringUtil.isNotEmpty(age)){
//                                    if(!StringUtil.isInteger(age)){
//                                        errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "年龄无效" :" || " + "年龄无效");
//                                    }else{
//                                        Integer ageInt = new Integer(age);
//                                        if(ageInt <= 18 || ageInt >= 65){
//                                            errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "年龄无效" :" || " + "年龄无效");
//                                        }
//                                    }
//                                }

                                /*** 职业证书类型 证书号 ***/
                                if(StringUtil.isNotEmpty(professionLevelInfo)){
                                    professionLevelInfo = professionLevelInfo.substring(professionLevelInfo.lastIndexOf("-") + 1);
                                    if(!professionLevelInfo.equals(Constants.PROFESSIONLEVEL_CJBAY) && !professionLevelInfo.equals(Constants.PROFESSIONLEVEL_ZJBAY) && !professionLevelInfo.equals(Constants.PROFESSIONLEVEL_GJBAY)
                                        && !professionLevelInfo.equals(Constants.PROFESSIONLEVEL_BAS) && !professionLevelInfo.equals(Constants.PROFESSIONLEVEL_GJBAS)){

                                        errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "职业证书类型无效" :" || " + "职业证书类型无效");
                                    }
                                   if(StringUtil.isEmpty(credential)){
                                        errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "填写了职业证书必须录入职业证书号" :" || " + "填写了职业证书必须录入职业证书号");
                                   }
                                }else{
                                    if(StringUtil.isNotEmpty(credential)){
                                        errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "填写了职业证书号必须选择职业证书类型" :" || " + "填写了职业证书号必须选择职业证书类型");
                                    }
                                }

                                if(StringUtil.isNotEmpty(credential) && credential.length() > 20){
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "职业证书号长度不能超过20位" :" || " + "职业证书号长度不能超过20位");
                                }

                                /*** 政治面貌 ***/
                                if(StringUtil.isNotEmpty(politicsInfo)){
                                    politicsInfo = politicsInfo.substring(politicsInfo.lastIndexOf("-") + 1);
                                    if(!politicsInfo.equals(Constants.POLITICS_DY) && !politicsInfo.equals(Constants.POLITICS_TY) && !politicsInfo.equals(Constants.POLITICS_QZ)){
                                        errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "政治面貌无效" :" || " + "政治面貌无效");
                                    }
                                }

                                /*** 婚姻状态 ***/
                                if(StringUtil.isNotEmpty(marriageInfo)){
                                    marriageInfo = marriageInfo.substring(marriageInfo.lastIndexOf("-") + 1);
                                    if(!marriageInfo.equals(Constants.MARRIAGE_WH) && !marriageInfo.equals(Constants.MARRIAGE_YH) && !marriageInfo.equals(Constants.MARRIAGE_LY)){
                                        errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "婚姻状态无效" :" || " + "婚姻状态无效");
                                    }
                                }

                                /*** 血型 ***/
                                if(StringUtil.isNotEmpty(bloodInfo)){
                                    bloodInfo = bloodInfo.substring(bloodInfo.lastIndexOf("-") + 1);
                                    if(!bloodInfo.equals(Constants.BLOOD_A) && !bloodInfo.equals(Constants.BLOOD_B) && !bloodInfo.equals(Constants.BLOOD_O)
                                         && !bloodInfo.equals(Constants.BLOOD_AB) && !bloodInfo.equals(Constants.BLOOD_RHYIN) && !bloodInfo.equals(Constants.BLOOD_RHYAN)){
                                        errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "血型无效" :" || " + "血型无效");

                                    }
                                }

                                /*** 保安员资格证号 ***/
                                if(StringUtil.isNotEmpty(bayCredential) && bayCredential.length() > 20){
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "保安员资格证号长度不能超过20位" :" || " + "保安员资格证号长度不能超过20位");
                                }


                                /*** 家庭住址 ***/
                                if(StringUtil.isNotEmpty(idCardAddress) && idCardAddress.length() > 100){
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "家庭住址长度不能超过100位" :" || " + "家庭住址长度不能超过100位");
                                }

                                /*** 现住地址 ***/
                                if(StringUtil.isNotEmpty(currentAddress) && currentAddress.length() > 100){
                                    errorMsg = errorMsg + (StringUtil.isEmpty(errorMsg)? "现住地址长度不能超过100位" :" || " + "现住地址长度不能超过100位");
                                }


                                // 生成错误的list
                                if(StringUtil.isNotEmpty(errorMsg)){
                                    data.put("errorMsg",errorMsg) ;
                                    faildList.add(data);
                                }else{
                                    list.add(data);
                                }

                            } catch (Exception e) {
                                if (e instanceof ArsException) {
                                    data.put("failMsg", e.getMessage());
                                } else {
                                    data.put("failMsg", "格式有错");
                                }
                                faildList.add(data);
                                logger.error("批量录入错误：" + data.get("idNum"), e);
                            }
                        } else {
                            flag = false;
                        }
                        i++;
                    }

                    /** 如果客户没上传内容 **/
                    if(list.size() == 0 && faildList.size() == 0 ){
                        result.setMsg("导入人员模板没有信息，请录入");
                        result.setSuccessful(false);
                        return result;
                    }

                    /****  处理人员导入业务逻辑 ***/

                    int batchId = personcertificateDao.getNextVal("seq_batchId") ;

                    List<Map<String, String>> checkFaildList = new ArrayList<>();
                    if(list != null &&  list.size() >0 ){
                        checkFaildList = companyService.batchImportPerson(list,batchId,loginUser,company);
                    }
                    long endTime = System.currentTimeMillis();
                    logger.info("耗费时间： " + (endTime - startTime) + " ms");

                    /****  如果校验的人员信息有误 ****/
                    if(checkFaildList != null && checkFaildList.size() > 0){
                        faildList.addAll(checkFaildList);
                    }

                    if (faildList.size() > 0) {
                        resultMap.put("faildFilePath", buildFaildList(company, faildList));
                    }

                    List<Map<String,Object>> successList = securityCompanyDao.getSuccessList(batchId);
                    List<String> successPhoneList = new ArrayList<>();
                    if(successList != null && successList.size()>0){
                       for(Map<String,Object> map : successList) {
                           /**** 离职人员因为系统中已存在账号，不发送短信 ***/
                         if(map.get("isSuccess") != null && map.get("isSuccess").toString().equals("1")){
                             successPhoneList.add(map.get("phone").toString());
                         }
                           saveList.add(Long.valueOf(map.get("personId").toString()));
                       }
                    }

                    /**** 查询出导入成功的人员 ***/
                    resultMap.put("successIds", saveList);
                    result.setData(resultMap);

                    if(resultMap.get("faildFilePath") == null || StringUtil.isEmpty(resultMap.get("faildFilePath").toString())) {
                        result.setMsg("批量导入成功");
                    } else {
                        result.setMsg(faildList.size() + "人导入失败，请下载导入失败的人员信息");
                    }
                    //保存成功之后发送记录
                    if(successPhoneList != null) {
                        companyService.batchSendMessage(successPhoneList);
                    }
                    result.setSuccessful(true);
                } else {
                    throw new RuntimeException("当前登录信息错误, company:" + company);
                }
            } else {
                throw new RuntimeException("当前登录信息错误, user:" + loginUser);
            }
       ;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw new ArsException("上传格式错误，请按要求整理后重新上传！");
        }
        return result;
    }

    private String buildFaildList(SecurityCompany company, List<Map<String, String>> data) throws Exception {
        Date now = new Date();
        String dirDate = DateUtil.systemDate.format(now);
        File dir = new File(tempFolder + dirDate);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        String fileName = now.getTime() + "_人员导入失败记录.xls";
        String templateName = tempFolder + dirDate + "/" + fileName;
        String fileKey = "temp/" + dirDate + "/" + fileName;
        File file = new File(templateName);
        companyService.buildTemplate(company, file);
        if (file != null && file.length() > 0) {
            HSSFWorkbook workbook = new HSSFWorkbook(new FileInputStream(file));
            HSSFSheet sheet = workbook.getSheetAt(1);
            int index = 1;
            for (Map<String, String> map : data) {
                Row row = sheet.createRow(index);
                row.createCell(0).setCellValue(map.get("orgInfo"));
                row.createCell(1).setCellValue(map.get("name"));
                row.createCell(2).setCellValue(map.get("phone"));
                row.createCell(3).setCellValue(map.get("idNum"));
                row.createCell(4).setCellValue(map.get("roleInfo"));
                row.createCell(5).setCellValue(map.get("personTypeInfo"));
                row.createCell(6).setCellValue(map.get("eduInfo"));
                row.createCell(7).setCellValue(map.get("nationalityInfo"));
                row.createCell(8).setCellValue(map.get("stature"));
//                row.createCell(9).setCellValue(map.get("age"));
                row.createCell(9).setCellValue(map.get("professionLevelInfo"));
                row.createCell(10).setCellValue(map.get("credential"));
                row.createCell(11).setCellValue(map.get("politicsInfo"));
                row.createCell(12).setCellValue(map.get("marriageInfo"));
                row.createCell(13).setCellValue(map.get("bloodInfo"));
                row.createCell(14).setCellValue(map.get("bayCredential"));
//                row.createCell(16).setCellValue(map.get("sexInfo"));
                row.createCell(15).setCellValue(map.get("idCardAddress"));
                row.createCell(16).setCellValue(map.get("currentAddress"));

                Cell cell = row.createCell(17); //获取第一行的每个单元格
                CellStyle errorStyle = ExcelUtil.getNecessaryTitleStyle(workbook);
                cell.setCellValue(map.get("errorMsg"));
                cell.setCellStyle(errorStyle);

                index++;
            }
            FileOutputStream fileOut = new FileOutputStream(file);
            workbook.write(fileOut);
            fileOut.close();
            workbook.close();
            return "/getResource.do?path=" + fileKey;
        }
        return null;
    }

    /**
     * 获取全部公司的区域分布画像
     *
     * @return
     */
    @RequestMapping("findAllAreaReport")
    public @ResponseBody
    AjaxResult findAllAreaReport() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            List<ReportData> data = companyService.findAllAreaReport();
            result.setData(data);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 获取全部公司的规模画像
     *
     * @return
     */
    @RequestMapping("findAllScaleReport")
    public @ResponseBody
    AjaxResult findAllScaleReport() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Map<String, String[]> data = companyService.findAllScaleReport();
            result.setData(data);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 获取全部公司的任务级别画像
     *
     * @return
     */
    @RequestMapping("findAllTaskLevelReport")
    public @ResponseBody
    AjaxResult findAllTaskLevelReport() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Map<String, String[]> data = companyService.findAllTaskLevelReport();
            result.setData(data);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 指定公司的保安员专业水平画像
     *
     * @param companyId
     * @return
     */
    @RequestMapping("findProfessionLevelReport/{companyId}")
    public @ResponseBody
    AjaxResult findProfessionLevelReport(@PathVariable("companyId") Long companyId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            List<ReportData> data = companyService.findProfessionLevelReport(companyId);
            result.setData(data);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 指定公司的保安员购买保险比例画像
     *
     * @param companyId
     * @return
     */
    @RequestMapping("findSecurityPersonReport/{companyId}")
    public @ResponseBody
    AjaxResult findSecurityPersonReport(@PathVariable("companyId") Long companyId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            List<ReportData> data = companyService.findSecurityPersonReport(companyId);
            result.setData(data);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 指定公司的保安员购买保险比例画像
     *
     * @param
     * @return
     */
    @RequestMapping("findSecurityPersonReportForArea")
    public @ResponseBody
    AjaxResult findSecurityPersonReportForArea() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            List<ReportData> data = companyService.findSecurityPersonReport(null);
            result.setData(data);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 指定公司的保安员学习比例画像
     *
     * @param companyId
     * @return
     */
    @RequestMapping("findSecurityPersonStudyReport/{companyId}")
    public @ResponseBody
    AjaxResult findSecurityPersonStudyReport(@PathVariable("companyId") Long companyId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            List<ReportData> data = companyService.findSecurityPersonStudyReport(companyId);
           
            PersonSearchDto dto = new PersonSearchDto();
            dto.setCompanyId(companyId);
			Long noPower = personService.searchAllCount(dto);
			 for (ReportData reportData : data) {
            	noPower = noPower - reportData.getValue();
			}
            ReportData da = new ReportData();
            da.setValue(noPower == null ? 0 : noPower);
            da.setName("无培训");
            data.add(da);
            result.setData(data);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 指定公司的保安员祖籍画像
     *
     * @param companyId
     * @return
     */
    @RequestMapping("findNativeReport/{companyId}")
    public @ResponseBody
    AjaxResult findNativeReport(@PathVariable("companyId") Long companyId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Map<String, String[]> data = companyService.findNativeReport(companyId);
            result.setData(data);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 指定公司的任务类型画像
     *
     * @param companyId
     * @return
     */
    @RequestMapping("findTaskCatalogReport/{companyId}")
    public @ResponseBody
    AjaxResult findTaskCatalogReport(@PathVariable("companyId") Long companyId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Map<String, String[]> data = companyService.findTaskCatalogReport(companyId);
            result.setData(data);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 指定公司的任务等级画像
     *
     * @param companyId
     * @return
     */
    @RequestMapping("findTaskLevelReport/{companyId}")
    public @ResponseBody
    AjaxResult findTaskLevelReport(@PathVariable("companyId") Long companyId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            List<ReportData> data = companyService.findTaskLevelReport(companyId);
            result.setData(data);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 获取当前公司班次信息
     *
     * @return
     */
    @RequestMapping("findSchedule")
    public @ResponseBody
    AjaxResult findSchedule() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User currentUser = arsUtil.getCurrentUser();
            if (currentUser == null || currentUser.getPlatform() == 1) {
                throw new ArsException("登录信息错误");
            }
            SecurityCompany company = null;
            if (currentUser.getPlatform() == 2) {
                company = companyService.findByUserid(currentUser.getId());
            }

            if (company != null) {
                List<SecurityCompanySchedule> data = scheduleService.findByCompanyId(company.getId());
                result.setSuccessful(true);
                result.setData(data);
            } else {
                throw new RuntimeException("无法获取当前公司信息，UserID:" + currentUser.getId());
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    /**
     * 获取当前公司班次信息
     *
     * @return
     */
    @RequestMapping("findScheduleWithTask/{id}")
    public @ResponseBody
    AjaxResult findScheduleWithTask(@PathVariable("id") Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            long num = scheduleService.findByCompanyIdWithTask(id);
            if (num > 0) {
                result.setSuccessful(false);
                result.setMsg("班次已经被使用，不能再更改!");
            } else {
                result.setSuccessful(true);
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 新增或更新公司班次信息
     *
     * @return
     */
    @RequestMapping("updateSchedule")
    public @ResponseBody
    AjaxResult updateSchedule(SecurityCompanySchedule schedule) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User currentUser = arsUtil.getCurrentUser();
            if (currentUser == null || currentUser.getPlatform() == 1) {
                throw new ArsException("登录信息错误");
            }
            SecurityCompany company = null;
            if (currentUser.getPlatform() == 2) {
                company = companyService.findByUserid(currentUser.getId());
            }
            if (company != null) {
                schedule.setCompanyId(company.getId());
                scheduleService.saveOrUpdate(schedule);
                result.setSuccessful(true);
            } else {
                throw new RuntimeException("无法获取当前公司信息，UserID:" + arsUtil.getCurrentUser().getId());
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 删除公司班次信息
     *
     * @return
     */
    @RequestMapping("deleteSchedule")
    public @ResponseBody
    AjaxResult deleteSchedule(SecurityCompanySchedule schedule) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User currentUser = arsUtil.getCurrentUser();
            if (currentUser == null || currentUser.getPlatform() == 1) {
                throw new ArsException("登录信息错误");
            }
            SecurityCompany company = null;
            if (currentUser.getPlatform() == 2) {
                company = companyService.findByUserid(currentUser.getId());
            }
            if (company != null) {
                schedule.setCompanyId(company.getId());
                scheduleService.delete(schedule);
                result.setSuccessful(true);
            } else {
                throw new RuntimeException("无法获取当前公司信息，UserID:" + arsUtil.getCurrentUser().getId());
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 调百联宝（企业）是否有购买保险的接口
     *
     * @return
     */
    @RequestMapping("checkCompanyPolicy")
    public @ResponseBody
    AjaxResult checkCompanyPolicy() throws Exception {
        return companyService.checkCompanyPolicy();
    }

    @RequestMapping("getByCurrentUser")
    public @ResponseBody
    AjaxResult getByCurrentUser() {
        AjaxResult result = new AjaxResult();
        try {
            User currentUser = arsUtil.getCurrentUser();
            SecurityCompany company = null;
            if (currentUser.getPlatform() == 2) {
                company = companyService.findByUserid(currentUser.getId());
            }

            if (company != null) {
                result.setSuccessful(true);
                result.setData(company);
            } else {
                throw new RuntimeException("无法获取当前公司信息，UserID:" + currentUser.getId());
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 获取培训管理->学习统计页面的数据。
     *
     * @return
     * @author liumd
     * @date 2017年4月10日 下午4:10:32
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("getStudyReport")
    public @ResponseBody
    AjaxResult getStudyReport() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User currentUser = arsUtil.getCurrentUser();
            //只对保安公司\授权的保安员开放
            if (currentUser != null && currentUser.getPlatform() != 1) {

                SecurityCompany company = null;
                if (currentUser.getPlatform() == 2) {
                    company = companyService.findByUserid(currentUser.getId());
                }

                if (company != null) {
                    StudyTotalReportData studyData = new StudyTotalReportData();
                    //获取公司总人数，以及各个学习阶段的人数。
                    Long count = company.getSecurityAmount().longValue();
                    List<ReportData> data = companyService.findSecurityPersonStudyReport(company.getId());
                    for (ReportData reportData : data) {
                        if ("初级保安课程".equals(reportData.getName())) {
                            studyData.setFirstLesson(reportData.getValue().toString());
                        } else if ("继续教育".equals(reportData.getName())) {
                            studyData.setContinueLesson(reportData.getValue().toString());
                        }
                    }
                    Long noPower = companyService.findNoPowerCount(company.getId());
                    studyData.setNoPower(noPower == null ? "0" : noPower.toString());
                    //获取该公司学习统计时长排名，value为时长，name名字。
                    List<ReportData> studyList = companyService.getStudyListDesc(company.getId());
                    Long minuteTotal = 0L;
                    if (studyList != null && studyList.size() > 0) {
                        studyData.setList(studyList);
                        for (ReportData reportData : studyList) {
                            minuteTotal += reportData.getValue();
                        }
                        DecimalFormat df = new DecimalFormat("0.00");
                        String perMinute = df.format((float) minuteTotal / count);
                        studyData.setPerMinutes(perMinute);
                        studyData.setPerDays(df.format((float) minuteTotal / count / 1440));
                    } else {
                        studyData.setPerDays("0");
                        studyData.setPerMinutes("0");
                    }
                    result.setSuccessful(true);
                    result.setData(studyData);
                }
            }
        } catch (Exception e) {
            throw e;
        }
        return result;
    }


    @RequestMapping("findPersonStudyList")
    public @ResponseBody
    AjaxResult findPersonStudyList(PersonStudySearchDTO dto, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            PersonStudySearchDTO data = companyService.personStudySearch(dto);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 保安公司管理 -- 重置密码
     * <b>Function </b>
     *
     * @param companyid
     * @param request
     * @return
     * @throws Exception
     * @author LinQingLin
     * @date 2017年6月22日 上午11:07:16
     * @注意事项 </b>
     * <b>
     */
    @RequestMapping("resetPwd/{companyid}")
    public @ResponseBody
    AjaxResult resetPwd(@PathVariable Long companyid, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            companyService.resetPwd(companyid);
            result.setSuccessful(true);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    @RequestMapping("delete/{companyid}")
    public @ResponseBody
    AjaxResult deleteCompany(@PathVariable Long companyid, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            companyService.deleteCompany(companyid);
            result.setSuccessful(true);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 自招撤销
     * @param companyid
     * @param request
     * @return
     * @throws Exception
     */
    @RequestMapping("revoke/{companyid}")
    public @ResponseBody
    AjaxResult revokeCompany(@PathVariable Long companyid, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            companyService.revokeCompany(companyid);
            result.setSuccessful(true);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 批量导出保安公司信息-生成excel
     *
     * @param dto
     * @param request
     */
    @RequestMapping("createCompanysExcel")
    public @ResponseBody
    AjaxResult createCompanysExcel(CompanySearchDto dto, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                dto.setPaging(false);
                CompanySearchDto data = companyService.searchForManager(dto);
                if (data.getData() != null) {
                    Date now = new Date();
                    String dirDate = DateUtil.systemDate.format(now);
                    File dir = new File(downloadFolder + dirDate);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    String templateName = downloadFolder + dirDate + "/" + (now.getTime() + "_保安公司列表.xls");
                    File file = new File(templateName);
                    companyService.exportCompanys(data.getData(), file);
                    result.setData(templateName);
                    result.setSuccessful(true);
                } else {
                    result.setSuccessful(false);
                }
            }
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 批量导出保安公司数据-生成excel(数据库数据导出）
     *
     * @param dto
     * @param request
     */
    @RequestMapping("createCompanysDataExcel")
    public @ResponseBody
    AjaxResult createCompanysDataExcel(CompanySearchDto dto, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                List<SecurityCompany> companylist = companyService.searchForExportData(dto);
                if (companylist != null && companylist.size() > 0) {
                    Date now = new Date();
                    String dirDate = DateUtil.systemDate.format(now);
                    File dir = new File(downloadFolder + dirDate);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }

                    DataSycDto dataSycDto = new DataSycDto();
                    dataSycDto.setDataType(Constants.DATASYC_COMPANY_LIST);
                    dataSycDto.setData(JSONObject.toJSONString(companylist));

                    String companyListStr = JSONObject.toJSONString(dataSycDto);
                    String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(companyListStr.getBytes(), Constants.APPROVAL_KEY));

                    String filepath = FileUtil.writeTxtFile(content, "company", tempFolder);
                    if (StringUtil.isNotEmpty(filepath)) {
                        for (SecurityCompany securityCompany : companylist) {
                            securityCompany.setExported(true);
                            companyService.updateExport(securityCompany);
                        }
                        result.setData(filepath);
                        result.setSuccessful(true);
                    } else {
                        result.setSuccessful(false);
                        result.setMsg("导出失败，请联系系统管理员确认！");
                    }
//					String templateName = downloadFolder + dirDate+"/" + (now.getTime() + "_保安公司列表.xls");
//					File file = new File(templateName);
//					companyService.exportCompanysData(data.getData(), file);
//					result.setData(templateName);
//					result.setSuccessful(true);
                } else {
                    result.setSuccessful(false);
                }
            }
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 批量导出保安公司信息
     *
     * @param response
     * @throws Exception
     */
    @RequestMapping("exportCompanys")
    public void exportCompanys(String templateName, HttpServletResponse response) throws Exception {
        User user = arsUtil.getCurrentUser();
        if (user != null) {
            File file = new File(templateName);
            if (file != null) {
                ServletOutputStream out = response.getOutputStream();
                String fileName = new String(file.getName().substring(file.getName().indexOf("_") + 1).getBytes("UTF-8"), "iso-8859-1");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                InputStream is = new FileInputStream(file);
                int read = 0;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                is.close();
                out.flush();
                out.close();
            }
        }
    }


    /**
     * 导出保安公司录入模板
     *
     * @param request
     * @param response
     * @throws Exception
     */
    @RequestMapping("exportCompanyTemplate")
    public void exportCompanyTemplate(HttpServletRequest request, HttpServletResponse response) throws Exception {
        User user = arsUtil.getCurrentUser();
        if (user != null) {
            Date now = new Date();
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(tempFolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String templateName = tempFolder + dirDate + (now.getTime() + "_保安公司导入模板.xls");
            File file = new File(templateName);

            companyService.buildCompanyTemplate(file);
            if (file != null) {
                ServletOutputStream out = response.getOutputStream();
                String fileName = new String(file.getName().substring(file.getName().indexOf("_") + 1));
                //判断是否是IE11
                Boolean flag = request.getHeader("User-Agent").indexOf("like Gecko") > 0;
                if (request.getHeader("User-Agent").toLowerCase().indexOf("msie") > 0 || flag) {
                    fileName = URLEncoder.encode(fileName, "UTF-8");//IE浏览器
                } else {
                    //先去掉文件名称中的空格,然后转换编码格式为utf-8,保证不出现乱码,
                    //这个文件名称用于浏览器的下载框中自动显示的文件名
                    fileName = new String(fileName.replaceAll(" ", "").getBytes("UTF-8"), "ISO8859-1");
                }
                response.reset();
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                response.addHeader("Content-Length", "" + file.length());
                response.setContentType("application/octet-stream");
                InputStream is = new FileInputStream(file);
                int read = 0;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                is.close();
                out.write(buffer);// 输出文件
                out.flush();
                out.close();
            }
        }
    }

    /**
     * 批量导入保安公司
     */
    @RequestMapping("importCompanyData")
    public @ResponseBody
    AjaxResult importCompanyData(MultipartFile file, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Date now = new Date();
            String fileName = now.getTime() + "_" + file.getOriginalFilename();
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(uploadFolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String targetPath = uploadFolder + dirDate + "/" + fileName;
            File targetFile = new File(targetPath);
            logger.info("执行保安公司文件上传..." + targetFile);
            file.transferTo(targetFile);

            Map<String, Object> resultMap = companyService.importCompany(targetFile);
            result.setData(resultMap);
            if (resultMap.get("faildFilePath") == null || StringUtil.isEmpty(resultMap.get("faildFilePath").toString())) {
                result.setMsg("批量导入成功");
            } else {
                result.setMsg("导入失败，请下载失败列表，修改后再上传.");//#1013
            }
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    //机构同步
    public static Map<String, Object> getCompany(SecurityCompany company) {
        //需要记录请求记录信息
        Map<String, Object> map = new HashMap<>();

        String url = ThirdPartyURL.YWZC + "/api/webCompany/receiveTerminalData";
        Map<String, Object> mapParams = new HashMap<String, Object>();
        mapParams.put("sign", Constants.WEB_TYPE_COINS);
        mapParams.put("webType", Constants.WEB_TYPE_COINS);

        if (company.getId() != null) {
            mapParams.put("id", company.getId());
        }
        if (company.getName() != null) {
            mapParams.put("companyName", company.getName());
        }
      /*  if (company.getCompany_ename() != null) {
            mapParams.put("companyEname", company.getCompany_ename());

        }*/
        if (company.getProvince() != null) {
            mapParams.put("province", company.getProvince());

        }
        if (company.getCity() != null) {
            mapParams.put("city", company.getCity());

        }
        if (company.getArea() != null) {
            mapParams.put("district", company.getArea());

        }
       /* if (company.getRegistered_address() != null) {
            mapParams.put("registeredAddress", company.getRegistered_address());

        }*/
        if (company.getLocation() != null) {
            mapParams.put("businessAddress", company.getLocation());

        }
        /*if(company.getOrganization_code_type()!=null){
            //1: 营业执照,2: 统一社会信用代码
            if("7".equals(company.getOrganization_code_type())){
                mapParams.put("documentType", "1");
            }
            if("2".equals(company.getOrganization_code_type())){
                mapParams.put("documentType", "2");
            }
            if("1".equals(company.getOrganization_code_type())){
                mapParams.put("documentType", "3");
            }
        }*/
        if (company.getSocialCode() != null) {
            mapParams.put("organizationCode", company.getSocialCode());
        }

        if (company.getCompanyType() != null) {
            mapParams.put("enterpriseType", company.getCompanyType());
        }

        if (company.getEconomicType() != null) {
            mapParams.put("natureManagement", company.getEconomicType());

        }
        //   1:法人代表,2:主要联系人:3:委托代理人,4:一般联系人
//        if(company.getLegal_duty()!=null){
        //'法人


//        mapParams.put("contactsList[2].contactsType", 3);

//        if (company.getLegal_name() != null) {
//            mapParams.put("contactsList[0].contactsType", 1);
//            mapParams.put("contactsList[0].name", company.getLegal_name());
//        }
//        if (company.getLegal_duty() != null) {
//            mapParams.put("contactsList[0].contactsDuty", company.getLegal_duty());
//        }
//        if (company.getLegal_phone() != null) {
//            mapParams.put("contactsList[0].contactsWay", company.getLegal_phone());
//
//        }
//        if (company.getLegal_email() != null) {
//            mapParams.put("contactsList[0].email", company.getLegal_email());
//        }

//        }

        //联系人

        if (company.getPrincipal() != null) {
            mapParams.put("contactsList[0].contactsType", 2);
            mapParams.put("contactsList[0].name", company.getPrincipal());
        }
       /* if (company.getAgent_duty() != null) {
            mapParams.put("contactsList[0].contactsDuty", company.getLink_duty());
        }*/

        if (company.getPrincipalPhone() != null) {
            mapParams.put("contactsList[0].contactsWay", company.getPrincipalPhone());
        }
      /*  if (company.getLink_email() != null) {
            mapParams.put("contactsList[0].email", company.getLink_email());
        }
      */
        //委托代理人
//        if (company.getAgent_name() != null) {
//            mapParams.put("contactsList[2].name", company.getAgent_name());
//        }
//        if (company.getAgent_duty() != null) {
//            mapParams.put("contactsList[2].contactsDuty", company.getAgent_duty());
//
//        }
//        if (company.getAgent_phone() != null) {
//            mapParams.put("contactsList[2].contactsWay", company.getAgent_phone());
//
//        }
//        if (company.getAgent_email() != null) {
//            mapParams.put("contactsList[2].email", company.getAgent_email());
//        }


        try {
            String s = messageUtils.doPost3(url, mapParams);
            JSONObject json = JSON.parseObject(s);
            if (json != null && json.get("success").toString().equals("true")) {
                map.put("status", true);
                map.put("webID", json.get("data"));
            }
        } catch (Exception ex) {
            map.put("status", true);
            ex.printStackTrace();
        }

        return map;
    }

    /**
     * 批量导入保安公司(数据库导入）
     */
    @RequestMapping("importCompanyDatas")
    public @ResponseBody
    AjaxResult importCompanyDatas(MultipartFile file, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Date now = new Date();
            String fileName = now.getTime() + "_" + file.getOriginalFilename();
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(uploadFolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String targetPath = uploadFolder + dirDate + "/" + fileName;
            File targetFile = new File(targetPath);
            logger.info("执行保安公司文件上传..." + targetFile);
            file.transferTo(targetFile);

            BufferedReader br = new BufferedReader(new FileReader(targetFile));
            StringBuffer content = new StringBuffer();
            // 获取文件内容
            String lineTxt = null;
            while ((lineTxt = br.readLine()) != null) {// 使用readLine方法，一次读一行
                content.append(lineTxt);
            }
            br.close();

            //TODO
            String jsonStr = new String(CipherDESUtil.decrypt(Encodes.decodeHex(content.toString()), Constants.APPROVAL_KEY));
            DataSycDto dataSycDto = JSONObject.parseObject(jsonStr, DataSycDto.class);
            if (dataSycDto != null) {
                if (dataSycDto.getDataType().equals(Constants.DATASYC_COMPANY_LIST)) {

                    List<SecurityCompany> companyList = JSONArray.parseArray(dataSycDto.getData(), SecurityCompany.class);
                    if (companyList != null && companyList.size() > 0) {
                        for (SecurityCompany securityCompany : companyList) {
                            try {
                                User user = securityCompany.getUser();
                                SecurityCompany dbSecurityCompany=companyService.findById(securityCompany.getId());

                                if (dbSecurityCompany!=null){
                                    securityCompany.setId(dbSecurityCompany.getId());

                                    //项目变更后，需要更新公司信息，同时推送给SaaS TODO


                                    continue;//数据库已存在，不做导入
                                }
                                //
                                userService.saveOrUpdateForDS(user);
                                securityCompany.setUser(user);
                                securityCompany.setUserid(user.getId());
                                companyService.saveForImport(securityCompany);
                            } catch (Exception e) {
                                throw e;
                            }
                        }
                    }

                    result.setMsg("导入成功");
                    result.setSuccessful(true);
                } else {
                    result.setMsg("导入失败，非保安公司的数据！");
                    result.setSuccessful(false);
                }
            } else {
                result.setMsg("导入失败，非保安公司的数据！");
                result.setSuccessful(false);
            }

            Map<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("faildFilePath", "");
            result.setData(resultMap);
            result.setSuccessful(true);
        } catch (BadPaddingException badPaddingException){
            logger.error(badPaddingException.getMessage(), badPaddingException);
            throw new ArsException("导入失败，非该区域数据\n！");
        }catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("updateInitstep")
    public @ResponseBody
    AjaxResult updateInitstep() throws Exception {
        AjaxResult result = new AjaxResult();
        try {

            User currentUser = arsUtil.getCurrentUser();
            currentUser.setInitstep(Constants.INTISTEP_COM);
            userService.updateInitstep(currentUser);
            result.setSuccessful(true);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    @RequestMapping("dataStatisticsReport")
    public @ResponseBody
    AjaxResult dataStatisticsReport(ReportDataSearchDto searchDto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            CompanyReportData data = companyService.dataStatisticsReport(searchDto);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    @RequestMapping("supervisionSearch")
    public @ResponseBody
    Object supervisionSearch(SupervisionSearchDto searchDto, HttpServletResponse resp) throws Exception {
//		AjaxResult result = new AjaxResult();
        try {
//			result.setSuccessful(true);
//			result.setData(companyService.supervisionSearch(searchDto));
//			searchDto.setPageNum(0);
//			searchDto.setNumPerPage(8);
            CTLUtil.out(companyService.querySupervisionList(searchDto), resp);//进行查询，并转换
        } catch (Exception e) {
            throw e;
        }
        return null;
//		return result;
    }

    @RequestMapping("supervisionTotal")
    public @ResponseBody
    AjaxResult supervisionTotal(SupervisionSearchDto searchDto, HttpServletResponse resp) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(companyService.supervisionTotal(searchDto));
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    @RequestMapping("supervisionDetail")
    public @ResponseBody
    AjaxResult supervisionDetail(Long companyId, HttpServletResponse resp) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(companyService.supervisionDetail(companyId));
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    @RequestMapping("companySecurityDetail")
    public @ResponseBody
    AjaxResult companySecurityDetail(Long companyId, HttpServletResponse resp) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(companyService.companySecurityDetail(companyId));
        } catch (Exception e) {
            throw e;
        }
        return result;
    }
    

    @RequestMapping("getCompanyTree")
    public @ResponseBody
    AjaxResult getCompanyTree() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(companyService.getCompanyTree());
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    @RequestMapping("findByComId/{comId}")
    public @ResponseBody
    AjaxResult findByComId(@PathVariable Long comId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(companyService.findByComId(comId));
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    @RequestMapping("findByParentId/{parentId}")
    public @ResponseBody
    AjaxResult findByParentId(@PathVariable String parentId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            result.setSuccessful(true);
            result.setData(companyService.findSubCompany(parentId));
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 公司信息列表页面初始化
     * @param institutionType 公司类型
     * @return
     */
    @RequestMapping("list/index")
    public ModelAndView listIndex(CompanyPageSearchDto searchDto,String institutionType,String local){
        ModelAndView view = new ModelAndView("sys/company/list");
        view.addObject("institutionType",institutionType);
        view.addObject("local",local);
        view.addObject("record",searchDto);
        return view;
    }

    /**
     * 外地公司信息列表页面初始化
     * @return
     */
    @RequestMapping("noLocalList/index")
    public ModelAndView listIndex(CompanyPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("sys/company/noLocalList");
        view.addObject("record",searchDto);
        return view;
    }
    /**
     * 外地公司信息列表页面初始化
     * @return
     */
    @RequestMapping("situation/index")
    public ModelAndView situationIndex(CompanyPageSearchDto dto){
        ModelAndView view = new ModelAndView("sys/company/situation");
        view.addObject("record",dto);
        return view;
    }

    /**
     * 公司详情页面初始化
     * 包括新增 修改 查看
     * @param company
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(SecurityCompany company){
        ModelAndView view = new ModelAndView("sys/company/detail");

        if(company.getId() != null){
            company = companyService.findById(company.getId());
        }else if(StringUtil.isNotEmpty(company.getComId())){
            company = companyService.findByComId(Long.parseLong(company.getComId()));
        }
        if(StringUtil.isNotEmpty(company.getInstitutionType())) {
            view.setViewName("sys/company/detail" + company.getInstitutionType());
        }
        view.addObject("company", company);
        return view;
    }
    /**
     * 公司分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("situationForPage")
    @ResponseBody
    public AjaxPageResponse situationForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page){
        companyService.situationForPage(dto,page);
        return page;
    }

    /**
     * 公司分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @RequiresPermissions(logical = Logical.OR,value ={"companyInfoManager:query","trainInfoManager:query","confessInfoManager:query","subsidiaryInfoManager:query"})
    @ResponseBody
    public AjaxPageResponse searchForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page){
        companyService.searchForPage(dto,page);
        List<CompanyDto> companyDtos = page.getData();
        companyDtos.forEach(str->{
            str.setNotOnDutyPersons(str.getSchedulePersons()-str.getOnDutyPersons());
            str.setNoSchedulePersons(str.getSecurityAmount()-str.getSchedulePersons());
        });
        page.setData(companyDtos);
        return page;
    }

    /**
     * 自招单位信息列表页面初始化 兼容旧数据
     * @return
     */
    @RequestMapping("conList/index")
    public ModelAndView conListIndex(){
        ModelAndView view = new ModelAndView("sys/company/conList");
        return view;
    }
    /**
     * 自招单位分页查询 兼容旧数据
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchConfessComForPage")
    @RequiresPermissions("confessInfoManager:query")
    @ResponseBody
    public AjaxPageResponse searchConfessComForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page){
        companyService.searchConfessComForPage(dto,page);
        return page;
    }


    @RequestMapping("public/query/index")
    @ResponseBody
    public ModelAndView queryIndex(CompanyPageSearchDto dto){
        ModelAndView view = new ModelAndView("public/comList");
        return view;
    }

    @RequestMapping("public/searchForPage")
    @ResponseBody
    public AjaxPageResponse publicSearchForPage(CompanyPageSearchDto dto, AjaxPageResponse<CompanyDto> page){
        if(StringUtil.isNotEmpty(dto.getName())) {
            companyService.publicSearchForPage(dto, page);
        }
        return page;
    }
}