package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.SbSubsidiaryBaseSearchDto;
import com.bcxin.ars.dto.sb.SbSubsidiaryManagerSearchDto;
import com.bcxin.ars.model.SbSubsidiaryBase;
import com.bcxin.ars.model.SbSubsidiaryManager;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.SbSubsidiaryBaseService;
import com.bcxin.ars.service.SbSubsidiaryManagerService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;


@Controller
@RequestMapping("sbSubsidiaryManager")
public class SbSubsidiaryManagerController {
	
	private static final Logger logger = LoggerFactory.getLogger(SbSubsidiaryManagerController.class);
	
	@Autowired
	private SbSubsidiaryManagerService sbSubsidiaryManagerervice;

	@Autowired
	private ArsRestUtil arsUtil;

	/**
	 * 查询全部
	 * @return
	 */
	@RequestMapping("getsbSubsidiaryManagerList")
	public @ResponseBody AjaxResult update(SbSubsidiaryManagerSearchDto sbSubsidiaryMabager) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(sbSubsidiaryMabager.getUserid() == null) {
				sbSubsidiaryMabager.setUserid(user.getId());
			}
			SbSubsidiaryManagerSearchDto data = sbSubsidiaryManagerervice.search(sbSubsidiaryMabager);
				result.setSuccessful(true);
				result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 创建或更新子公司基础信息
	 * @param sbSubsidiaryManager 子公司基础信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody AjaxResult update(SbSubsidiaryManager sbSubsidiaryManager, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			sbSubsidiaryManagerervice.saveOrUpdate(sbSubsidiaryManager);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}
	/**
	 * 删除任务
	 * @return
	 */
	@RequestMapping("delete/{id}")
	public @ResponseBody AjaxResult delete(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SbSubsidiaryManager sbSubsidiaryManager = sbSubsidiaryManagerervice.findById(id);

			if(sbSubsidiaryManager != null) {
				sbSubsidiaryManagerervice.delete(sbSubsidiaryManager);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
					result.setMsg("删除信息失败，ID:" + id);
				}

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据ID获取信息明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SbSubsidiaryManager sbSubsidiaryManager = sbSubsidiaryManagerervice.findById(id);
			result.setSuccessful(true);
			result.setData(sbSubsidiaryManager);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
