package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.SbPunishSearchDto;
import com.bcxin.ars.model.SbPunish;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.SbPunishService;
import com.bcxin.ars.service.SecurityPersonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * 保安员处罚
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年8月2日 上午9:59:41
 * @注意事项 </b>
 * <b>
 */

@Controller
@RequestMapping("sbPunish")
public class SbPunishController {
	
	private static final Logger logger = LoggerFactory.getLogger(SbPunishController.class);
	
	@Autowired
	private SbPunishService sbPunishService;

	@Autowired
	private SecurityPersonService securityPersonService;

	@Autowired
	private ArsRestUtil arsUtil;

	/**
	 * 查询全部
	 * @return
	 */
	@RequestMapping("getSbPunishList")
	public @ResponseBody AjaxResult search(SbPunishSearchDto sbPunishSearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				if (user.getPlatform() == 2) {
					sbPunishSearchDto.setUserid(user.getId());
				}
			}
			SbPunishSearchDto data = sbPunishService.search(sbPunishSearchDto);
				result.setSuccessful(true);
				result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 创建或更新保安奖励信息
	 * @param sbPunish 保安奖励信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody AjaxResult update(SbPunish sbPunish, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			sbPunishService.saveOrUpdate(sbPunish);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}
	/**
	 * 删除保安奖励信息
	 * @return
	 */
	@RequestMapping("delete/{id}")
	public @ResponseBody AjaxResult delete(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SbPunish sbPunish = sbPunishService.findById(id);

			if(sbPunish != null) {
				sbPunishService.delete(sbPunish);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
					result.setMsg("删除信息失败，ID:" + id);
				}

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据ID获取保安奖励信息
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SbPunish sbPunish = sbPunishService.findById(id);
			result.setSuccessful(true);
			result.setData(sbPunish);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
