package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.SbBusinessOutsideManagementSearchDto;
import com.bcxin.ars.model.SbBusinessOutsideManagement;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.SbBusinessOutsideManagementService;
import com.bcxin.ars.service.SecurityPersonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

/**
 * 海外经营情况
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年8月1日 下午5:15:09
 * @注意事项 </b>
 * <b>
 */

@Controller
@RequestMapping("sbBusinessOutsideManagement")
public class SbBusinessOutsideManagementController {
	
	private static final Logger logger = LoggerFactory.getLogger(SbBusinessOutsideManagementController.class);
	
	@Autowired
	private SbBusinessOutsideManagementService sbBusinessOutsideManagementService;

	@Autowired
	private SecurityPersonService securityPersonService;

	@Autowired
	private ArsRestUtil arsUtil;

	/**
	 * 查询全部
	 * @return
	 */
	@RequestMapping("getSbBusinessOutsideManagementList")
	public @ResponseBody AjaxResult update(SbBusinessOutsideManagementSearchDto sbBusinessOutsideManagementSearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				if (user.getPlatform() == 2) {
					sbBusinessOutsideManagementSearchDto.setUserid(user.getId());
				}
			}
			SbBusinessOutsideManagementSearchDto data = sbBusinessOutsideManagementService.search(sbBusinessOutsideManagementSearchDto);
				result.setSuccessful(true);
				result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 创建或更新海外经营信息
	 * @param sbBusinessOutsideManagement 子公司基础信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody AjaxResult update(SbBusinessOutsideManagement sbBusinessOutsideManagement, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			sbBusinessOutsideManagementService.saveOrUpdate(sbBusinessOutsideManagement);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}

	/**
	 * 删除海外经营信息
	 * @return
	 */
	@RequestMapping("delete/{id}")
	public @ResponseBody AjaxResult delete(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SbBusinessOutsideManagement sbBusinessOutsideManagement = sbBusinessOutsideManagementService.findById(id);

			if(sbBusinessOutsideManagement != null) {
				sbBusinessOutsideManagementService.delete(sbBusinessOutsideManagement);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
					result.setMsg("删除信息失败，ID:" + id);
				}

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据ID获取信息明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			SbBusinessOutsideManagement sbBusinessOutsideManagement = sbBusinessOutsideManagementService.findById(id);
			result.setSuccessful(true);
			result.setData(sbBusinessOutsideManagement);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
