package com.bcxin.ars.rest;

import cn.hutool.http.HttpUtil;
import cn.org.bjca.yzt.YZTAuthService;
import cn.org.bjca.yzt.YZTAuthUtil;
import com.bcxin.ars.dao.UserDao;
import com.bcxin.ars.dao.UserDaoAop;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.LoginLogService;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.JwtUtil;
import com.bcxin.ars.util.StringUtil;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.*;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/**
 * 北京企业法人单点登录
 * @author linqinglin
 * @date 2020/10/21 0021 16:33
 */
@Controller
@RequestMapping("yztAuth")
@Slf4j
public class SSOLoginController {

    private Logger logger = LoggerFactory.getLogger(SSOLoginController.class);

    @Autowired
    private UserDao userDao;

    @Autowired
    private UserDaoAop userDaoAop;

    @Autowired
    private SecurityCompanyService securityCompanyService;

    @Autowired
    private ArsUtil arsUtil;

    /***
     * 登陆日志
     */
    @Autowired
    private LoginLogService loginLogService;

    @Value("${login-timeout}")
    private int loginTimeout = 10;
    @Value("${v5_web_url}")
    private String v5WebUrl;

//    @RequestMapping(value = "ssoLogin")
    public void ssoLogin1(HttpServletRequest req, HttpServletResponse resp) throws Exception {

        resp.setContentType("text/html;charset=utf-8");
        resp.setCharacterEncoding("UTF-8");
        PrintWriter pw = resp.getWriter();

        String userInfoStr = new YZTAuthService().doAuth(req, true);

        // 解析用户信息，并根据业务进行相应处理
        if (userInfoStr == null) {
            pw.print("获取用户的信息为空");
            pw.print(req.getAttribute("yzt_login_ermsg"));
        } else {
            logger.error(userInfoStr);
            JSONObject userInfoJson = JSONObject.fromObject(userInfoStr);

            String errorMsg = userInfoJson.optString("error_msg");

            if (null != errorMsg && !"".equals(errorMsg)) {
                pw.write("<br/>");
                pw.write("<h3>" + errorMsg + "</h3>");
                return ;
            }

            // 判断是否是用户名密码用户，credenceClass为Credence_002表示用户名口令、Credence_001表示证书用户
            String credenceClass = userInfoJson.optString("credenceClass");
            boolean isPwdUser = null != credenceClass && credenceClass.equalsIgnoreCase("Credence_002");

            // 获取用户基本信息 +++++++++++++++++++++++++++++++++++
            String uid = userInfoJson.optString("uid"); // 用户证书唯一标识/用户名
            String cn = userInfoJson.optString("cn"); // 用户单位名称
            String idCardNumber = userInfoJson.optString("idCardNumber"); // 组织机构代码

            String extProperties = userInfoJson.optString("extProperties");
            String phone = YZTAuthUtil.resolveExtProperties(extProperties, "LEGAL_PERSON_PHONE");   // 法人手机号
            String blrMobile = YZTAuthUtil.resolveExtProperties(extProperties, "BLR_MOBILE");   // 办理人手机号
            String blrName = YZTAuthUtil.resolveExtProperties(extProperties, "BLR_NAME");   // 办理人姓名
            String blrCardid = YZTAuthUtil.resolveExtProperties(extProperties, "BLR_CARDID");   // 办理人身份证号
            String blrEmail = YZTAuthUtil.resolveExtProperties(extProperties, "BLR_EMAIL"); // 办理人邮箱

            String unionCode = YZTAuthUtil.resolveExtProperties(extProperties, "UNION_CODE");   // 统一社会信用代码
            if (null == unionCode || "".equals(unionCode)) {
                unionCode = YZTAuthUtil.resolveRegCodes(userInfoJson, "UNION_CODE");
            }

            //pw.write("<br/>");
            //pw.write("当前用户为" + (isPwdUser ? "[ 用户名/密码 ]" : "[ 证书 ]") + "用户");
            //pw.write("<h3>" + (isPwdUser ? "用户名：" : "证书唯一标识：") + uid + "</h3><br/>");
            //pw.write("<h3>单位名称：" + cn + "</h3><br/>");
            //pw.write("<h3>组织机构代码：" + idCardNumber + "</h3><br/>");
            //pw.write("<h3>统一社会信用代码：" + unionCode + "</h3><br/>");
            //pw.write("<h3>办理人姓名：" + blrName + "</h3><br/>");
            //pw.write("<h3>办理人身份证号：" + blrCardid + "</h3><br/>");
            //pw.write("<h3>办理人手机号：" + blrMobile + "</h3><br/>");
            //pw.write("<h3>办理人邮箱：" + blrEmail + "</h3><br/>");
            //
            //pw.write("<h3>accessToken：" + req.getSession().getAttribute(Constants.SINGLELOGINBJ_TOKEN) + "</h3><br />");

            //TODO 判断用户是否关联，已关联则登录，未关联则跳转到关联或注册页面（或进行相关流程的提示）
            /**
             * 一般逻辑参考：
             * 1. 此处已获取到用户的证书唯一标识（或用户名）及基本信息
             * 2. 根据用户的证书唯一标识，到用户库里查找，判断是否已与业务系统中的用户进行关联
             *      1. 如果已关联，则进行登录（并调用下方通知一证通平台开通情况的代码）
             *      2. 如果未关联，则跳转到用户关联页面（如果是线下关联，则提醒用户如何办理证书关联）进行关联；
             *          如果无账号，则可以在用户注册完成后，后台直接完成关联，关联后直接登录
             *          注：应在关联页面中放置“用户注册”的相关链接及说明
             */

            //TODO 用户登录成功后，调用如下代码，通知根据用户状态确认是否通知一证通平台开户开通情况
            //String openFlag = userInfoJson.optString("open_flag");
            //YZTAuthUtil.informYZT(uid, openFlag);
            //
            //// 事项级单点登录需要进行如下处理
            //Object matterCodeObj = req.getSession().getAttribute("yzt_matter_code");
            //req.getSession().removeAttribute("yzt_matter_code");
            //if (null != matterCodeObj && !"".equals(matterCodeObj.toString())) {
            //    //TODO 根据事项编码，在用户登录成功后，跳转到对应的事项页面
            //    pw.print("<h3>事项编码：" + matterCodeObj.toString() + "，根据事项编码跳转到对应的事项页面</h3>");
            //}

            /** 用户关联页面示例
             * 可将获取到的证书用户名称、证书唯一标识放到session中，用于后台关联业务
             */
            //TODO 跳转用户关联或注册页面
            // 登录完成后，清除cookie
            req.getSession().setAttribute("cert_user_cn", cn);
            req.getSession().setAttribute(Constants.SINGLELOGINBJ_UNIQUEID, uid);
            //if (!isPwdUser) {
            //    pw.print("<h3>已有账号？<a href='band.jsp'>请点击在线关联</a></h3>");
            //    pw.print("<h3>没有账号？<a href='register.jsp'>请点击在线注册</a></h3>");
            //}

            if( null == arsUtil.getCurrentUser()){
                logger.error("手机号："+phone);
                //phone="16600000066";
                webLogin(phone,null,Constants.PLATFORM_COMPANY,Constants.BJ_FR_SSO,req);
            }
        }
        String redirect_uri = "";
        if(StringUtil.isNotEmpty(req.getParameter("state"))){
            redirect_uri =req.getParameter("state");
        }

        //获取上下文
        ServletContext servletContext = req.getServletContext();
        String rootPath = servletContext.getContextPath();
        resp.sendRedirect(rootPath+"/index.do?redirect_uri="+redirect_uri);
    }

    @RequestMapping(value = "ssoLogin")
    public void ssoLogin(HttpServletRequest req, HttpServletResponse resp) throws Exception {
//        保安员证核发
//        https://bjt.beijing.gov.cn/renzheng/open/login/goUserLogin?client_id=100100000503&redirect_uri=http://bj.baibaodun.cn:8801/ars-web/user/singleLoginBJ.do&response_type=code&scope=user_info&state=v501
//        保安公司设立许可
//        https://bjt.beijing.gov.cn/renzheng/open/login/goUserLogin?client_id=100100000503&redirect_uri=http://bj.baibaodun.cn:8801/ars-web/user/singleLoginBJ.do&response_type=code&scope=user_info&state=v502
//        保安服务公司法定代表人变更许可
//        https://yzt.beijing.gov.cn/am/oauth2/authorize?service=bjzwService&response_type=code&client_id=00002888X_02&scope=cn+uid+idCardNumber+reserve3+extProperties+credenceClass&state=v506&redirect_uri=http%3A%2F%2Fbj.baibaodun.cn%3A8801%2Fars-web%2FyztAuth%2FssoLogin.do
//        设立保安培训单位备案
//        https://yzt.beijing.gov.cn/am/oauth2/authorize?service=bjzwService&response_type=code&client_id=00002888X_02&scope=cn+uid+idCardNumber+reserve3+extProperties+credenceClass&state=v503&redirect_uri=http%3A%2F%2Fbj.baibaodun.cn%3A8801%2Fars-web%2FyztAuth%2FssoLogin.do
//        外省市自治区保安服务公司在京设立分公司备案
//        https://yzt.beijing.gov.cn/am/oauth2/authorize?service=bjzwService&response_type=code&client_id=00002888X_02&scope=cn+uid+idCardNumber+reserve3+extProperties+credenceClass&state=v505&redirect_uri=http%3A%2F%2Fbj.baibaodun.cn%3A8801%2Fars-web%2FyztAuth%2FssoLogin.do
//        *自行招用保安员单位备案
//        https://yzt.beijing.gov.cn/am/oauth2/authorize?service=bjzwService&response_type=code&client_id=00002888X_02&scope=cn+uid+idCardNumber+reserve3+extProperties+credenceClass&state=v504&redirect_uri=http%3A%2F%2Fbj.baibaodun.cn%3A8801%2Fars-web%2FyztAuth%2FssoLogin.do
//        外省市在京提供保安服务备案
//        https://yzt.beijing.gov.cn/am/oauth2/authorize?service=bjzwService&response_type=code&client_id=00002888X_02&scope=cn+uid+idCardNumber+reserve3+extProperties+credenceClass&state=v507&redirect_uri=http%3A%2F%2Fbj.baibaodun.cn%3A8801%2Fars-web%2FyztAuth%2FssoLogin.do
        resp.setContentType("text/html;charset=utf-8");
        resp.setCharacterEncoding("UTF-8");
        PrintWriter pw = resp.getWriter();
        try {
            String userInfoStr = new YZTAuthService().doAuth(req, true);

            // 解析用户信息，并根据业务进行相应处理
            if (userInfoStr == null) {
                pw.print("获取用户的信息为空");
                pw.print(req.getAttribute("yzt_login_ermsg"));
            } else {
                logger.error(userInfoStr);
                JSONObject userInfoJson = JSONObject.fromObject(userInfoStr);

                String errorMsg = userInfoJson.optString("error_msg");

                if (null != errorMsg && !"".equals(errorMsg)) {
                    pw.write("<br/>");
                    pw.write("<h3>" + errorMsg + "</h3>");
                    return;
                }

                String extProperties = userInfoJson.getString("extProperties");
                String blrMobile = YZTAuthUtil.resolveExtProperties(extProperties, "BLR_MOBILE");   // 办理人手机号
                String idNum = YZTAuthUtil.resolveExtProperties(extProperties, "LEGAL_PERSON_ID");   // 法人证件号
                String BidNum = YZTAuthUtil.resolveExtProperties(extProperties, "BLR_CARDID");   // 办理人证件号码
                String name = YZTAuthUtil.resolveExtProperties(extProperties, "LEGAL_PERSON");   // 法定代表人 姓名
                String phone = YZTAuthUtil.resolveExtProperties(extProperties, "LEGAL_PERSON_PHONE");   // 法人电话
                String state = req.getParameter("state");

                if(StringUtils.isEmpty(idNum)){
                    if (state.equals("v504")||state.equals("v505")||state.equals("v507")){ //自招备案登录 外省市在京提供保安服务备案 外省市自治区保安服务公司在京设立分公司备案
                        if (!StringUtils.isEmpty(BidNum)){
                            idNum=BidNum;
                        }else {
                            pw.write("<br/>");
                            pw.write("<h3>办理人证件(BLR_CARDID)数据缺失</h3>");
                            return;
                        }
                    }else {
                        pw.write("<br/>");
                        pw.write("<h3>法人证件(LEGAL_PERSON_ID)数据缺失</h3>");
                        return;
                    }
                }
                Map<String, String> map = Maps.newHashMap();
                map.put("certName",name);
                map.put("certNo",idNum);
                map.put("mobile",StringUtils.isEmpty(phone)?StringUtils.isEmpty(blrMobile)?"13000000000":blrMobile:phone);
                String token = JwtUtil.createJWT(map);
                String accessToken = HttpUtil.get(v5WebUrl+"/v3/identity/sso/bbd/ssoLegalLogin?token="+token);
                if(StringUtils.isEmpty(accessToken)){
                    pw.write("<br/>");
                    pw.write("<h3>法人登录失败</h3>");
                    return;
                }

                System.out.println("=========> 北京单点登录yztAuth.ssoLogin.state:"+state);
                logger.error("=========> 北京单点登录yztAuth.ssoLogin.state:"+state);
                /*token = accessToken.replace("%22","").replace("\"","");
                switch (state) {
                    case "v501":
                        resp.sendRedirect(v5WebUrl + "/static/portal/vue/index.html#/open?appId=__KDXZvc8mnEmDqMARhK7G&actionContent=__vJplXNdVxgo5Rpyif75&opentarget=detail&linkType=00&flag=1&token=" + token);
                        break;
                    case "v502":
                        resp.sendRedirect(v5WebUrl + "/static/portal/vue/index.html#/open?appId=__KDXZvc8mnEmDqMARhK7G&actionContent=__AVYis7QN4iLJYRXNGhE&opentarget=detail&linkType=00&flag=1&token=" + token);
                        break;
                    case "v503":
                        resp.sendRedirect(v5WebUrl + "/static/portal/vue/index.html#/open?appId=__KDXZvc8mnEmDqMARhK7G&actionContent=__zagjldcIQyPSATrE9me&opentarget=detail&linkType=00&flag=1&token=" + token);
                        break;
                    case "v504":
                        resp.sendRedirect(v5WebUrl + "/static/portal/vue/index.html#/open?appId=__KDXZvc8mnEmDqMARhK7G&actionContent=__ApIdjDPXF5g3dIg9LMM&opentarget=detail&linkType=00&flag=1&token=" + token);
                        break;
                    case "v505":
                        resp.sendRedirect(v5WebUrl + "/static/portal/vue/index.html#/open?appId=__KDXZvc8mnEmDqMARhK7G&actionContent=__6sVq2e7D6SVInCgisRS&opentarget=detail&linkType=00&flag=1&token=" + token);
                        break;
                    case "v506":
                        resp.sendRedirect(v5WebUrl + "/static/portal/vue/index.html#/open?appId=__KDXZvc8mnEmDqMARhK7G&actionContent=__PX0OFiN9BKKt6hjbEy9&opentarget=detail&linkType=00&flag=1&token=" + token);
                        break;
                    default:
                        resp.sendRedirect(v5WebUrl + "/static/signon/bjca.html?token=" + token);
                        break;
                }*/
                String type = "&type="+state;
                System.out.println("=========> 北京单点登录yztAuth.ssoLogin.Redirect:"+v5WebUrl + "/static/signon/bjca.html?token=" + accessToken.replace("%22","").replace("\"","")+type);
                logger.error("=========> 北京单点登录yztAuth.ssoLogin.Redirect:"+v5WebUrl + "/static/signon/bjca.html?token=" + accessToken.replace("%22","").replace("\"","")+type);
                resp.sendRedirect(v5WebUrl + "/static/signon/bjca.html?token=" + accessToken.replace("%22","").replace("\"","")+type);
            }
        } catch (Exception e) {
            pw.write("<br/>");
            pw.write("<h3>" + e.getMessage() + "</h3>");
        }
    }

    /**
     * 登陆
     * @param username 用户名
     * @param password 密码
     * @param platform 角色
     * @param host 环境标识
     * @return
     * @throws Exception
     */
    public AjaxResult webLogin(String username, String password, Integer platform, String host, HttpServletRequest request) {
        AjaxResult result = new AjaxResult();
        try {
            UsernamePasswordToken token = new UsernamePasswordToken(username, password,host);
            Subject currentUser = SecurityUtils.getSubject();
            token.setRememberMe(false);
            try {
                currentUser.login(token);
            } catch (AuthenticationException e) {
                logger.error(e.getMessage(), e);
                result.setSuccessful(false);
                result.setMsg("用户名/密码错误");
            }
            //判断是否登录成功！
            if(currentUser.isAuthenticated()) {
                Session session = currentUser.getSession();
                User user = userDao.findByUsername(username,platform.toString());
                //更新一下登陆状态
                user.setLoginstate(1);
                //登录次数+1
                if (user.getLoginNum() != null) {
                    user.setLoginNum(user.getLoginNum() + 1);
                } else {
                    user.setLoginNum(1);
                }
                //登录时间为当前时间
                user.setLoginDate(new Date());
                userDaoAop.updateLoginState(user);
                //sessionID
                user.setSessionId(session.getId().toString());
                //设置超时时间
                arsUtil.setCurrentUser(user, 1000 * 120 * loginTimeout);
                result.setData(user);
                result.setSuccessful(true);
                loginLogService.logIn(request);
            }
        } catch (UnknownAccountException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("用户名/密码错误");
        } catch (IncorrectCredentialsException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("用户名/密码错误");
        } catch (ExcessiveAttemptsException e) {
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            result.setMsg("登录失败多次，账户锁定10分钟");
        } catch (AuthenticationException e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

}
