package com.bcxin.ars.rest;

import com.bcxin.ars.dto.page.PersonDto;
import com.bcxin.ars.dto.page.PersonPageSearchDto;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.service.SecurityGoodThingService;
import com.bcxin.ars.service.SecurityPersonExperienceService;
import com.bcxin.ars.service.SecurityPersonService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;

/***
 * 保安员现实表现
 */
@Controller
@RequestMapping("reality")
public class RealityController {
    /**
     * 日志
     */
    private static final Logger logger = LoggerFactory.getLogger(RealityController.class);
    @Autowired
    private SecurityPersonService personService;
    @Autowired
    private SecurityPersonExperienceService securityPersonExperienceService;

    /**
     * 好人好事
     */
    @Autowired
    private SecurityGoodThingService securityGoodThingService;
    /**
     * 保安员现实表现 list
     * @return
     */
    @RequestMapping("list")
    public ModelAndView listIndex(PersonPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("reality/list");
        view.addObject("record",searchDto);
        return view;
    }
    /**
     * 保安员现实表现分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForReality")
    @ResponseBody
    public AjaxPageResponse searchForPage(PersonPageSearchDto dto, AjaxPageResponse<PersonDto> page, HttpServletRequest request){
        personService.searchForReality(dto,page);
        return page;
    }
    /**
     * 保安员现实表现详情
     * @param id
     * @param request
     * @return
     */
    @RequestMapping("detail")
    public ModelAndView editIndex(Long id,HttpServletRequest request){
        ModelAndView view = new ModelAndView("reality/detail");
        SecurityPerson person = personService.findById(id);
        view.addObject("content",person);
        return view;
    }
}
