package com.bcxin.ars.rest;

import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.PoliceRoleSearchDto;
import com.bcxin.ars.dto.page.PoliceRoleDto;
import com.bcxin.ars.dto.page.RolePageSearchDto;
import com.bcxin.ars.dto.sb.PoliceSearchDto;
import com.bcxin.ars.model.DataAuth;
import com.bcxin.ars.model.PoliceRole;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.DataAuthService;
import com.bcxin.ars.service.PermissionService;
import com.bcxin.ars.service.PoliceRoleService;
import com.bcxin.ars.service.PoliceService;
import com.bcxin.ars.service.sys.ModuleMenuService;
import com.bcxin.ars.service.util.ArsUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.Logical;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import java.util.List;
import java.util.stream.Collectors;

@Controller
@RequestMapping("policeRole")
public class PoliceRoleController {

	Logger logger = LoggerFactory.getLogger(PoliceRoleController.class);
	
	@Autowired
	private PoliceRoleService policeRoleService;
	
	@Autowired
	private PermissionService permissionService;
	
	@Autowired
	private DataAuthService dataAuthService;

	@Autowired
	private ModuleMenuService moduleMenuService;

	@Autowired
	private PoliceService policeService;

	@Autowired
	private ArsUtil arsUtil;

	/***
	 * 获取审批角色
	 * @param dto
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("findApprovalRole")
	public @ResponseBody AjaxResult findApprovalRole(PoliceRoleSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setData(policeRoleService.findApprovalRole(dto));
				result.setSuccessful(true);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 搜索公安角色列表
	 * <b>Function </b>
	 *
	 * @param dto
	 * @return
	 * @throws Exception
	 * @author LinQingLin
	 * @date 2017年8月2日 下午2:10:44
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("searchForUser")
	public @ResponseBody AjaxResult searchForUser(PoliceRoleSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
//				if(dto.getUserid() == null){
//					dto.setUserid(user.getId());
//				}
				PoliceRoleSearchDto list = policeRoleService.searchForUser(dto);
				result.setSuccessful(true);
				result.setData(list);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 搜索公安角色列表
	 * <b>Function </b> 
	 * 
	 * @param dto
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月2日 下午2:10:44
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("search")
	public @ResponseBody AjaxResult search(PoliceRoleSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
//				if(dto.getUserid() == null){
//					dto.setUserid(user.getId());
//				}
				PoliceRoleSearchDto list = policeRoleService.search(dto);
				result.setSuccessful(true);
				result.setData(list);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 保存公安角色
	 * @param policeRole 角色信息
	 * @param operationIds 功能信息
	 * @param orgIds 机构列表
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * <b>
	 */
	@RequestMapping("saveAll")
	@Deprecated
	@RequiresPermissions(logical = Logical.OR,value ={"roleManager:edit","roleManager:add"})
	public @ResponseBody AjaxResult saveAll(PoliceRole policeRole,Long[] operationIds,String orgIds) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			//获取当前用户信息
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				//保存角色信息
				policeRoleService.saveOrUpdate(policeRole,operationIds,orgIds);
				result.setData(policeRole);
				result.setSuccessful(true);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	@RequestMapping("save")
	@RequiresPermissions(logical = Logical.OR,value ={"roleManager:edit","roleManager:add"})
	public @ResponseBody AjaxResult save(PoliceRole policeRole, String[] menuIds, String[] orgIds) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			//获取当前用户信息
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				//保存角色信息
				policeRoleService.save(policeRole,menuIds,orgIds);
				result.setData(policeRole);
				result.setSuccessful(true);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 检查角色是否已被使用
	 * <b>Function </b> 
	 * 
	 * @param policeRole
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月2日 下午2:10:06
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("checkUse")
	public @ResponseBody AjaxResult checkUse(PoliceRole policeRole) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				List<PoliceRole> roles = policeRoleService.findByRoleId(policeRole.getId());
				if(roles != null && roles.size() >0){
					result.setSuccessful(false);
				}else{
					result.setSuccessful(true);
				}
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 删除公安角色
	 * <b>Function </b> 
	 * 
	 * @param policeRole
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月2日 下午2:09:53
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("delete")
	@RequiresPermissions("roleManager:del")
	public @ResponseBody AjaxResult delete(PoliceRole policeRole) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				policeRoleService.delete(policeRole);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据ID获取明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			PoliceRole policeRole = policeRoleService.findById(id);
			result.setSuccessful(true);
			result.setData(policeRole);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}


	/**
	 * 公安角色管理列表页
	 *
	 * @return
	 */
	@RequestMapping("manage/index")
	@RequiresPermissions("roleManager:query")
	public String manageIndex() {
		return "sys/role/list";
	}


	/**
	 * 公安角色管理新增修改页面
	 *
	 * @return
	 */
	@RequestMapping("edit/index")
	@RequiresPermissions(logical = Logical.OR,value ={"roleManager:edit","roleManager:add","roleManager:copy"})
	public ModelAndView editIndex(PoliceRole policeRole) {
		ModelAndView view = new ModelAndView("sys/role/editRole");
		view.addObject("record",policeRole);
		PoliceSearchDto searchDto = new PoliceSearchDto();

		if(policeRole.getId() != null){
			searchDto.setRoleId(policeRole.getId());
			PoliceRole dbPoliceRole = policeRoleService.findById(policeRole.getId());
			dbPoliceRole.setOptype(policeRole.getOptype());
			view.addObject("record",dbPoliceRole);
			List<DataAuth> dataAuths = dataAuthService.findByRoleId(policeRole.getId());
			Long[] orgIds = dataAuths.stream().map(DataAuth::getOrgid).collect(Collectors.toList()).stream().toArray(Long[]:: new);
			view.addObject("orgIds", JSON.toJSONString(orgIds));
		}
		view.addObject("menuTree", JSON.toJSONString(moduleMenuService.findMenuTreeForPermission(policeRole.getId())));
		view.addObject("orgTree", JSON.toJSONString(policeService.searchForMenuTree(searchDto)));
		return view;
	}

	/***
	 * 公安用户管理查询
	 * @param dto 查询条件参数
	 * @param page 返回数据对象
	 * @return 查询列表
	 */
	@RequestMapping("searchForPage")
	@RequiresPermissions("roleManager:query")
	public @ResponseBody
	AjaxPageResponse searchForPage(RolePageSearchDto dto, AjaxPageResponse<PoliceRoleDto> page){
		try {
			User currentUser = arsUtil.getCurrentUser();
			dto.setPath(currentUser.getPolice().getPath());
			policeRoleService.searchForPage(dto, page);
			return page;
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
	}
}
