package com.bcxin.ars.rest;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sys.MessageLogDao;
import com.bcxin.ars.dto.*;
import com.bcxin.ars.dto.sb.PoliceSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.*;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.*;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.*;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.crypto.BadPaddingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import java.io.*;
import java.util.*;

/**
 * 公安机构管理
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年8月2日 下午1:21:22
 * @注意事项 </b>
 * <b>
 */

@Controller
@RequestMapping("police")
public class PoliceController {
	
	private static final Logger logger = LoggerFactory.getLogger(PoliceController.class);
	
	@Autowired
	private PoliceService policeService;

	@Autowired
	private UserService userService;
	
	@Autowired
	private UserRoleService userRoleService;

	@Autowired
	private PoliceRoleService policeRoleService;
	
	@Autowired
	private PermissionService permissionService;
	
	@Autowired
	private DataAuthService dataAuthService;
	@Autowired
	private MessageLogDao messageLogDao;
	@Autowired
	private ArsRestUtil arsUtil;
	@Autowired
	private ConfigUtils configUtils;
	@Value("${temp-folder}")
	private String tempfolder;
	/**
	 * 查询全部
	 * @return
	 */
	@RequestMapping("getPoliceList")
	public @ResponseBody AjaxResult getPoliceList(PoliceSearchDto policeSearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(policeSearchDto.getUserid() == null) {
				policeSearchDto.setUserid(user.getId());
			}
			if(policeSearchDto.getOrgid() ==null){
				policeSearchDto.setPath(user.getPolice().getPath());
			}else{
				Police police= policeService.findById(policeSearchDto.getOrgid());
				policeSearchDto.setPath(police.getPath());

			}
            if("110100".equals(policeSearchDto.getAreaCode())){
				policeSearchDto.setAreaCode("");
			}
			PoliceSearchDto data = policeService.search(policeSearchDto);
			result.setSuccessful(true);
			result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 查询所属区域
	 * @param policeSearchDto 机构管理信息
	 * @return
	 */
	@RequestMapping("getArea")
	public @ResponseBody AjaxResult getArea(PoliceSearchDto policeSearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(policeSearchDto.getUserid() == null) {
				policeSearchDto.setUserid(user.getId());
			}
			if(policeSearchDto.getOrgid() ==null){
				policeSearchDto.setOrgid(user.getOrgid());
				policeSearchDto.setSearchCondition(user.getOrgid().toString());
			}
			policeSearchDto.setPaging(false);
			PoliceSearchDto data = policeService.search(policeSearchDto);
			result.setData(data);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}

	/**
	 * 查询所属上级机构
	 * @param police 机构管理信息
	 * @return
	 */
	@RequestMapping("getParentorg")
	public @ResponseBody AjaxResult getParentorg(Police police) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<Police> list = policeService.searchParentorg(police);
			result.setData(list);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}

	@RequestMapping("findAllForTreeView")
	public @ResponseBody AjaxResult findAllForTreeView(PoliceSearchDto policeSearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<TreeView> list = policeService.searchForTreeView(policeSearchDto);
			result.setData(list);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}


	/****
	 * 查询机构树型结构
	 * @param policeSearchDto 参数
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("findAllForTreeViewPower")
	public @ResponseBody AjaxResult findAllForTreeViewPower(PoliceSearchDto policeSearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<TreeView> list = policeService.findAllForTreeViewPower(policeSearchDto);
			result.setData(list);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}

	@RequestMapping("findAllForTreeViewByprint")
	public @ResponseBody AjaxResult findAllForTreeViewByprint(PoliceSearchDto policeSearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<TreeView> list = policeService.searchForTreeViewByprint(policeSearchDto);
			result.setData(list);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}
	@RequestMapping("findPoliceForTreeViewByprint")
	public @ResponseBody AjaxResult findPoliceForTreeViewByprint(PoliceSearchDto policeSearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			//获取机构树型结构
			List<TreeView> list = policeService.searchPoliceForTreeViewByprint(policeSearchDto);
			result.setData(list);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}
	/**
	 * 查询全部
	 * @return
	 */
	@RequestMapping("getOrgList")
	public @ResponseBody AjaxResult searchAll(PoliceSearchDto policeSearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(policeSearchDto.getUserid() == null) {
				policeSearchDto.setUserid(user.getId());
			}
			if(policeSearchDto.getOrgid() ==null){
				policeSearchDto.setOrgid(user.getOrgid());
			}


			policeSearchDto.setPath(user.getPolice().getPath());
			PoliceSearchDto data = policeService.searchAll(policeSearchDto);
			List<Police> resultdata =data.getData();

			if(resultdata != null && resultdata.size() > 0){
				List<Police> listtop = new ArrayList<Police>();
				for (Police temp:
						resultdata ) {
					List<Police> childrens = new ArrayList<Police>();
					for (Police temp1:
							resultdata ) {
						if(temp1.getParentorg()!=null && temp.getId().intValue() == temp1.getParentorg()){
							childrens.add(temp1);
						}
					}
					temp.setChildren(childrens);
					listtop.add(temp);
				}
				List<Tree> trees = new ArrayList<Tree>();

					Tree tree = new Tree();
					tree.setExpanded(true);
					tree.setText(listtop.get(0).getOrgname());
					tree.setId(listtop.get(0).getId()+"");
					List<Tree> childrens = new ArrayList<Tree>();
					for (Police police : listtop.get(0).getChildren()) {
						childrens.add(getTreeFormOrg(police,true));
						tree.setChildren(childrens);
					}
				    trees.add(tree);
					result.setSuccessful(true);
					result.setData(trees);

			}else{
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	@RequestMapping("searchForTree")
	@ResponseBody
	public List<Tree> searchForTree(PoliceSearchDto searchDto){
		return policeService.searchForTree(searchDto);
	}

	@RequestMapping("searchForMenuTree")
	@ResponseBody
	public List<MenuTree> searchForMenuTree(PoliceSearchDto searchDto){
		return policeService.searchForMenuTree(searchDto);
	}

	/**
	 * 查询全部 for easyui的 comboTree
	 * @return
	 */
	@RequestMapping("getOrgTrees")
	public @ResponseBody List<Tree> getOrgTrees(PoliceSearchDto policeSearchDto) throws Exception {
		List<Tree> trees = new ArrayList<Tree>();
		try {
			arsUtil.setPoliceSearch(policeSearchDto);
			User user = arsUtil.getCurrentUser();
			//获取当前用户数据角色
			List<Police> aresList =  null;
			//如果没有传父级节点ID，则设置当前用户
			if(policeSearchDto.getParentorg() == null && user.getOrgid() != null) {
				policeSearchDto.setOrgid(user.getOrgid());
				aresList = user.getAreasList();
			}
			if(policeSearchDto.getParentorg() ==null){
				//easyui传过来的是id转成parentorg
				if(policeSearchDto.getId() !=null) {
					policeSearchDto.setParentorg(policeSearchDto.getId());
				}
			}
			PoliceSearchDto data = policeService.searchAll(policeSearchDto);
			List<Police> resultdata =data.getData();
			if(resultdata != null && resultdata.size() > 0){
				List<Police> listtop = new ArrayList<Police>();
				for (Police temp: resultdata ) {
					List<Police> childrens = new ArrayList<Police>();
					for (Police temp1: resultdata ) {
						if(temp1.getParentorg()!=null && temp.getId().intValue() == temp1.getParentorg()){
							childrens.add(temp1);
						}
					}
					temp.setChildren(childrens);
					listtop.add(temp);
				}

				Tree tree = new Tree();
				tree.setExpanded(true);
				tree.setState("open");
				tree.setOrgType(listtop.get(0).getOrgtype());
				tree.setCode(listtop.get(0).getAreacode());
				tree.setText(listtop.get(0).getOrgname());
				tree.setId(listtop.get(0).getId()+"");
				List<Tree> childrens = new ArrayList<Tree>();
				for (Police police : listtop.get(0).getChildren()) {
					childrens.add(getTreeFormOrg(police,policeSearchDto.isExpanded()));
					tree.setChildren(childrens);
				}
				trees.add(tree);
			}

			//数据权限
			if (aresList!=null && aresList.size()>0) {
				for (Police p : aresList) {
					Tree tree = new Tree();
					tree.setExpanded(true);
					tree.setState("open");
					tree.setOrgType(p.getOrgtype());
					tree.setCode(p.getAreacode());
					tree.setText(p.getOrgname());
					tree.setId(p.getId()+"");
					//父级机构ID
					//加到列表加
					trees.add(tree);
				}
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return trees;
	}
	/**
	 * 查询全部 for layui的 selectTree
	 * @return
	 */
	@RequestMapping("getOrgTreesForLay")
	public @ResponseBody List<LayTree> getOrgTreesForLay(PoliceSearchDto policeSearchDto) throws Exception {
		return policeService.searchForLayTree(policeSearchDto);
	}

	/**
	 * 指派民警用
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("getOrgListForAssignPolice")
	public @ResponseBody AjaxResult getOrgListForAssignPolice() throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			Police police = policeService.findById(user.getOrgid());
				List<Tree> trees = new ArrayList<Tree>();
				Tree tree = new Tree();
				tree.setExpanded(true);
				tree.setText(police.getOrgname());
				tree.setId(police.getId()+"");
				trees.add(tree);
				result.setSuccessful(true);
				result.setData(trees);

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	private Tree getTreeFormOrg(Police org,Boolean expanded){
		Tree tree = new Tree();
		tree.setId(org.getId()+"");
		tree.setText(org.getOrgname());
		tree.setOrgType(org.getOrgtype());
		tree.setCode(org.getAreacode());
		if(expanded){
			tree.setState("open");
		}
		if(org.getChildren() != null && org.getChildren().size() > 0){
			List<Tree> childTrees = new ArrayList<Tree>();
			for(Police childOrg:org.getChildren()){
				childTrees.add(getTreeFormOrg(childOrg,expanded));
			}
			tree.setChildren(childTrees);
		}
		return tree;
	}

	private LayTree getLayTreeFormOrg(Police org,Boolean expanded){
		LayTree tree = new LayTree();
		tree.setId(org.getId()+"");
		tree.setName(org.getOrgname());
		tree.setCode(org.getAreacode());
		tree.setOpen(expanded);
		if(org.getChildren() != null && org.getChildren().size() > 0){
			List<LayTree> childTrees = new ArrayList<LayTree>();
			for(Police childOrg:org.getChildren()){
				childTrees.add(getLayTreeFormOrg(childOrg,expanded));
			}
			tree.setChildren(childTrees);
		}
		return tree;
	}

	/**
	 * 创建或更新机构管理信息
	 * @param police 机构管理信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody AjaxResult update(Police police) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			policeService.saveOrUpdate(police);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}
	/**
	 * 删除机构管理信息
	 * @return
	 */
	@RequestMapping("delete/{id}")
	public @ResponseBody AjaxResult delete(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Police police = policeService.findById(id);

			//如果机构从内网导出到外网，则不允许删除
			if(null!=police && police.isExport){
				throw new ArsException("当前机构已经导出，不允许删除!");
			}
			//查询该机构下的用户
			UserSearchDto userSearchDto =new UserSearchDto();
			userSearchDto.setPaging(false);
			userSearchDto.setPlatform("1");
			userSearchDto.setOrgid(id);
			userSearchDto.setIncludeSub(true);
			UserSearchDto userdata = userService.search(userSearchDto);

			if(userdata.getData().size()>0){
				throw new ArsException("当前机构或下属机构中有用户不允许删除!");
			}

			if(police != null) {
				policeService.delete(police);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
					result.setMsg("删除信息失败，ID:" + id);
				}

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据ID获取机构管理信息
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Police police = policeService.findById(id);
			result.setSuccessful(true);
			result.setData(police);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	

	/**
	 * 批量导入机构角色用户数据(数据库导入）
	 */
	@RequestMapping("importData")
	@Deprecated
	public @ResponseBody AjaxResult importData(MultipartFile file,HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User currentUser = arsUtil.getCurrentUser();
			Date now = new Date();
			String fileName = now.getTime() + "_" + file.getOriginalFilename();
			String dirDate = DateUtil.systemDate.format(now);
			File dir = new File(tempfolder + dirDate);
			if(!dir.exists()) {
				dir.mkdirs();
			}
			String targetPath = tempfolder + dirDate + "/" + fileName;
			File targetFile = new File(targetPath);
			logger.info("执行文件上传..." + targetFile);
			file.transferTo(targetFile);
			
			BufferedReader br = new BufferedReader(new FileReader(targetFile));
			StringBuffer content = new StringBuffer();
			// 获取文件内容
			String lineTxt = null;
			while ((lineTxt = br.readLine()) != null) {// 使用readLine方法，一次读一行
				content.append(lineTxt);
			}
			br.close();

			//TODO
			String jsonStr = new String(CipherDESUtil.decrypt(Encodes.decodeHex(content.toString()), Constants.APPROVAL_KEY));
			DataSycDto dataSycDto = JSONObject.parseObject(jsonStr, DataSycDto.class);
			if(dataSycDto != null) {
				if(dataSycDto.getDataType().equals(Constants.DATASYC_ORGUSER_LIST)) {
					
		            new Thread(()->{ //异步处理
		    			try {
		    				OrgUserDto orgUser = JSONObject.parseObject(dataSycDto.getData(), OrgUserDto.class);
							
							if(orgUser != null){
								List<Police> policelist = orgUser.getPolicelist();
								List<PoliceRole> policeRolelist = orgUser.getPoliceRolelist();
								List<User> userlist = orgUser.getUserlist();
//								List<UserRole> userRolelist = orgUser.getUserRolelist();
//								List<Permission> permissionlist = orgUser.getPermissionlist();
//								List<DataAuth> dataAuthlist = orgUser.getDataAuthlist(); 
								if(policelist != null && policelist.size() > 0){
									for (Police police : policelist) {
										policeService.saveOrUpdateForImport(police);
									}
								}

								if(policeRolelist != null && policeRolelist.size() > 0){
									for (PoliceRole policeRole : policeRolelist) {
										policeRoleService.saveOrUpdateForImport(policeRole);
									}
								}
								
								if (userlist != null && userlist.size() > 0) {
				                    for (User user : userlist) {
				                      /*  User dbUser = userService.findByInRawId(user.getId());
				                        user.setInrawid(user.getId());
				                        if (dbUser != null) {
				                            user.setId(dbUser.getId());
				                        } else {
				                            if(user.getRawid() != null){
				                                dbUser = userService.findById(user.getRawid());
				                                if(dbUser != null){
				                                    user.setId(dbUser.getId());
				                                }else{
				                                    user.setId(null);
				                                }
				                            }else{
				                                user.setId(null);
				                            }
				                        }*/
				                        userService.saveOrUpdateForImport(user);
				                    }
				                }
							}
							MessageUtil.sendMessage(currentUser.getPhone(), Constants.POLICE_IMPORTDATA_MESSAGE,messageLogDao);

		    			} catch(Exception e) {
							MessageUtil.sendMessage(currentUser.getPhone(), Constants.POLICE_IMPORTDATA_MESSAGE_FAIL,messageLogDao);
		    				e.printStackTrace();
		    			}
		    		}).start();
					
					result.setMsg("数据导入中，导入成功后将会短信通知您！");
		            result.setSuccessful(true);
				}else {
		            result.setMsg("导入失败，非机构角色用户的数据！");
		            result.setSuccessful(false);
				}
			}else {
				result.setMsg("导入失败，非机构角色用户的数据！");
	            result.setSuccessful(false);
			}
			
            Map<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("faildFilePath", "");
            result.setData(resultMap);
            result.setSuccessful(true);
		} catch (BadPaddingException badPaddingException){
			logger.error(badPaddingException.getMessage(), badPaddingException);
			throw new ArsException("导入失败，非该区域数据\n！");
		}catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	

	/**
	 * 批量导出机构角色用户数据-生成data(数据库数据导出）
	 * @param request
	 */
	@RequestMapping("createData")
	@Deprecated
	public @ResponseBody AjaxResult createData(HttpServletRequest request) throws Exception{
		AjaxResult result = new AjaxResult();
		try{
			User user = arsUtil.getCurrentUser();
			if(user != null) {

			    //默认同步最近两天的数据
				OrgUserDto orgUserDto =policeService.findOrgUserForDS(DateUtil.getYesterday());


				List<Police> policelist = orgUserDto.getPolicelist();


				//1.确定  第一次导出机构的个数
				int j =0;
				for (int i = 0; i < policelist.size(); i++) {
					if(!policelist.get(i).isExport){

						j++;
					}
				}
				//如果查询出来的isExport都等于1，则内网无法再次修改
				if (0!=j){
					//2.定义数组 存放机构的ID

					Long[] policeIdArrs = new Long[j];
					for (int i = 0,k=0; i < policelist.size(); i++) {
						if(!policelist.get(i).isExport){
							policeIdArrs[k++] = policelist.get(i).getId();
						}
					}
					//3.更新 是否导出isexport标志位为true
					PoliceSearchDto policeSearchDto = new PoliceSearchDto();
					policeSearchDto.setPoliceIdArrs(policeIdArrs);
					policeSearchDto.setExport(true);
					policeService.updateExport(policeSearchDto);

				}


				if((orgUserDto.getPolicelist()!= null && orgUserDto.getPolicelist().size() > 0) || (orgUserDto.getPoliceRolelist() != null && orgUserDto.getPoliceRolelist() .size() > 0) || (orgUserDto.getUserlist() != null && orgUserDto.getUserlist().size() > 0) ) {
					Date now = new Date();
					String dirDate = DateUtil.systemDate.format(now);
					File dir = new File(tempfolder + dirDate);
					if(!dir.exists()) {
						dir.mkdirs();
					}
					DataSycDto dataSycDto = new DataSycDto();
					dataSycDto.setDataType(Constants.DATASYC_ORGUSER_LIST);
					dataSycDto.setData(JSONObject.toJSONString(orgUserDto));
					
					String listStr = JSONObject.toJSONString(dataSycDto);
                    String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(listStr.getBytes(), Constants.APPROVAL_KEY));
                    
                    String filepath = FileUtil.writeTxtFile(content,"orgUser",tempfolder);

                    if(StringUtil.isNotEmpty(filepath)){
                    	result.setData(filepath);
                    	result.setSuccessful(true);
                    }else{
                    	result.setSuccessful(false);
                    	result.setMsg("导出失败，请联系系统管理员确认！");
                    }

				}else{
					result.setSuccessful(false);
				}
			}
		}catch(Exception e){
			throw e;
		}
		return result;
	}
	

	/**
	 * 批量导出机构角色用户数据
	 * @param response
	 * @param response
	 * @throws Exception
	 */
	@RequestMapping("exportData")
	@Deprecated
	public void exportData(String templateName, HttpServletResponse response)throws Exception{
		User user = arsUtil.getCurrentUser();
		if(user != null) {
			File file = new File(templateName);
			if(file != null) {
				ServletOutputStream out = response.getOutputStream();
				String fileName = new String(file.getName().substring(file.getName().indexOf("_")+1).getBytes("UTF-8"),"iso-8859-1");
				response.addHeader("Content-Disposition","attachment;filename=" + fileName);
				InputStream is = new FileInputStream(file);
				int read = 0;
				byte[] buffer = new byte[8192];
				while ((read = is.read(buffer)) != -1) {
					out.write(buffer, 0, read);
				}
				is.close();
				out.flush();
				out.close();
			}
		}
	}

	/**
	 * 根据区域编码查询police
	 * @param police
	 * @return
	 */
	@RequestMapping("findPoliceByAreacode")
	public @ResponseBody AjaxResult findPoliceByAreacode(Police police) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<Police> list = policeService.findPoliceByAreacode(police);
			result.setData(list);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}

	/**
	 * 机构查询
	 * @param policeSearchDto
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("search")
	public @ResponseBody
	AjaxResult search(PoliceSearchDto policeSearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			//如果上级机构id没传，查询市级机构
			if(policeSearchDto.getParentorg() == null){
				policeSearchDto.setOrgtype(Constants.POLICE_ORGTYPE_SHI);
			}
			List<PoliceDto> data = policeService.searchForSaas(policeSearchDto);
			result.setSuccessful(true);
			result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
