package com.bcxin.ars.rest;

import java.util.List;

import com.bcxin.ars.model.User;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.Permission;
import com.bcxin.ars.service.PermissionService;
import com.bcxin.ars.service.util.ArsUtil;

@Controller
@RequestMapping("permission")
public class PermissionController {

	private Logger logger = LoggerFactory.getLogger(PermissionController.class);
	
	@Autowired
	private PermissionService permissionService;
	
	@Autowired
	private ArsUtil arsUtil;

	/**
	 * 
	 * <b>Function </b> 保存角色权限
	 * 
	 * @param id //角色id即 roleid
	 * @param operationIds
	 * @return
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("save")
	public @ResponseBody AjaxResult save(Long id,Long[] operationIds,String roletype) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			permissionService.saveOrUpdate(id, operationIds,roletype);
			result.setSuccessful(true);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 
	 * <b>Function </b> 根据角色获取权限
	 * 
	 * @param  id //角色id即 roleid
	 * @return
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("getByRole")
	public @ResponseBody AjaxResult getByRole(Long id,String roletype) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user  = arsUtil.getCurrentUser();
			List<Permission> permissions = null;
			if(user.getPlatform()==1) {//公安
				permissions = permissionService.findByRole(id, roletype, Constants.MODULE_GA);
			}else{//公司
				permissions = permissionService.findByRole(id, roletype,Constants.MODULE_BA);
			}
			if(permissions !=null && permissions.size() > 0){
				result.setSuccessful(true);
				result.setData(permissions);
			}else{
				result.setSuccessful(false);
//				result.setMsg("无相关数据！");
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
}
