package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.Tree;
import com.bcxin.ars.model.*;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.OrganizationService;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;

@Controller
@RequestMapping("org")
public class OrganizationController {

	private Logger logger = LoggerFactory.getLogger(OrganizationController.class);

	@Autowired
	private OrganizationService orgService;

	@Autowired
	private SecurityCompanyService companyService;

	@Autowired
	private SecurityPersonService personService;

	@Autowired
	private UserService userService;

	@Autowired
	private ArsRestUtil arsUtil;

	/**
	 * 根据ID获取组织架构明细
	 * @param id
	 * @param request
	 * @return
	 */
	@RequestMapping("detail/{id}")
	public @ResponseBody AjaxResult detail(@PathVariable("id")Long id, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Organization org = orgService.findById(id);
			result.setSuccessful(true);
			result.setData(org);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 获取当前登录安保公司的组织架构列表
	 * @param request
	 * @return
	 */
	@RequestMapping("getOrgListOld")
	public @ResponseBody AjaxResult getOrgListOld(HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			Long userid = user.getId();
			SecurityCompany company = null;
			if(user.getPlatform() == 1){
				String useridString = request.getParameter("userid");
				if(StringUtil.isNotEmpty(useridString)){
					userid = Long.parseLong(useridString);
					company = companyService.findByUserid(Long.parseLong(useridString));
				}
			}else if(user.getPlatform() == 2){
				company = companyService.findByUserid(userid);
			}

			if(company == null){
				result.setSuccessful(false);
			}else{
//				List<OrganizationDto> orgList = orgService.findByCompany(company.getId());
				List<Organization> orgList = orgService.findByCompany(company.getId());
//				if(orgList != null && orgList.size() > 0){
				List<Tree> trees = new ArrayList<Tree>();
				Tree tree = new Tree();
				tree.setExpanded(true);
				Integer count = 0 ;
				List<Tree> childrens = new ArrayList<Tree>();
				for (Organization organization : orgList) {
					organization.setCompanyId(company.getId());
					childrens.add(getTreeFormOrg(organization,count));
				}
				tree.setText(company.getName()+"("+(company.getSecurityAmount() == null ? 0:company.getSecurityAmount()) +")");
				tree.setChildren(childrens);
				trees.add(tree);
				result.setSuccessful(true);
				result.setData(trees);
				if(orgList != null && orgList.size() > 0){
					result.setSuccessful(true);
				}else{
					result.setSuccessful(false);
				}
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 获取当前登录安保公司的组织架构列表重新优化
	 * @param request
	 * @return
	 * by llc 2018-08-29
	 */
	@RequestMapping("getOrgList")
	public @ResponseBody AjaxResult getOrgList(HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			Long userid = user.getId();
			SecurityCompany company = null;
			if(user.getPlatform() == 1){
				String useridString = request.getParameter("userid");
				if(StringUtil.isNotEmpty(useridString)){
					userid = Long.parseLong(useridString);
					company = companyService.findByUserid(Long.parseLong(useridString));
				}
			}else if(user.getPlatform() == 2){
				company = companyService.findByUserid(userid);
			}
			if(company == null){
				result.setSuccessful(false);
			}else{
				List<OrganizationDto> orgList = orgService.findOrgInfoByCompanyId(company.getId());
				List<Tree> trees = new ArrayList<Tree>();
				Tree tree = new Tree();
				tree.setExpanded(true);
				List<Tree> childrens = new ArrayList<Tree>();
				List<OrganizationDto> orgList2 = new ArrayList<>();
				for (OrganizationDto dto : orgList) {
					List<OrganizationDto> childrenList = new ArrayList<OrganizationDto>();
					for (OrganizationDto dto2 : orgList) {
						if(dto2.getParentId() != null && dto.getId().equals(dto2.getParentId())){
							childrenList.add(dto2);
						}
					}
					dto.setChildrens(childrenList);
					orgList2.add(dto);
				}
				for (OrganizationDto dto : orgList2) {
					/*** 从第一级的部门处理 ***/
					if(dto.getParentId() == null) {
						childrens.add(getTreeFormOrgNew(dto));
					}
				}
				tree.setText(company.getName()+"("+(company.getSecurityAmount() == null ? 0:company.getSecurityAmount()) +")"); // 公司标题
				tree.setChildren(childrens);
				trees.add(tree);
				result.setSuccessful(true);
				result.setData(trees);
				if(orgList != null && orgList.size() > 0){
					result.setSuccessful(true);
				}else{
					result.setSuccessful(false);
				}
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 把组织机构递归处理生成树
	 * @param org
	 * @return
	 * by llc 2018-08-29
	 */
	private Tree getTreeFormOrgNew(OrganizationDto org){
		Tree tree = new Tree();
		tree.setId(org.getId()+"");
		int count = org.getPesonNum() ;
		count = getChildrenPersonNum(org,count);
		tree.setText(org.getOrgName()+"("+count+")"); // 部门标题
		/*** 递归处理 ***/
		if(org.getChildrens() != null && org.getChildrens().size() > 0){
			List<Tree> childTrees = new ArrayList<Tree>();
			for(OrganizationDto childOrg : org.getChildrens()){
				childOrg.setCompanyId(org.getCompanyId());
				childTrees.add(getTreeFormOrgNew(childOrg));
			}
			tree.setChildren(childTrees);
		}
		return tree;
	}

	/***
	 * 递归获取子节点的人数
	 * @param org
	 * @param count
	 * @return count
	 * by llc 2018-09-01
	 */
	public static int getChildrenPersonNum(OrganizationDto org,int count){
		;
		for (OrganizationDto temp :
				org.getChildrens()) {
			count += temp.getPesonNum();
			if(temp.getChildrens()!= null && temp.getChildrens().size()>0){
				/*** 这里count为0 是防止重复计算父节点的人数 ***/
				count += getChildrenPersonNum(temp,0);
			}
		}
		return count;
	}

	/**
	 * 创建或更新组织架构
	 * @param org	基本信息
	 * @param parentId	父机构ID
	 * @param request
	 * @return
	 */
	@RequestMapping(value="update", method=RequestMethod.POST)
	public @ResponseBody AjaxResult update(Organization org, @RequestParam(value="parentId",required=false)Long parentId, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			SecurityCompany company = companyService.getCurrentUserCompany();
			if(company != null) {
				org.setCompany(company);
				if(parentId != null) {
					Organization parent = new Organization();
					parent.setId(parentId);
					org.setParent(parent);
				}
				orgService.saveOrUpdate(org);
				result.setSuccessful(true);
				result.setData(org.getId());
			} else {
				result.setSuccessful(false);
				result.setMsg("当前安保公司信息错误，Userid:" + user.getId());
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 删除组织架构
	 * @param org	基本信息
	 * @param request
	 * @return
	 */
	@RequestMapping(value="delete", method=RequestMethod.POST)
	public @ResponseBody AjaxResult delete(Organization org, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null){
				orgService.delete(org);
				result.setSuccessful(true);
				result.setData(org.getId());
			} else {
				result.setSuccessful(false);
				result.setMsg("当前用户信息错误");
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	private Tree getTreeFormOrg(Organization org,Integer count){
		Tree tree = new Tree();
		tree.setId(org.getId()+"");
		List<Long> ids = getChildrenIds(org);
		ids.add(org.getId());
		org.setIds(ids);
		org.setNumber(orgService.queryCount(org).intValue());
		count += org.getNumber();
		tree.setText(org.getName()+"("+org.getNumber()+")");
		if(org.getChildren() != null && org.getChildren().size() > 0){
			List<Tree> childTrees = new ArrayList<Tree>();
			for(Organization childOrg : org.getChildren()){
				childOrg.setCompanyId(org.getCompanyId());
				childTrees.add(getTreeFormOrg(childOrg,count));
			}
			tree.setChildren(childTrees);
		}
		return tree;
	}

	/***
	 * 获取子节点的所有ID值
	 * @param org
	 * @return
	 */
	public static List<Long> getChildrenIds(Organization org){
		List<Long> result = new ArrayList<Long>();
		for (Organization temp :
				org.getChildren()) {
			result.add(temp.getId());
			if(temp.getChildren()!=null && temp.getChildren().size()>0){
				List<Long> ids = getChildrenIds(temp);

				for (Long id :
						ids) {
					result.add(id);
				}
			}
		}
		return result;
	}




	@RequestMapping("updateInitstep")
	public @ResponseBody AjaxResult updateInitstep() throws Exception{
		AjaxResult result = new AjaxResult();
		try {

			User currentUser = arsUtil.getCurrentUser();
			currentUser.setInitstep(Constants.INTISTEP_ORG);
			userService.updateInitstep(currentUser);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}

}
