package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.OrderPersonSearchDto;
import com.bcxin.ars.dto.sb.SbPunishSearchDto;
import com.bcxin.ars.model.SbPunish;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.OrderPersonService;
import com.bcxin.ars.service.SbPunishService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;


@Controller
@RequestMapping("orderperson")
public class OrderPersonController {
	
	private static final Logger logger = LoggerFactory.getLogger(OrderPersonController.class);
	
	@Autowired
	private OrderPersonService orderPersonService;

	@Autowired
	private ArsRestUtil arsUtil;

	/**
	 * 根据订单ID查询全部
	 * @return
	 */
	@RequestMapping("findAllByOrderid")
	public @ResponseBody AjaxResult search(OrderPersonSearchDto dto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			OrderPersonSearchDto data = orderPersonService.findByOrderid(dto);
				result.setSuccessful(true);
				result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

}
