package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.Module;
import com.bcxin.ars.model.User;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.ModuleService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Controller
@RequestMapping("module")
public class ModuleController {
	
	@Autowired
	private ModuleService moduleService;
	@Autowired
	private ArsRestUtil arsUtil;

	/**
	 * 获取权限模块列表
	 * @param request
	 * @return
	 */
	@RequestMapping("findAllPerson")
	public @ResponseBody AjaxResult findAllPerson(HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
//			if(user.getPlatform() == 2) {//保安公司
				List<Module> data = moduleService.findAllPerson();
				result.setData(data);
//			}else{//保安人员
//				List<Module> data = moduleService.findByUserId(user.getId());
//				result.setData(data);
//			}
			result.setSuccessful(true);

		} catch (Exception e) {
			throw e;
		}
		return result;
	}
	
	/**
	 * 获取权限模块列表
	 * @param request
	 * @return
	 */
	@RequestMapping("findAllPolice")
	public @ResponseBody AjaxResult findAllPolice(HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			List<Module> data = moduleService.findAllPolice(user.getId());
			result.setSuccessful(true);
			result.setData(data);
		} catch (Exception e) {
			throw e;
		}
		return result;
	}

	/**
	 * 获取角色权限树形
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("getModuleTree")
	public @ResponseBody
	AjaxResult getCompanyTree(){
		AjaxResult result = new AjaxResult();
		try {
			result.setSuccessful(true);
			result.setData(moduleService.getModuleTree());
		} catch (Exception e) {
			throw e;
		}
		return result;
	}
}
