package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.FilerecordStatusSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.FilerecordStatus;
import com.bcxin.ars.model.MobileConfig;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.FilerecordStatusService;
import com.bcxin.ars.service.MobileConfigService;
import com.bcxin.ars.util.Constants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Controller
@RequestMapping("filerecordStatus")
public class FilerecordStatusController {

	private Logger logger = LoggerFactory.getLogger(FilerecordStatusController.class);

	
	@Autowired
	private FilerecordStatusService filerecordStatusService;

	/**
	 * 查询全部
	 * @return
	 */
	@RequestMapping("search")
	public @ResponseBody AjaxResult search(FilerecordStatusSearchDto dto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			FilerecordStatusSearchDto data = filerecordStatusService.search(dto);
			result.setSuccessful(true);
			result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	

}
