package com.bcxin.ars.rest;

import com.abcxin.smart.validator.annotation.DataSyncAnnotation;
import com.abcxin.smart.validator.annotation.DataSyncOutAnnotation;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.ApprovalDTO;
import com.bcxin.ars.dto.DataSynchronizationSearchDto;
import com.bcxin.ars.dto.sb.DatasyncSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.Datasync;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.task.Task;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.DatasyncService;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.task.TaskService;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.service.util.DataSyncContantsUtil;
import com.bcxin.ars.service.util.DataSyncUtil;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;


@Controller
@RequestMapping("datasync")
public class DatasyncController {
	
	private static final Logger logger = LoggerFactory.getLogger(DatasyncController.class);
	
	@Autowired
	private DatasyncService datasyncService;

	@Autowired
	private ArsRestUtil arsUtil;

	@Autowired
	private TaskService taskService;

	@Autowired
	private ApprovalService approvalService;

	@Autowired
	private ConfigUtils configUtils;

	@Autowired
	private DataSyncContantsUtil dataSyncContantsUtil;

	@Autowired
	private DataSyncUtil dataSyncUtil;

	@Value("${task-download-folder}")
	private String downloadFolder;

	@Value("${time-approval-download-folder}")
	private String spdownloadFolder;


    /**
     * 数据同步页面进入
     * @return
     */
	@RequestMapping("index")
	public String approvalIndex() {
		return "dataSync/index";
	}

    /**
     * 导入数据
     * @param file
     * @return
     * @throws Exception
     */
	@RequestMapping("importData")
	public @ResponseBody
	AjaxResult importData(MultipartFile file) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Class dataSyncClass = null;
			if(configUtils.isIntranet()){
				dataSyncClass = DataSyncAnnotation.class;
			}else{
				dataSyncClass = DataSyncOutAnnotation.class;
			}

			if (!file.getOriginalFilename().startsWith(configUtils.getDataSyncStartFileName(dataSyncClass))) {
				throw new ArsException("导入失败，非该环境同步数据！");
			}
			String fileName = file.getOriginalFilename();
			String dirDate = DateUtil.getCurrentDate();
			File dir = new File(configUtils.tempfolder + dirDate);
			if (!dir.exists()) {
				dir.mkdirs();
			}
			String targetPath = configUtils.tempfolder + dirDate + "/" + fileName;
			File targetFile = new File(targetPath);
			logger.info("执行文件上传..." + targetFile);
			file.transferTo(targetFile);
			dataSyncUtil.readDSFile(dataSyncClass,targetFile);
			targetFile.delete();
			result.setData(fileName);
			result.setSuccessful(true);
			result.setMsg("导入完成！");
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 *
	 * 生成同步数据文件（仅适用与内网数据导入到外网）
	 * @param startDate 开始时间
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("createDSFile")
	public @ResponseBody AjaxResult createDSFile(String startDate) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				String filePath = null;
				if(configUtils.isIntranet()) {
					filePath = dataSyncUtil.createDSFile(startDate, null);
				}else{
					//外网生成同步文件
					DataSynchronizationSearchDto searchDto = new DataSynchronizationSearchDto();
					searchDto.setPaging(false);
					searchDto.setStartDate(startDate);
					searchDto.setEndDate(DateUtil.getTomorrow());
					filePath = dataSyncUtil.createDSFile(DataSyncAnnotation.class,searchDto,null);
				}
				if(StringUtil.isNotEmpty(filePath)){
					result.setData(filePath);
					result.setSuccessful(true);
				}else{
					result.setSuccessful(false);
					result.setMsg("没有需要导出的数据！");
				}
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 *
	 * 生成同步数据文件到摆渡通道（仅适用与内网数据导入到外网）
	 * @param startDate 开始时间
	 * @return
	 * @throws Exception
	 */
	@RequestMapping("createDSFileToFTP")
	public @ResponseBody AjaxResult createDSFileToFTP(String startDate) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if (user != null) {
				String filePath = null;
				if(configUtils.isIntranet()) {
					String dirDate = DateUtil.getCurrentDate();
					if (Constants.DATASYNC_SWITCH_1.equals(configUtils.getValueByKey(Constants.DATASYNC_SWITCH))) {
						filePath = dataSyncContantsUtil.ftpInFolder + dirDate + File.separatorChar;
						dataSyncUtil.createDSFile(startDate, filePath);
					}else{
						if(!Constants.BEIJING.equals(configUtils.getCurrentNative())) {
							datasyncService.createToOutDataFile(startDate);
						}else{
							datasyncService.createToOutDataFileByHttp(startDate);
						}
					}
				}else{
					//外网生成同步文件
					DataSynchronizationSearchDto searchDto = new DataSynchronizationSearchDto();
					searchDto.setPaging(false);
					searchDto.setStartDate(startDate);
					searchDto.setEndDate(DateUtil.getTomorrow());
					if (Constants.DATASYNC_SWITCH_1.equals(configUtils.getValueByKey(Constants.DATASYNC_SWITCH))) {
						filePath = dataSyncContantsUtil.ftpOutFolder + DateUtil.getCurrentDate()+File.separator;
					}else{
						filePath = configUtils.ftpFolder + DateUtil.getCurrentDate()+File.separator;
					}
					dataSyncUtil.createDSFile(DataSyncAnnotation.class,searchDto,filePath);
				}
				if(StringUtil.isNotEmpty(filePath)){
					result.setData(filePath);
					result.setSuccessful(true);
				}else{
					result.setSuccessful(false);
					result.setMsg("没有需要导出的数据！");
				}
			} else {
				result.setSuccessful(false);
			}
		} catch (Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 生成并下载同步数据文件
	 *
	 * @param templateName
	 * @param response
	 * @throws Exception
	 */
	@RequestMapping("exportData")
	public void exportData(String templateName, HttpServletResponse response) throws Exception {
		User user = arsUtil.getCurrentUser();
		if (user != null) {
			File file = new File(templateName);
			if (file != null) {
				ServletOutputStream out = response.getOutputStream();
				response.addHeader("Content-Disposition", "attachment;filename=" + file.getName());
				InputStream is = new FileInputStream(file);
				int read = 0;
				byte[] buffer = new byte[8192];
				while ((read = is.read(buffer)) != -1) {
					out.write(buffer, 0, read);
				}
				is.close();
				out.flush();
				out.close();
				file.delete();
			}
		}
	}

	/**
	 * 查询全部
	 * @return
	 */
	@RequestMapping("getDatasyncList")
	public @ResponseBody AjaxResult search(DatasyncSearchDto datasyncSearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			DatasyncSearchDto data = datasyncService.search(datasyncSearchDto);
				result.setSuccessful(true);
				result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 创建或更新数据同步信息
	 * @param datasync 数据同步信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody AjaxResult update(Datasync datasync, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			datasyncService.saveOrUpdate(datasync);
			result.setSuccessful(true);
		} catch(Exception e) {
			throw e;
		}
		return result;
	}
	/**
	 * 删除数据同步信息
	 * @return
	 */
	@RequestMapping("delete/{id}")
	public @ResponseBody AjaxResult delete(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Datasync datasync = datasyncService.findById(id);

			if(datasync != null) {
				datasyncService.delete(datasync);
					result.setSuccessful(true);
				} else {
					result.setSuccessful(false);
					result.setMsg("删除信息失败，ID:" + id);
				}

		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据ID获取数据同步信息
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Datasync datasync = datasyncService.findById(id);
			result.setSuccessful(true);
			result.setData(datasync);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 一键导出
	 * @return
	 */
	@RequestMapping("createExcel")
	@Deprecated
	public @ResponseBody AjaxResult improtAll() throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			DatasyncSearchDto datasyncSearchDto = new DatasyncSearchDto();
			datasyncSearchDto.setPaging(false);
			List<Datasync> list = datasyncService.search(datasyncSearchDto).getData();
			for(Datasync datasync:list){
				//紧急任务导出
				if("1".equals(datasync.getOpfun())){
					Task data = taskService.findById(datasync.getBid());
					if(data != null) {
						Date now = new Date();
						String dirDate = DateUtil.systemDate.format(now);
						File dir = new File(downloadFolder + dirDate);
						if (!dir.exists()) {
							dir.mkdirs();
						}
						String templateName = downloadFolder + dirDate + "/" + (now.getTime() + "_任务.xls");
						datasync.setTemplateName(templateName);
						File file = new File(templateName);
						taskService.exportTask(data, file);
					}

                //审批导出
				}else if("2".equals(datasync.getOpfun())) {
					ApprovalDTO dto = new ApprovalDTO();
					dto.setPaging(false);
					dto.setOrgid(datasync.getBid());
					Calendar calendar = new GregorianCalendar();
					if (null != dto.getEndDate() && !"".equals(dto.getEndDate())) {
						calendar.setTime(dto.getEndDate());
						calendar.add(calendar.DATE, 1);
						dto.setEndDate(calendar.getTime());
					}

					ApprovalDTO data = approvalService.query(dto);

					if (data.getData() != null) {
						Date now = new Date();
						String dirDate = DateUtil.systemDate.format(now);
						File dir = new File(spdownloadFolder + dirDate);
						if (!dir.exists()) {
							dir.mkdirs();
						}
						String templateName = spdownloadFolder + dirDate + "/" + (now.getTime() + "_审批列表.xls");
						File file = new File(templateName);
						datasync.setTemplateName(templateName);
						approvalService.exportApprovals(data.getData(), file);
					}
				}
			}

			result.setSuccessful(true);
			result.setData(list);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 导出
	 * @param templateName
	 * @param response
	 * @throws Exception
	 */
	@RequestMapping("exportAll")
	public void exportAll(String templateName, HttpServletResponse response)throws Exception{
		User user = arsUtil.getCurrentUser();
		if(user != null) {
	//		String[] filenames = templateName.split(",");
			ServletOutputStream out=null;
			InputStream is=null;
//			for(String filename:filenames){
				File file = new File(templateName);
				if(file != null) {
					out = response.getOutputStream();
					String fileName = new String(file.getName().substring(file.getName().indexOf("_")+1).getBytes("UTF-8"),"iso-8859-1");
					response.addHeader("Content-Disposition","attachment;filename=" + fileName);
					 is = new FileInputStream(file);
					int read = 0;
					byte[] buffer = new byte[8192];
					while ((read = is.read(buffer)) != -1) {
						out.write(buffer, 0, read);
					}

	//			}
				if(null!=is){
					is.close();
				}
				if(null!=out){
					out.flush();
					out.close();
				}

			}
		}
	}
}
