package com.bcxin.ars.rest;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataAuthSearchDto;
import com.bcxin.ars.model.DataAuth;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.DataAuthService;
import com.bcxin.ars.service.util.ArsUtil;

/**
 * 数据权限
 * <b>Function </b>
 * 
 * @author LinQingLin
 * @date 2017年8月2日 下午3:49:49
 * @注意事项 </b>
 * <b>
 */
@Controller
@RequestMapping("dataAuth")
public class DataAuthController {

	Logger logger = LoggerFactory.getLogger(DataAuthController.class);
	
	@Autowired
	private DataAuthService dataAuthService;
	
	@Autowired
	private ArsUtil arsUtil;
	
	/**
	 * 查询数据权限列表
	 * <b>Function </b> 
	 * 
	 * @param dto
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月2日 下午3:56:39
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("search")
	public @ResponseBody AjaxResult search(DataAuthSearchDto dto) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
//				if(dto.getUserid() == null){
//					dto.setUserid(user.getId());
//				}
				DataAuthSearchDto list = dataAuthService.search(dto);
				result.setSuccessful(true);
				result.setData(list);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 新增或者修改数据权限
	 * <b>Function </b> 
	 * 
	 * @param dataAuth
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月2日 下午3:56:51
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("update")
	public @ResponseBody AjaxResult update(DataAuth dataAuth) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				dataAuthService.saveOrUpdate(dataAuth);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 删除数据权限
	 * <b>Function </b> 
	 * 
	 * @param dataAuth
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月2日 下午3:57:11
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("delete")
	public @ResponseBody AjaxResult delete(DataAuth dataAuth) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user != null) {
				result.setSuccessful(true);
				dataAuthService.delete(dataAuth);
			} else {
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	/**
	 * 根据ID获取数据权限明细
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			DataAuth dataAuth = dataAuthService.findById(id);
			result.setSuccessful(true);
			result.setData(dataAuth);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 根据机构id获取数据权限
	 * <b>Function </b> 
	 * 
	 * @param orgid
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月2日 下午3:57:30
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("findByOrgId/{orgid}")
	public @ResponseBody AjaxResult findByUserId(@PathVariable("orgid")Long orgid) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<DataAuth> dataAuth = dataAuthService.findByOrgId(orgid);
			result.setSuccessful(true);
			result.setData(dataAuth);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 根据角色id获取数据权限
	 * <b>Function </b> 
	 * 
	 * @param roleid
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月2日 下午3:57:49
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("findByRoleId/{roleid}")
	public @ResponseBody AjaxResult findByRoleId(@PathVariable("roleid")Long roleid) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<DataAuth> dataAuths = dataAuthService.findByRoleId(roleid);
			result.setSuccessful(true);
			result.setData(dataAuths);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * 保存数据权限
	 * <b>Function </b> 
	 * 
	 * @param roleid
	 * @param orgIds
	 * @return
	 * @throws Exception
	 * @author LinQingLin 
	 * @date 2017年8月2日 下午3:58:07
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("save")
	public @ResponseBody AjaxResult save(Long roleid,String orgIds) throws Exception{
		AjaxResult result = new AjaxResult();
		try {
			dataAuthService.saveOrUpdate(roleid, orgIds);
			result.setSuccessful(true);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
