package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sb.CyFirearmsLogSearchDto;
import com.bcxin.ars.dto.sb.FirearmsSearchDto;
import com.bcxin.ars.model.CyFirearmsLog;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Firearms;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.CyFirearmsLogService;

import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;


@Controller
@RequestMapping("cyFirearmsLog")
public class CyFirearmsLogController {
	
	private static final Logger logger = LoggerFactory.getLogger(CyFirearmsLogController.class);
	
	@Autowired
	private CyFirearmsLogService cyFirearmsLogService;

	@Autowired
	private ArsRestUtil arsUtil;



	@RequestMapping("list/index")
	public ModelAndView listIndex(CyFirearmsLogSearchDto searchDto){
		ModelAndView view = new ModelAndView("/firearms/log");
		view.addObject("record", searchDto);
		return view;
	}


	/**
	 * 分页查询
	 * @param dto
	 * @param page
	 * @return
	 */
	@RequestMapping("searchForPage")
	@ResponseBody
	public AjaxPageResponse searchForPage(CyFirearmsLogSearchDto dto, AjaxPageResponse<CyFirearmsLog> page){
		User user = arsUtil.getCurrentUser();
		if(user.getId() == null) {
			dto.setUserid(user.getId());
		}
		cyFirearmsLogService.searchForPage(dto,page);
		return page;
	}


	/**
	 * 查询全部
	 * @return
	 */
	@RequestMapping("getcyFirearmsList")
	public @ResponseBody AjaxResult search(CyFirearmsLogSearchDto cyFirearmsLogSearchDto) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			User user = arsUtil.getCurrentUser();
			if(user.getId() == null) {
				cyFirearmsLogSearchDto.setUserid(user.getId());
			}
			CyFirearmsLogSearchDto data = cyFirearmsLogService.search(cyFirearmsLogSearchDto);
				result.setSuccessful(true);
				result.setData(data);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 创建或更新枪支日志信息
	 * @param cyFirearmsLog 枪支日志信息
	 * @return
	 */
	@RequestMapping("saveOrUpdate")
	public @ResponseBody AjaxResult update(CyFirearmsLog cyFirearmsLog, HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			cyFirearmsLogService.saveOrUpdate(cyFirearmsLog);
			result.setSuccessful(true);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 根据ID获取枪支日志信息
	 * @return
	 */
	@RequestMapping("findById/{id}")
	public @ResponseBody AjaxResult findById(@PathVariable("id")Long id) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			CyFirearmsLog cyFirearmsLog = cyFirearmsLogService.findById(id);
			result.setSuccessful(true);
			result.setData(cyFirearmsLog);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
}
