package com.bcxin.ars.rest;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.DataSycDto;
import com.bcxin.ars.dto.sb.CyCheckSearchDto;
import com.bcxin.ars.exception.ArsException;
import com.bcxin.ars.model.CyCheck;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.rest.util.ArsRestUtil;
import com.bcxin.ars.service.CyCheckService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.util.*;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.crypto.BadPaddingException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;


@Controller
@RequestMapping("cyCheck")
public class CyCheckController {

    private static final Logger logger = LoggerFactory.getLogger(CyCheckController.class);

    @Autowired
    private CyCheckService cyCheckService;

    @Autowired
    private UserService userService;

    @Autowired
    private ArsRestUtil arsUtil;

    @Value("${upload-folder}")
    private String uploadFolder;

    @Value("${temp-folder}")
    private String tempFolder;

    @Value("${cyCheck-download-folder}")
    private String downloadFolder;

    /**
     * 查询全部
     *
     * @return
     */
    @RequestMapping("getCyCheckList")
    @RequiresPermissions("jdManager:query")
    public @ResponseBody
    AjaxResult update(CyCheckSearchDto CyCheckSearchDto) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            CyCheckSearchDto data = cyCheckService.search(CyCheckSearchDto);
            result.setSuccessful(true);
            result.setData(data);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 创建或更新监督检查情况信息
     *
     * @param cyCheck 监督检查情况信息
     * @return
     */
    @RequestMapping("saveOrUpdate")
    public @ResponseBody
    AjaxResult update(CyCheck cyCheck, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            cyCheckService.saveOrUpdate(cyCheck);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 删除监督检查情况信息
     *
     * @return
     */
    @RequestMapping("delete/{id}")
    @RequiresPermissions("jdManager:del")
    public @ResponseBody
    AjaxResult delete(@PathVariable("id") Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            CyCheck cyCheck = cyCheckService.findById(id);
            //判断是否存在，如果不存在删除失败
            if (cyCheck != null) {
                cyCheckService.delete(cyCheck);
                result.setSuccessful(true);
            } else {
                result.setSuccessful(false);
                result.setMsg("删除信息失败，ID:" + id);
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 根据ID获取监督检查情况信息
     *
     * @return
     */
    @RequestMapping("findById/{id}")
    public @ResponseBody
    AjaxResult findById(@PathVariable("id") Long id) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            CyCheck cyCheck = cyCheckService.findById(id);
            result.setSuccessful(true);
            result.setData(cyCheck);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 批量导出监督检查情况信息数据-生成excel(数据库数据导出）
     *
     * @param dto
     * @param request
     */
    @RequestMapping("createCyChecksDataExcel")
    public @ResponseBody
    AjaxResult createCyChecksDataExcel(CyCheckSearchDto dto, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            if (user != null) {
                List<CyCheck> cyChecklist = cyCheckService.searchForExportData(dto);
                if (cyChecklist != null && cyChecklist.size() > 0) {
                	
                	DataSycDto dataSycDto = new DataSycDto();
					dataSycDto.setDataType(Constants.DATASYC_CYCHECK_LIST);
					dataSycDto.setData(JSONObject.toJSONString(cyChecklist));
					
                    Date now = new Date();
                    String dirDate = DateUtil.systemDate.format(now);
                    File dir = new File(downloadFolder + dirDate);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    String cyChecklistStr = JSONObject.toJSONString(dataSycDto);
                    String content = CipherDESUtil.parseByte2HexStr(CipherDESUtil.encrypt(cyChecklistStr.getBytes(), Constants.APPROVAL_KEY));

                    String filepath = FileUtil.writeTxtFile(content, "cyCheck", tempFolder);
                    if (StringUtil.isNotEmpty(filepath)) {
                        result.setData(filepath);
                        result.setSuccessful(true);
                    } else {
                        result.setSuccessful(false);
                        result.setMsg("导出失败，请联系系统管理员确认！");
                    }
                } else {
                    result.setSuccessful(false);
                }
            }
        } catch (Exception e) {
            throw e;
        }
        return result;
    }

    /**
     * 批量导出监督检查情况信息
     *
     * @param templateName
     * @param response
     * @throws Exception
     */
    @RequestMapping("exportCyChecks")
    public void exportCyChecks(String templateName, HttpServletResponse response) throws Exception {
        User user = arsUtil.getCurrentUser();
        if (user != null) {
            File file = new File(templateName);
            if (file != null) {
                ServletOutputStream out = response.getOutputStream();
                String fileName = new String(file.getName().substring(file.getName().indexOf("_") + 1).getBytes("UTF-8"), "iso-8859-1");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
                InputStream is = new FileInputStream(file);
                int read = 0;
                byte[] buffer = new byte[8192];
                while ((read = is.read(buffer)) != -1) {
                    out.write(buffer, 0, read);
                }
                is.close();
                out.flush();
                out.close();
            }
        }
    }

    /**
     * 批量导入监督检查情况信息(数据库导入）
     */
    @RequestMapping("importCyCheckDatas")
    public @ResponseBody
    AjaxResult importCyCheckDatas(MultipartFile file, HttpServletRequest request) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            Date now = new Date();
            String fileName = now.getTime() + "_" + file.getOriginalFilename();
            String dirDate = DateUtil.systemDate.format(now);
            File dir = new File(uploadFolder + dirDate);
            if (!dir.exists()) {
                dir.mkdirs();
            }
            String targetPath = uploadFolder + dirDate + "/" + fileName;
            File targetFile = new File(targetPath);
            logger.info("执行监督检查情况文件上传..." + targetFile);
            file.transferTo(targetFile);

            BufferedReader br = new BufferedReader(new FileReader(targetFile));
            StringBuffer content = new StringBuffer();
            // 获取文件内容
            String lineTxt = null;
            while ((lineTxt = br.readLine()) != null) {// 使用readLine方法，一次读一行
                content.append(lineTxt);
            }
            br.close();

            String jsonStr = new String(CipherDESUtil.decrypt(Encodes.decodeHex(content.toString()), Constants.APPROVAL_KEY));

            DataSycDto dataSycDto = JSONObject.parseObject(jsonStr, DataSycDto.class);
			
			if(dataSycDto != null) {
				if(dataSycDto.getDataType().equals(Constants.DATASYC_CYCHECK_LIST)) {
					 List<CyCheck> cyCheckList = JSONArray.parseArray(dataSycDto.getData(), CyCheck.class);
		            if (cyCheckList != null && cyCheckList.size() > 0) {
		                for (CyCheck cyCheck : cyCheckList) {
		                    User user = cyCheck.getUser();
		                   /* User dbUser = userService.findByInRawId(cyCheck.getUser().getId());
		                    user.setInrawid(user.getId());
		                    if (dbUser != null) {
		                        user.setId(dbUser.getId());
		                    } else {
		                        if (user.getRawid() != null) {
		                            dbUser = userService.findByRawId(user.getRawid());
		                            if (dbUser != null) {
		                                user.setId(dbUser.getId());
		                            } else {
		                                user.setId(null);
		                            }
		                        } else {
		                            user.setId(null);
		                        }
		                    }*/
		                    userService.saveOrUpdateForDS(user);

		                    CyCheck dbCyCheck = cyCheckService.findById(cyCheck.getId());
		                    if (dbCyCheck != null) {
		                        cyCheck.setId(dbCyCheck.getId());
		                    } else {
		                        if (cyCheck.getId() != null) {
		                            dbCyCheck = cyCheckService.findById(cyCheck.getId());
		                            if (dbCyCheck != null) {
		                                cyCheck.setId(dbCyCheck.getId());
		                            } else {
		                                cyCheck.setId(null);
		                            }
		                        } else {
		                            cyCheck.setId(null);
		                        }
		                    }
		                    cyCheckService.saveOrUpdateForDS(cyCheck);
		                }
		            }
			            
					result.setMsg("导入成功");
		            result.setSuccessful(true);
				}else {
		            result.setMsg("导入失败，非监督检查情况的数据！");
		            result.setSuccessful(false);
				}
			}else {
				result.setMsg("导入失败，非监督检查情况的数据！");
	            result.setSuccessful(false);
			}
            
           
            Map<String, Object> resultMap = new HashMap<String, Object>();
            resultMap.put("faildFilePath", "");
            result.setData(resultMap);
            result.setSuccessful(true);
        } catch (BadPaddingException badPaddingException){
            logger.error(badPaddingException.getMessage(), badPaddingException);
            throw new ArsException("导入失败，非该区域数据\n！");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
}
