package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.CyAssociationPageSearchDto;
import com.bcxin.ars.model.CyAssociation;
import com.bcxin.ars.service.CyAssociationService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * 保安协会控制器
 *
 * @author linqinglin
 * @Date 2020-08-05 22:14:24
 */


@Controller
@RequestMapping("cyAssociation")
public class CyAssociationController {

	Logger logger = LoggerFactory.getLogger(CyAssociationController.class);

	@Autowired
	CyAssociationService cyAssociationService;

	/**
	 * 管理列表页面
	 * @return
	 */
	@RequestMapping("list/index")
	public ModelAndView listIndex(CyAssociationPageSearchDto searchDto){
		ModelAndView view = new ModelAndView("/cyAssociation/list");
		view.addObject("record", searchDto);
		return view;
	}

	/**
	 * 查看页面
	 * @param cyAssociation
	 * @return
	 */
	@RequestMapping("detail/index")
	public ModelAndView detailIndex(CyAssociation cyAssociation){
		ModelAndView view = new ModelAndView("/cyAssociation/detail");

		if(cyAssociation.getId() != null){
			view.addObject("record",cyAssociationService.findById(cyAssociation.getId()));
		}else {
			view.addObject("record", cyAssociation);
		}

		return view;
	}

	/**
	 * 新增编辑页面
	 * @param cyAssociation
	 * @return
	 */
	@RequestMapping("edit/index")
	public ModelAndView editIndex(CyAssociation cyAssociation){
		ModelAndView view = new ModelAndView("/cyAssociation/edit");

		if(cyAssociation.getId() != null){
			view.addObject("record",cyAssociationService.findById(cyAssociation.getId()));
		}else {
			view.addObject("record", cyAssociation);
		}

		return view;
	}

	/**
	 * 保存
	 * @param cyAssociation
	 * @return
	 */
	@RequestMapping("save")
	@ResponseBody
	public AjaxResult save(CyAssociation cyAssociation){
		AjaxResult result = new AjaxResult();
		try {
			cyAssociationService.save(cyAssociation);
			result.setSuccessful(true);
			result.setMsg("操作成功");
		}catch (Exception e){
			logger.error(e.getMessage(), e);
			result.setSuccessful(false);
			throw e;
		}
		return result;
	}

	/**
	 * 分页查询
	 * @param dto
	 * @param page
	 * @return
	 */
	@RequestMapping("searchForPage")
	@ResponseBody
	public AjaxPageResponse searchForPage(CyAssociationPageSearchDto dto, AjaxPageResponse<CyAssociation> page){
		cyAssociationService.searchForPage(dto,page);
		return page;
	}
}

