package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.sys.PdfFormDto;
import com.bcxin.ars.model.Edu;
import com.bcxin.ars.service.pdf.StampService;
import com.bcxin.ars.service.sb.CreatePDFService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.FileUtil;
import com.bcxin.ars.util.approval.BusinessType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

@Controller
@RequestMapping("createpdf")
public class CreatePDFController {

	/***
	 * 保安服务公司
	 */
	@Autowired
	private CreatePDFService createPDFService;
	@Autowired
	private StampService stampService;

	/**
	 * 生成PDF
	 * @param pdfFormDto
	 * @return
	 */
	@RequestMapping("create")
	public @ResponseBody AjaxResult createPDF( PdfFormDto pdfFormDto ) throws Exception {
		AjaxResult result = new AjaxResult();
		pdfFormDto.setBusinesstype(BusinessType.PXDW);
		pdfFormDto.setBusinessid(17L);

		pdfFormDto.setHasReverse("0");
		pdfFormDto.setHasStamp("1");
		createPDFService.createPDF(pdfFormDto);
		result.setSuccessful(true);
		return result;
	}

	public static void main(String[] args) {
		String sdfjaskl="\"{\"attendAddress\":\"福建省厦门市集美区诚毅大街靠近软件园3期A区\",\"clockInWay\":\"2\",\"palceLatitude\":\"24.608348\",\"placeLongitude\":\"118.052438\",\"shiftRuleClockDate\":\"2019-01-02\",\"shiftRuleId\":\"523546645988638720\"}\"";
		System.out.print(sdfjaskl);
	}
	/**
	 * 确认印章
	 * @param pdfFormDto
	 * @return
	 */
	@RequestMapping("checkStamp")
	public @ResponseBody AjaxResult checkStamp( PdfFormDto pdfFormDto ) throws Exception {
		AjaxResult result = new AjaxResult();
		stampService.addStamp("D:/1546419476716_companyTrain1.pdf","2");
		result.setSuccessful(true);
		return result;
	}

}
