package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.ConfigPageSearchDto;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.MobileConfig;
import com.bcxin.ars.service.ConfigService;
import com.bcxin.ars.service.MobileConfigService;
import com.bcxin.ars.util.Constants;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@Controller
@RequestMapping("config")
public class ConfigController {

	private Logger logger = LoggerFactory.getLogger(ConfigController.class);
	
	@Autowired
	private MobileConfigService mobileConfigService;
	
	@Autowired
	private ConfigService configService;
	
	/**
	 * 获取当前数据区域编号
	 * @param request
	 * @return
	 */
	@RequestMapping("getCurrentNative")
	public @ResponseBody AjaxResult getCurrentNative(HttpServletRequest request) {
		AjaxResult result = new AjaxResult();
		Object data = request.getSession().getServletContext().getAttribute(Constants.CURRENT_NATIVE);
		if(data != null) {
			result.setSuccessful(true);
			result.setData(data);
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
	/**
	 * 获取血型分类
	 * @param request
	 * @return
	 */
	@RequestMapping("getBloodList")
	public @ResponseBody AjaxResult getBloodList(HttpServletRequest request) {
		AjaxResult result = new AjaxResult();
		Object data = request.getSession().getServletContext().getAttribute(Constants.BLOOD);
		if(data != null) {
			result.setSuccessful(true);
			result.setData(data);
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
	/**
	 * 获取驾驶级别
	 * @param request
	 * @return
	 */
	@RequestMapping("getDrivingLevel")
	public @ResponseBody AjaxResult getDrivingLevel(HttpServletRequest request) {
		AjaxResult result = new AjaxResult();
		Object data = request.getSession().getServletContext().getAttribute(Constants.DRIVING_LEVEL);
		if(data != null) {
			result.setSuccessful(true);
			result.setData(data);
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
	/**
	 * 获取性别
	 * @param request
	 * @return
	 */
	@RequestMapping("getGender")
	public @ResponseBody AjaxResult getGender(HttpServletRequest request) {
		AjaxResult result = new AjaxResult();
		Object data = request.getSession().getServletContext().getAttribute(Constants.GENDER);
		if(data != null) {
			result.setSuccessful(true);
			result.setData(data);
		} else {
			result.setSuccessful(false);
			result.setMsg("初始化错误，未找到常量数据。");
		}
		return result;
	}
	
	/**
	 * <b>Function </b> android app获得最新版本信息
	 * 
	 * @param request
	 * @return
	 * @author LinQingLin 
	 * @date 2017年2月23日 上午10:11:14
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("getAndroidVersion")
	public @ResponseBody AjaxResult getAndroidVersion(HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<MobileConfig> adList =mobileConfigService.findByKeyForList(Constants.VERSION_ANDROID);
			result.setSuccessful(true);
			result.setData(adList);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * <b>Function </b> app获得引导页
	 * 
	 * @param request
	 * @return
	 * @author LinQingLin 
	 * @date 2017年2月23日 上午10:11:14
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("getGuidePage")
	public @ResponseBody AjaxResult getGuidePage(HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<MobileConfig> guideList =mobileConfigService.findByKeyForList(Constants.GUIDE_PAGE);
			result.setSuccessful(true);
			result.setData(guideList);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	/**
	 * <b>Function </b> app获得广告页
	 * 
	 * @param request
	 * @return
	 * @author LinQingLin 
	 * @date 2017年2月23日 上午10:11:14
	 * @注意事项 </b>
	 * <b>
	 */
	@RequestMapping("getAdPage")
	public @ResponseBody AjaxResult getAdPage(HttpServletRequest request) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			List<MobileConfig> adList =mobileConfigService.findByKeyForList(Constants.AD);
			result.setSuccessful(true);
			result.setData(adList);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}
	
	@RequestMapping("getConfigByKeyAndName")
	public @ResponseBody AjaxResult getConfigByKeyAndName(String key,String name) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			Config config =configService.findByKeyAndName(key,name);
			if(config != null){
				result.setSuccessful(true);
				result.setData(config);
			}else{
				result.setSuccessful(false);
			}
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 管理列表页面
	 * @return
	 */
	@RequestMapping("list/index")
	public ModelAndView listIndex(){
		ModelAndView view = new ModelAndView("/config/list");
		return view;
	}

	/**
	 * 查看页面
	 * @param config
	 * @return
	 */
	@RequestMapping("detail/index")
	public ModelAndView detailIndex(Config config){
		ModelAndView view = new ModelAndView("/config/detail");

		if(config.getId() != null){
			view.addObject("record",configService.findById(config.getId()));
		}else {
			view.addObject("record", config);
		}

		return view;
	}

	/**
	 * 新增编辑页面
	 * @param config
	 * @return
	 */
	@RequestMapping("edit/index")
	public ModelAndView editIndex(Config config){
		ModelAndView view = new ModelAndView("/config/edit");

		if(config.getId() != null){
			view.addObject("record",configService.findById(config.getId()));
		}else {
			view.addObject("record", config);
		}

		return view;
	}

	/**
	 * 保存
	 * @param config
	 * @return
	 */
	@RequestMapping("save")
	@ResponseBody
	public AjaxResult save(Config config){
		AjaxResult result = new AjaxResult();
		try {
			configService.save(config);
			result.setSuccessful(true);
			result.setMsg("操作成功");
		}catch (Exception e){
			logger.error(e.getMessage(), e);
			result.setSuccessful(false);
			throw e;
		}
		return result;
	}


	/**
	 * 删除配置
	 * @return
	 */
	@RequestMapping("delete")
	public @ResponseBody
	AjaxResult delete(Config config) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			configService.delete(config);
			result.setSuccessful(true);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 启用配置
	 * @return
	 */
	@RequestMapping("use")
	public @ResponseBody
	AjaxResult use(Config config) throws Exception {
		AjaxResult result = new AjaxResult();
		try {
			configService.use(config);
			result.setSuccessful(true);
		} catch(Exception e) {
			logger.error(e.getMessage(), e);
			throw e;
		}
		return result;
	}

	/**
	 * 分页查询
	 * @param dto
	 * @param page
	 * @return
	 */
	@RequestMapping("searchForPage")
	@ResponseBody
	public AjaxPageResponse searchForPage(ConfigPageSearchDto dto, AjaxPageResponse<Config> page){
		configService.searchForPage(dto,page);
		return page;
	}
}
