package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.CommonComplaintPageSearchDto;
import com.bcxin.ars.model.CommonComplaint;
import com.bcxin.ars.service.CommonComplaintService;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

/**
 * 市民意见建议控制器
 *
 * @author linqinglin
 * @Date 2020-08-07 10:39:15
 */
@Controller
@RequestMapping("commonComplaint")
public class CommonComplaintController {

	Logger logger = LoggerFactory.getLogger(CommonComplaintController.class);

	@Autowired
	CommonComplaintService commonComplaintService;

	/**
	 * 管理列表页面
	 * @return
	 */
	@RequestMapping("list/index")
	public ModelAndView listIndex(CommonComplaintPageSearchDto searchDto){
		ModelAndView view = new ModelAndView("/commonComplaint/list");
		view.addObject("record", searchDto);
		return view;
	}

	/**
	 * 查看页面
	 * @param commonComplaint
	 * @return
	 */
	@RequestMapping("detail/index")
	public ModelAndView detailIndex(CommonComplaint commonComplaint){
		ModelAndView view = new ModelAndView("/commonComplaint/detail");

		if(commonComplaint.getId() != null){
			view.addObject("record",commonComplaintService.findById(commonComplaint.getId()));
		}else {
			view.addObject("record", commonComplaint);
		}

		return view;
	}

	/**
	 * 新增编辑页面
	 * @param commonComplaint
	 * @return
	 */
	@RequestMapping("edit/index")
	public ModelAndView editIndex(CommonComplaint commonComplaint){
		ModelAndView view = new ModelAndView("/commonComplaint/edit");

		if(commonComplaint.getId() != null){
			view.addObject("record",commonComplaintService.findById(commonComplaint.getId()));
		}else {
			view.addObject("record", commonComplaint);
		}

		return view;
	}

	/**
	 * 保存
	 * @param commonComplaint
	 * @return
	 */
	@RequestMapping("save")
	@ResponseBody
	public AjaxResult save(CommonComplaint commonComplaint){
		AjaxResult result = new AjaxResult();
		try {
			commonComplaintService.save(commonComplaint);
			result.setSuccessful(true);
			result.setMsg("操作成功");
		}catch (Exception e){
			logger.error(e.getMessage(), e);
			result.setSuccessful(false);
			throw e;
		}
		return result;
	}

	/**
	 * 分页查询
	 * @param dto
	 * @param page
	 * @return
	 */
	@RequestMapping("searchForPage")
	@ResponseBody
	public AjaxPageResponse searchForPage(CommonComplaintPageSearchDto dto, AjaxPageResponse<CommonComplaint> page){
		commonComplaintService.searchForPage(dto,page);
		return page;
	}
}

