package com.bcxin.ars.rest;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.page.AnnualSurveyReportPageSearchDto;
import com.bcxin.ars.model.AnnualSurveyReport;
import com.bcxin.ars.model.SecurityCompany;
import com.bcxin.ars.model.SecurityPerson;
import com.bcxin.ars.model.User;
import com.bcxin.ars.service.AnnualSurveyReportService;
import com.bcxin.ars.service.SecurityCompanyService;
import com.bcxin.ars.service.SecurityPersonService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.net.URLEncoder;


/**
 * 北京保安从业单位和从业人员情况年度调查Controller
 * 
 * @author lin
 * @date 2020-11-20
 */
@Controller
@RequestMapping("/annualSurveyReport")
public class AnnualSurveyReportController{
    Logger logger = LoggerFactory.getLogger(AnnualSurveyReportController.class);

    @Autowired
    private AnnualSurveyReportService annualSurveyReportService;

    @Autowired
    private SecurityPersonService securityPersonService;

    @Autowired
    private SecurityCompanyService securityCompanyService;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;

    /**
      * 管理列表页面
      * @return
      */
    @RequestMapping("list/index")
    @RequiresPermissions("annualSurveyReport:view")
    public ModelAndView listIndex(AnnualSurveyReportPageSearchDto searchDto){
        ModelAndView view = new ModelAndView("annualSurveyReport/list");
        view.addObject("record", searchDto);
        return view;
    }

    /**
     * 分页查询
     * @param dto
     * @param page
     * @return
     */
    @RequestMapping("searchForPage")
    @ResponseBody
    @RequiresPermissions("annualSurveyReport:view")
    public AjaxPageResponse searchForPage(AnnualSurveyReportPageSearchDto dto, AjaxPageResponse<AnnualSurveyReport> page){
        annualSurveyReportService.searchForPage(dto,page);
        return page;
    }

    /**
     * 查看页面
     * @param annualSurveyReport
     * @return
     */
    @RequestMapping("detail/index")
    @RequiresPermissions("annualSurveyReport:view")
    public ModelAndView detailIndex(AnnualSurveyReport annualSurveyReport){
        ModelAndView view = new ModelAndView("annualSurveyReport/detail");

        if(annualSurveyReport.getId() != null){
            view.addObject("record",annualSurveyReportService.findById(annualSurveyReport.getId()));
        }else {
            view.addObject("record", annualSurveyReport);
        }

        return view;
    }

    /**
     * 新增编辑页面
     * @param perId
     * @return
     */
    @RequestMapping("edit/index")
    public ModelAndView editIndex(Long perId){
        ModelAndView view = new ModelAndView("annualSurveyReport/edit");
        String configValue = configUtils.getValueByKey(Constants.ANNUALSURVEYREPORT_DATA);
        User user = arsUtil.getCurrentUser();
        AnnualSurveyReport annualSurveyReport = annualSurveyReportService.findByUserId(user.getId());
        if(System.currentTimeMillis() > DateUtil.convertStringToDate(configValue).getTime()){
            view.setViewName("annualSurveyReport/detail");
        }else {
            SecurityPerson person = securityPersonService.findById(perId);
            SecurityCompany company = securityCompanyService.findByUserid(user.getId());
            if(annualSurveyReport == null){
                annualSurveyReport = new AnnualSurveyReport();
            }
            annualSurveyReport.setRealName(person.getRealName());
            annualSurveyReport.setPhone(person.getPhone());
            annualSurveyReport.setComName(company.getName());
            annualSurveyReport.setComId(company.getId());
        }
        view.addObject("record", annualSurveyReport);

        return view;
    }

    /**
     * 保存
     * @param annualSurveyReport
     * @return
     */
    @RequestMapping("save")
    @ResponseBody
    public AjaxResult save(AnnualSurveyReport annualSurveyReport){
        AjaxResult result = new AjaxResult();
        try {
            annualSurveyReportService.save(annualSurveyReport);
            result.setSuccessful(true);
            result.setMsg("操作成功");
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            result.setSuccessful(false);
            throw e;
        }
        return result;
    }

    @RequestMapping("exportTotal")
    public @ResponseBody
    AjaxResult exportTotal(HttpServletRequest request, HttpServletResponse response) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            User user = arsUtil.getCurrentUser();
            /**
             *  //获取浏览器
             *  不同的浏览器的编码不一样
             *  */
            String userAgent = request.getHeader("user-agent");
            String tableExcelName ="保安从业单位和从业人员情况年度调查表";
            if (userAgent != null && userAgent.indexOf("Firefox") >= 0 || userAgent.indexOf("Chrome") >= 0
                    || userAgent.indexOf("Safari") >= 0) {
                tableExcelName= new String((tableExcelName).getBytes(), "ISO8859-1");
            } else {
                tableExcelName= URLEncoder.encode(tableExcelName,"UTF8"); //其他浏览器
            }
            String excelPath = annualSurveyReportService.exportTotal(request);
            if (excelPath != null) {
                result.setData(excelPath);
                result.setMsg("导出成功");
                result.setSuccessful(true);
            } else {
                result.setMsg("数据为空");
                result.setSuccessful(false);
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

}
