package com.bcxin.ars.rest;

import cn.hutool.core.bean.BeanUtil;
import com.bcxin.ars.dao.ConfigDao;
import com.bcxin.ars.dao.PersonBaseInfoDao;
import com.bcxin.ars.dao.PersonImgDao;
import com.bcxin.ars.dao.PoliceDao;
import com.bcxin.ars.dao.approve.*;
import com.bcxin.ars.dao.certificate.SecurityCertificateDao;
import com.bcxin.ars.dto.ActivityRepairApprovalSearchDto;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.ApprovalDTO;
import com.bcxin.ars.dto.approve.*;
import com.bcxin.ars.dto.sb.BackgroundApprovalDto;
import com.bcxin.ars.model.*;
import com.bcxin.ars.model.approve.*;
import com.bcxin.ars.model.certificate.SecurityCertificate;
import com.bcxin.ars.model.sb.BackgroundApproval;
import com.bcxin.ars.model.sb.Personcertificate;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.zw.Pctinfo;
import com.bcxin.ars.rest.thread.ReSetOldProcessRunnable;
import com.bcxin.ars.rest.thread.ReSetProcessRunnable;
import com.bcxin.ars.rest.thread.ReStartProcessRunnable;
import com.bcxin.ars.service.PersonBaseInfoService;
import com.bcxin.ars.service.ProblemPersonService;
import com.bcxin.ars.service.UserService;
import com.bcxin.ars.service.bean.factory.CustomPersoncertificateBeanFactory;
import com.bcxin.ars.service.exam.TrainExamPersonService;
import com.bcxin.ars.service.sb.ActivityRepairService;
import com.bcxin.ars.service.sb.BackgroundApprovalService;
import com.bcxin.ars.service.sb.CustomPersoncertificateService;
import com.bcxin.ars.service.sb.PersoncertificateService;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.util.*;
import com.bcxin.ars.service.zw.PctinfoService;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.DateUtil;
import com.bcxin.ars.util.StringUtil;
import com.bcxin.ars.util.approval.ApprovalState;
import com.bcxin.ars.util.approval.BusinessType;
import com.bcxin.ars.util.thread.ThreadPoolManager;
import com.bcxin.ars.web.util.WebStartup;
import com.com.bcxin.ars.com.abcxin.smart.core.web.validate.AjaxPageResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.*;

/**
 * 流程修复
 *
 * @author linqinglin
 * @date 2018/08/20 0020 9:45
 */
@Controller
@RequestMapping("activity/repair")
public class ActivityRepairContoller extends BaseController{

    private Logger logger = LoggerFactory.getLogger(ActivityRepairContoller.class);
    @Value("${base-folder}")
    private String baseFolder;

    @Value("${upload-folder}")
    private String uploadFolder;
    @Autowired
    private TrainExamPersonService trainExamPersonService;
    @Autowired
    private PersoncertificateService personcertificateService;

    @Autowired
    private BackgroundApprovalService backgroundApprovalService;

    @Autowired
    private PctinfoService pctinfoService;
    @Autowired
    private PersonBaseInfoService personBaseInfoService;
    @Autowired
    private ActivityRepairService activityRepairService;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ConfigDao configDao;

    @Autowired
    SecurityCertificateDao securityCertificateDao;

    @Autowired
    PersonImgDao personImgDao;

    @Autowired
    WebStartup webStartup;

    @Autowired
    ApprovalService approvalService;

    @Autowired
    ApproveTempDao approveTempDao;


    @Autowired
    PersonBaseInfoDao personBaseInfoDao;
    @Autowired
    ApproveLinkProDetailDao approveLinkProDetailDao;

    @Autowired
    ApproveAreaProDetailDao approveAreaProDetailDao;

    @Autowired
    PoliceDao policeDao;

    @Autowired
    ApproveTempLinkRelaDao approveTempLinkRelaDao;

    @Autowired
    ApproveLinkDao approveLinkDao;

    @Autowired
    ApproveAreaProcessDao approveAreaProcessDao;

    @Autowired
    ApproveTempProcessDao approveTempProcessDao;

    @Autowired
    ApproveLinkLevelDao approveLinkLevelDao;

    @Autowired
    ArsUtil arsUtil;

    @Autowired
    DataSyncUtil dataSyncUtil;

    @Autowired
    SAASInterfaceUtil saasInterfaceUtil;

    @Autowired
    ProblemPersonService problemPersonService;

    @Autowired
    UserService userService;

    //private static BackGroupCensorService backGroupCensorService;

    static{
       // backGroupCensorService = BackGroupCensorServiceBeanFactory.getBackGroupCensorServiceBean();
    }

    /**
     * 全部业务流程修复首页
     *
     * @return
     */
    @RequestMapping("approval/index")
    public String approvalIndex(HttpServletRequest request) {

        //try {
        //    URL resource = request.getServletContext().getResource("/fileTemp/gradeFailTemp.xls");
        //    resource.getFile();
        //    System.out.println(resource.getFile());
        //} catch (MalformedURLException e) {
        //    e.printStackTrace();
        //}
        //List<ProblemPerson> problemPersonList = problemPersonService.findProblemPersonList();
        //problemPersonService.importBatch(problemPersonList);
        //ComInfoDto comInfoDto = new ComInfoDto();
        //comInfoDto.setComId(123L);
        //comInfoDto.setUpdateBy(1111L);
        //comInfoDto.setComName("11232443");
        //saasInterfaceUtil.callInterface("11112345",comInfoDto);
        return "activityRepair/index";
    }

    /**
     * 新版本 背景筛查验证
     * @return
     */
    @RequestMapping("backGroupCensor/index")
    public ModelAndView backGroupCensorIndex() {
        ModelAndView view = new ModelAndView("activityRepair/easyuiIndex");

        return view;
    }

    /***
     * 审批流程修复查询
     * @param dto 查询条件参数
     * @param page 返回数据对象
     * @return 查询列表
     */
    @RequestMapping("searchForApproval")
    public @ResponseBody
    AjaxPageResponse searchForApproval(ActivityRepairApprovalSearchDto dto, AjaxPageResponse page){
        try {
            Config nativeConfig = configUtils.getConfigByKey(Constants.CURRENT_NATIVE);
            //dto.setAreaCode(nativeConfig.getValue());
            activityRepairService.search(dto, page);
            return page;
        } catch(Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
    }

    /**
     * 保安员证流程修复首页
     *
     * @return
     */
    @RequestMapping("index")
    public String index() {
        return "personcertificate/activityRepair";
    }

    /**
     * 保安员证批量重置流程页面
     *
     * @return
     */
    @RequestMapping("resetProcess/index")
    public String resetProcessIndex() {
        return "personcertificate/resetProcess";
    }

    /**
     * 保安员证批量重启流程页面
     *
     * @return
     */
    @RequestMapping("restartProcess/index")
    public String restartProcessIndex() {
        return "personcertificate/restartProcess";
    }

    /**
     * 重置保安员证审批流程
     *
     * @param id
     * @return
     */
    @RequestMapping("resetProcess")
    @ResponseBody
    public AjaxResult resetPersoncertificateProcess(Long id) {
        AjaxResult result = new AjaxResult();
        try {
            activityRepairService.resetProcess(id);
            result.setSuccessful(true);
            result.setMsg("重置成功！");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("/checkReturn")
    @ResponseBody
    public AjaxResult checkReturn(Long[] personIds) {
        AjaxResult result = new AjaxResult();
        if (personIds !=null) {
            //根据环境获取不同的打回实现接口
            CustomPersoncertificateService customPersoncertificateService =  CustomPersoncertificateBeanFactory.getPersoncertificateBean();
            //执行
            result = customPersoncertificateService.checkReturn(personIds);
        } else {
            result.setMsg("流程打回失败，请选择人员");
            result.setSuccessful(false);
            result.setData("");
        }
        return result;
    }

    /**
     * 批量重置保安员证审批流程
     *
     * @param personIds
     * @return
     */
    @RequestMapping("batchResetProcess")
    @ResponseBody
    public AjaxResult batchResetProcess(String personIds) {
        AjaxResult result = new AjaxResult();
        result.setSuccessful(true);
        result.setMsg("后台运行中！");
        Config config = configDao.findByKey("approvalflag");
        if (config != null && config.getValue().equals("1")) {
            config.setValue("0");
            configDao.update(config);
            try {
                if (StringUtil.isNotEmpty(personIds)) {
                    personIds = personIds.replaceAll("\n", ",");
                    String[] personIdArr = personIds.split(",");
                    if (personIdArr != null && personIdArr.length > 0) {
                        ThreadPoolManager threadPoolManager = ThreadPoolManager.newInstance();
                        for (String personId : personIdArr) {
                            if (StringUtil.isNotEmpty(personId)) {
                                try {
                                    threadPoolManager.addExecuteTask(new ReSetProcessRunnable(activityRepairService, Long.parseLong(personId)));
                                } catch (Exception e) {
                                    logger.error(e.getMessage(), e);
                                }
                            }
                        }
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                throw e;
            }
        } else {
            result.setSuccessful(false);
            result.setMsg("请勿重复重置！");
        }
        return result;
    }

    /**
     * 批量重启保安员证审批流程
     *
     * @param personIds
     * @return
     */
    @RequestMapping("batchRestartProcess")
    @ResponseBody
    public AjaxResult batchRestartProcess(String personIds) {
        AjaxResult result = new AjaxResult();
        result.setSuccessful(true);
        result.setMsg("后台运行中！");
        Config config = configDao.findByKey("approvalflag");
        if (config != null && config.getValue().equals("1")) {
            config.setValue("0");
            configDao.update(config);
            try {
                if (StringUtil.isNotEmpty(personIds)) {
                    personIds = personIds.replaceAll("\n", ",");
                    String[] personIdArr = personIds.split(",");
                    if (personIdArr != null && personIdArr.length > 0) {
                        ThreadPoolManager threadPoolManager = ThreadPoolManager.newInstance();
                        for (String personId : personIdArr) {
                            if (StringUtil.isNotEmpty(personId)) {
                                try {
                                    threadPoolManager.addExecuteTask(new ReStartProcessRunnable(activityRepairService, Long.parseLong(personId)));
                                } catch (Exception e) {
                                    logger.error(e.getMessage(), e);
                                }
                            }
                        }
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                throw e;
            }
        } else {
            result.setSuccessful(false);
            result.setMsg("请勿重复启用！");
        }
        return result;
    }

    /**
     * 保安员证审批批量获取指纹
     *
     * @param personIds
     * @return
     */
    @RequestMapping("batchGetFingerprint")
    @ResponseBody
    public AjaxResult batchGetFingerprint(String[] personIds) {
        AjaxResult result = new AjaxResult();
        try {
            // 初始化信息
            String failMsg = "", sucMsg = "", dupMsg = "";
            // 从循环中取出来，这样减少性能消耗
            Personcertificate personcertificate = null;
            Boolean flag = null;
            // 读取配置文件
            Config isNew = configUtils.getConfigByKey(Constants.APPROVAL_VERSION_SWITCH);
            for (String personId : personIds) {
                personcertificate = personcertificateService.getCardStateByIds(personId);
                // 获取指纹卡号的前提条件是该员已经第一次报名审核通过。
                if (isNew != null && Constants.APPROVAL_VERSION_NEW.equals(isNew.getValue())) {
                    flag = personcertificate != null && personcertificate.getApprovalstate() != null &&
                            Constants.APPROVALSTATE_DSP.equals(personcertificate.getApprovalstate());
                } else {
                    flag = personcertificate != null && personcertificate.getApprovalstate() != null
                            && Constants.APPROVALSTATE_SHZ.equals(personcertificate.getApprovalstate());
                }
                if (flag) {
                    if (!Constants.FINGERCARD_STATE_JL.equals(personcertificate.getFingercardState())
                            && !Constants.FINGERCARD_STATE_YCJ.equals(personcertificate.getFingercardState())) {
                        personcertificate.setFingercardState(Constants.FINGERCARD_STATE_JL);
                        personcertificate.setFingerprint("BA" + personcertificate.getCardnumber());
                        // 列表操作，不需要reason
                        personcertificate.setApprovalreason("");
                        personcertificateService.updatefingercardStateById(personcertificate);
                        sucMsg += personcertificate.getName() + ",";
                    } else if (Constants.FINGERCARD_STATE_JL.equals(personcertificate.getFingercardState())) {
                        dupMsg += personcertificate.getName() + ",";
                    }

                } else {
                    failMsg += personcertificate.getName() + ",";
                }
            }

            String msg = "";
            if (!"".equals(sucMsg)) {
                msg += sucMsg + "成功获取指纹卡号，请告知指纹录入成功人员进行考试缴费哦!";
            }
            if (!"".equals(dupMsg)) {
                msg += dupMsg + "指纹已录入，无须重复录入!";
            }
            if (!"".equals(failMsg)) {
                msg += failMsg + "指纹录入失败,不在获取指纹环节！";
            }
            if ("".equals(sucMsg)) {
                result.setSuccessful(false);
                msg += "指纹录入失败";
            } else {
                result.setSuccessful(true);
            }

            result.setMsg(msg);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 保安员证审批批量打回
     *
     * @param personIds
     * @return
     */
    @RequestMapping("batchRepulse")
    @ResponseBody
    public AjaxResult batchRepulse(Long[] personIds) {
        AjaxResult result = new AjaxResult();
        try {
            activityRepairService.batchRepulse(personIds);
            result.setSuccessful(true);
            result.setMsg("打回成功！");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    /**
     * 保安员证审批批量打回+填写打回意见
     *
     * @param personIds
     * @return
     */
    @RequestMapping("batchRepulseAndReturnMsg")
    @ResponseBody
    public AjaxResult batchRepulseAndReturnMsg(String personIds,String returnreason) {
        AjaxResult result = new AjaxResult();
        try {
            if (personIds!=null) {
                String [] personId=  personIds.split(",");
               int strLen= personId.length;

                Long [] longIds=new Long[strLen];
                for (int i=0;i<strLen;i++){
                    longIds[i]=  Long.parseLong(personId[i]);
                }
                List<Long> list= activityRepairService.checkCanReturnPerson(longIds);
                trainExamPersonService.deleteTestForApporvalId(longIds);
                activityRepairService.batchRepulseAndNotFeeState(longIds);
                ApprovalDTO approval = new ApprovalDTO();
                approval.setApprovalstate(Constants.APPROVALSTATE_BTG);
                approval.setOutreason("打回意见：" + returnreason);
                approval.setApprovalperson("打回");
                if (list.size()>0) {
                    for (Long id : list) {
                        approval.setId(id);
                        approvalService.saveApprovalOutreason(approval);
                    }
                    result.setSuccessful(true);
                    result.setMsg("打回成功！");
                }
            }else {
                result.setSuccessful(false);
                result.setMsg("无人员数据！");
            }
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }
    @RequestMapping("approval/jumpNextProcess")
    @ResponseBody
    public AjaxResult jumpNextProcess(Long approvalId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            activityRepairService.jumpNextProcess(approvalId);
            result.setSuccessful(true);
            result.setMsg("操作成功！");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("approval/reStartProcess")
    @ResponseBody
    public AjaxResult approvalReStartProcess(Long approvalId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            activityRepairService.reStartProcess(approvalId);
            result.setSuccessful(true);
            result.setMsg("操作成功！");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 审批流程打回
     *
     * @param approvalId
     * @return
     */
    @RequestMapping("approval/repulseProcess")
    @ResponseBody
    public AjaxResult approvalRepulseProcess(Long approvalId) throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            activityRepairService.repulseProcess(approvalId);
            result.setSuccessful(true);
            result.setMsg("操作成功！");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    /**
     * 陕西旧审批转新审批
     *
     * @param params
     * @return
     */
    @RequestMapping("resetOldProcess")
    @ResponseBody
    public AjaxResult resetOldProcess(@RequestParam Map<Object, Object> params) {
        AjaxResult result = new AjaxResult();
        result.setSuccessful(true);
        result.setMsg("后台运行中！");
        Config config = configDao.findByKey("approvalflag");
        if (config != null && config.getValue().equals("1")) {
            config.setValue("0");
            configDao.update(config);
            try {
                params.put("oldRev", true);
                //params.put("businesstype","005");
                //params.put("areaCode","610832");
                //params.put("approvalid","10267");
                PageResult pageResult = activityRepairService.searchApprovalList(params);
                if (pageResult.getRows() != null) {
                    List<Map<Object, Object>> rows = (List<Map<Object, Object>>) pageResult.getRows();
                    ThreadPoolManager threadPoolManager = ThreadPoolManager.newInstance();
                    for (Map<Object, Object> bean : rows) {
                        Approval approval = BeanUtil.mapToBean(bean, Approval.class, true);
                        if (approval != null && !BusinessType.BAYZ.equals(approval.getBusinesstype()) && approval.getOrgid() != null && (ApprovalState.SPZ.equals(approval.getApprovalstate()) || ApprovalState.DSH.equals(approval.getApprovalstate()))) {
                            try {
                                threadPoolManager.addExecuteTask(new ReSetOldProcessRunnable(activityRepairService, approval.getId()));
                            } catch (Exception e) {
                                logger.error(e.getMessage(), e);
                            }
                        }
                    }
                }
            } catch (Exception e) {
                logger.error(e.getMessage(), e);
                throw e;
            }
        } else {
            result.setSuccessful(false);
            result.setMsg("请勿重复启用！");
        }
        return result;
    }

    @RequestMapping("personImg/index")
    public ModelAndView personImgIndex(String idNumber) {
        ModelAndView view = new ModelAndView("personcertificate/personImg");
        view.addObject("idNumber", idNumber);
        return view;
    }

    @RequestMapping("uploadPersonImg")
    @RequiresPermissions("personcertificatePrint:uploadImg")
    @ResponseBody
    public AjaxResult uploadPersonImg(PersonBaseInfo personBaseInfo, MultipartFile file, String idNumber) throws Exception {
        AjaxResult result = new AjaxResult();
        result.setSuccessful(true);
        result.setMsg("后台运行中！");

        Date now = new Date();
        if(file == null ){
            return result;
        }
        String[] fileTypes = file.getOriginalFilename().split("\\.");
        String materialFileType = fileTypes[fileTypes.length-1];
        //文件类型
        /***  上传的文件类型可能小写、可能大写、可能大小混合 by llc 2018-08-21 ***/
        String fileType = "ZIP,RAR,PDF,TXT,XML,DOC,GIF,PNG,BMP,JPEG,JPG,DOCX,XLS,XLSX,PPT,PPTX";
        //判断是否为允许上传的文件类型
        if ( !Arrays.<String> asList(fileType.split(",")).contains(materialFileType.toUpperCase()))
        {   result.setSuccessful(false);
            result.setMsg("文件格式不对，重新上传！！");
            return result;
        }
        String fileName = now.getTime() +"."+ materialFileType;
        String dirDate = DateUtil.systemDate.format(now);
        File dir = new File(uploadFolder + dirDate);
        if(!dir.exists()) {
            dir.mkdirs();
        }
        String key = "upload/" + dirDate + "/" + fileName;
        String url = "getResource.do?path=" + key;
        String targetPath = uploadFolder + dirDate + "/" + fileName;
        File targetFile = new File(targetPath);
        file.transferTo(targetFile);
        personBaseInfo.setIdnum(idNumber);
        personBaseInfo.setCreateTime(new Date());
        personBaseInfo.setActive(true);
        personBaseInfo.setImgPath(url);
        personBaseInfo.setState(Constants.PHOTO_YES);
        personBaseInfoService.save(personBaseInfo);

        SecurityCertificate securityCertificate = new SecurityCertificate();
        securityCertificate.setHavephoto(true);
        securityCertificate.setIdnum(personBaseInfo.getIdnum());
        securityCertificate.setHeadImg(url);
        securityCertificateDao.updateHavePhotodByIdnum(securityCertificate);
        return result;
    }

    @RequestMapping("config/reload")
    @ResponseBody
    public AjaxResult configReload() throws Exception {
        AjaxResult result = new AjaxResult();
        try {
            webStartup.afterPropertiesSet();
            result.setSuccessful(true);
            result.setMsg("操作成功！");
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("bjsc")
    @ResponseBody
    public AjaxResult bjsc(Long id) {
        AjaxResult result = new AjaxResult();
        try {
            Personcertificate personcertificate = personcertificateService.findById(id);
            if (StringUtil.isEmpty(personcertificate.getCensorStatus()) || personcertificate.getCensorStatus().equals(Constants.CENSORSTATUS_WAIT)) {
                //背景筛查开始
                BackgroundApprovalDto backgroundApprovalDto = new BackgroundApprovalDto();
                backgroundApprovalDto.setBusinessid(personcertificate.getId());
                backgroundApprovalDto.setBusinesstype(Constants.BAYZ);
                backgroundApprovalDto.setIdNumber(personcertificate.getCardnumber());
                backgroundApprovalDto.setRealName(personcertificate.getName());
                //对接八大库查询
                backgroundApprovalService.approval(backgroundApprovalDto);
                //查询结果
                List<BackgroundApproval> list = backgroundApprovalService.query(backgroundApprovalDto);
                Boolean pass = true;
                Boolean startActiviti = false;
                for (BackgroundApproval backgroundApproval : list) {
                    if (Constants.APPROVALSTATE_BTG.equals(backgroundApproval.getApprovalstate())) {
                        pass = false;
                        break;
                    }
                }
                //判断背景筛查是否通过
                if (pass) {
                    //背景筛查通过
                    personcertificate.setCensorStatus(Constants.CENSORSTATUS_PASS);
                    //是否显示指纹录入环节
                    Config isShowFingerprintConfig = configUtils.getConfigByKey(Constants.IS_SHOW_FINGERPRINT);
                    if (isShowFingerprintConfig == null || (StringUtil.isNotEmpty(isShowFingerprintConfig.getValue())
                            && Constants.IS_SHOW_FINGERPRINT_YES.equals(isShowFingerprintConfig.getValue()))) {
                        //获取指纹
                        Pctinfo pctinfo = pctinfoService.findByIdnumber(personcertificate.getCardnumber());

                        if (pctinfo != null) {
                            //获取到指纹 开启 activiti流程
                            personcertificate.setFingerprint(pctinfo.getBarcode());
                            personcertificate.setFingercardState(Constants.FINGERCARD_STATE_JL);
                            startActiviti = true;
                        }
                    } else {
                        startActiviti = true;
                    }

                } else {
                    //背景筛查不通过 开启 activiti流程
                    personcertificate.setCensorStatus(Constants.CENSORSTATUS_UNPASS);
                    startActiviti = true;
                }
                //更新背景筛查状态
                personcertificate.setUpdateTime(new Date());
                personcertificateService.updateCensorStatus(personcertificate);
                if (startActiviti) {
                    activityRepairService.restartProcess(id);
                }
                result.setSuccessful(true);
                result.setMsg("操作成功！");
            } else {
                result.setSuccessful(false);
                result.setMsg("该笔已做过背景筛查！");
            }

        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("createConfirmAndRegisterForm")
    @ResponseBody
    public AjaxResult createConfirmAndRegisterForm(Approval approval) {
        AjaxResult result = new AjaxResult();
        try {
            approval = approvalService.findById(approval.getId());
            approvalService.createConfirmAndRegisterForm(approval);
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }


    @RequestMapping("createCard")
    @ResponseBody
    public AjaxResult createCard(Approval approval) {
        AjaxResult result = new AjaxResult();
        try {
            approval = approvalService.findById(approval.getId());
            approvalService.createCard(approval,"0");
            result.setSuccessful(true);
        } catch (Exception e) {
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("startAllProcess")
    public @ResponseBody
    AjaxResult startAllProcess() {
        AjaxResult result = new AjaxResult();
        result.setSuccessful(true);
        User user = arsUtil.getCurrentUser();
        result.setMsg("启动中，需要比较久的时间，请稍候再查看！");
        try {
            Date date = new Date();
            ApproveTempLinkRelaDto approveTempLinkRelaDto = new ApproveTempLinkRelaDto();
            List<ApproveTemp> list = approveTempDao.findAll();

            List<ApproveAreaProDetailDto> approveAreaProDetailDtoList = null;
            ApproveAreaProcess approveAreaProcess = null;
            Police police = null;
            ApproveTempLinkRela approveTempLinkRela = null;
            ApproveLink approveLink =null;
            List<ApproveProcessDto> approveProcessDtoList = null;
            String linkName = null;
            for(ApproveTemp approveTemp : list){
                if(!approveTemp.getTempCode().startsWith(Constants.ACTIVITI_PROCESS_YEARREPORT_ARMED)){
                    continue;
                }
                approveTempLinkRelaDto.setTempName(approveTemp.getTempName());

                List<ApproveLinkProDetail> approveLinkProDetailList = approveLinkProDetailDao.findListByTempId(approveTemp.getId());
                for(ApproveLinkProDetail approveLinkProDetail:approveLinkProDetailList){
                    approveTempLinkRela = approveTempLinkRelaDao.findById(approveLinkProDetail.getTempLinkRelaId());
                    approveLink = approveLinkDao.findById(approveTempLinkRela.getApproveLinkId());
                    linkName = approveLink.getLinkName();
                    approveTempLinkRelaDto.setLinkName(linkName);
                    approveAreaProcess = approveAreaProcessDao.findById(approveLinkProDetail.getApproveAreaProId());
                    if(approveAreaProcess == null || approveAreaProcess.getApproveSetStatus().equals(Constants.CONFIGURATION_NOT_CONFIGURED)){
                        continue;
                    }
                    // 机构信息
                    police = policeDao.findById(approveAreaProcess.getPoliceId());
                    approveAreaProDetailDtoList = approveAreaProDetailDao.findListByapproveAreaProId(approveAreaProcess.getId());
                    approveAreaProcess.setProcessInfo(ApprovalActivityUtil.thirdJson(approveAreaProDetailDtoList,
                            approveAreaProcess, police, approveTempLinkRelaDto));
                    approveAreaProcess.setUpdateTime(date);
                    approveAreaProcess.setEffectTime(date);
                    approveAreaProcessDao.update(approveAreaProcess);
                    approveProcessDtoList = approveAreaProcessDao.findAllIdBypolice(police.getId(), approveTempLinkRela.getId());
                    if(approveProcessDtoList != null && approveProcessDtoList.size() > 1){
                        System.out.println(approveProcessDtoList.size());
                    }
                    for(ApproveProcessDto approveProcessDto : approveProcessDtoList){
                        approveLinkProDetail.setProcessInfo(ApprovalActivityUtil.secondJson(approveProcessDto, approveLinkProDetail, approveTempLinkRelaDto));
                        approveLinkProDetail.setUpdateTime(date);
                        approveLinkProDetailDao.update(approveLinkProDetail);
                    }
                }
                /**
                 * 当前省份信息
                 */
                Config provinceConfig = configUtils.getConfigByKey(Constants.CURRENT_NATIVE);
                //北京直接启动流程
                if(provinceConfig!=null && Constants.BEIJING.equals(provinceConfig.getValue())){
                    saveMainProcess(approveTemp);
                }else {
                    // 生成并启动审批主流程(省级模板不启动审批主流程，市级模板才启动审批主流程)
                    if (approveTemp.getParentTempId() != null) {
                        saveMainProcess(approveTemp);
                    }
                }
            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
        return result;
    }

    @RequestMapping("startProcess/{tempId}")
    public @ResponseBody
    AjaxResult oneKeyStartProcess(@PathVariable Long tempId) {
        AjaxResult result = new AjaxResult();
        result.setSuccessful(true);
        result.setMsg("启动完成！");
        startProcess(tempId);
        List<ApproveTemp> tempList = approveTempDao.findByParentTempId(tempId);
        for (ApproveTemp approveTemp : tempList) {
            startProcess(approveTemp.getId());
        }
        return result;
    }

    private void startProcess(Long tempId){
        try {
            Date date = new Date();
            ApproveTempLinkRelaDto approveTempLinkRelaDto = new ApproveTempLinkRelaDto();
            ApproveTemp approveTemp = approveTempDao.findById(tempId);
            //User user = userService.findByOrgId(approveTemp.getPoliceId());
            approveTempLinkRelaDto.setTempName(approveTemp.getTempName());
            List<ApproveLinkProDetail> approveLinkProDetailList = approveLinkProDetailDao.findListByTempId(approveTemp.getId());
            for (ApproveLinkProDetail approveLinkProDetail : approveLinkProDetailList) {
                ApproveTempLinkRela approveTempLinkRela = approveTempLinkRelaDao.findById(approveLinkProDetail.getTempLinkRelaId());
                ApproveLink approveLink = approveLinkDao.findById(approveTempLinkRela.getApproveLinkId());
                String linkName = approveLink.getLinkName();
                approveTempLinkRelaDto.setLinkName(linkName);
                ApproveAreaProcess approveAreaProcess = approveAreaProcessDao.findById(approveLinkProDetail.getApproveAreaProId());
                if (approveAreaProcess == null) {
                    continue;
                }
                // 机构信息
                Police police = policeDao.findById(approveAreaProcess.getPoliceId());
                List<ApproveAreaProDetailDto> approveAreaProDetailDtoList = approveAreaProDetailDao.findListByapproveAreaProId(approveAreaProcess.getId());
                approveAreaProcess.setProcessInfo(ApprovalActivityUtil.thirdJson(approveAreaProDetailDtoList, approveAreaProcess, police, approveTempLinkRelaDto));
                approveAreaProcess.setUpdateTime(date);
                approveAreaProcess.setEffectTime(date);
                approveAreaProcess.setApproveSetStatus("1");
                approveAreaProcessDao.update(approveAreaProcess);
                List<ApproveProcessDto> approveProcessDtoList = approveAreaProcessDao.findAllIdBypolice(police.getId(), approveTempLinkRela.getId());
                if (approveProcessDtoList != null && approveProcessDtoList.size() > 1) {
                    System.out.println(approveProcessDtoList.size());
                }
                for (ApproveProcessDto approveProcessDto : approveProcessDtoList) {
                    approveLinkProDetail.setProcessInfo(ApprovalActivityUtil.secondJson(approveProcessDto, approveLinkProDetail, approveTempLinkRelaDto));
                    approveLinkProDetail.setUpdateTime(date);
                    approveLinkProDetailDao.update(approveLinkProDetail);
                }
            }

            // 生成并启动审批主流程(省级模板不启动审批主流程，市级模板才启动审批主流程)
            if (approveTemp.getParentTempId() != null) {
                saveMainProcess(approveTemp);
            }
        } catch (Exception e) {
            logger.error(e.getMessage());
        }
    }

    private String saveMainProcess(ApproveTemp approveTemp) throws Exception {
        // get审批流程配置ID
        Long approveTempId = approveTemp.getId();
        // 将配置信息全部改为无效
        approveTemp = approveTempDao.findById(approveTempId);

        Police currentPolice = policeDao.findById(approveTemp.getPoliceId());
        // get流程名称
        String approveTempName = approveTemp.getTempName();
        // get唯一标识ID
        String tempCode = approveTemp.getTempCode();
        String businessTypeCode = "";

        String groupId = "";
        // 科长账号
        Config kzConfig = configDao.findByKey(Constants.KZZHID);
        if (kzConfig != null && StringUtil.isNotEmpty(kzConfig.getValue())) {
            groupId = kzConfig.getValue();
        }
        // 业务类型code
        if (tempCode.contains("-")) {
            businessTypeCode = BusinessType.getBusinessType(tempCode.split("-")[0]);
        }
        String maxApproveLevel = approveTempDao.getMaxApproveLevelByApproveTempId(approveTempId);
        String configMsg = ""; // 配置结果
        if (StringUtil.isNotEmpty(maxApproveLevel)) {
            String orgtype = currentPolice.getOrgtype(); // 当前机构类型
            String superAreaCode = ""; // 上级机构编码
            String superOrgtype = ""; // 上级机构类别

            Long policeId = currentPolice.getId(); // 当前机构ID

            String areaCode = currentPolice.getAreacode(); // 当前机构所在地区,地区只有6位
            if (orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)) {
                // 省级
                areaCode = areaCode.substring(0, 2);
            } else if (orgtype.equals(Constants.POLICE_ORGTYPE_SHI)) {
                // 市级
                areaCode = areaCode.substring(0, 4);
                superAreaCode = areaCode.substring(0, 2) + "0000";
                superOrgtype = Constants.POLICE_ORGTYPE_SHENG;
            } else if (orgtype.equals(Constants.POLICE_ORGTYPE_QX)) {
                // 区县
                superAreaCode = areaCode.substring(0, 4) + "00";
                superOrgtype = Constants.POLICE_ORGTYPE_SHI;
            } else {
                // 派出所
                superAreaCode = areaCode;
                superOrgtype = Constants.POLICE_ORGTYPE_QX;
            }
            if (!orgtype.equals(Constants.POLICE_ORGTYPE_SHENG)) {
                /**
                 * 判断审批模板当前机构的所属上级机构是否都配置完成，如果未配置完成则不能启动主流程,省级机构除外
                 */
                CheckTempConfigDto checkDto = new CheckTempConfigDto();
                checkDto.setTempId(approveTempId);
                checkDto.setAreaCode(superAreaCode);
                checkDto.setOrgtype(superOrgtype);
                Long check = approveTempLinkRelaDao.checkTempConfigCompleteByOrgTypeAndCityCode(checkDto);
                if (check != null && check > 0) {
                    configMsg = "模板环节上级机构未配置完成！";
                    logger.info(configMsg);
                    return configMsg;
                }
            }

            List<ApproveTempLinkRela> approveTempLinkRelaList = approveTempLinkRelaDao
                    .findByApproveTempIdList(approveTempId);
            List<Police> policeList = new ArrayList<Police>();
            if (orgtype.equals(Constants.POLICE_ORGTYPE_PCS)) {
                // 派出所，只查询自己机构信息
                Police police = policeDao.findById(policeId);
                policeList.add(police);
            } else {
                // 非派出所，则取本级机构以及下属机构信息
                policeList = policeDao.findPoliceByOrgTypeAndLikeAreacode(maxApproveLevel, areaCode);
            }
            if (policeList != null && policeList.size() > 0) {
                List<ApproveTempProcess> approveTempProcessList = new ArrayList<>();
                for (Police police : policeList) {
                    String[] policeIds = police.getPath().split("/");
                    ApproveLinkProDetailDto searchDto = new ApproveLinkProDetailDto();
                    searchDto.setPoliceIds(policeIds);
                    List<ApproveTempLinkRelaDto> approveTempLinkRelaDtoList = new ArrayList<ApproveTempLinkRelaDto>();
                    if (approveTempLinkRelaList != null && approveTempLinkRelaList.size() > 0) {
                        int tempLinkSize = approveTempLinkRelaList.size();
                        for (ApproveTempLinkRela approveTempLinkRela : approveTempLinkRelaList) {
                            Long tempLinkRelaId = approveTempLinkRela.getId();
                            String approveLevel = approveLinkLevelDao
                                    .getMaxApproveLevelByTempLinkRelaId(tempLinkRelaId);

                            // 类型是1、报名确认， 2、缴费确认， 3、指纹获取，4、考试安排没有审批层次
                            if (StringUtil.isEmpty(approveLevel)) {
                                ApproveLink approveLink = approveLinkDao
                                        .findById(approveTempLinkRela.getApproveLinkId());
                                if (approveLink != null) {
                                    /*
                                     * 1、判断未设置环境是不是特殊节点：保安资格证特殊节点有报名确认、缴费确认、指纹获取
                                     * 、考试安排。另外模板用到指派民警
                                     * 2、如果不是特殊节点，则环境未配置地区则不启动整体流程
                                     */
                                    if (StringUtils.isEmpty(approveLink.getLinkType())) {
                                        // 非特殊节点，则不启动整体流程
                                        configMsg = "审批流程未启动：存在未配置审批单位的审批环节";
                                        return configMsg;
                                    } else {
                                        // 特殊节点
                                        ApproveTempLinkRelaDto approveTempLinkRelaDto = new ApproveTempLinkRelaDto();
                                        approveTempLinkRelaDto.setLinkName(approveLink.getLinkName());
                                        approveTempLinkRelaDto.setLinkType(approveLink.getLinkType());
                                        approveTempLinkRelaDtoList.add(approveTempLinkRelaDto);
                                    }
                                }
                            } else {
                                searchDto.setTempLinkRelaId(tempLinkRelaId);
                                searchDto.setApproveLevel(approveLevel);
                                ApproveLinkProDetail pproveLinkProDetail = approveLinkProDetailDao
                                        .findListByTempLinkRelaIdAndPoliceIds(searchDto);
                                if (pproveLinkProDetail != null) {
                                    ApproveTempLinkRelaDto approveTempLinkRelaDto = new ApproveTempLinkRelaDto();
                                    approveTempLinkRelaDto = approveTempLinkRelaDao
                                            .findDtoById(pproveLinkProDetail.getTempLinkRelaId());
                                    approveTempLinkRelaDto.setApproveLinkProDetailId(pproveLinkProDetail.getId());
                                    approveTempLinkRelaDto
                                            .setApproveAreaProId(pproveLinkProDetail.getApproveAreaProId());
                                    approveTempLinkRelaDtoList.add(approveTempLinkRelaDto);
                                } else {
                                    // 找不到流程配置信息则不继续循环，循环下一个机构
                                    break;
                                }
                            }
                        }
                        // 环节阶段都配置完成才可以启动主流程
                        if (approveTempLinkRelaDtoList != null && approveTempLinkRelaDtoList.size() > 0
                                && tempLinkSize == approveTempLinkRelaDtoList.size()) {
                            // 如果为保安服务公司年度报告备案要把最后流程的人员ID修改为annals
                            if (businessTypeCode.equals(BusinessType.NDBG)) {
                                List<ApproveAreaProcess> approveAreaProcessList = new ArrayList<ApproveAreaProcess>();
                                ApproveAreaProcess approveAreaProcess = approveAreaProcessDao
                                        .findById(approveTempLinkRelaDtoList.get(approveTempLinkRelaDtoList.size() - 1)
                                                .getApproveAreaProId());
                                if (approveAreaProcess != null) {
                                    approveAreaProcessList.add(approveAreaProcess);
                                }
                                if (approveTempLinkRelaDtoList.size() > 1) {
                                    approveAreaProcess = approveAreaProcessDao.findById(approveTempLinkRelaDtoList
                                            .get(approveTempLinkRelaDtoList.size() - 2).getApproveAreaProId());
                                    if (approveAreaProcess != null) {
                                        approveAreaProcessList.add(approveAreaProcess);
                                    }
                                }
                                ApprovalActivityUtil.thirdJsonUpdate(approveAreaProcessList);
                            }
                            ApproveTempProcess approveTempProcess = new ApproveTempProcess();
                            approveTempProcess.setCreateTime(new Date());
                            approveTempProcess.setUpdateTime(new Date());
                            approveTempProcess.setActive(true);
                            approveTempProcess.setApproveTempId(approveTempId);
                            approveTempProcess.setRegionLevel(police.getOrgtype());
                            approveTempProcess.setPoliceCode(StringUtil.isNotEmpty(police.getCode()) ? police.getCode() : "");
                            approveTempProcess.setPoliceId(police.getId());
                            String processID = tempCode + "-" + police.getId().toString();
                            String processName = approveTempName + police.getOrgname();
                            approveTempProcess.setProcessInfo(ApprovalActivityUtil.oneJson(approveTempLinkRelaDtoList,
                                    processID, processName, groupId));
                            approveTempProcessList.add(approveTempProcess);
                        }
                    }
                }
                if (approveTempProcessList != null && approveTempProcessList.size() > 0) {
                    approveTempProcessDao.batchSave(approveTempProcessList);
                    ApproveTemp approveTempSave = approveTempDao.findById(approveTempId);
                    approveTempSave.setEffectTime(new Date());
                    approveTempSave.setUpdateTime(new Date());
                    approveTempSave.setApproveSetStatus(Constants.CONFIGURATION_CONFIGURED);
                    approveTempDao.update(approveTempSave);
                }
            } else {
                if (approveTempLinkRelaList != null && approveTempLinkRelaList.size() > 0) {
                    for (ApproveTempLinkRela approveTempLinkRela : approveTempLinkRelaList) {
                        Long tempLinkRelaId = approveTempLinkRela.getId();
                        String approveLevel = approveLinkLevelDao.getMaxApproveLevelByTempLinkRelaId(tempLinkRelaId);
                        // 类型是1、报名确认， 2、缴费确认， 3、指纹获取，4、考试安排没有审批层次
                        if (StringUtil.isEmpty(approveLevel)) {
                            ApproveLink approveLink = approveLinkDao.findById(approveTempLinkRela.getApproveLinkId());
                            if (approveLink != null) {
                                /*
                                 * 1、判断未设置环境是不是特殊节点：保安资格证特殊节点有报名确认、缴费确认、指纹获取
                                 * 、考试安排。另外模板用到指派民警 2、如果不是特殊节点，则环境未配置地区则不启动整体流程
                                 */
                                if (StringUtils.isEmpty(approveLink.getLinkType())) {
                                    // 非特殊节点，则不启动整体流程
                                    configMsg = "审批流程未启动：存在未配置审批单位的审批环节";
                                    return configMsg;
                                }
                            }
                        }
                    }
                }
            }
        } else {
            configMsg = "审批环节未配置";
        }
        return configMsg;
    }
}
