package com.bcxin.ars.rest;


import com.alibaba.fastjson.JSON;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.model.Config;
import com.bcxin.ars.model.sys.Approval;
import com.bcxin.ars.model.sys.ApprovalLog;
import com.bcxin.ars.rest.util.act.DateJsonValueProcessor;
import com.bcxin.ars.rest.util.act.ResponseUtil;
import com.bcxin.ars.service.sb.LegalchangeService;
import com.bcxin.ars.service.sb.SponsorlicenseService;
import com.bcxin.ars.service.sb.TraincompanyapplyService;
import com.bcxin.ars.service.sys.ApprovalLogService;
import com.bcxin.ars.service.sys.ApprovalService;
import com.bcxin.ars.service.util.ArsUtil;
import com.bcxin.ars.service.util.ConfigSignUtils;
import com.bcxin.ars.service.util.ConfigUtils;
import com.bcxin.ars.util.Constants;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Controller
@RequestMapping("history")
public class ActivitiHistoryController {

    @Autowired
    private ApprovalLogService approvalLogService;

    @Autowired
    private ApprovalService approvalService;
    @Autowired
    private LegalchangeService legalchangeService;
    @Autowired
    private SponsorlicenseService sponsorlicenseService;
    @Autowired
    private TraincompanyapplyService traincompanyapplyService;
    @Value("${timeFlag}")
    private String timeFlag = "";
    @Autowired
    private ConfigSignUtils configSignUtils;

    @Autowired
    private ConfigUtils configUtils;
    @Autowired
    private ArsUtil arsUtil;
    private static  final Logger logger = LoggerFactory.getLogger(ActivitiHistoryController.class);
    /**
     * 查询历史流程批注
     *
     * @param response
     * @param processInstanceId
     *            流程ID
     * @return
     * @throws Exception
     */
    @RequestMapping("/listHistoryCommentWithProcessInstanceId")
    public String listHistoryCommentWithProcessInstanceId(
            HttpServletResponse response, String processInstanceId) throws Exception {
        if (processInstanceId == null) {
            return null;
        }

        /*List<ActivitiComment> commentListOut;
        List<Comment> commentList;

        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.registerJsonValueProcessor(java.util.Date.class,
                //时间格式转换
                new DateJsonValueProcessor("yyyy-MM-dd HH:mm:ss"));
        JSONObject result = new JSONObject();
        JSONArray jsonArray;

        Config config = configService.findByKey("police");
        // 外网
        if (config.getValue().equals("0")  && timeFlag.equals("true")) {
            commentListOut = activitiCommentService.findByProcessInstanceId(processInstanceId);
            // 改变顺序，按原顺序的反向顺序返回list
            Collections.reverse(commentListOut); //集合元素反转
             jsonArray = JSONArray.fromObject(commentListOut, jsonConfig);
        }else{//内网
             commentList = taskService.getProcessInstanceComments(processInstanceId);
            // 改变顺序，按原顺序的反向顺序返回list
            Collections.reverse(commentList); //集合元素反转
             jsonArray = JSONArray.fromObject(commentList, jsonConfig);
        }*/
        JSONObject result = new JSONObject();
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.registerJsonValueProcessor(java.util.Date.class,
        //时间格式转换
        new DateJsonValueProcessor("yyyy-MM-dd HH:mm:ss"));
        List<ApprovalLog> logList = approvalLogService.findByProcessInstanceId(processInstanceId);
        JSONArray jsonArray = JSONArray.fromObject(logList, jsonConfig);
        result.put("rows", jsonArray);
        ResponseUtil.write(response, result);
        return null;
    }


    @RequestMapping("listHistoryComment")
    public ModelAndView editInit(Long processInstanceId){
        ModelAndView view = new ModelAndView();
        if (processInstanceId == null) {
            return null;
        }
        List<ApprovalLog> logList = approvalLogService.findByProcessInstanceId(processInstanceId.toString());
        view.addObject("logList", logList);

        //查询对外附件
        if(logList.size()>0&&null!=logList.get(0)&&null!=logList.get(0).getApprovalid()){
            Approval approval = approvalService.findById(Long.parseLong(logList.get(0).getApprovalid()));
            view.addObject("approval",approval);
        }

        view.setViewName("approval/approvalLog");
        return view;
    }

    @RequestMapping("listHistoryCommentAndTable")
    @RequiresPermissions("sponsorlicense:printDispose")
    public ModelAndView editInitAndTable(String processInstanceId){

        ModelAndView view = new ModelAndView();
        if (processInstanceId == null) {
            return null;
        }
        Approval approval = approvalService.findByProcessInstanceId(processInstanceId);
        List<ApprovalLog> logList = approvalLogService.findByApprovalId(approval.getId().toString());
        view.addObject("logList", logList);
        Map map = approvalService.findByApprovalId(approval.getId());
        String businesstype = map.get("businesstype").toString();
        Long businessid = Long.valueOf(map.get("businessid").toString());
        String type="1";
        Config provinceConfig = configUtils.getConfigByKey(Constants.CURRENT_PROVINCE);
      String province=  provinceConfig.getValue();
        Map messageMap=new HashMap();
        if ("001".equals(businesstype)) {
            //'保安服务公司许可证'
            messageMap= sponsorlicenseService.searchForPrintf(businessid);

        } else if ("002".equals(businesstype)) {
            //	'保安培训机构许可证'
            messageMap=   traincompanyapplyService.searchForPrintf(businessid);
        }else if ("007".equals(businesstype)) {
            //'保安服务（培训）许可证项目变更'法人变更
            messageMap=legalchangeService.searchForPrintf(businessid);
            type="2";
        }
        String configSign=configSignUtils.getConfigSign(type,province);
        Map mapTypes = JSON.parseObject(configSign);
        mapTypes.put("approvalId",approval.getId());
        view.addObject("tableMessage",JSONObject.fromObject(configSign));
       Map approvalLogMap= approvalLogService.findPrintfMessageByApprovalId(mapTypes);
        if (approvalLogMap.get("personPoliceStationName")==null){
            if (approvalLogMap.get("personPoliceStationName2")==null){
                approvalLogMap.put("personPoliceStationName",approvalLogMap.get("personPoliceStationName1"));
                approvalLogMap.put("approvalPoliceStationDate",approvalLogMap.get("approvalPoliceStationDate1"));
                approvalLogMap.put("approvalPoliceStationReason",approvalLogMap.get("approvalPoliceStationReason1"));

            }else {
                approvalLogMap.put("personPoliceStationName",approvalLogMap.get("personPoliceStationName2"));
                approvalLogMap.put("approvalPoliceStationDate",approvalLogMap.get("approvalPoliceStationDate2"));
                approvalLogMap.put("approvalPoliceStationReason",approvalLogMap.get("approvalPoliceStationReason2"));

            }
        }
        view.addObject("companyDetail", map);
        view.addObject("approvalMessage", approvalLogMap);
        view.addObject("messageMap",messageMap);
        view.setViewName("approval/approvalTable"+configUtils.getCurrentNative());
        return view;
    }

    //保安服务公司许可项目审检文件处理签打印
    @RequestMapping("listHistoryCommentAndTableV2/{processInstanceId}")
    @RequiresPermissions("sponsorlicense:printDispose")
    public @ResponseBody AjaxResult listHistoryCommentAndTableV2(@PathVariable("processInstanceId")String processInstanceId){
        AjaxResult result = new AjaxResult();
        if (processInstanceId == null) {
            return null;
        }
        Map<Object,Object> sponsorlicenseMap = new HashMap<>();
        try {

            Approval approval = approvalService.findByProcessInstanceId(processInstanceId);
            List<ApprovalLog> logList = approvalLogService.findByApprovalId(approval.getId().toString());
            Map map = approvalService.findByApprovalId(approval.getId());
            sponsorlicenseMap.put("logList", logList);
            String businesstype = map.get("businesstype").toString();
            Long businessid = Long.valueOf(map.get("businessid").toString());
            String type="1";
            Config provinceConfig = configUtils.getConfigByKey(Constants.CURRENT_PROVINCE);
            String province=  provinceConfig.getValue();
            Map messageMap=new HashMap();
            if ("001".equals(businesstype)) {
                //'保安服务公司许可证'
                messageMap= sponsorlicenseService.searchForPrintf(businessid);

            } else if ("002".equals(businesstype)) {
                //	'保安培训机构许可证'
                messageMap=   traincompanyapplyService.searchForPrintf(businessid);
            }else if ("007".equals(businesstype)) {
                //'保安服务（培训）许可证项目变更'法人变更
                messageMap=legalchangeService.searchForPrintf(businessid);
                type="2";
            }
            String configSign=configSignUtils.getConfigSign(type,province);
            Map mapTypes = JSON.parseObject(configSign);
            mapTypes.put("approvalId",approval.getId());
            sponsorlicenseMap.put("tableMessage",JSONObject.fromObject(configSign));
            Map approvalLogMap= approvalLogService.findPrintfMessageByApprovalId(mapTypes);
            if (approvalLogMap.get("personPoliceStationName")==null){
                if (approvalLogMap.get("personPoliceStationName2")==null){
                    approvalLogMap.put("personPoliceStationName",approvalLogMap.get("personPoliceStationName1"));
                    approvalLogMap.put("approvalPoliceStationDate",approvalLogMap.get("approvalPoliceStationDate1"));
                    approvalLogMap.put("approvalPoliceStationReason",approvalLogMap.get("approvalPoliceStationReason1"));

                }else {
                    approvalLogMap.put("personPoliceStationName",approvalLogMap.get("personPoliceStationName2"));
                    approvalLogMap.put("approvalPoliceStationDate",approvalLogMap.get("approvalPoliceStationDate2"));
                    approvalLogMap.put("approvalPoliceStationReason",approvalLogMap.get("approvalPoliceStationReason2"));

                }
            }
            sponsorlicenseMap.put("companyDetail", map);
            sponsorlicenseMap.put("approvalMessage", approvalLogMap);
            sponsorlicenseMap.put("messageMap",messageMap);
            result.setSuccessful(true);
            result.setData(sponsorlicenseMap);
        }catch (Exception e){
            logger.error(e.getMessage(), e);
            throw e;
        }
        return result;
    }

    @RequestMapping("listHistoryCommentByApprovalid")
    public ModelAndView listHistoryCommentByApprovalid(Long approvalid){
        ModelAndView view = new ModelAndView();
        if (approvalid == null) {
            return null;
        }

        List<ApprovalLog> logList = approvalLogService.findByApprovalId(approvalid.toString());
        //查询对外附件
        Approval approval = approvalService.findById(approvalid);
        view.addObject("approval",approval);

        view.addObject("logList", logList);
        view.setViewName("approval/approvalLog");
        return view;
    }
}
