package com.bcxin.ars.filter.nx;

import com.dragonsoft.dids.client.sys.DidsServiceLocator;
import com.dragonsoft.dids.model.AuthResult;
import com.dragonsoft.dids.model.BaseUserInfo;
import com.dragonsoft.dids.model.UserInfo;
import com.dragonsoft.encrypt.EncryptFactory;
import com.dragonsoft.encrypt.EncryptHandler;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;

/**
 * 宁夏单点过滤器
 * @author subh
 * @version 1.0
 */
public class SSOSysInit extends HttpServlet {
	private static final long serialVersionUID = 1L;
       
    public SSOSysInit() {
        super();
    }
@Override
	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		HttpSession session = request.getSession();
		//取得DIDS2-Server认证成功后，返回的用户基本信息对象AuthResult
		AuthResult au=DidsServiceLocator.getUserResourceService(session).getAuthResult();
		//从AuthResult取得登录用户的DIDS2,用户id
		String userId = au.getUserId();
		//通过userId获取登录用户的详细信息对象
		UserInfo userInfo=DidsServiceLocator.getUserResourceService().getUserInfo(userId);
		// userInfo里面的baseUserInfo包含的信息才是用户的基本信息。
		BaseUserInfo baseUserInfo = userInfo.getBaseUserInfo();
		baseUserInfo.getUserId(); // 用户的id
		baseUserInfo.getUserNo(); // 登录用户名
		baseUserInfo.getAdminType(); // 用户类型
		baseUserInfo.getDeptId(); // 机构（如：福建厦门）的id
		baseUserInfo.getIdCard(); // 身份证
		baseUserInfo.getManId(); // 人员ID
		baseUserInfo.getPoliceNo(); // 警号
		// TODO:接入应用根据用户信息来处理登录初始化信息。

		EncryptHandler rsaHandler = EncryptFactory.getInstance();
		String  encryptIdcard=rsaHandler.encapsulateString(baseUserInfo.getIdCard());
		System.out.println(encryptIdcard);

		//获取要重定向的url
		String forwardUrl = request.getParameter("forwardUrl");
		String queryString = request.getQueryString();
		request.getSession().setAttribute("userId", baseUserInfo.getUserId());
		// request.getSession().setAttribute("userNo", baseUserInfo.getUserNo());
		request.getRequestDispatcher(forwardUrl).forward(request, response);
	}
	@Override
	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		this.doGet(request, response);
	}

}
