package com.bcxin.ars.filter.nx;

import com.dragonsoft.dids.client.sys.DidsServiceLocator;
import com.dragonsoft.dids.model.AuthResult;
import com.dragonsoft.dids.model.UserInfo;

import javax.servlet.*;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import java.io.IOException;

/**
 * 宁夏单点过滤器
 * @author subh
 * @version 1.0
 */
public class LoginFilter implements Filter {

    public LoginFilter() {
    }
	@Override
	public void destroy() {
	}
	@Override
	public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
		HttpServletRequest req = (HttpServletRequest) request;
		HttpServletResponse res = (HttpServletResponse) response;
		HttpSession session = req.getSession();
		AuthResult au = DidsServiceLocator.getUserResourceService(session).getAuthResult();
        String userId = au.getUserId();
        UserInfo u = DidsServiceLocator.getUserResourceService().getUserInfo(userId);
        if (u != null) {
        	String userNo = u.getBaseUserInfo().getUserNo();
        	System.out.println("didsserver userNo:" + userNo);
        	req.getSession().setAttribute("userInfo", u);
        } else {
		}
        req.getRequestDispatcher("/index.jsp").forward(request, response);
	}
	@Override
	public void init(FilterConfig fConfig) throws ServletException {
		// TODO Auto-generated method stub
	}

}
