package com.bcxin.ars.filter;

import javax.servlet.*;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * @author panxianwei
 * @date 2023/4/12 18:16
 */
@WebFilter(urlPatterns = { "*.json" })
public class XssFilter implements Filter {

    /**
     * 排除链接
     */
    public List<String> excludes = new ArrayList<>();

    @Override
    public void init(FilterConfig filterConfig) throws ServletException {
//        String tempExcludes = filterConfig.getInitParameter("excludes");
//        if (StringUtils.isNotEmpty(tempExcludes))
//        {
//            String[] url = tempExcludes.split(",");
//            for (int i = 0; url != null && i < url.length; i++)
//            {
//                excludes.add(url[i]);
//            }
//        }
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain)
            throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest) request;
        HttpServletResponse resp = (HttpServletResponse) response;
//        if (handleExcludeURL(req, resp))
//        {
//            chain.doFilter(request, response);
//            return;
//        }
        XssHttpServletRequestWrapper xssRequest = new XssHttpServletRequestWrapper((HttpServletRequest) request);
        chain.doFilter(xssRequest, response);
    }

    private boolean handleExcludeURL(HttpServletRequest request, HttpServletResponse response)
    {
        String url = request.getServletPath();
        String method = request.getMethod();
        // GET DELETE 不过滤
        if (method == null || method.matches("GET") || method.matches("DELETE"))
        {
            return true;
        }
        return true;

    }

    @Override
    public void destroy() {
        Filter.super.destroy();
    }
}
