package com.bcxin.ars.filter;

import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.rest.util.ResponseJsonUtils;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import java.io.IOException;

/**
 * @author linqinglin
 * @date 2020/06/05 0005 10:31
 */
public class BaseAuthcFilter extends FormAuthenticationFilter {

    @Override
    protected void redirectToLogin(ServletRequest request, ServletResponse response) throws IOException {
        HttpServletRequest httpServletRequest = (HttpServletRequest) request;

        System.out.println("request url:"+httpServletRequest.getRequestURL().toString());
        boolean isajax = ResponseJsonUtils.isJsonAccept(httpServletRequest);
        if (isajax) {
            ResponseJsonUtils.writeJSON(response, AjaxResult.unLogin());
        } else {
            String loginUrl = this.getLoginUrl();
            WebUtils.issueRedirect(request, response, loginUrl);
        }
    }
}
