package com.bcxin.ars.service.util;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.ars.dao.sys.InterfaceLogDao;
import com.bcxin.ars.dto.AjaxResult;
import com.bcxin.ars.dto.SAASMessageDto;
import com.bcxin.ars.dto.SAASResultDto;
import com.bcxin.ars.dto.SaaSCompany;
import com.bcxin.ars.model.User;
import com.bcxin.ars.model.sys.InterfaceLog;
import com.bcxin.ars.util.Constants;
import com.bcxin.ars.util.StringUtil;
import com.xiaoleilu.hutool.http.HttpUtil;
import org.apache.commons.collections.map.HashedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 调saas接口工具类
 * @author linqinglin
 * @date 2019/04/23 0023 15:14
 */
@Component
public class SAASInterfaceUtil {

    private static Logger logger = LoggerFactory.getLogger(SAASInterfaceUtil.class);

    @Autowired
    private InterfaceLogDao interfaceLogDao;

    @Autowired
    private ConfigUtils configUtils;

    @Autowired
    private ArsUtil arsUtil;


    /**
     * 调saas接口
     * @param url 接口地址
     * @param paramObj 传参
     */
    public AjaxResult callInterface(String url , Object paramObj){
        //对象转map
        Map<String,Object> paramMap = BeanUtil.beanToMap(paramObj);
        return callInterface(url,paramMap);
    }

    /**
     * 调saas接口
     * @param url 接口地址
     * @param paramMap 传参
     */
    public AjaxResult callInterface(String url , Map<String,Object> paramMap){
        String msg = StringUtil.EMPTY;
        Boolean result = true;
        Object data = null;
        User currentUser = arsUtil.getCurrentUser();
        //获取SaaS对接地址

        url = configUtils.saas_data_host + url;
//        url = "http://localhost:8199/" + url;

        InterfaceLog interfaceLog = new InterfaceLog();
        interfaceLog.setCreateTime(new Date());
        interfaceLog.setActive(true);
        interfaceLog.setUrl(url);
        interfaceLog.setParameters(JSONObject.toJSONString(paramMap));

        if(currentUser != null){
            interfaceLog.setUpdateBy(currentUser.getUsername());
        }
        try {
            //获取结果
            String resultStr = HttpUtil.post(url, paramMap);
            interfaceLog.setResult(resultStr);

            SAASResultDto resultDto = JSONObject.parseObject(resultStr, SAASResultDto.class);
            if(resultDto != null && StringUtil.isNotEmpty(resultDto.getRetType())) {
                String retType = resultDto.getRetType();
                if (Constants.BTK_IS_SUCCESS.equals(retType)) {
                    data = resultDto.getData();
                    logger.info("百保盾与Saas同步成功");
                } else {
                    result = false;
                    //错误信息
                    msg =  resultDto.getMsg();
                    logger.error(resultStr);
                    logger.info("百保盾与Saas同步失败");
                }
            }else{
                result = false;
                msg =  "没有返回结果";
                logger.info("百保盾与Saas同步失败,没有返回结果");
            }
        }catch (Exception e){
            result = false;
            logger.error(e.getMessage(),e);
            msg = e.getMessage();
            interfaceLog.setResult(e.getMessage());
        }
        interfaceLog.setUpdateTime(new Date());
        interfaceLog.setSuccessful(result);
        /**
         * 异步保存
         */
        new Thread(()->{
            interfaceLogDao.insert(interfaceLog);
        }).start();

        if(StringUtil.isNotEmpty(msg)){
            msg = "百保盾与Saas同步失败:" + msg;
        }
        return new AjaxResult(result,msg,data);
    }

    /***
     * 删除消息
     * @param message
     * @return
     */
    public AjaxResult delSaasMsg(SAASMessageDto message){
        //url地址
        String url = Constants.SAAS_MESSAGE_DEL;
        return this.callInterface(url,message);
    }

    /***
     * 发送消息
     * @param message
     * @return
     */
    public AjaxResult sendSaasMsg(SAASMessageDto message){
        //url地址
        String url = Constants.SAAS_MESSAGE_SEND;


        if(StringUtil.isEmpty(message.getSendPer())){
            message.setSendPer("system");
        }
        if(StringUtil.isEmpty(message.getPlatId())){
            message.setPlatId("11");
        }
        if(StringUtil.isEmpty(message.getWay())){
            message.setWay(Constants.SAAS_MESSAGE_SEND_WAY);
        }

        return this.callInterface(url,message);
    }

    /***
     * 获取公共服务平台公司ID
     * @param userNames 用户名称
     * @return
     */
    public List<SaaSCompany> querySaaSComId(String userNames){
        List<SaaSCompany> resultList = null;
        String url = Constants.SAAS_COMID_LIST;
        SAASMessageDto messageDto = new SAASMessageDto();
        messageDto.setUserNames(userNames.toString());
        AjaxResult ajaxResult =  this.callInterface(url,messageDto);
        if(ajaxResult.getData()!=null){
            resultList=  JSON.parseArray(ajaxResult.getData().toString(),SaaSCompany.class);
        }
        return resultList;

    }

    public static void main(String[] args) {
      //String url ="http://114.116.191.105:8010/ars-rest/comTask/contract/save.json";
      //String contracts = "[{\"comContractId\":638318060121358336,\"comTaskId\":636983286630973440,\"createBy\":634333489453334528,\"createTime\":1572229567521,\"isDelete\":\"0\",\"updateTime\":1572229567524}]";
      ////对象转map
      //Map<String,Object> paramMap = new HashedMap();
      //paramMap.put("sid","0E44373E153D7C59341D77809D11C17E07FD91598F759F3E79BFA3D9BDB2CCCF7DD089A41E48CD4CADB1F18A76187437EC609C2215764BBA1AF3EF5CE85BAAC2");
      //paramMap.put("comTaskId",636983286630973440L);
      //paramMap.put("contracts",contracts);
      ////获取结果
      //String resultStr = HttpUtil.post(url, paramMap);
      //System.out.println(resultStr);
        String url ="http://qiye.baibaodun.cn:9009//thirdPlat/bbd-callBack/batch-per-auth-result";
        Map<String,Object> paramMap = new HashedMap();
        paramMap.put("authList","[{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622701198909073438\",\"name\":\"信伟伟\",\"perId\":\"859366421246668800\",\"updateTime\":\"2021-09-08 11:45:02\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"130984197810290634\",\"name\":\"方海军\",\"perId\":\"859758876223307776\",\"updateTime\":\"2021-09-08 11:45:02\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"152825197904295014\",\"name\":\"薛飞\",\"perId\":\"859757317800751104\",\"updateTime\":\"2021-09-08 11:45:02\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622726196510051235\",\"name\":\"陈银丑\",\"perId\":\"857649161364459520\",\"updateTime\":\"2021-09-08 11:45:02\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"370783198606213772\",\"name\":\"张永建\",\"perId\":\"859376346831749120\",\"updateTime\":\"2021-09-08 11:45:02\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622822200101164529\",\"name\":\"苏粉莲\",\"perId\":\"843871599753252864\",\"updateTime\":\"2021-09-08 11:45:03\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"210504196706161877\",\"name\":\"胡明开\",\"perId\":\"859477932224966656\",\"updateTime\":\"2021-09-08 11:45:03\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622727199011274725\",\"name\":\"齐雪梅\",\"perId\":\"859388627141492736\",\"updateTime\":\"2021-09-08 11:45:03\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622727197102093533\",\"name\":\"胡小进\",\"perId\":\"859389582986080256\",\"updateTime\":\"2021-09-08 11:45:03\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"15030319720607003X\",\"name\":\"张治华\",\"perId\":\"851864067041619968\",\"updateTime\":\"2021-09-08 11:45:03\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622701199003084514\",\"name\":\"焦小亮\",\"perId\":\"864093615198605312\",\"updateTime\":\"2021-09-08 11:45:04\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"62272219910709361X\",\"name\":\"王勇\",\"perId\":\"566191802059587584\",\"updateTime\":\"2021-09-08 11:45:04\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622826200302181531\",\"name\":\"陈坤\",\"perId\":\"869581883667279872\",\"updateTime\":\"2021-09-08 11:45:04\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622301196801091916\",\"name\":\"韩银生\",\"perId\":\"870249763299815424\",\"updateTime\":\"2021-09-08 11:45:04\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"630104196710201014\",\"name\":\"刘永卫\",\"perId\":\"871716013578162176\",\"updateTime\":\"2021-09-08 11:45:04\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"630104197706081018\",\"name\":\"纳运来\",\"perId\":\"871716276502302720\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"630104197204072533\",\"name\":\"栗绍活\",\"perId\":\"871717643006668800\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"370125198512148512\",\"name\":\"温涛\",\"perId\":\"875030918151634944\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"152324200004043816\",\"name\":\"张明清\",\"perId\":\"875350174094327808\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"130823199912152516\",\"name\":\"林阳\",\"perId\":\"875387354023985152\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"612732200106224821\",\"name\":\"姬娜娜\",\"perId\":\"875393863557677056\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"130533200102026616\",\"name\":\"褚双树\",\"perId\":\"875412948081278976\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622726197311050234\",\"name\":\"马振军\",\"perId\":\"768827402444292096\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"41148119940310126X\",\"name\":\"丁佳莉\",\"perId\":\"875419737746046976\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"522622199912090025\",\"name\":\"李铭欣\",\"perId\":\"875354373325684736\",\"updateTime\":\"2021-09-08 11:45:05\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622722197103241727\",\"name\":\"徐巧桂\",\"perId\":\"875359697467080704\",\"updateTime\":\"2021-09-08 11:45:06\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"232126199611020217\",\"name\":\"郭帅\",\"perId\":\"875395042866888704\",\"updateTime\":\"2021-09-08 11:45:06\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"410322198101186842\",\"name\":\"杜玉兴\",\"perId\":\"875681684520534016\",\"updateTime\":\"2021-09-08 11:45:06\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"412728200008283850\",\"name\":\"吴旭康\",\"perId\":\"875690014244700160\",\"updateTime\":\"2021-09-08 11:45:06\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622822200109234712\",\"name\":\"李潇\",\"perId\":\"875711722309648384\",\"updateTime\":\"2021-09-08 11:45:06\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"513022199904015427\",\"name\":\"李晓淋\",\"perId\":\"875730785233534976\",\"updateTime\":\"2021-09-08 11:45:07\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622726199910152899\",\"name\":\"马晓刚\",\"perId\":\"875397825850507264\",\"updateTime\":\"2021-09-08 11:45:07\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"620121196803101930\",\"name\":\"陈万年\",\"perId\":\"875708314748026880\",\"updateTime\":\"2021-09-08 11:45:07\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622827199910192315\",\"name\":\"杜辉\",\"perId\":\"876885940016111616\",\"updateTime\":\"2021-09-08 11:45:07\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"62282520030407061X\",\"name\":\"彭超\",\"perId\":\"880850072852656128\",\"updateTime\":\"2021-09-08 11:45:07\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622823197302183234\",\"name\":\"宋尚坤\",\"perId\":\"880850072865239040\",\"updateTime\":\"2021-09-08 11:45:08\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"612127197604094013\",\"name\":\"卢建军\",\"perId\":\"882670037611778048\",\"updateTime\":\"2021-09-08 11:45:08\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"612726198912100076\",\"name\":\"薛晓阳\",\"perId\":\"883001290874056704\",\"updateTime\":\"2021-09-08 11:45:08\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"620421199310026127\",\"name\":\"路晓叶\",\"perId\":\"882711766813577216\",\"updateTime\":\"2021-09-08 11:45:08\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622701199506122535\",\"name\":\"马海贵\",\"perId\":\"883282525487304704\",\"updateTime\":\"2021-09-08 11:45:08\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"610321196908010444\",\"name\":\"王建华\",\"perId\":\"857346695524081664\",\"updateTime\":\"2021-09-08 11:45:09\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622726197702090372\",\"name\":\"贾军平\",\"perId\":\"857346618105155584\",\"updateTime\":\"2021-09-08 11:45:09\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"620421196907063330\",\"name\":\"赵玉国\",\"perId\":\"882698301638119424\",\"updateTime\":\"2021-09-08 11:45:09\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622826196602200432\",\"name\":\"刘全秀\",\"perId\":\"856860450460684288\",\"updateTime\":\"2021-09-08 11:45:09\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622726197604201497\",\"name\":\"刘胜利\",\"perId\":\"883283478429462528\",\"updateTime\":\"2021-09-08 11:45:09\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"41108219900529542X\",\"name\":\"申路平\",\"perId\":\"882684208374509568\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622727196505134737\",\"name\":\"陈宏斌\",\"perId\":\"850737740113092608\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"610326196805102233\",\"name\":\"李旭\",\"perId\":\"862347293718376448\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"152921198411095326\",\"name\":\"景淑红\",\"perId\":\"884019423411859456\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622727196405125913\",\"name\":\"曹金昌\",\"perId\":\"884046956450705408\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622426199304121535\",\"name\":\"马金虎\",\"perId\":\"859442888416587776\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622701199508063217\",\"name\":\"王鹏\",\"perId\":\"859123145838657536\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622726198801261653\",\"name\":\"岳随英\",\"perId\":\"859105576415555584\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622727198906285615\",\"name\":\"徐帆\",\"perId\":\"864094301017763840\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622727199402151116\",\"name\":\"李高阳\",\"perId\":\"860898290304585728\",\"updateTime\":\"2021-09-08 11:45:10\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"620502199005053635\",\"name\":\"金旭东\",\"perId\":\"864164897965633536\",\"updateTime\":\"2021-09-08 11:45:11\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622726198801072617\",\"name\":\"史世红\",\"perId\":\"859128364517978112\",\"updateTime\":\"2021-09-08 11:45:11\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622722198803232033\",\"name\":\"杜俊仁\",\"perId\":\"883736844716150784\",\"updateTime\":\"2021-09-08 11:45:11\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622726199101181219\",\"name\":\"张攀峰\",\"perId\":\"883742149298556928\",\"updateTime\":\"2021-09-08 11:45:11\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"612728198510010863\",\"name\":\"艾香香\",\"perId\":\"884475924642992128\",\"updateTime\":\"2021-09-08 11:45:11\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"610323196701160050\",\"name\":\"张录让\",\"perId\":\"859757724136079360\",\"updateTime\":\"2021-09-08 11:45:12\"},{\"authResult\":\"身份证号不存在。请修改信息或到派出所更新身份证信息后重新认证。\",\"authStatus\":\"4\",\"idNumber\":\"622727199006174113\",\"name\":\"陈广周\",\"perId\":\"883394977873424384\",\"updateTime\":\"2021-09-08 11:45:12\"}]");



      //  paramMap.put("personStr","{\"address\":\"河北省邯郸市磁县磁县磁州镇沙营村\",\"brith\":\"2000-02-15\",\"cardnumber\":\"130427200002150051\",\"city\":\"110100\",\"companyName\":\"北京首卫保安服务有限公司\",\"culture\":\"5\",\"district\":\"110108\",\"eduPhoto\":\"\",\"healthExamination\":\"\",\"hight\":\"175\",\"id\":\"747867082295558144\",\"idCardFront\":\"http://bcxinsaasprod.baibaodun.cn/upload%2F2020-08-20%2F1597933887103513983.jpg\",\"idCardReverse\":\"http://bcxinsaasprod.baibaodun.cn/upload%2F2020-08-20%2F1597933925588716883.jpg\",\"imglogo\":\"https://bcxin-saas-prod.obs.cn-north-1.myhuaweicloud.com:443/upload%2F2020-08-25%2F1598344116787959459.jpg\",\"name\":\"王世伟\",\"nation\":\"01\",\"nowAddress\":\"河北省邯郸市磁县磁县磁州镇沙营村\",\"orgid\":289,\"personid\":743482413554012160,\"phone\":\"13013202160\",\"province\":\"110000\",\"residentPlaceType\":\"\",\"residentType\":\"\",\"sex\":\"1\",\"szss\":\"北京市市辖区海淀区\"}");
      //  paramMap.put("sid","c08ef672-987c-480f-ad15-18910070033d");
      //
        String resultStr = HttpUtil.post(url, paramMap);
        System.out.println(resultStr);

//        String url ="http://saasweb.test.baibaodun.cn/saas_api/"+Constants.SAAS_MEET_PERSON_PAGE_LIST;
//        Map<String,Object> paramMap = new HashedMap();
//        paramMap.put("pageNumber",1);
//        paramMap.put("pageSize",20);
//        paramMap.put("regProvince",110000);
//
//        String resultStr = HttpUtil.post(url, paramMap);
//        System.out.println(resultStr);

        //try {
        //    File excel = new File("C:\\Users\\lenovo\\Desktop\\1.xlsx");
        //    FileInputStream inStream = new FileInputStream(excel);
        //    Workbook workBook = WorkbookFactory.create(inStream);
        //    Sheet sheet = workBook.getSheetAt(0);
        //    boolean flag = true;
        //    int i = 0;
        //    while (flag) {
        //        Row row = sheet.getRow(i);
        //        if (row != null) {
        //            String url = "http://bj.baibaodun.cn:8803/ars-rest/personcertificate/saveOrUpdate.json";
        //            Map<String, Object> paramMap = new HashedMap();
        //            paramMap.put("sid", ExcelUtil.getCellValue(row.getCell(1)));
        //            paramMap.put("personStr", ExcelUtil.getCellValue(row.getCell(0)));
        //
        //            String resultStr = HttpUtil.post(url, paramMap);
        //            System.out.println(resultStr);
        //        } else {
        //            flag = false;
        //        }
        //        i++;
        //    }
        //}catch (Exception e){
        //
        //}


    }
}
